/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.server;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import webetk.install.resources.Resource;
import webetk.install.server.HeaderPanel;
import webetk.install.server.InstallServer;
import webetk.install.utils.ImageCache;
import webetk.install.utils.LimitedTextField;

public class AskServerName
extends JPanel {
    private InstallServer mParent;
    private HeaderPanel mHeaderPanel;
    private JButton mButtonUebernehmen;
    private JButton mButtonAbbrechen;
    private JLabel mZeile1;
    private JTextField mtfServerName;
    private String msDefaultServerName;

    public AskServerName(InstallServer parent, String sDefaultServerName) {
        this.mParent = parent;
        this.msDefaultServerName = sDefaultServerName;
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getServerName(), null);
        this.initComponents();
    }

    private void initComponents() {
        this.mParent.setTitle(Resource.getInstance().getServerName());
        this.mButtonUebernehmen = new JButton(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonAbbrechen = new JButton(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.mZeile1 = new JLabel(Resource.getInstance().getServerNameAngeben());
        this.mtfServerName = new LimitedTextField(128, 64);
        if (this.msDefaultServerName != null) {
            this.mtfServerName.setText(this.msDefaultServerName);
        }
        this.layoutAll();
    }

    private void layoutAll() {
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(l);
        this.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 5, 0, 5};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.mZeile1, c.rc(2, 2, "l"));
        panel.add((Component)this.mtfServerName, c.rc(4, 2, "l"));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(1, 1);
        layout.setColumnWeight(5, 1);
        layout.setRowWeight(2, 1);
        panel.setLayout(layout);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AskServerName.this.mtfServerName.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(AskServerName.this.mParent, Resource.getInstance().getServerNameAngeben(), Resource.getInstance().getServerName(), 0);
                    return;
                }
                AskServerName.this.mParent.setServerName(AskServerName.this.mtfServerName.getText());
                AskServerName.this.mParent.executeNextStep();
            }
        });
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AskServerName.this.mParent.stopInstall();
            }
        });
        return panel;
    }
}

