/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.server;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import webetk.install.lookandfeel.UIHelper;
import webetk.install.resources.Resource;
import webetk.install.server.HeaderPanel;
import webetk.install.server.InstallServer;
import webetk.install.utils.Command;
import webetk.install.utils.ImageCache;

public class CmdDlg
extends JPanel {
    private static Logger log = Logger.getLogger(CmdDlg.class);
    private InstallServer mParent;
    private HeaderPanel mHeaderPanel;
    private JButton mButtonUebernehmen;
    private JButton mButtonAbbrechen;
    private JTextArea mTextArea;
    private String[] maszCommands = null;
    private String[] maszEnv = null;
    private Command mCmd = null;
    private boolean mbShowHinweisZeile2 = false;

    public CmdDlg(InstallServer parent, String szCommand, boolean bShowHinweisZeile2) {
        this.mbShowHinweisZeile2 = bShowHinweisZeile2;
        String[] aCmds = new String[]{szCommand};
        this.createCmdDlg(parent, aCmds);
    }

    public void createCmdDlg(InstallServer parent, String[] aszCommands) {
        this.mParent = parent;
        this.maszCommands = aszCommands;
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getKommandoWirdAusgefuehrt(), null);
        this.mParent.setTitle(Resource.getInstance().getKommandoWirdAusgefuehrt());
        this.initComponents();
        log.info("Kommando ausfuehren");
        this.mCmd = new Command(this.maszCommands, this.maszEnv, this.mTextArea);
        this.mCmd.start();
    }

    private void initComponents() {
        this.mTextArea = new JTextArea();
        this.mButtonUebernehmen = new JButton(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonAbbrechen = new JButton(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.layoutAll();
    }

    private void layoutAll() {
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(l);
        this.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 5, 0, 5};
        HIGLayout layout = new HIGLayout(widths, heights);
        panel.setLayout(layout);
        panel.add((Component)this.createTextAreaPanel(), c.rc(2, 2, "l"));
        panel.add((Component)new JLabel(Resource.getInstance().getMsgOkButton1()), c.rc(4, 2, "l"));
        if (this.mbShowHinweisZeile2) {
            panel.add((Component)new JLabel(Resource.getInstance().getMsgOkButton2()), c.rc(6, 2, "l"));
        }
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layout = new HIGLayout(widths, heights);
        layout.setColumnWeight(1, 1);
        layout.setColumnWeight(5, 1);
        layout.setRowWeight(2, 1);
        panel.setLayout(layout);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.info("OK Button gedrueckt");
                CmdDlg.this.mParent.executeNextStep();
            }
        });
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.info("Installation mit Abrechen Button abgebrochen");
                System.exit(1);
            }
        });
        return panel;
    }

    protected JComponent createTextAreaPanel() {
        this.mTextArea = new JTextArea();
        this.mTextArea.setBackground(this.getBackground());
        this.mTextArea.setAutoscrolls(true);
        this.mTextArea.setEditable(true);
        this.mTextArea.setLineWrap(true);
        this.mTextArea.setWrapStyleWord(true);
        this.mTextArea.setEnabled(true);
        JScrollPane sc = new JScrollPane(this.mTextArea);
        sc.setPreferredSize(new Dimension(750, 340));
        this.mTextArea.setCaretPosition(0);
        sc.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), UIHelper.getStandardBorder()));
        return sc;
    }
}

