/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.server;

import de.esg.tools.win32.registry.WindowsRegistry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import webetk.install.lookandfeel.WebETKTheme;
import webetk.install.resources.Resource;
import webetk.install.server.AskPort;
import webetk.install.server.AskProperties;
import webetk.install.server.AskServerName;
import webetk.install.server.AskTomcat;
import webetk.install.server.CmdDlg;
import webetk.install.server.GlobalObjects;
import webetk.install.server.Kopiere;
import webetk.install.server.Sprachauswahl;
import webetk.install.server.UpdateDeleteDlg;
import webetk.install.server.UpdateTransbaseIni;
import webetk.install.server.Willkommen;
import webetk.install.utils.Command;
import webetk.install.utils.Copy;
import webetk.install.utils.DirectoryChooserDialog;
import webetk.install.utils.DirectoryChooserPanel;
import webetk.install.utils.ImageCache;
import webetk.install.utils.PropertyUtils;

public class InstallServer
extends JFrame {
    private static final long serialVersionUID = 2704363101294288958L;
    private static InstallServer InstallServerInstance;
    private static Logger log;
    private int mnStep = 0;
    private String mszTargetDir = "";
    private String msWorkDir = null;
    private String msSamba = null;
    private String mszServerName = "";
    private boolean mbUpdate = false;
    private boolean mbCopyPrograms = true;
    private boolean mbInstallThinClient = false;
    private boolean mbInstallTomcat = false;
    private boolean mbDeinstall = false;
    private String mszInstalledVersion = null;
    private String mszCurrentVersion = null;
    private String szJavaHome = null;
    private String szJvmDll = null;

    protected InstallServer() {
        this.setIconImage(ImageCache.getInstance().getImage("ai_etk.jpg"));
    }

    public Logger getLogger() {
        return log;
    }

    private static void showDebugMessage(String string) {
        if ("true".equals(System.getProperty("debugETK"))) {
            JOptionPane.showConfirmDialog(null, string, "dubug Starter", 0);
        }
    }

    public static void main(String[] args) throws Exception {
        String sArg;
        InstallServer.showDebugMessage("Start InstallServer");
        System.out.println(System.getProperty("user.dir"));
        String szClassPath = System.getProperty("java.class.path");
        System.out.println("Classpath: " + szClassPath);
        MetalLookAndFeel.setCurrentTheme(new WebETKTheme());
        InstallServer.getInstance().init();
        boolean bInstallThinClient = false;
        String sWorkDir = null;
        String sSamba = "/etc/samba/smb.conf";
        if (args.length == 1) {
            sArg = args[0];
            if (sArg != null && sArg.equalsIgnoreCase("thin")) {
                bInstallThinClient = true;
            } else {
                sWorkDir = sArg;
            }
        } else if (args.length >= 2) {
            sWorkDir = args[0];
            sArg = args[1];
            if (sArg != null && sArg.equalsIgnoreCase("-smb") && args.length >= 3) {
                sSamba = args[2];
                if (args.length == 4) {
                    sArg = args[3];
                    bInstallThinClient = sArg != null && sArg.equalsIgnoreCase("thin");
                }
            } else {
                bInstallThinClient = sArg != null && sArg.equalsIgnoreCase("thin");
            }
        }
        String sHostname = InetAddress.getLocalHost().getHostName();
        String sFullWorkDir = System.getProperty("user.dir");
        if (sWorkDir != null && !sWorkDir.equals(".")) {
            sFullWorkDir = sWorkDir.indexOf(File.separator) == 0 ? sWorkDir : sFullWorkDir + File.separator + sWorkDir;
        }
        InstallServer.getInstance().install(bInstallThinClient, sHostname, sFullWorkDir, sSamba);
    }

    public static InstallServer getInstance() {
        if (InstallServerInstance == null) {
            InstallServerInstance = new InstallServer();
        }
        return InstallServerInstance;
    }

    public void init() {
        System.out.println("start init");
        Locale loc = Locale.getDefault();
        String sLang = loc.getLanguage();
        if (sLang.equals("en") || sLang.equals("zh")) {
            sLang = sLang + loc.getCountry();
        }
        if (!(sLang.equals("de") || sLang.equals("en") || sLang.equals("enUS") || sLang.equals("es") || sLang.equals("fr") || sLang.equals("it") || sLang.equals("ja") || sLang.equals("ko") || sLang.equals("nl") || sLang.equals("pt") || sLang.equals("ru") || sLang.equals("sv") || sLang.equals("th") || sLang.equals("zh") || sLang.equals("zhTW"))) {
            sLang = GlobalObjects.getInstance().getLanguage();
        }
        Resource.setLanguage(sLang);
        WebETKTheme.changeFont(sLang.substring(0, 2));
        this.setTitle(Resource.getInstance().getETKInstallation());
        System.out.println("setSize of Frame");
        this.setSize(800, 550);
        this.setPosition();
        this.setVisible(true);
    }

    private void install(boolean bInstallThinClient, String sHostname, String sWorkDir, String sSamba) {
        if (!this.testJavaVersion()) {
            JOptionPane.showMessageDialog(this, Resource.getInstance().getWrongJavaVersion(), Resource.getInstance().getJavaVersion(), 0);
            this.stopInstall();
        }
        this.mbInstallThinClient = bInstallThinClient;
        this.mszServerName = sHostname;
        this.msWorkDir = sWorkDir;
        this.msSamba = sSamba;
        GlobalObjects.getInstance(this.msWorkDir);
        this.mnStep = 0;
        this.executeNextStep();
    }

    public void executeNextStep() {
        if (log != null) {
            log.info("Processing step: " + this.mnStep);
        }
        InstallServer.showDebugMessage("mnStep" + this.mnStep);
        System.out.println("Processing step: " + this.mnStep);
        if (this.mnStep == 0) {
            ++this.mnStep;
            System.out.println("Processing executeErmittleInstallationsart in step" + this.mnStep);
            this.executeErmittleInstallationsart();
            System.out.println("Processing executeSprachauswahl in step" + this.mnStep);
            this.executeSprachauswahl();
            return;
        }
        if (this.mnStep == 1) {
            ++this.mnStep;
        }
        if (this.mnStep == 2) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            if (!this.mbUpdate) {
                this.executeWillkommen();
            } else {
                this.configLogger();
                log.info("Frage ob Update oder Deinstall.");
                log.info("msWorkDir: " + this.msWorkDir);
                log.info("mszTargetDir: " + this.mszTargetDir);
                log.info("mszInstalledVersion: " + this.mszInstalledVersion);
                log.info("mszCurrentVersion: " + this.mszCurrentVersion);
                this.executeUpdateDelete();
            }
            return;
        }
        if (this.mnStep == 3) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            if (this.mbDeinstall) {
                log.info("Deinstallieren.");
                this.executeDeinstall();
                return;
            }
            if (!this.mbUpdate) {
                this.executeZielverzeichnis();
                return;
            }
            log.info("Update wird ausgef\u00fchrt!");
            this.setzeProgrammVersion();
            this.executeRemoveTomcat();
        }
        if (this.mnStep == 4) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            if (this.mbDeinstall) {
                log.info("Dateien l\u00f6schen.");
                this.executeDeleteAll();
                System.exit(0);
            } else if (!this.mbUpdate || this.mbUpdate && this.mszInstalledVersion.compareTo("3.0.01") < 0) {
                this.configLogger();
                log.info("Fragen ob Tomcat installiert werden soll.");
                this.executeAskTomcat();
                return;
            }
        }
        if (this.mnStep == 5) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            log.info("Umgebungsvariable setzen.");
            this.executeSetEnvWebetk();
        }
        if (this.mnStep == 6) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            log.info("Dateien kopieren.");
            this.executeCopyFiles();
            return;
        }
        if (this.mnStep == 7) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            log.info("Transbase installieren.");
            this.executeInstallTransbase();
        }
        if (this.mnStep == 8) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            boolean bAskTransbasePorts = true;
            if (this.mbInstallTomcat || this.mbUpdate && this.mszInstalledVersion.compareTo("3.0.01") < 0) {
                log.info("Ports abfragen.");
                if (this.mbUpdate && this.mszInstalledVersion.compareTo("3.0.01") < 0) {
                    this.executeConfigPorts(true, false);
                } else {
                    this.executeConfigPorts(true, bAskTransbasePorts);
                }
                return;
            }
            if (!this.mbUpdate && bAskTransbasePorts) {
                log.info("Ports abfragen.");
                this.executeConfigPorts(false, bAskTransbasePorts);
                return;
            }
        }
        if (this.mnStep == 9) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            log.info("Einrichtung Datenbanken.");
            this.executeInstallDatabases();
        }
        if (this.mnStep == 10) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            if (!this.mbUpdate || this.mbUpdate && this.mszInstalledVersion.compareTo("3.0.01") < 0) {
                log.info("Abfrage des Rechnernamens des Servers.");
                this.executeAskServerName();
                return;
            }
        }
        if (this.mnStep == 11) {
            System.out.println("Processing step: " + this.mnStep);
            ++this.mnStep;
            log.info("Erzeugung Propertydateien.");
            this.executeWritePropertyFile();
            return;
        }
        if (this.mnStep == 12) {
            System.out.println("Processing step: " + this.mnStep);
            log.info("Batch-Files ausf\u00fchren.");
            ++this.mnStep;
            this.writeStep2Bat();
            CmdDlg panel = null;
            panel = InstallServer.isMSWindows() ? new CmdDlg(this, this.mszTargetDir + File.separator + "step2.bat", true) : new CmdDlg(this, this.mszTargetDir + File.separator + "step2.sh", true);
            Container c = this.getContentPane();
            c.removeAll();
            c.add((Component)panel, "Center");
            this.validate();
            return;
        }
        if (this.mnStep == 13) {
            System.out.println("Processing step: " + this.mnStep);
            log.info("Abschliessende Batch-Files ausf\u00fchren.");
            ++this.mnStep;
            String sCommand = null;
            if (InstallServer.isMSWindows()) {
                log.info("call step3.bat.");
                sCommand = this.mszTargetDir + File.separator + "step3.bat";
            } else {
                log.info("call step3.sh.");
                sCommand = this.mszTargetDir + File.separator + "step3.sh";
            }
            String[] aCmds = new String[]{sCommand};
            Command cmd = new Command(aCmds, null, null);
            cmd.start();
            cmd.waitForFirstOutput();
        }
        if (this.mnStep == 14) {
            System.out.println("Processing step: " + this.mnStep);
            log.info("Installationshauptprogramm beenden.");
            System.exit(0);
        }
    }

    public void stopInstall() {
        System.out.println("Installation aborted!");
        if (this.mnStep >= 4 && this.mnStep <= 9 && this.mbUpdate && InstallServer.isMSWindows()) {
            log.info("Trying to start Tomcat Service after abort in step 3, so that installation is runnable");
            String startTomcat = "net start Tomcat";
            String[] aCmds = new String[]{startTomcat};
            Command cmd = new Command(aCmds, null, null);
            cmd.start();
            cmd.waitForFirstOutput();
            log.info("Tomcat Service started again after abort in step 2");
        }
        System.exit(1);
    }

    public void back() {
        this.mnStep -= 2;
        this.executeNextStep();
    }

    private void executeSprachauswahl() {
        Container c = this.getContentPane();
        c.removeAll();
        Sprachauswahl oSprachauswahl = new Sprachauswahl(this);
        c.add((Component)oSprachauswahl, "Center");
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeErmittleInstallationsart() {
        if (InstallServer.isMSWindows()) {
            String szKeyName = "HKEY_CURRENT_USER\\Environment";
            String szValueName = "WEBETK";
            this.mszTargetDir = WindowsRegistry.getValueAsString(szKeyName, szValueName);
            if (this.mszTargetDir == null || this.mszTargetDir.trim().equals("")) {
                szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
                this.mszTargetDir = WindowsRegistry.getValueAsString(szKeyName, szValueName);
            }
        } else {
            Properties oProperties = new Properties();
            FileInputStream in = null;
            try {
                String szPath = System.getProperty("user.home");
                in = new FileInputStream(szPath + "/webetkhome");
                oProperties.load(in);
                this.mszTargetDir = oProperties.getProperty("webetk.home");
            }
            catch (FileNotFoundException ex) {
                try {
                    in = new FileInputStream("/usr/local/bin/webetkhome");
                    oProperties.load(in);
                    this.mszTargetDir = oProperties.getProperty("webetk.home");
                }
                catch (FileNotFoundException ex2) {
                    this.mszTargetDir = null;
                }
                catch (IOException ex2) {
                    this.mszTargetDir = null;
                }
            }
            catch (IOException ex) {
                this.mszTargetDir = null;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
            }
        }
        this.mbUpdate = this.mszTargetDir != null && !this.mszTargetDir.trim().equals("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSetEnvWebetk() {
        if (InstallServer.isMSWindows()) {
            String szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
            String szValueName = "WEBETK";
            String szValue = this.mszTargetDir;
            WindowsRegistry.setValueAsString(szKeyName, szValueName, szValue);
            szKeyName = "HKEY_CURRENT_USER\\Environment";
            WindowsRegistry.setValueAsString(szKeyName, szValueName, szValue);
        } else {
            Properties oProperties = new Properties();
            FileOutputStream out = null;
            try {
                out = new FileOutputStream("/usr/local/bin/webetkhome");
                oProperties.setProperty("webetk.home", this.mszTargetDir);
                oProperties.store(out, null);
            }
            catch (FileNotFoundException ex) {
                try {
                    String szPath = System.getProperty("user.home");
                    out = new FileOutputStream(szPath + "/webetkhome");
                    oProperties.setProperty("webetk.home", this.mszTargetDir);
                    oProperties.store(out, null);
                }
                catch (FileNotFoundException ex2) {
                    System.out.println("could not find user.home");
                }
                catch (IOException ex2) {
                    System.out.println("writing webetkhome failed");
                }
            }
            catch (IOException ex) {
                System.out.println("writing /usr/local/bin/webetkhome failed");
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                }
            }
        }
    }

    private void executeWillkommen() {
        Container c = this.getContentPane();
        c.removeAll();
        Willkommen oWillkommen = new Willkommen(this);
        c.add((Component)oWillkommen, "Center");
        this.validate();
    }

    private void executeUpdateDelete() {
        Container c = this.getContentPane();
        c.removeAll();
        UpdateDeleteDlg oUpdateDeleteDlg = new UpdateDeleteDlg(this);
        c.add((Component)oUpdateDeleteDlg, "Center");
        this.validate();
    }

    private void executeZielverzeichnis() {
        Container c = this.getContentPane();
        c.removeAll();
        DirectoryChooserPanel oDirectoryChooser = new DirectoryChooserPanel(this, Resource.getInstance().getInstallationsverzeichnis(), Resource.getInstance().getInstallationsverzeichnisAuswaehlen());
        c.add((Component)oDirectoryChooser, "Center");
        this.validate();
    }

    private void setzeProgrammVersion() {
        this.mszInstalledVersion = this.readPropertyFileAndKey(this.mszTargetDir + File.separator + "version.txt", "Datum.Publikationsdaten");
        String sPathCd = null;
        sPathCd = this.msWorkDir != null ? this.msWorkDir + File.separator + "version.txt" : "version.txt";
        String szCDVersion = this.readPropertyFileAndKey(sPathCd, "Datum.Publikationsdaten");
        this.mszInstalledVersion = this.readPropertyFileAndKey(this.mszTargetDir + File.separator + "version.txt", "Version.Programme");
        if (this.mszInstalledVersion != null) {
            log.info("Bisher installierte Version: " + this.mszInstalledVersion);
        } else {
            log.info("Bisher installierte Version is null");
        }
        szCDVersion = this.readPropertyFileAndKey(sPathCd, "Version.Programme");
        if (szCDVersion != null) {
            log.info("CD Version: " + szCDVersion);
            this.mszCurrentVersion = szCDVersion;
        } else {
            log.warn("CD Version is null");
        }
        if (this.mszInstalledVersion != null && this.mszInstalledVersion.equals(szCDVersion)) {
            this.mbCopyPrograms = false;
        }
    }

    private void executeAskTomcat() {
        Container c = this.getContentPane();
        c.removeAll();
        AskTomcat oAskTomcat = new AskTomcat(this);
        c.add((Component)oAskTomcat, "Center");
        this.validate();
    }

    private void executeCopyFiles() {
        Container c = this.getContentPane();
        c.removeAll();
        Kopiere oKopiere = new Kopiere(this);
        c.add((Component)oKopiere, "Center");
        this.validate();
        CopyFiles oCopyThread = new CopyFiles(this, oKopiere, this.mbCopyPrograms, this.mbUpdate, this.mbInstallThinClient, this.mbInstallTomcat, this.mszInstalledVersion, this.mszCurrentVersion);
        oCopyThread.start();
    }

    private String getJvmPath(String szJavaHome) {
        if (szJavaHome == null || szJavaHome.trim().equals("")) {
            return null;
        }
        File fToolsJar = new File(szJavaHome + File.separator + "lib" + File.separator + "tools.jar");
        if (!fToolsJar.exists()) {
            return null;
        }
        String szJvmDll = "jre" + File.separator + "bin" + File.separator + "hotspot" + File.separator + "jvm.dll";
        File fJvmDll = new File(szJavaHome + File.separator + szJvmDll);
        if (fJvmDll.exists()) {
            return szJvmDll;
        }
        szJvmDll = "jre" + File.separator + "bin" + File.separator + "classic" + File.separator + "jvm.dll";
        fJvmDll = new File(szJavaHome + File.separator + szJvmDll);
        if (fJvmDll.exists()) {
            return szJvmDll;
        }
        szJvmDll = "jre" + File.separator + "bin" + File.separator + "client" + File.separator + "jvm.dll";
        fJvmDll = new File(szJavaHome + File.separator + szJvmDll);
        if (fJvmDll.exists()) {
            return szJvmDll;
        }
        szJvmDll = "jre" + File.separator + "bin" + File.separator + "server" + File.separator + "jvm.dll";
        fJvmDll = new File(szJavaHome + File.separator + szJvmDll);
        if (fJvmDll.exists()) {
            return szJvmDll;
        }
        return null;
    }

    private boolean testJavaVersion() {
        String sVersion = System.getProperty("java.version");
        sVersion = sVersion.substring(0, 3);
        if (InstallServer.isMSWindows()) {
            if (sVersion.compareTo("1.4") >= 0) {
                System.out.println("Schritt 1");
                this.szJvmDll = null;
                String szKeyName = "HKEY_CURRENT_USER\\Environment";
                String szValueName = "JAVA_HOME";
                this.szJavaHome = WindowsRegistry.getValueAsString(szKeyName, szValueName);
                if (this.szJavaHome == null || this.szJavaHome.trim().equals("")) {
                    szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
                    this.szJavaHome = WindowsRegistry.getValueAsString(szKeyName, szValueName);
                    System.out.println("Schritt 2 - Java Home: " + this.szJavaHome);
                }
                String szPath = null;
                String szValue = null;
                this.szJvmDll = this.getJvmPath(this.szJavaHome);
                if (this.szJvmDll != null) {
                    System.out.println("Schritt 3 ");
                    szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
                    szValueName = "Path";
                    szPath = WindowsRegistry.getValueAsString(szKeyName, szValueName);
                    if (!(szPath.matches(".*?[jJ][dD][kK].*?") || szPath.matches(".*?[jJ][2][sS][dD][kK].*?") || szPath.matches(".*?[jJ]ava\\.*?") || szPath.matches(".*?(?i)JAVA_HOME.*?"))) {
                        System.out.println("Schritt 4 (jetzt soll die Variable gesetzt werden)");
                        szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
                        szValueName = "Path";
                        szValue = szPath + ";" + this.szJavaHome + "\\bin";
                        System.out.println("Schritt 5 ein Schritt vor setzen der Variable");
                        this.setXCommand(szValueName, szValue, true);
                    }
                }
                if (this.szJvmDll == null) {
                    System.out.println("Schritt 6 szJvmDll ist immer noch null");
                    szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
                    szValueName = "Path";
                    szPath = WindowsRegistry.getValueAsString(szKeyName, szValueName);
                    if (szPath.matches(".*?[jJ][dD][kK].*?") || szPath.matches(".*?[jJ][2][sS][dD][kK].*?") || szPath.matches(".*?[jJ]ava\\.*?")) {
                        System.out.println("Schritt 7");
                        String[] szPathEntries = szPath.split(";");
                        for (int iCnt = 0; iCnt < szPathEntries.length; ++iCnt) {
                            System.out.println("Schritt 8: " + iCnt);
                            if (!szPathEntries[iCnt].matches(".*?[jJ][dD][kK].*?") && !szPathEntries[iCnt].matches(".*?[jJ][2][sS][dD][kK].*?") && !szPathEntries[iCnt].matches(".*?[jJ][2][sS][dD][kK].*?")) continue;
                            String sJavaHome = null;
                            if (szPathEntries[iCnt].endsWith("\\bin")) {
                                sJavaHome = szPathEntries[iCnt].substring(0, szPathEntries[iCnt].indexOf("\\bin"));
                            }
                            if (szPathEntries[iCnt].endsWith("/bin")) {
                                sJavaHome = szPathEntries[iCnt].substring(0, szPathEntries[iCnt].indexOf("/bin"));
                            }
                            if (sJavaHome == null) continue;
                            this.szJavaHome = sJavaHome;
                            this.szJvmDll = this.getJvmPath(this.szJavaHome);
                            if (this.szJvmDll == null) break;
                            szValue = this.szJavaHome;
                            szValueName = "JAVA_HOME";
                            szKeyName = "HKEY_CURRENT_USER\\Environment";
                            System.out.println("Nummer 1");
                            this.setXCommand(szValueName, szValue, false);
                            szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
                            System.out.println("Nummer 2");
                            this.setXCommand(szValueName, szValue, true);
                            break;
                        }
                    }
                }
                while (this.szJvmDll == null) {
                    StringBuffer szBufJavaHome = this.askUserForJavaPath();
                    if (szBufJavaHome.toString().equals("-1")) {
                        this.stopInstall();
                        continue;
                    }
                    this.szJavaHome = szBufJavaHome.toString();
                    this.szJvmDll = this.getJvmPath(this.szJavaHome);
                    if (this.szJvmDll == null) continue;
                    szValue = this.szJavaHome;
                    szValueName = "JAVA_HOME";
                    szKeyName = "HKEY_CURRENT_USER\\Environment";
                    this.setXCommand(szValueName, szValue, false);
                    szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
                    this.setXCommand(szValueName, szValue, true);
                    szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
                    szValueName = "Path";
                    szPath = WindowsRegistry.getValueAsString(szKeyName, szValueName);
                    szValue = szPath + ";" + this.szJavaHome + "\\bin";
                    this.setXCommand(szValueName, szValue, true);
                }
                return true;
            }
            return false;
        }
        return sVersion.compareTo("1.4") >= 0;
    }

    private void setXCommand(String psKey, String psValue, boolean global) {
        String sCommand = "%SYSTEMROOT%\\system32\\setx " + psKey + " \"" + psValue + "\"" + (global ? " /m" : "");
        String[] aCmds = new String[]{sCommand};
        Command cmd = new Command(aCmds, null, null);
        cmd.start();
        cmd.waitForFirstOutput();
    }

    private StringBuffer askUserForJavaPath() {
        StringBuffer szBufJavaHome = new StringBuffer("");
        DirectoryChooserDialog oDirectoryChooser = new DirectoryChooserDialog(this, Resource.getInstance().getJavaInstallation(), Resource.getInstance().getAskJavaPath(), Resource.getInstance().getPfad(), szBufJavaHome);
        oDirectoryChooser.setVisible(true);
        return szBufJavaHome;
    }

    private void executeConfigPorts(boolean bAskTomcatPorts, boolean bAskTransbasePorts) {
        Container c = this.getContentPane();
        c.removeAll();
        String szPropertyFile = this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF" + File.separator + "bmwetk.properties";
        File fTomcat = new File(this.mszTargetDir + File.separator + "tomcat");
        if (!this.mbInstallTomcat && !fTomcat.exists()) {
            szPropertyFile = this.mszTargetDir + File.separator + "javaserver" + File.separator + "WEB-INF" + File.separator + "bmwetk.properties";
        }
        AskPort oAskPort = new AskPort(this, this.mszTargetDir, szPropertyFile, bAskTomcatPorts, bAskTransbasePorts);
        c.add((Component)oAskPort, "Center");
        this.validate();
    }

    private void executeInstallTransbase() {
        if (InstallServer.isMSWindows()) {
            UpdateTransbaseIni.updateFile(this.mszTargetDir + File.separator + "transbase");
        } else {
            UpdateTransbaseIni.updateFile(this.mszTargetDir + File.separator + "transbase", "rc.tbenv");
            UpdateTransbaseIni.updateFile(this.mszTargetDir + File.separator + "transbase", "rc.TransBase");
            UpdateTransbaseIni.updateFile(this.mszTargetDir + File.separator + "transbase", "rc.tbstop");
        }
        if (InstallServer.isMSWindows()) {
            try {
                String szFile = this.mszTargetDir + File.separator + "transbase_service.bat";
                Vector<String> aszZeilen = new Vector<String>();
                BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(szFile)));
                String szLine = in.readLine();
                while (szLine != null) {
                    szLine = this.mbUpdate ? InstallServer.substituteString(szLine, "#UPDATE#", "true") : InstallServer.substituteString(szLine, "#UPDATE#", "false");
                    szLine = InstallServer.substituteString(szLine, "#TARGETDIR#", this.mszTargetDir);
                    aszZeilen.add(szLine);
                    szLine = in.readLine();
                }
                in.close();
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(szFile)));
                Iterator iter = aszZeilen.iterator();
                while (iter.hasNext()) {
                    out.write((String)iter.next() + System.getProperty("line.separator"));
                }
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void executeInstallDatabases() {
        try {
            String szFile = null;
            szFile = InstallServer.isMSWindows() ? this.mszTargetDir + File.separator + "transbase_db.bat" : this.mszTargetDir + File.separator + "transbase_db.sh";
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(szFile)));
            String szLine = in.readLine();
            while (szLine != null) {
                szLine = this.mbUpdate ? InstallServer.substituteString(szLine, "#UPDATE#", "true") : InstallServer.substituteString(szLine, "#UPDATE#", "false");
                szLine = InstallServer.substituteString(szLine, "#TARGETDIR#", this.mszTargetDir);
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(szFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void executeAskServerName() {
        Container c = this.getContentPane();
        c.removeAll();
        AskServerName oDirectoryChooser = new AskServerName(this, this.mszServerName);
        c.add((Component)oDirectoryChooser, "Center");
        this.validate();
    }

    private void executeWritePropertyFile() {
        File fTomcat = new File(this.mszTargetDir + File.separator + "tomcat");
        String szJavaserverDir = null;
        szJavaserverDir = !this.mbInstallTomcat && !fTomcat.exists() ? this.mszTargetDir + File.separator + "javaserver" : this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps";
        String szClientPropertyFile = this.mszTargetDir + File.separator + "javaclient" + File.separator + "classes" + File.separator + "javaclient.properties";
        String szAdmintoolPropertyFile = this.mszTargetDir + File.separator + "admintool" + File.separator + "admintool.properties";
        String szMigrationPropertyFile = this.mszTargetDir + File.separator + "migration" + File.separator + "migration.properties";
        Container c = this.getContentPane();
        c.removeAll();
        boolean bShowBackButton = !this.mbUpdate;
        AskProperties oAskProperties = new AskProperties(this, this.mszTargetDir, szJavaserverDir, szClientPropertyFile, szAdmintoolPropertyFile, szMigrationPropertyFile, this.mszServerName, this.msWorkDir, this.msSamba, bShowBackButton);
        c.add((Component)oAskProperties, "Center");
        this.validate();
    }

    private void writeStep2Bat() {
        try {
            File fTomcat;
            String szFile = null;
            szFile = InstallServer.isMSWindows() ? this.mszTargetDir + File.separator + "step2.bat" : this.mszTargetDir + File.separator + "step2.sh";
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(szFile)));
            String szLine = in.readLine();
            while (szLine != null) {
                szLine = this.mbUpdate ? InstallServer.substituteString(szLine, "#UPDATE#", "true") : InstallServer.substituteString(szLine, "#UPDATE#", "false");
                szLine = this.mbUpdate && this.mbCopyPrograms ? InstallServer.substituteString(szLine, "#UPDATECLIENTPROG#", "true") : InstallServer.substituteString(szLine, "#UPDATECLIENTPROG#", "false");
                szLine = this.mbInstallTomcat ? InstallServer.substituteString(szLine, "#TOMCATSERVICE#", "true") : InstallServer.substituteString(szLine, "#TOMCATSERVICE#", "false");
                File fTomcat2 = new File(this.mszTargetDir + File.separator + "tomcat");
                szLine = this.mbInstallTomcat || fTomcat2.exists() ? InstallServer.substituteString(szLine, "#TOMCATINSTALLED#", "true") : InstallServer.substituteString(szLine, "#TOMCATINSTALLED#", "false");
                szLine = InstallServer.substituteString(szLine, "#TARGETDRIVE#", this.mszTargetDir.substring(0, 2));
                szLine = InstallServer.substituteString(szLine, "#TARGETDIR#", this.mszTargetDir);
                szLine = this.mszInstalledVersion != null ? InstallServer.substituteString(szLine, "#OLDVERSION#", this.mszInstalledVersion + " noIsis") : InstallServer.substituteString(szLine, "#OLDVERSION#", "");
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(szFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
            log.info("step2 angepasst");
            szFile = InstallServer.isMSWindows() ? this.mszTargetDir + File.separator + "step3.bat" : this.mszTargetDir + File.separator + "step3.sh";
            aszZeilen = new Vector();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(szFile)));
            szLine = in.readLine();
            while (szLine != null) {
                szLine = this.mbUpdate ? InstallServer.substituteString(szLine, "#UPDATE#", "true") : InstallServer.substituteString(szLine, "#UPDATE#", "false");
                szLine = InstallServer.substituteString(szLine, "#TARGETDRIVE#", this.mszTargetDir.substring(0, 2));
                szLine = InstallServer.substituteString(szLine, "#TARGETDIR#", this.mszTargetDir);
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(szFile)));
            iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
            log.info("step3 angepasst");
            szFile = InstallServer.isMSWindows() ? this.mszTargetDir + File.separator + "remove_step2.bat" : this.mszTargetDir + File.separator + "remove_step2.sh";
            aszZeilen = new Vector();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(szFile)));
            szLine = in.readLine();
            while (szLine != null) {
                szLine = InstallServer.substituteString(szLine, "#TARGETDRIVE#", this.mszTargetDir.substring(0, 2));
                szLine = InstallServer.substituteString(szLine, "#TARGETDIR#", this.mszTargetDir);
                fTomcat = new File(this.mszTargetDir + File.separator + "tomcat");
                szLine = fTomcat.exists() ? InstallServer.substituteString(szLine, "#TOMCATSERVICE#", "true") : InstallServer.substituteString(szLine, "#TOMCATSERVICE#", "false");
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(szFile)));
            iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
            log.info("remove_step2 angepasst");
            szFile = InstallServer.isMSWindows() ? this.mszTargetDir + File.separator + "admintool" + File.separator + "admintool.bat" : this.mszTargetDir + File.separator + "admintool" + File.separator + "admintool.sh";
            aszZeilen = new Vector();
            in = new BufferedReader(new InputStreamReader(new FileInputStream(szFile)));
            szLine = in.readLine();
            while (szLine != null) {
                szLine = InstallServer.substituteString(szLine, "standalone == standalone", "standalone == false");
                szLine = InstallServer.substituteString(szLine, "clientserver == true", "clientserver == clientserver");
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(szFile)));
            iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
            log.info("admintool Aufruf angepasst");
            if (!InstallServer.isMSWindows()) {
                szFile = this.mszTargetDir + File.separator + "BmwEtk";
                aszZeilen = new Vector();
                in = new BufferedReader(new InputStreamReader(new FileInputStream(szFile)));
                szLine = in.readLine();
                while (szLine != null) {
                    szLine = InstallServer.substituteString(szLine, "#TARGETDRIVE#", this.mszTargetDir.substring(0, 2));
                    szLine = InstallServer.substituteString(szLine, "#TARGETDIR#", this.mszTargetDir);
                    fTomcat = new File(this.mszTargetDir + File.separator + "tomcat");
                    szLine = fTomcat.exists() ? InstallServer.substituteString(szLine, "#TOMCATSERVICE#", "true") : InstallServer.substituteString(szLine, "#TOMCATSERVICE#", "false");
                    aszZeilen.add(szLine);
                    szLine = in.readLine();
                }
                in.close();
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(szFile)));
                iter = aszZeilen.iterator();
                while (iter.hasNext()) {
                    out.write((String)iter.next() + System.getProperty("line.separator"));
                }
                out.close();
                log.info("BmwEtk angepasst");
            }
        }
        catch (RuntimeException e) {
            log.error("Exception beim Anpassen der Batch Files: ", e);
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error("Exception beim Anpassen der Batch Files: ", e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPropertyFileAndKey(String szFile, String szKey) {
        FileInputStream in = null;
        try {
            Properties oProperties = new Properties();
            in = new FileInputStream(szFile);
            oProperties.load(in);
            String string = oProperties.getProperty(szKey);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = "";
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateSWSCrisJavaclientProperties(InstallServer obj, String psTargetDir) {
        String sFileName = psTargetDir + "javaclient.properties";
        obj.getLogger().info("updateSWSCrisJavaclientProperties in: " + sFileName);
        Properties propsNew = new Properties();
        PropertyUtils pu = new PropertyUtils();
        Properties propsOld = pu.loadPropertyFile(sFileName);
        obj.getLogger().info("updateSWSCrisJavaclientProperties - alte Properties gelesen: " + propsOld);
        propsNew.put("TEST.INT.swscris.host", "https://swsa-3-integration.bmw.com/swscris/query");
        propsNew.put("swscris.host", "https://swsa-3.bmw.com/swscris/query");
        propsNew.put("swscris.timeout", "1000");
        if (!propsOld.containsKey("swscris.proxyset")) {
            propsNew.put("swscris.proxyset", "false");
        }
        pu.updatePropertyFile(propsNew, propsOld, sFileName);
        obj.getLogger().info("updateSWSCrisJavaclientProperties - neue Properties ge\u00e4ndert: " + propsNew);
    }

    public void setInstallTomcat(boolean bInstallTomcat) {
        this.mbInstallTomcat = bInstallTomcat;
    }

    public void setTargetDir(String szTargetDir) {
        this.mszTargetDir = szTargetDir;
    }

    public void setServerName(String szServerName) {
        this.mszServerName = szServerName;
    }

    public void setUpdate(boolean bUpdate) {
        this.mbUpdate = bUpdate;
    }

    public void setDeinstall(boolean bDeinstall) {
        this.mbDeinstall = bDeinstall;
    }

    public static boolean isMSWindows() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return (os = os.toUpperCase()).indexOf("WIN") != -1;
    }

    private static String substituteString(String sSource, String sParam, String sSubst) {
        if (sSource == null || sParam == null) {
            return sSource;
        }
        if (sSubst == null) {
            sSubst = "";
        }
        int nIndex = sSource.indexOf(sParam);
        while (nIndex != -1) {
            String sNewString;
            sSource = sNewString = sSource.substring(0, nIndex) + sSubst + sSource.substring(nIndex + sParam.length(), sSource.length());
            nIndex = sSource.indexOf(sParam, nIndex + sSubst.length());
        }
        return sSource;
    }

    private void executeDeinstall() {
        if (InstallServer.isMSWindows()) {
            String szKeyName = "HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";
            String szValueName = "WEBETK";
            WindowsRegistry.deleteKeyValue(szKeyName, szValueName);
            szKeyName = "HKEY_CURRENT_USER\\Environment";
            WindowsRegistry.deleteKeyValue(szKeyName, szValueName);
        } else {
            boolean bResult = true;
            try {
                File file = new File("/usr/local/bin/webetkhome");
                bResult = file.delete();
            }
            catch (Exception ex) {
                bResult = false;
            }
            if (!bResult) {
                try {
                    String szPath = System.getProperty("user.home");
                    File file = new File(szPath + "/webetkhome");
                    bResult = file.delete();
                }
                catch (RuntimeException ex2) {
                    log.error("Fehler beim Loeschen", ex2);
                }
                catch (Exception ex2) {
                    log.error("Fehler beim Loeschen", ex2);
                }
            }
        }
        CmdDlg panel = null;
        panel = InstallServer.isMSWindows() ? new CmdDlg(this, this.mszTargetDir + File.separator + "remove_step2.bat", false) : new CmdDlg(this, this.mszTargetDir + File.separator + "remove_step2.sh", false);
        Container c = this.getContentPane();
        c.removeAll();
        c.add((Component)panel, "Center");
        this.validate();
    }

    private void executeRemoveTomcat() {
        String szCommand;
        CmdDlg panel = null;
        if (InstallServer.isMSWindows()) {
            szCommand = this.msWorkDir + File.separator + "install" + File.separator + "remove_tomcat_service.bat";
            log.info(szCommand);
            panel = new CmdDlg(this, szCommand, false);
        } else {
            szCommand = this.mszTargetDir + File.separator + "tomcat/bin/shutdown.sh";
            log.info(szCommand);
            panel = new CmdDlg(this, szCommand, false);
        }
        Container c = this.getContentPane();
        c.removeAll();
        c.add((Component)panel, "Center");
        this.validate();
    }

    private void executeDeleteAll() {
        File fileDelDir = new File(this.mszTargetDir);
        String sExcept = "Etk_Sicherung";
        Copy.deleteDirectory(fileDelDir, sExcept);
    }

    public boolean getInstallThinClient() {
        return this.mbInstallThinClient;
    }

    private void setPosition() {
        int width = Toolkit.getDefaultToolkit().getScreenSize().width;
        int height = Toolkit.getDefaultToolkit().getScreenSize().height;
        System.out.println("ScreenSize: " + width + " " + height);
        System.out.println("setPosition: " + (width - this.getWidth()) / 2 + " " + (height - this.getHeight()) / 2);
        this.setLocation((width - this.getWidth()) / 2, (height - this.getHeight()) / 2);
    }

    public static boolean testDiskSpace(String sPath, long lNeededSpace) {
        return true;
    }

    private void configLogger() {
        boolean ret;
        System.out.println("Logger konfigurieren");
        File fTarget = new File(this.mszTargetDir);
        if (!fTarget.exists() && !(ret = fTarget.mkdirs())) {
            System.out.println("Could not create TargetDir for logging");
        }
        try {
            log = Logger.getLogger(InstallServer.class);
            Logger logr = Logger.getRootLogger();
            RollingFileAppender rfa = new RollingFileAppender(new PatternLayout("%d{dd.MM.yyyy HH:mm:ss,SSS}>%-5.5p [%-5.5t:%-20.20C{1}#%-20.20M](L%-4.4L) - %m%n"), this.mszTargetDir + File.separator + "install.log", true);
            rfa.setThreshold(Priority.INFO);
            logr.addAppender(rfa);
        }
        catch (IOException ex) {
            System.out.println("Could not create TargetDir for logging");
        }
    }

    static {
        log = null;
    }

    public class CopyFiles
    extends Thread {
        private Kopiere moKopiere;
        private InstallServer mParent;
        private boolean mbCopyPrograms = true;
        private boolean mbInstallThinClient = false;
        private boolean mbInstallTomcat = false;
        private boolean mbUpdate = false;
        private String msInstalledVersion = null;

        public CopyFiles(InstallServer Parent, Kopiere oKopiere, boolean bCopyPrograms, boolean bUpdate, boolean bInstallThinClient, boolean bInstallTomcat, String sInstalledVersion, String sCurrentVersion) {
            this.mParent = Parent;
            this.moKopiere = oKopiere;
            this.mbCopyPrograms = bCopyPrograms;
            this.mbInstallThinClient = bInstallThinClient;
            this.mbInstallTomcat = bInstallTomcat;
            this.mbUpdate = bUpdate;
            this.msInstalledVersion = sInstalledVersion == null ? "1.0.00" : sInstalledVersion;
        }

        private void delLogFile(File pFile) {
            this.mParent.getLogger().info("... l\u00f6schen Datei " + pFile.getAbsolutePath() + " war OK ? - " + Copy.deleteDirectory(pFile));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                File fTomcat;
                boolean ret;
                boolean ret2;
                File fTarget = new File(InstallServer.this.mszTargetDir);
                if (!fTarget.exists() && !(ret2 = fTarget.mkdirs())) {
                    this.mParent.getLogger().error("Could not create TargetDir: " + InstallServer.this.mszTargetDir);
                    return;
                }
                this.mParent.getLogger().info("TargetDir: " + InstallServer.this.mszTargetDir);
                String sSrcPath = "";
                if (InstallServer.this.msWorkDir != null) {
                    sSrcPath = InstallServer.this.msWorkDir + File.separator;
                }
                this.mParent.getLogger().info("Quellverzeichnis: " + sSrcPath);
                Copy.copyFile(sSrcPath + "version.txt", InstallServer.this.mszTargetDir + File.separator + "version.txt");
                if (this.mbUpdate) {
                    Copy.copyFile(sSrcPath + "version.txt", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "version.txt");
                }
                if (InstallServer.isMSWindows()) {
                    Copy.copyFile(sSrcPath + "install" + File.separator + "step2.bat", InstallServer.this.mszTargetDir + File.separator + "step2.bat");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "remove_step2.bat", InstallServer.this.mszTargetDir + File.separator + "remove_step2.bat");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "step3.bat", InstallServer.this.mszTargetDir + File.separator + "step3.bat");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "tomcat_service.bat", InstallServer.this.mszTargetDir + File.separator + "tomcat_service.bat");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "remove_tomcat_service.bat", InstallServer.this.mszTargetDir + File.separator + "remove_tomcat_service.bat");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "transbase_db.bat", InstallServer.this.mszTargetDir + File.separator + "transbase_db.bat");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "transbase_service.bat", InstallServer.this.mszTargetDir + File.separator + "transbase_service.bat");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "remove_transbase_service.bat", InstallServer.this.mszTargetDir + File.separator + "remove_transbase_service.bat");
                    Copy.copyDirectory(sSrcPath + "install" + File.separator + "server_install", InstallServer.this.mszTargetDir + File.separator + "server_install");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "install_server.iss", InstallServer.this.mszTargetDir + File.separator + "server_install" + File.separator + "install_server.iss");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "uninstall_server.iss", InstallServer.this.mszTargetDir + File.separator + "server_install" + File.separator + "uninstall_server.iss");
                } else {
                    Copy.copyFile(sSrcPath + "install" + File.separator + "step2.sh", InstallServer.this.mszTargetDir + File.separator + "step2.sh");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "step3.sh", InstallServer.this.mszTargetDir + File.separator + "step3.sh");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "remove_step2.sh", InstallServer.this.mszTargetDir + File.separator + "remove_step2.sh");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "remove_step2b.sh", InstallServer.this.mszTargetDir + File.separator + "remove_step2b.sh");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "transbase_db.sh", InstallServer.this.mszTargetDir + File.separator + "transbase_db.sh");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "etk_services.sh", InstallServer.this.mszTargetDir + File.separator + "etk_services.sh");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "remove_etk_services.sh", InstallServer.this.mszTargetDir + File.separator + "remove_etk_services.sh");
                    Copy.copyFile(sSrcPath + "install" + File.separator + "BmwEtk", InstallServer.this.mszTargetDir + File.separator + "BmwEtk");
                }
                this.moKopiere.setProgress(1);
                File fRoms = new File(InstallServer.this.mszTargetDir + File.separator + "roms");
                if (!fRoms.exists() && !(ret = fRoms.mkdirs())) {
                    this.mParent.getLogger().error("Could not create ROM-Directory: " + InstallServer.this.mszTargetDir + File.separator + "roms");
                }
                if ((fTomcat = new File(InstallServer.this.mszTargetDir + File.separator + "tomcat")).exists()) {
                    File fJavaserver = new File(InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "javaserver");
                    try {
                        if (!Copy.deleteDirectory(fJavaserver)) {
                            this.mParent.getLogger().error("Could not delete " + fTomcat.getName() + "delete returned false");
                        }
                    }
                    catch (SecurityException ex) {
                        this.mParent.getLogger().error("Could not delete " + fTomcat.getName() + ex.getMessage());
                    }
                    File fzubwbt = new File(InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "Zubwbt");
                    Copy.deleteDirectory(fzubwbt);
                    if (!InstallServer.isMSWindows()) {
                        fJavaserver = new File(InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "javaserver.war_out");
                        Copy.deleteDirectory(fJavaserver);
                    }
                }
                Copy.copyDirectory(sSrcPath + "ticker", InstallServer.this.mszTargetDir + File.separator + "ticker");
                if (this.mbCopyPrograms) {
                    this.mParent.getLogger().info("neue Programmversion");
                    if (this.mbUpdate) {
                        boolean ret3;
                        File fTemp;
                        boolean ret4;
                        File fJava;
                        File file;
                        this.mParent.getLogger().info("Update");
                        Copy.copyFile(sSrcPath + "admintool" + File.separator + "admintool.bat", InstallServer.this.mszTargetDir + File.separator + "admintool" + File.separator + "admintool.bat");
                        Copy.copyFile(sSrcPath + "admintool" + File.separator + "admintool.exe", InstallServer.this.mszTargetDir + File.separator + "admintool" + File.separator + "admintool.exe");
                        try {
                            file = new File(InstallServer.this.mszTargetDir + File.separator + "admintool" + File.separator + "log4j.properties");
                            boolean ret5 = file.delete();
                            if (ret5) {
                                // empty if block
                            }
                        }
                        catch (RuntimeException ex) {
                            this.mParent.getLogger().error("Fehler beim Loeschen ", ex);
                        }
                        catch (Exception ex) {
                            this.mParent.getLogger().debug("Konnte nicht Loeschen", ex);
                        }
                        Copy.copyFile(sSrcPath + "admintool" + File.separator + "log4j.xml", InstallServer.this.mszTargetDir + File.separator + "admintool" + File.separator + "log4j.xml");
                        this.moKopiere.setProgress(1);
                        Copy.copyFile(sSrcPath + "admintool" + File.separator + "admintool.jar", InstallServer.this.mszTargetDir + File.separator + "admintool" + File.separator + "admintool.jar");
                        Copy.copyFile(sSrcPath + "WindowsRegistryDLL.dll", InstallServer.this.mszTargetDir + File.separator + "admintool" + File.separator + "WindowsRegistryDLL.dll");
                        this.moKopiere.setProgress(2);
                        Copy.copyFile(sSrcPath + "admintool" + File.separator + "admintoolHlp.jar", InstallServer.this.mszTargetDir + File.separator + "admintool" + File.separator + "admintoolHlp.jar");
                        this.moKopiere.setProgress(5);
                        Copy.copyFile(sSrcPath + "migration" + File.separator + "migration.jar", InstallServer.this.mszTargetDir + File.separator + "migration" + File.separator + "migration.jar");
                        try {
                            file = new File(InstallServer.this.mszTargetDir + File.separator + "migration" + File.separator + "log4j.properties");
                            boolean ret6 = file.delete();
                            if (ret6) {
                                // empty if block
                            }
                        }
                        catch (Exception ex) {
                            this.mParent.getLogger().debug("Konnte nicht Loeschen", ex);
                        }
                        Copy.copyFile(sSrcPath + "migration" + File.separator + "log4j.xml", InstallServer.this.mszTargetDir + File.separator + "migration" + File.separator + "log4j.xml");
                        this.moKopiere.setProgress(35);
                        this.mParent.getLogger().info("*** javaclient directory wird versogrt ");
                        String client = InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator;
                        this.mParent.getLogger().info("Client Template-Verzeichnis (client): " + client);
                        String clientSrc = sSrcPath + "javaclient" + File.separator;
                        this.mParent.getLogger().info("Client Quell-Verzeichnis (clientSrc): " + clientSrc);
                        if (this.msInstalledVersion.compareTo("2.0.16") < 0) {
                            this.mParent.getLogger().info("... alte setup Dateien werden entfernt: ");
                            try {
                                this.delLogFile(new File(client + "0x0404.ini"));
                                this.delLogFile(new File(client + "0x0405.ini"));
                                this.delLogFile(new File(client + "0x0407.ini"));
                                this.delLogFile(new File(client + "0x0408.ini"));
                                this.delLogFile(new File(client + "0x0409.ini"));
                                this.delLogFile(new File(client + "0x040a.ini"));
                                this.delLogFile(new File(client + "0x040c.ini"));
                                this.delLogFile(new File(client + "0x0410.ini"));
                                this.delLogFile(new File(client + "0x0411.ini"));
                                this.delLogFile(new File(client + "0x0412.ini"));
                                this.delLogFile(new File(client + "0x0413.ini"));
                                this.delLogFile(new File(client + "0x0415.ini"));
                                this.delLogFile(new File(client + "0x0419.ini"));
                                this.delLogFile(new File(client + "0x041d.ini"));
                                this.delLogFile(new File(client + "0x041e.ini"));
                                this.delLogFile(new File(client + "0x041f.ini"));
                                this.delLogFile(new File(client + "0x0804.ini"));
                                this.delLogFile(new File(client + "0x0816.ini"));
                                this.delLogFile(new File(client + "data1.cab"));
                                this.delLogFile(new File(client + "data1.hdr"));
                                this.delLogFile(new File(client + "data2.cab"));
                                this.delLogFile(new File(client + "engine32.cab"));
                                this.delLogFile(new File(client + "ISSetup.dll"));
                                this.delLogFile(new File(client + "layout.bin"));
                                this.delLogFile(new File(client + "setup.ibt"));
                                this.delLogFile(new File(client + "setup.ini"));
                                this.delLogFile(new File(client + "setup.inx"));
                            }
                            catch (Exception ex) {
                                this.mParent.getLogger().info("Fehler beim L\u00f6schen der alten setup Datein - ex: ", ex);
                            }
                        }
                        Copy.copyDirectory(clientSrc + "libs", client + "libs");
                        Copy.copyDirectory(clientSrc + "endorsed", client + "endorsed");
                        Copy.copyDirectory(clientSrc + "res", client + "res");
                        this.mParent.getLogger().info("..\\javaclient\\res - kopiert");
                        Copy.copyFile(clientSrc + "setup.exe", client + "setup.exe");
                        Copy.copyFile(clientSrc + "version.txt", client + "version.txt");
                        Copy.copyFile(clientSrc + "zub.bmp", client + "zub.bmp");
                        Copy.copyFile(clientSrc + "Setup.bmp", client + "Setup.bmp");
                        Copy.copyFile(sSrcPath + File.separator + "WindowsRegistryDLL.dll", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "WindowsRegistryDLL.dll");
                        Copy.copyFile(sSrcPath + File.separator + "WindowsRegistryDLL.dll", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "WindowsRegistryDLL2.dll");
                        String clientClasses = client + "classes" + File.separator;
                        String clientClassesSrc = clientSrc + "classes" + File.separator;
                        Copy.copyFile(clientClassesSrc + "javaclient.jar", clientClasses + "javaclient.jar");
                        Copy.copyFile(clientClassesSrc + "zubclient.jar", clientClasses + "zubclient.jar");
                        Copy.copyFile(clientClassesSrc + "javaserver.jar", clientClasses + "javaserver.jar");
                        Copy.copyFile(clientClassesSrc + "javaclientStarter.jar", clientClasses + "javaclientStarter.jar");
                        Copy.copyFile(clientClassesSrc + "starter.properties", clientClasses + "starter.properties");
                        Copy.copyFile(clientClassesSrc + "log4j.properties", clientClasses + "log4j.properties");
                        InstallServer.this.updateSWSCrisJavaclientProperties(this.mParent, clientClasses);
                        String clientInstallSrc = sSrcPath + "install" + File.separator;
                        Copy.copyFile(clientInstallSrc + "askclientproperties.bat", clientClasses + "askclientproperties.bat");
                        Copy.copyFile(clientInstallSrc + "install.jar", clientClasses + "install.jar");
                        Copy.copyFile(clientInstallSrc + "standalone.jar", clientClasses + "standalone.jar");
                        this.moKopiere.setProgress(39);
                        String clientTomcat = client + File.separator + "tomcat";
                        Copy.copyDirectory(sSrcPath + "tomcat", clientTomcat);
                        String axis = clientTomcat + File.separator + "webapps" + File.separator + "axis";
                        Copy.copyDirectory(sSrcPath + "axis", axis);
                        String axisWebInf = axis + File.separator + "WEB-INF";
                        Copy.copyDirectory(sSrcPath + "javaclientws" + File.separator + "classes", axisWebInf + File.separator + "classes");
                        Copy.copyFile(sSrcPath + "javaclientws" + File.separator + "server-config.wsdd", axisWebInf + File.separator + "server-config.wsdd");
                        this.moKopiere.setProgress(40);
                        try {
                            fJava = new File(InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre_1.5.0_11.exe");
                            ret4 = fJava.delete();
                            if (!ret4) {
                                // empty if block
                            }
                            fJava = new File(InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre1.5.0_11");
                            this.logInfo("delete Client jre1.5.0_11");
                            Copy.deleteDirectory(fJava);
                        }
                        catch (Exception ex) {
                            this.mParent.getLogger().debug("Konnte nicht Loeschen", ex);
                        }
                        try {
                            fJava = new File(InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre_1.7.0_55.exe");
                            ret4 = fJava.delete();
                            if (!ret4) {
                                // empty if block
                            }
                            fJava = new File(InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre1.7.0_55");
                            this.logInfo("delete Client jre1.7.0_55");
                            Copy.deleteDirectory(fJava);
                        }
                        catch (Exception ex) {
                            this.mParent.getLogger().debug("Konnte nicht Loeschen", ex);
                        }
                        try {
                            fJava = new File(InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre_1.8.0_72.exe");
                            ret4 = fJava.delete();
                            if (!ret4) {
                                // empty if block
                            }
                            fJava = new File(InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre1.8.0_72");
                            this.logInfo("delete Client jre_1.8.0_72");
                            Copy.deleteDirectory(fJava);
                        }
                        catch (Exception ex) {
                            this.mParent.getLogger().debug("Konnte nicht Loeschen", ex);
                        }
                        fJava = new File(InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre_1.8.0_92.exe");
                        this.logInfo("javaclient jre_1.8.0_92.exe exists: " + fJava.exists());
                        if (!fJava.exists()) {
                            Copy.copyFile(sSrcPath + "jre_1.8.0_92.exe", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre_1.8.0_92.exe");
                            if (!InstallServer.isMSWindows()) {
                                Copy.copyFile(sSrcPath + "jre_1.8.0_92.tar.gz", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre_1.8.0_92.tar.gz");
                            }
                        }
                        if (!(fTemp = new File(InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "temp")).exists() && !(ret3 = fTemp.mkdirs())) {
                            this.mParent.getLogger().warn("Could not create TempDir: " + InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "temp");
                        }
                        this.moKopiere.setProgress(60);
                        if (this.msInstalledVersion.compareTo("3.0.01") < 0) {
                            try {
                                Copy.copyDirectory(InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF", InstallServer.this.mszTargetDir + File.separator + "_save_" + File.separator + "webapps" + File.separator + "WEB-INF");
                                File fTomcatDelete = new File(InstallServer.this.mszTargetDir + File.separator + "tomcat");
                                if (fTomcatDelete.exists()) {
                                    this.mParent.getLogger().info("... alter Tomcat wird entfernt ... ");
                                    Copy.deleteDirectory(fTomcatDelete);
                                    this.mParent.getLogger().info("... neuer Tomcat wird hinzugef\u00fcgt ... ");
                                    Copy.copyDirectory(sSrcPath + "tomcat", InstallServer.this.mszTargetDir + File.separator + "tomcat");
                                }
                                Copy.copyDirectory(InstallServer.this.mszTargetDir + File.separator + "_save_" + File.separator + "webapps" + File.separator + "WEB-INF", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF");
                                Copy.deleteDirectory(new File(InstallServer.this.mszTargetDir + File.separator + "_save_"));
                            }
                            catch (Exception ex) {
                                this.mParent.getLogger().info("Fehler beim L\u00f6schen des alten Tomcats - ex: ", ex);
                            }
                        }
                        this.moKopiere.setProgress(79);
                        fTomcat = new File(InstallServer.this.mszTargetDir + File.separator + "tomcat");
                        if (!fTomcat.exists()) {
                            Copy.copyDirectory(sSrcPath + "javaserver", InstallServer.this.mszTargetDir + File.separator + "javaserver");
                        } else {
                            Copy.copyFile(sSrcPath + "javaserver" + File.separator + "javaserver.war", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "javaserver.war");
                            Copy.copyFile(sSrcPath + "tomcat" + File.separator + "bin" + File.separator + "catalina.sh", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "bin" + File.separator + "catalina.sh");
                            Copy.copyFile(sSrcPath + "javaserver" + File.separator + "Zubwbt.war", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "Zubwbt.war");
                        }
                        this.moKopiere.setProgress(98);
                        Copy.copyDirectory(sSrcPath + "standalone", InstallServer.this.mszTargetDir + File.separator + "javaclient");
                        this.moKopiere.setProgress(99);
                        Copy.copyDirectory(sSrcPath + "etk_nutzer", InstallServer.this.mszTargetDir + File.separator + "etk_nutzer");
                        this.moKopiere.setProgress(100);
                    } else {
                        this.mParent.getLogger().info("Neuinstallation");
                        Copy.copyDirectory(sSrcPath + "admintool", InstallServer.this.mszTargetDir + File.separator + "admintool");
                        Copy.copyFile(sSrcPath + "WindowsRegistryDLL.dll", InstallServer.this.mszTargetDir + File.separator + "admintool" + File.separator + "WindowsRegistryDLL.dll");
                        this.moKopiere.setProgress(2);
                        Copy.copyDirectory(sSrcPath + "migration", InstallServer.this.mszTargetDir + File.separator + "migration");
                        this.moKopiere.setProgress(5);
                        Copy.copyDirectory(sSrcPath + "fonts", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "fonts");
                        this.moKopiere.setProgress(25);
                        if (InstallServer.isMSWindows()) {
                            Copy.copyDirectory(sSrcPath + "transbase", InstallServer.this.mszTargetDir + File.separator + "transbase");
                        } else {
                            Copy.copyDirectory(sSrcPath + "transbase_linux", InstallServer.this.mszTargetDir + File.separator + "transbase");
                        }
                        this.moKopiere.setProgress(35);
                        Copy.copyFile(sSrcPath + "jre_1.8.0_92.exe", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre_1.8.0_92.exe");
                        if (!InstallServer.isMSWindows()) {
                            Copy.copyFile(sSrcPath + "jre_1.8.0_92.tar.gz", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "jre_1.8.0_92.tar.gz");
                        }
                        if (this.mbInstallTomcat) {
                            Copy.copyDirectory(sSrcPath + "tomcat", InstallServer.this.mszTargetDir + File.separator + "tomcat");
                            this.moKopiere.setProgress(85);
                        }
                        Copy.copyDirectory(sSrcPath + "javaclient", InstallServer.this.mszTargetDir + File.separator + "javaclient");
                        Copy.copyFile(sSrcPath + File.separator + "WindowsRegistryDLL.dll", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "WindowsRegistryDLL.dll");
                        Copy.copyFile(sSrcPath + File.separator + "WindowsRegistryDLL.dll", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "WindowsRegistryDLL2.dll");
                        this.moKopiere.setProgress(89);
                        String clientTomcat = InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "tomcat";
                        Copy.copyDirectory(sSrcPath + "tomcat", clientTomcat);
                        String axis = clientTomcat + File.separator + "webapps" + File.separator + "axis";
                        Copy.copyDirectory(sSrcPath + "axis", axis);
                        String axisWebInf = axis + File.separator + "WEB-INF";
                        Copy.copyDirectory(sSrcPath + "javaclientws" + File.separator + "classes", axisWebInf + File.separator + "classes");
                        Copy.copyFile(sSrcPath + "javaclientws" + File.separator + "server-config.wsdd", axisWebInf + File.separator + "server-config.wsdd");
                        this.moKopiere.setProgress(90);
                        Copy.copyFile(sSrcPath + "install" + File.separator + "askclientproperties.bat", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "classes" + File.separator + "askclientproperties.bat");
                        Copy.copyFile(sSrcPath + "install" + File.separator + "standalone.jar", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "classes" + File.separator + "standalone.jar");
                        Copy.copyFile(sSrcPath + "install" + File.separator + "install.jar", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "classes" + File.separator + "install.jar");
                        Copy.copyFile(sSrcPath + "version.txt", InstallServer.this.mszTargetDir + File.separator + "javaclient" + File.separator + "version.txt");
                        this.moKopiere.setProgress(91);
                        if (this.mbInstallTomcat) {
                            boolean ret7;
                            Copy.copyFile(sSrcPath + "javaserver" + File.separator + "javaserver.war", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "javaserver.war");
                            File fWebInf = new File(InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF");
                            if (!fWebInf.exists() && !(ret7 = fWebInf.mkdirs())) {
                                this.mParent.getLogger().error("Could not create Tomcat WEB-INF Dir: " + InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF");
                            }
                            Copy.copyFile(sSrcPath + "javaserver" + File.separator + "WEB-INF" + File.separator + "javaclient.properties", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF" + File.separator + "javaclient.properties");
                            Copy.copyFile(sSrcPath + "javaserver" + File.separator + "WEB-INF" + File.separator + "bmwetk.properties", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF" + File.separator + "bmwetk.properties");
                            Copy.copyFile(sSrcPath + "javaserver" + File.separator + "WEB-INF" + File.separator + "log4j.properties", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF" + File.separator + "log4j.properties");
                            Copy.copyFile(sSrcPath + "javaserver" + File.separator + "Zubwbt.war", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "Zubwbt.war");
                        } else {
                            Copy.copyDirectory(sSrcPath + "javaserver", InstallServer.this.mszTargetDir + File.separator + "javaserver");
                        }
                        this.moKopiere.setProgress(95);
                        if (this.mbInstallThinClient) {
                            if (this.mbInstallTomcat) {
                                Copy.copyFile(sSrcPath + "htmlserver" + File.separator + "webetk.war", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "webetk");
                            } else {
                                Copy.copyDirectory(sSrcPath + "htmlserver", InstallServer.this.mszTargetDir + File.separator + "htmlserver");
                            }
                        }
                        this.moKopiere.setProgress(99);
                        Copy.copyDirectory(sSrcPath + "standalone", InstallServer.this.mszTargetDir + File.separator + "javaclient");
                        Copy.copyDirectory(sSrcPath + "etk_nutzer", InstallServer.this.mszTargetDir + File.separator + "etk_nutzer");
                        this.moKopiere.setProgress(100);
                    }
                }
                if (!(fTomcat = new File(InstallServer.this.mszTargetDir + File.separator + "tomcat")).exists()) {
                    Copy.copyFile(sSrcPath + "version.txt", InstallServer.this.mszTargetDir + File.separator + "javaserver" + File.separator + "WEB-INF" + File.separator + "version.txt");
                } else {
                    Copy.copyFile(sSrcPath + "version.txt", InstallServer.this.mszTargetDir + File.separator + "tomcat" + File.separator + "webapps" + File.separator + "WEB-INF" + File.separator + "version.txt");
                }
            }
            catch (RuntimeException ex) {
                this.mParent.getLogger().error("Fehler beim Kopieren: " + ex.getMessage(), ex);
                ex.printStackTrace(System.out);
                System.exit(0);
            }
            catch (Exception ex) {
                this.mParent.getLogger().error("Fehler beim Kopieren: " + ex.getMessage(), ex);
                ex.printStackTrace(System.out);
                System.exit(0);
            }
            this.mParent.executeNextStep();
        }

        private void logInfo(String message) {
            if (this.mParent.getLogger() != null) {
                this.mParent.getLogger().info(message);
            }
            System.out.println(message);
        }
    }
}

