/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.server;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import webetk.install.lookandfeel.UIHelper;
import webetk.install.lookandfeel.WebETKTheme;
import webetk.install.resources.Resource;
import webetk.install.server.HeaderPanel;
import webetk.install.server.InstallServer;
import webetk.install.utils.ImageCache;

public class Sprachauswahl
extends JPanel {
    private InstallServer mParent;
    private HeaderPanel mHeaderPanel;
    private JLabel mTxtSprachPrompt;
    private JButton mButtonUebernehmen;
    private JButton mButtonAbbrechen;
    private JComboBox mComboSprachen;
    private static final String CZECH = "\u010cesk\u00fd";
    private static final String DEUTSCH = "Deutsch";
    private static final String GREEK = "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac";
    private static final String ENGLISCH = "English";
    private static final String ENGLISCH_US = "English (US)";
    private static final String SPANISCH = "Espa\u00f1ol";
    private static final String FRANZOESISCH = "Fran\u00e7ais";
    private static final String JAPANISCH = "\u65e5\u672c\u8a9e";
    private static final String KOREANISCH = "\ud55c\uad6d\uc5b4";
    private static final String NIEDERLAENDISCH = "Nederlands";
    private static final String POLNISCH = "Polski";
    private static final String ITALIENISCH = "Italiano";
    private static final String PORTUGIESISCH = "Portugu\u00eas";
    private static final String RUSISCH = "\u0440\u0443\u0441\u0441\u043a\u0438\u0439";
    private static final String SCHWEDISCH = "Svensk";
    private static final String THAI = "\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22";
    private static final String TUERKISCH = "T\u00fcrk\u00e7e";
    private static final String CHINESISCH = "\u6c49\u8bed";
    private static final String CHINESISCH_TW = "\u53f0\u6e7e\u4eba";

    public Sprachauswahl(InstallServer parent) {
        this.mParent = parent;
        this.mHeaderPanel = new HeaderPanel(Resource.getInstance().getSpracheDerInstallation(), null);
        this.setSize(500, 380);
        this.setLocation(50, 10);
        this.initComponents();
    }

    private void initComponents() {
        this.mParent.setTitle(Resource.getInstance().getSpracheDerInstallation());
        this.mTxtSprachPrompt = new JLabel(Resource.getInstance().getSprachauswahl());
        Vector<String> aSprachen = new Vector<String>();
        aSprachen.add(CZECH);
        aSprachen.add(DEUTSCH);
        aSprachen.add(GREEK);
        aSprachen.add(ENGLISCH);
        aSprachen.add(ENGLISCH_US);
        aSprachen.add(SPANISCH);
        aSprachen.add(FRANZOESISCH);
        aSprachen.add(ITALIENISCH);
        aSprachen.add(JAPANISCH);
        aSprachen.add(KOREANISCH);
        aSprachen.add(NIEDERLAENDISCH);
        aSprachen.add(POLNISCH);
        aSprachen.add(PORTUGIESISCH);
        aSprachen.add(RUSISCH);
        aSprachen.add(SCHWEDISCH);
        aSprachen.add(THAI);
        aSprachen.add(TUERKISCH);
        aSprachen.add(CHINESISCH);
        aSprachen.add(CHINESISCH_TW);
        this.mComboSprachen = new JComboBox(aSprachen);
        this.mComboSprachen.setFont(UIHelper.getSprachenCbUnicodeFont());
        this.setSelSprache(Resource.getInstance().getLanguage());
        this.mButtonUebernehmen = new JButton(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.mButtonAbbrechen = new JButton(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        this.layoutAll();
    }

    private void layoutAll() {
        int[] w = new int[]{0};
        int[] h = new int[]{0, 0, 0};
        HIGLayout l = new HIGLayout(w, h);
        l.setColumnWeight(1, 1);
        l.setRowWeight(3, 1);
        HIGConstraints c = new HIGConstraints();
        this.setLayout(l);
        this.add((Component)this.mHeaderPanel, c.rc(1, 1, "tlbr"));
        JPanel content = this.createContent();
        this.add((Component)content, c.rc(3, 1, "tlbr"));
    }

    private JPanel createContent() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0};
        int[] heights = new int[]{10, 0, 10, 0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.createCenterPanel(), c.rc(2, 2, "lrtb"));
        panel.add((Component)this.createButtonPanel(), c.rc(4, 2, "lrtb"));
        return panel;
    }

    private JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{10, 0, 10};
        int[] heights = new int[]{10, 0, 10, 0, 5};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mTxtSprachPrompt, c.rc(2, 2, "l"));
        panel.add((Component)this.mComboSprachen, c.rc(4, 2, "l"));
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel();
        HIGConstraints c = new HIGConstraints();
        int[] widths = new int[]{-5, -4, 10, -2, -1};
        int[] heights = new int[]{0, 10};
        HIGLayout layoutPosTeileliste = new HIGLayout(widths, heights);
        layoutPosTeileliste.setColumnWeight(1, 1);
        layoutPosTeileliste.setColumnWeight(5, 1);
        layoutPosTeileliste.setRowWeight(2, 1);
        panel.setLayout(layoutPosTeileliste);
        panel.add((Component)this.mButtonUebernehmen, c.rc(1, 2, "lrtb"));
        panel.add((Component)this.mButtonAbbrechen, c.rc(1, 4, "lrtb"));
        this.mButtonUebernehmen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String sISORegISO = Sprachauswahl.this.getSelSprache();
                Resource.setLanguage(sISORegISO);
                WebETKTheme.changeFont(sISORegISO.length() == 4 ? sISORegISO.substring(0, 2) : sISORegISO);
                Sprachauswahl.this.mParent.executeNextStep();
            }
        });
        this.mButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sprachauswahl.this.mParent.stopInstall();
            }
        });
        return panel;
    }

    private void setSelSprache(String sRegiso) {
        for (int ii = 0; ii < this.mComboSprachen.getItemCount(); ++ii) {
            String sBezeichnung = (String)this.mComboSprachen.getItemAt(ii);
            String sItemKuerzel = this.getSpracheKuerzelZuBezeichnung(sBezeichnung);
            if (!sItemKuerzel.equals(sRegiso)) continue;
            this.mComboSprachen.setSelectedIndex(ii);
            break;
        }
    }

    private String getSelSprache() {
        String sSprachBezeichnung = (String)this.mComboSprachen.getSelectedItem();
        return this.getSpracheKuerzelZuBezeichnung(sSprachBezeichnung);
    }

    private String getSpracheKuerzelZuBezeichnung(String sSprachBezeichnung) {
        String sRet = "";
        if (sSprachBezeichnung.equals(CZECH)) {
            sRet = "cs";
        } else if (sSprachBezeichnung.equals(DEUTSCH)) {
            sRet = "de";
        } else if (sSprachBezeichnung.equals(GREEK)) {
            sRet = "el";
        } else if (sSprachBezeichnung.equals(ENGLISCH)) {
            sRet = "en";
        } else if (sSprachBezeichnung.equals(ENGLISCH_US)) {
            sRet = "enUS";
        } else if (sSprachBezeichnung.equals(SPANISCH)) {
            sRet = "es";
        } else if (sSprachBezeichnung.equals(FRANZOESISCH)) {
            sRet = "fr";
        } else if (sSprachBezeichnung.equals(ITALIENISCH)) {
            sRet = "it";
        } else if (sSprachBezeichnung.equals(JAPANISCH)) {
            sRet = "ja";
        } else if (sSprachBezeichnung.equals(KOREANISCH)) {
            sRet = "ko";
        } else if (sSprachBezeichnung.equals(NIEDERLAENDISCH)) {
            sRet = "nl";
        } else if (sSprachBezeichnung.equals(POLNISCH)) {
            sRet = "pl";
        } else if (sSprachBezeichnung.equals(PORTUGIESISCH)) {
            sRet = "pt";
        } else if (sSprachBezeichnung.equals(RUSISCH)) {
            sRet = "ru";
        } else if (sSprachBezeichnung.equals(SCHWEDISCH)) {
            sRet = "sv";
        } else if (sSprachBezeichnung.equals(THAI)) {
            sRet = "th";
        } else if (sSprachBezeichnung.equals(TUERKISCH)) {
            sRet = "tr";
        } else if (sSprachBezeichnung.equals(CHINESISCH)) {
            sRet = "zh";
        } else if (sSprachBezeichnung.equals(CHINESISCH_TW)) {
            sRet = "zhTW";
        }
        return sRet;
    }
}

