/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.utils;

import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import webetk.install.utils.InputThread;
import webetk.install.utils.OutputThread;

public class Command
extends Thread {
    private static Logger log = Logger.getLogger(Command.class);
    private String[] maszCommands;
    private String[] maszEnv;
    private JTextArea moInterface;
    OutputThread mErrThread;
    OutputThread mOutThread;

    public Command(String[] aszCommands, String[] aszEnv, JTextArea oInterface) {
        this.maszCommands = aszCommands;
        this.maszEnv = aszEnv;
        this.moInterface = oInterface;
    }

    @Override
    public void run() {
        try {
            String[] cmd = null;
            if (Command.isMSWindows()) {
                String osName = System.getProperty("os.name");
                int nSize = this.maszCommands.length + 2;
                cmd = new String[nSize];
                cmd[0] = osName.equals("Windows 95") ? "command.com" : "cmd.exe";
                cmd[1] = "/C";
                for (int ii = 0; ii < this.maszCommands.length; ++ii) {
                    cmd[2 + ii] = this.maszCommands[ii];
                }
            } else {
                int nSize = this.maszCommands.length + 1;
                cmd = new String[nSize];
                cmd[0] = "/bin/sh";
                for (int ii = 0; ii < this.maszCommands.length; ++ii) {
                    cmd[1 + ii] = this.maszCommands[ii];
                }
            }
            log.info("Kommando ausfuehren: " + this.getOutput(cmd));
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd, this.maszEnv);
            this.mErrThread = new OutputThread(proc.getErrorStream(), this.moInterface);
            this.mOutThread = new OutputThread(proc.getInputStream(), this.moInterface);
            InputThread inThread = null;
            if (this.moInterface != null) {
                inThread = new InputThread(proc.getOutputStream(), this.moInterface);
            }
            log.info("Threads starten");
            this.mErrThread.start();
            this.mOutThread.start();
            if (inThread != null) {
                inThread.start();
            }
            log.info("auf Ende des Prozesses warten");
            int exitVal = proc.waitFor();
            System.out.println("ExitValue: " + exitVal);
            if (exitVal != 0) {
                log.error("ExitValue: " + exitVal);
            } else {
                log.info("ExitValue: " + exitVal);
            }
            if (this.moInterface == null) {
                this.mOutThread.getOutput();
            }
        }
        catch (RuntimeException ex) {
            log.error(ex);
            ex.printStackTrace();
        }
        catch (Exception ex) {
            log.error(ex);
            ex.printStackTrace();
        }
    }

    private String getOutput(String[] cmd) {
        StringBuilder builder = new StringBuilder();
        for (String s : cmd) {
            builder.append(s);
            builder.append(" ");
        }
        return builder.toString();
    }

    public void waitForFirstOutput() {
        if (!Command.isMSWindows()) {
            return;
        }
        try {
            log.info("auf Output des Prozesses warten");
            String szOutput = "";
            while (szOutput.length() < 1) {
                if (this.mOutThread != null) {
                    Command.sleep(1L);
                    szOutput = this.mOutThread.getOutput();
                    continue;
                }
                Command.sleep(1L);
            }
            log.info("Prozess hat mit Output begonnen");
        }
        catch (Exception ex) {
            log.error("Exception: ", ex);
        }
    }

    public static boolean isMSWindows() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        return (os = os.toUpperCase()).indexOf("WIN") != -1;
    }
}

