/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.utils;

import cz.autel.dmi.HIGConstraints;
import cz.autel.dmi.HIGLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import webetk.install.resources.Resource;
import webetk.install.server.HeaderPanel;
import webetk.install.server.InstallServer;
import webetk.install.utils.ImageCache;
import webetk.install.utils.LineBreakPanel;

public class DirectoryChooserDialog
extends JDialog
implements TreeWillExpandListener {
    private static File rootDirectory = File.listRoots()[0];
    private LineBreakPanel msMessage = null;
    private StringBuffer msResult = null;
    private String msPath = "";
    private JTextField tfPath;
    private JTree tree;
    protected JButton approveButton;
    protected DefaultTreeModel treeModel;
    protected DefaultMutableTreeNode rootNode;
    protected boolean treeExpanding;
    protected LinkedList expandedNodes;
    protected FileSystemView fsv;

    public DirectoryChooserDialog(InstallServer owner, String sTitle, String sMessage, String sPath, StringBuffer sResult) {
        super((Frame)owner, true);
        this.init(sTitle, sMessage, sPath, sResult);
    }

    public DirectoryChooserDialog(JDialog owner, String sTitle, String sMessage, String sPath, StringBuffer sResult) {
        super((Dialog)owner, true);
        this.init(sTitle, sMessage, sPath, sResult);
    }

    public void init(String sTitle, String sMessage, String sPath, StringBuffer sResult) {
        this.msMessage = new LineBreakPanel(sMessage);
        this.msMessage.setZeilenabastand(5);
        if (sMessage != null && sMessage.length() > 100) {
            this.msMessage.setPreferredSize(new Dimension(600, 44));
        } else {
            this.msMessage.setPreferredSize(new Dimension(600, 22));
        }
        this.msPath = sPath;
        this.msResult = sResult;
        HeaderPanel panHeader = new HeaderPanel(sTitle, null);
        this.setTitle(sTitle);
        JPanel panContent = this.createContent();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panHeader, "North");
        this.getContentPane().add((Component)panContent, "Center");
        this.pack();
        this.setSize(620, 500);
        this.setPosition();
        this.rescan();
        this.gotoNode("");
    }

    private JPanel createContent() {
        JLabel txtPath = new JLabel(this.msPath + ":");
        txtPath.setPreferredSize(new Dimension(600, 22));
        this.tfPath = new JTextField();
        this.tfPath.addActionListener(new OkButtonActionListener());
        JLabel txtDirectories = new JLabel(Resource.getInstance().getVerzeichnisse() + ":");
        this.treeExpanding = false;
        this.expandedNodes = new LinkedList();
        this.fsv = new JFileChooser().getFileSystemView();
        this.rootNode = InstallServer.isMSWindows() ? new DefaultMutableTreeNode(this.fsv.getHomeDirectory()) : new DefaultMutableTreeNode(new File(rootDirectory.getAbsolutePath()));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new InnerJTree(this.treeModel);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer());
        this.tree.addTreeWillExpandListener(this);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addKeyListener(new EnterKeyListener());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)DirectoryChooserDialog.this.tree.getLastSelectedPathComponent();
                if (node != null) {
                    DirectoryChooserDialog.this.tfPath.setText(DirectoryChooserDialog.this.getDirectory());
                }
            }
        });
        JButton cancelButton = new JButton(Resource.getInstance().getAbbrechen(), ImageCache.getInstance().getIcon("delete.gif"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectoryChooserDialog.this.msResult.insert(0, "-1");
                DirectoryChooserDialog.this.dispose();
            }
        });
        this.approveButton = new JButton(Resource.getInstance().getOk(), ImageCache.getInstance().getIcon("ok.gif"));
        this.approveButton.addActionListener(new OkButtonActionListener());
        FlowLayout buttonPanelLayout = new FlowLayout(1);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(buttonPanelLayout);
        buttonPanel.add(this.approveButton);
        buttonPanel.add(cancelButton);
        int[] w = new int[]{5, 0, 5};
        int[] h = new int[]{5, 0, 10, 0, 5, 0, 5, 0, 5, 0, 5, 0, 5};
        HIGLayout textLayout = new HIGLayout(w, h);
        HIGConstraints c = new HIGConstraints();
        JPanel textPanel = new JPanel();
        textPanel.setLayout(textLayout);
        textPanel.add((Component)this.msMessage, c.rc(2, 2, "tlbr"));
        textPanel.add((Component)txtPath, c.rc(4, 2, "tlbr"));
        textPanel.add((Component)this.tfPath, c.rcwh(6, 1, 3, 1, "tlbr"));
        textPanel.add((Component)txtDirectories, c.rc(8, 2, "tlbr"));
        JScrollPane treeScrollPane = new JScrollPane(this.tree);
        BorderLayout mainLayout = new BorderLayout();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(mainLayout);
        mainPanel.add((Component)textPanel, "North");
        mainPanel.add((Component)treeScrollPane, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        return mainPanel;
    }

    public void setPosition() {
        int width = Toolkit.getDefaultToolkit().getScreenSize().width;
        int height = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.setLocation((width - this.getWidth()) / 2, (height - this.getHeight()) / 2);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        if (this.treeExpanding) {
            this.treeExpanding = false;
            return;
        }
        TreePath selectedPath = e.getPath();
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        if (!this.expandNode(currentNode)) {
            throw new ExpandVetoException(e);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    public boolean expandNode(DefaultMutableTreeNode currentNode) {
        ListIterator iterator = this.expandedNodes.listIterator();
        while (iterator.hasNext()) {
            if ((DefaultMutableTreeNode)iterator.next() != currentNode) continue;
            return true;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        File[] folders = this.getInnerFolders((File)currentNode.getUserObject());
        if (folders == null || folders.length == 0) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        currentNode.removeAllChildren();
        DefaultMutableTreeNode innerNode = null;
        for (int i = 0; i < folders.length; ++i) {
            innerNode = new DefaultMutableTreeNode(folders[i]);
            currentNode.add(innerNode);
            System.out.println(" + node " + innerNode.getUserObject());
            innerNode.add(new DefaultMutableTreeNode(null));
        }
        this.treeExpanding = true;
        this.treeModel.reload(currentNode);
        this.tree.expandPath(new TreePath(currentNode.getPath()));
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.treeExpanding = false;
        this.expandedNodes.add(currentNode);
        return true;
    }

    public void rescan() {
        this.expandedNodes.clear();
        this.treeModel.reload();
        this.expandNode(this.rootNode);
    }

    protected File[] getInnerFolders(File expandThis) {
        File[] fileContents = expandThis.listFiles();
        if (fileContents == null || fileContents.length == 0 || this.fsv.isFileSystemRoot(fileContents[0])) {
            return fileContents;
        }
        LinkedList<File> folderContents = new LinkedList<File>();
        for (int i = 0; i < fileContents.length; ++i) {
            if (!fileContents[i].isDirectory() || fileContents[i].isHidden()) continue;
            folderContents.add(fileContents[i]);
        }
        Collections.sort(folderContents);
        File[] returnArray = new File[folderContents.size()];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = (File)folderContents.get(i);
        }
        return returnArray;
    }

    public String getDirectory() {
        File selectedFolder = (File)((DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent()).getUserObject();
        if (selectedFolder != null) {
            return selectedFolder.toString();
        }
        return "";
    }

    private void gotoNode(String sPath) {
        ArrayList<String> folders = new ArrayList<String>();
        boolean expandTree = false;
        while (sPath.indexOf(File.separator, 0) != -1) {
            folders.add(sPath.substring(0, sPath.indexOf(File.separator, 0)));
            sPath = sPath.substring(sPath.indexOf(File.separator, 0) + 1, sPath.length());
            expandTree = true;
        }
        if (sPath.length() > 0) {
            folders.add(sPath);
        }
        if (expandTree && InstallServer.isMSWindows()) {
            boolean bFound = false;
            String sArbeitsplatzName = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}";
            for (int ii = 1; ii <= this.tree.getRowCount(); ++ii) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getPathForRow(ii).getLastPathComponent();
                File file = (File)node.getUserObject();
                if (!file.getName().equals(sArbeitsplatzName)) continue;
                this.expandNode(node);
                bFound = true;
                break;
            }
            if (!bFound) {
                this.expandNode((DefaultMutableTreeNode)this.tree.getPathForRow(1).getLastPathComponent());
            }
        }
        int currentIndex = 0;
        block2: for (int i = 0; i < folders.size(); ++i) {
            String folder = folders.get(i).toString();
            for (int j = currentIndex; j < this.tree.getRowCount(); ++j) {
                String path = this.tree.getPathForRow(j).toString();
                if (!path.endsWith(folder + File.separator + "]") && !path.endsWith(folder + "]")) continue;
                this.expandNode((DefaultMutableTreeNode)this.tree.getPathForRow(j).getLastPathComponent());
                currentIndex = ++j;
                continue block2;
            }
        }
        this.tree.scrollRowToVisible(--currentIndex + 10);
        this.tree.setSelectionRow(currentIndex);
    }

    protected void doOkButtonAction() {
        String sTargetDir = this.tfPath.getText();
        this.msResult.insert(0, sTargetDir);
        this.dispose();
    }

    protected static class InnerJTree
    extends JTree {
        protected FileSystemView fileSystemView = null;

        public InnerJTree(DefaultTreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return this.getFileSystemView().getSystemDisplayName((File)((DefaultMutableTreeNode)value).getUserObject());
        }

        public FileSystemView getFileSystemView() {
            if (this.fileSystemView == null) {
                this.fileSystemView = new JFileChooser().getFileSystemView();
            }
            return this.fileSystemView;
        }
    }

    protected class EnterKeyListener
    extends KeyAdapter {
        protected EnterKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ev) {
            if (ev.getKeyCode() == 10) {
                DirectoryChooserDialog.this.doOkButtonAction();
            }
        }
    }

    protected class OkButtonActionListener
    implements ActionListener {
        protected OkButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (DirectoryChooserDialog.this.approveButton.isEnabled()) {
                DirectoryChooserDialog.this.doOkButtonAction();
            }
        }
    }
}

