/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.utils;

import java.awt.Dimension;
import javax.swing.JTextField;
import webetk.install.utils.EnhancedTextDocument;

public class LimitedNumberField
extends JTextField {
    public LimitedNumberField(int maxChars) {
        EnhancedTextDocument ehDoc = new EnhancedTextDocument(maxChars, 1);
        this.setDocument(ehDoc);
        this.setPreferredSizeToDigitLength(maxChars);
    }

    public LimitedNumberField(int maxChars, boolean acceptWildcards) {
        if (acceptWildcards) {
            EnhancedTextDocument ehDoc = new EnhancedTextDocument(maxChars, 2);
            this.setDocument(ehDoc);
        } else {
            EnhancedTextDocument ehDoc = new EnhancedTextDocument(maxChars, 1);
            this.setDocument(ehDoc);
        }
        this.setPreferredSizeToDigitLength(maxChars);
    }

    public LimitedNumberField(int maxChars, boolean acceptPrice, boolean acceptSign) {
        EnhancedTextDocument ehDoc = null;
        ehDoc = acceptPrice ? (acceptSign ? new EnhancedTextDocument(maxChars, 5) : new EnhancedTextDocument(maxChars, 4)) : new EnhancedTextDocument(maxChars, 1);
        this.setDocument(ehDoc);
        this.setPreferredSizeToDigitLength(maxChars);
    }

    public void setPreferredSizeToDigitLength(int numberOfDigits) {
        StringBuffer sb = new StringBuffer(numberOfDigits);
        for (int i = 0; i < numberOfDigits; ++i) {
            sb.append("0");
        }
        String oldText = this.getText();
        this.setText(sb.toString());
        Dimension s = this.getPreferredSize();
        this.setPreferredSize(new Dimension(s.width + 2, s.height));
        this.setText(oldText);
    }
}

