/*
 * Decompiled with CFR 0.152.
 */
package webetk.install.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PropertyUtils {
    private static Logger log = Logger.getLogger(PropertyUtils.class);
    private String propertyFile = "";

    public PropertyUtils() {
    }

    public PropertyUtils(String pFile) {
        this.propertyFile = pFile;
    }

    public Properties loadPropertyFile() {
        return this.loadPropertyFile(this.propertyFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadPropertyFile(String fileName) {
        log.info("loadProperties");
        if (fileName != null) {
            FileInputStream in = null;
            try {
                Properties oProperties = new Properties();
                in = new FileInputStream(fileName);
                log.info("PropertyFile: " + fileName);
                oProperties.load(in);
                log.info("Loaded Properties from file: " + fileName);
                Properties properties = oProperties;
                return properties;
            }
            catch (IOException e) {
                log.error(e);
                e.printStackTrace(System.err);
                Properties properties = null;
                return properties;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        log.error("Property Datei nicht gesetzt");
        return null;
    }

    public Properties loadPropertyFileUTF8(String fileName) {
        log.debug("loadPropertiesUTF8; fileName: " + fileName);
        Properties oProperties = new Properties();
        if (fileName != null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(fileName);
                InputStreamReader isr = new InputStreamReader((InputStream)in, "UTF-8");
                BufferedReader br = new BufferedReader(isr);
                String szLine = br.readLine();
                while (szLine != null) {
                    if (!szLine.startsWith("#")) {
                        String[] keyValue = szLine.split("=");
                        String key = keyValue[0].trim();
                        String value = keyValue[1].trim();
                        oProperties.setProperty(key, value);
                    }
                    szLine = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
                log.error(e);
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                log.error(e);
                e.printStackTrace();
            }
            catch (IOException e) {
                log.error(e);
                e.printStackTrace();
            }
        }
        log.debug("Properties UTF-8 loaded!");
        return oProperties;
    }

    public boolean saveProperties(Properties properties) {
        return this.saveProperties(properties, this.propertyFile);
    }

    public boolean saveProperties(Properties properties, String fileName) {
        try {
            FileOutputStream propOutFile = new FileOutputStream(fileName);
            properties.store(propOutFile, "");
            propOutFile.close();
            return true;
        }
        catch (FileNotFoundException e) {
            log.error(e);
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error(e);
            e.printStackTrace();
        }
        return false;
    }

    public boolean saveProperties(Properties properties, String filename, String charsetName) {
        try {
            String comments = "";
            FileOutputStream propOutFile = new FileOutputStream(filename);
            BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter((OutputStream)propOutFile, charsetName));
            if (comments != null) {
                PropertyUtils.writeln(awriter, "#" + comments);
            }
            PropertyUtils.writeln(awriter, "#" + new Date().toString());
            String key = null;
            String val = null;
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                key = entry.getKey().toString();
                val = entry.getValue().toString();
                PropertyUtils.writeln(awriter, key + "=" + val);
            }
            awriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    public void editPropertyFile(String sField, String sValue) {
        try {
            Vector<String> aszZeilen = new Vector<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(this.propertyFile)));
            String szLine = in.readLine();
            while (szLine != null) {
                if ((szLine = szLine.trim()).startsWith(sField)) {
                    szLine = sField + " = " + sValue;
                }
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            in.close();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.propertyFile)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            log.error(e);
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error(e);
            e.printStackTrace();
        }
    }

    public void list(Properties props) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = props.getProperty(key);
            log.debug("Key: " + key + "  Value: " + value);
        }
    }

    public void updatePropertyFile(Properties propsnew, Properties propsold, String fileName) {
        log.debug("property File: " + fileName);
        this.list(propsnew);
        PropertyUtils.getFileExistsAndCreateIfNot(fileName);
        Vector<String> aszZeilen = new Vector<String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            String szLine = in.readLine();
            while (szLine != null) {
                for (Map.Entry<Object, Object> entry : propsnew.entrySet()) {
                    if (szLine.indexOf(entry.getKey().toString()) != 0 || szLine.indexOf(entry.getKey().toString() + ".") >= 0) continue;
                    szLine = entry.getKey().toString() + "=" + entry.getValue().toString();
                }
                aszZeilen.add(szLine);
                szLine = in.readLine();
            }
            for (Map.Entry<Object, Object> entry : propsnew.entrySet()) {
                if (propsold.containsKey(entry.getKey())) continue;
                szLine = entry.getKey().toString() + "=" + entry.getValue().toString();
                aszZeilen.add(szLine);
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));
            Iterator iter = aszZeilen.iterator();
            while (iter.hasNext()) {
                out.write((String)iter.next() + System.getProperty("line.separator"));
            }
            out.close();
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean getFileExistsAndCreateIfNot(String pFile) {
        File f = new File(pFile);
        if (f.exists()) {
            return true;
        }
        try {
            f.createNewFile();
            return true;
        }
        catch (IOException e) {
            log.error("Konnte " + pFile + " nicht anlegen");
            log.error(e);
            e.printStackTrace();
            return false;
        }
    }

    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }
}

