/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import transbase.jdbc.ConnectionControl;
import transbase.jdbc.JDBCTSpec;
import transbase.jdbc.PreparedStatement;
import transbase.jdbc.TBJDBCLog;
import transbase.jdbc.TBTypeMapEntry;
import transbase.jdbc.TBTypeProperties;
import transbase.tbx.TBException;
import transbase.tbx.types.TypeToClass;
import transbase.tbx.types.helpers.TBObject;

public class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    private TBJDBCLog mLog;

    public CallableStatement(ConnectionControl connectionControl, String string, int n, int n2, TBJDBCLog tBJDBCLog) throws SQLException {
        super(connectionControl, string, n, n2, tBJDBCLog);
        this.mLog = tBJDBCLog;
        this.mLog.logJDBCMethodCall(this, null, new Object[]{connectionControl, string});
        this.mLog.logJDBCReturnValue(this, null, null);
    }

    public ResultSet executeQuery() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "executeQuery", null);
        ResultSet resultSet = super.executeQuery();
        this.mLog.logJDBCReturnValue(this, "executeQuery", resultSet);
        return resultSet;
    }

    public boolean execute() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "execute", null);
        this.storedQuery.checkProcAllRegistered();
        boolean bl = super.execute();
        if (bl) {
            this.openResultSet.next();
        }
        this.mLog.logJDBCReturnValue(this, "execute", new Boolean(bl));
        return bl;
    }

    public int executeUpdate() throws SQLException {
        throw new TBException(30009);
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "registerOutParameter", new Object[]{new Integer(n)});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(n2, this.mCharEncodingFactory);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "registerOutParameter", null);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "registerOutParameter", new Object[]{new Integer(n)});
        TBObject tBObject = null;
        switch (n2) {
            case 2: 
            case 3: {
                tBObject = TypeToClass.getInstance(new TBTypeMapEntry(n2, 3, new JDBCTSpec(3, 0, 0, n3, 0, 0)).getTBType(), this.mCharEncodingFactory);
                break;
            }
            default: {
                throw new TBException(30213);
            }
        }
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "registerOutParameter", null);
    }

    public boolean wasNull() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "wasNull", null);
        boolean bl = this.openResultSet.wasNull();
        this.mLog.logJDBCReturnValue(this, "wasNull", new Boolean(bl));
        return bl;
    }

    public String getString(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getString", new Object[]{new Integer(n)});
        String string = this.openResultSet.getString(n);
        this.mLog.logJDBCReturnValue(this, "getString", string);
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBoolean", new Object[]{new Integer(n)});
        boolean bl = this.openResultSet.getBoolean(n);
        this.mLog.logJDBCReturnValue(this, "getBoolean", new Boolean(bl));
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getByte", new Object[]{new Integer(n)});
        byte by = this.openResultSet.getByte(n);
        this.mLog.logJDBCReturnValue(this, "getByte", new Byte(by));
        return by;
    }

    public short getShort(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getShort", new Object[]{new Integer(n)});
        short s = this.openResultSet.getShort(n);
        this.mLog.logJDBCReturnValue(this, "getShort", new Short(s));
        return s;
    }

    public int getInt(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getInt", new Object[]{new Integer(n)});
        int n2 = this.openResultSet.getInt(n);
        this.mLog.logJDBCReturnValue(this, "getInt", new Integer(n2));
        return n2;
    }

    public long getLong(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getLong", new Object[]{new Integer(n)});
        long l = this.openResultSet.getLong(n);
        this.mLog.logJDBCReturnValue(this, "getLong", new Long(l));
        return l;
    }

    public float getFloat(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getFloat", new Object[]{new Integer(n)});
        float f = this.openResultSet.getFloat(n);
        this.mLog.logJDBCReturnValue(this, "getFloat", new Float(f));
        return f;
    }

    public double getDouble(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDouble", new Object[]{new Integer(n)});
        double d = this.openResultSet.getDouble(n);
        this.mLog.logJDBCReturnValue(this, "getDouble", new Double(d));
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBigDecimal", new Object[]{new Integer(n), new Integer(n2)});
        BigDecimal bigDecimal = this.openResultSet.getBigDecimal(n, n2);
        this.mLog.logJDBCReturnValue(this, "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBytes", new Object[]{new Integer(n)});
        byte[] byArray = this.openResultSet.getBytes(n);
        this.mLog.logJDBCReturnValue(this, "getBytes", byArray);
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDate", new Object[]{new Integer(n)});
        Date date = this.openResultSet.getDate(n);
        this.mLog.logJDBCReturnValue(this, "getDate", date);
        return date;
    }

    public Time getTime(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTime", new Object[]{new Integer(n)});
        Time time = this.openResultSet.getTime(n);
        this.mLog.logJDBCReturnValue(this, "getTime", time);
        return time;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTimestamp", new Object[]{new Integer(n)});
        Timestamp timestamp = this.openResultSet.getTimestamp(n);
        this.mLog.logJDBCReturnValue(this, "getTimestamp", timestamp);
        return timestamp;
    }

    public Object getObject(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getObject", new Object[]{new Integer(n)});
        Object object = this.openResultSet.getObject(n);
        this.mLog.logJDBCReturnValue(this, "getObject", object);
        return object;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBigDecimal", new Object[]{new Integer(n)});
        BigDecimal bigDecimal = this.openResultSet.getBigDecimal(n);
        this.mLog.logJDBCReturnValue(this, "getBigDecimal", bigDecimal);
        return bigDecimal;
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getObject", new Object[]{new Integer(n), map});
        Object object = this.openResultSet.getObject(n, map);
        this.mLog.logJDBCReturnValue(this, "getObject", object);
        return object;
    }

    public Ref getRef(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getRef", new Object[]{new Integer(n)});
        Ref ref = this.openResultSet.getRef(n);
        this.mLog.logJDBCReturnValue(this, "getRef", ref);
        return ref;
    }

    public Blob getBlob(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getBlob", new Object[]{new Integer(n)});
        Blob blob = this.openResultSet.getBlob(n);
        this.mLog.logJDBCReturnValue(this, "getBlob", blob);
        return blob;
    }

    public Clob getClob(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getClob", new Object[]{new Integer(n)});
        Clob clob = this.openResultSet.getClob(n);
        this.mLog.logJDBCReturnValue(this, "getClob", clob);
        return clob;
    }

    public Array getArray(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getArray", new Object[]{new Integer(n)});
        Array array = this.openResultSet.getArray(n);
        this.mLog.logJDBCReturnValue(this, "getArray", array);
        return array;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getDate", new Object[]{new Integer(n), calendar});
        Date date = this.openResultSet.getDate(n, calendar);
        this.mLog.logJDBCReturnValue(this, "getDate", date);
        return date;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTime", new Object[]{new Integer(n), calendar});
        Time time = this.openResultSet.getTime(n, calendar);
        this.mLog.logJDBCReturnValue(this, "getTime", time);
        return time;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTimestamp", new Object[]{new Integer(n), calendar});
        Timestamp timestamp = this.openResultSet.getTimestamp(n, calendar);
        this.mLog.logJDBCReturnValue(this, "getTimestamp", timestamp);
        return timestamp;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "registerOutParameter", new Object[]{new Integer(n), new Integer(n2), string});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(n2, this.mCharEncodingFactory);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "registerOutParameter", null);
    }
}

