/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import transbase.jdbc.CallableStatement;
import transbase.jdbc.ConnectionControl;
import transbase.jdbc.DatabaseMetaData;
import transbase.jdbc.DriverSettings;
import transbase.jdbc.PreparedStatement;
import transbase.jdbc.SQLWarningQueue;
import transbase.jdbc.Statement;
import transbase.jdbc.TBJDBCLog;
import transbase.jdbc.TBNativeSQL;
import transbase.tbx.TBException;
import transbase.tbx.TBURL;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXObjectFactory;
import transbase.tbx.TBXTransactionIf;

public class Connection
implements java.sql.Connection {
    private TBJDBCLog mLog;
    private TBXConnectionIf connection = null;
    private TBXTransactionIf transaction = null;
    private TBXObjectFactory layer = null;
    private boolean readOnlyDB = false;
    protected ConnectionControl connectionControl;
    protected SQLWarningQueue mWarningQueue = new SQLWarningQueue();

    protected TBXConnectionIf getTBXConnection() {
        return this.connection;
    }

    public Connection(String string, Properties properties, TBXObjectFactory tBXObjectFactory, TBJDBCLog tBJDBCLog) throws SQLException {
        String string2;
        this.mLog = tBJDBCLog;
        this.mLog.logJDBCMethodCall(this, null, new Object[]{string, "{user, password, options hidden}", tBXObjectFactory});
        TBURL tBURL = new TBURL(string);
        if (!tBURL.isTransbase() || !tBURL.isValid()) {
            throw TBException.getTBException(30031, new String[]{tBURL.getUrl()});
        }
        Properties properties2 = new Properties(tBURL.getProperties());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            properties2.setProperty(string2, properties.getProperty(string2));
        }
        String string3 = (String)DriverSettings.getValue(properties2, 0);
        String string4 = (String)DriverSettings.getValue(properties2, 1);
        this.layer = tBXObjectFactory;
        string2 = (String)DriverSettings.getValue(properties2, 5);
        this.connection = tBXObjectFactory.getConnection(tBURL, string2, this.mLog);
        this.connection.login(string3, string4);
        this.connectionControl = new ConnectionControl(this, this.layer, string3, this.connection.getCharEncodingFactory(), this.mLog);
        this.connectionControl.setAutoCommitMode((Integer)DriverSettings.getValue(properties2, 2));
        this.connectionControl.setDefaultEscapeProcessing((Integer)DriverSettings.getValue(properties2, 4) == 1);
        if (this.layer.toString().startsWith("transbase.tbx.coman.TBXComanObjectFactory")) {
            this.connectionControl.setAutoCommit(false);
        }
        this.mLog.logJDBCReturnValue(this, null, null);
    }

    public synchronized void clearWarnings() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "clearWarnings", null);
        this.mWarningQueue.clearWarnings();
        this.mLog.logJDBCReturnValue(this, "clearWarnings", null);
    }

    public void close() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "close", null);
        this.connectionControl.close(false);
        this.mLog.logJDBCReturnValue(this, "close", null);
    }

    public void commit() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "commit", null);
        this.connectionControl.commit();
        this.mLog.logJDBCReturnValue(this, "commit", null);
    }

    public java.sql.Statement createStatement() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "createStatement", null);
        java.sql.Statement statement = this.createStatement(1003, 1007);
        this.mLog.logJDBCReturnValue(this, "createStatement", statement);
        return statement;
    }

    public boolean getAutoCommit() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getAutoCommit", null);
        boolean bl = this.connectionControl.getAutoCommit();
        this.mLog.logJDBCReturnValue(this, "getAutoCommit", new Boolean(bl));
        return bl;
    }

    public String getCatalog() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getCatalog", null);
        this.mLog.logJDBCReturnValue(this, "getCatalog", null);
        return null;
    }

    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMetaData", null);
        DatabaseMetaData databaseMetaData = new DatabaseMetaData(this, this.connectionControl, this.mLog);
        this.mLog.logJDBCReturnValue(this, "getMetaData", databaseMetaData);
        return databaseMetaData;
    }

    public int getTransactionIsolation() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTransactionIsolation", null);
        int n = this.connectionControl.getTransactionIsolation();
        this.mLog.logJDBCReturnValue(this, "getTransactionIsolation", new Integer(n));
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getWarnings", null);
        SQLWarning sQLWarning = this.mWarningQueue.getWarnings();
        this.mLog.logJDBCReturnValue(this, "getWarnings", sQLWarning);
        return sQLWarning;
    }

    public boolean isClosed() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isClosed", null);
        boolean bl = this.connectionControl.isClosed();
        this.mLog.logJDBCReturnValue(this, "isClosed", new Boolean(bl));
        return bl;
    }

    public boolean isReadOnly() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "isReadOnly", null);
        this.mLog.logJDBCReturnValue(this, "isReadOnly", new Boolean(this.readOnlyDB));
        return this.readOnlyDB;
    }

    public String nativeSQL(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "nativeSQL", new Object[]{string});
        string = new TBNativeSQL(string, this.connectionControl).getNativeSQL();
        this.mLog.logJDBCReturnValue(this, "nativeSQL", string);
        return string;
    }

    public java.sql.CallableStatement prepareCall(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "prepareCall", new Object[]{string});
        java.sql.CallableStatement callableStatement = this.prepareCall(string, 1003, 1007);
        this.mLog.logJDBCReturnValue(this, "prepareCall", callableStatement);
        return callableStatement;
    }

    public java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "prepareStatement", new Object[]{string});
        java.sql.PreparedStatement preparedStatement = this.prepareStatement(string, 1003, 1007);
        this.mLog.logJDBCReturnValue(this, "prepareStatement", preparedStatement);
        return preparedStatement;
    }

    public void rollback() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "rollback", null);
        this.connectionControl.rollback();
        this.mLog.logJDBCReturnValue(this, "rollback", null);
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setAutoCommit", new Object[]{new Boolean(bl)});
        this.connectionControl.setAutoCommit(bl);
        this.mLog.logJDBCReturnValue(this, "setAutoCommit", null);
    }

    public void setCatalog(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setCatalog", new Object[]{string});
        this.mLog.logJDBCReturnValue(this, "setCatalog", null);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setReadOnly", new Object[]{new Boolean(bl)});
        this.readOnlyDB = bl;
        this.mLog.logJDBCReturnValue(this, "setReadOnly", null);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setTransactionIsolation", new Object[]{new Integer(n)});
        this.connectionControl.setTransactionIsolation(n);
        this.mLog.logJDBCReturnValue(this, "setTransactionIsolation", null);
    }

    public java.sql.Statement createStatement(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "createStatement", new Object[]{new Integer(n), new Integer(n2)});
        Statement statement = new Statement(this.connectionControl, n, n2, this.mLog);
        this.mLog.logJDBCReturnValue(this, "createStatement", statement);
        return statement;
    }

    public java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "prepareStatement", new Object[]{string, new Integer(n), new Integer(n2)});
        PreparedStatement preparedStatement = new PreparedStatement(this.connectionControl, string, n, n2, this.mLog);
        this.mLog.logJDBCReturnValue(this, "prepareStatement", preparedStatement);
        return preparedStatement;
    }

    public java.sql.CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "prepareCall", new Object[]{string, new Integer(n), new Integer(n2)});
        CallableStatement callableStatement = new CallableStatement(this.connectionControl, string, n, n2, this.mLog);
        this.mLog.logJDBCReturnValue(this, "prepareCall", callableStatement);
        return callableStatement;
    }

    public Map getTypeMap() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getTypeMap", null);
        Hashtable hashtable = new Hashtable();
        this.mLog.logJDBCReturnValue(this, "getTypeMap", hashtable);
        return hashtable;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setTypeMap", new Object[]{map});
        if (map.size() > 0) {
            throw new TBException(30201);
        }
        this.mLog.logJDBCReturnValue(this, "setTypeMap", null);
    }

    protected SQLWarningQueue getWarningQueue() {
        return this.mWarningQueue;
    }

    public void rollbackOutband() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "rollbackOutband", null);
        this.connectionControl.rollbackOutband();
        this.mLog.logJDBCReturnValue(this, "rollbackOutband", null);
    }
}

