/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import transbase.jdbc.Connection;
import transbase.jdbc.DriverSettings;
import transbase.jdbc.TBJDBCLog;
import transbase.jdbc.Version;
import transbase.tbx.TBException;
import transbase.tbx.TBURL;
import transbase.tbx.TBXObjectFactory;

public class Driver
implements java.sql.Driver {
    private TBJDBCLog mLog = new TBJDBCLog();

    public boolean acceptsURL(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "acceptsURL", new Object[]{string});
        TBURL tBURL = new TBURL(string);
        boolean bl = tBURL.isTransbase();
        this.mLog.logJDBCReturnValue(this, "acceptsURL", new Boolean(bl));
        return bl;
    }

    private void throwLayerException(String string, String string2) throws SQLException {
        throw TBException.getTBException(30030, new String[]{string, string2});
    }

    public java.sql.Connection connect(String string, Properties properties) throws SQLException {
        return this.connect(string, properties, this.mLog);
    }

    public java.sql.Connection connect(String string, Properties properties, TBJDBCLog tBJDBCLog) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "connect", new Object[]{string, "{Properties hidden}"});
        DriverSettings.checkRequired(string, properties);
        String string2 = (String)DriverSettings.getValue(properties, 3);
        TBXObjectFactory tBXObjectFactory = null;
        try {
            tBXObjectFactory = (TBXObjectFactory)Class.forName(string2).newInstance();
        }
        catch (ClassCastException classCastException) {
            this.throwLayerException(string2, "this is not a valid tbx layer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.throwLayerException(string2, "class not found in class path");
        }
        catch (Exception exception) {
            this.throwLayerException(string2, exception.toString());
        }
        Connection connection = new Connection(string, properties, tBXObjectFactory, tBJDBCLog);
        this.mLog.logJDBCReturnValue(this, "connect", connection);
        return connection;
    }

    public int getMajorVersion() {
        this.mLog.logJDBCMethodCall(this, "getMajorVersion", null);
        int n = Version.getMajorVersion();
        this.mLog.logJDBCReturnValue(this, "getMajorVersion", new Integer(n));
        return n;
    }

    public int getMinorVersion() {
        this.mLog.logJDBCMethodCall(this, "getMinorVersion", null);
        int n = Version.getMinorVersion();
        this.mLog.logJDBCReturnValue(this, "getMinorVersion", new Integer(n));
        return n;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getPropertyInfo", new Object[]{string, "{Properties hidden}"});
        DriverPropertyInfo[] driverPropertyInfoArray = DriverSettings.getPropertyInfo(string, properties);
        this.mLog.logJDBCReturnValue(this, "getPropertyInfo", new Object[]{"Properties hidden"});
        return driverPropertyInfoArray;
    }

    public boolean jdbcCompliant() {
        this.mLog.logJDBCMethodCall(this, "jdbcCompliant", null);
        this.mLog.logJDBCReturnValue(this, "jdbcCompliant", new Boolean(true));
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("TransBase JDBC Driver");
        System.out.println("Driver: ".concat(String.valueOf(String.valueOf(Version.getVersionString()))));
        String string = "not installed";
        try {
            Class<?> clazz = Class.forName("transbase.jdbcx.Version");
            Method method = clazz.getMethod("getVersionString", new Class[0]);
            string = (String)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        System.out.println("Standard extension: ".concat(String.valueOf(String.valueOf(string))));
    }

    static {
        try {
            Driver driver = new Driver();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

