/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import transbase.tbx.TBException;
import transbase.tbx.TBURL;

public class DriverSettings {
    public static final String DEFAULT_TBX_LAYER = "transbase.tbx.java.TBXJavaObjectFactory";
    public static final String DEFAULT_CONNECTION_LAYER = "transbase.tbx.coman.TBXComanObjectFactory";
    public static final String DEFAULT_ESCAPE_PROC = "ENABLED";
    public static final String DEFAULT_CHARACTER_ENCODING = null;
    public static final String DEFAULT_AUTOCOMMIT_MODE = "STRICT";
    protected static final int PROP_USER = 0;
    protected static final int PROP_PASSWORD = 1;
    protected static final int PROP_AUTOCOMMITMODE = 2;
    protected static final int PROP_TBXLAYER = 3;
    protected static final int PROP_ESCAPESYNTAX = 4;
    protected static final int PROP_CHARACTER_ENCODING = 5;
    protected static final int AC_CURSOR_SENSITIVE = 0;
    protected static final int AC_STRICT = 1;
    protected static final int AC_STRICT_ON_UPDATES = 2;
    protected static final int SW_DISABLED = 0;
    protected static final int SW_ENABLED = 1;
    private static final DriverPropertyInfo[] allProperties = new DriverPropertyInfo[]{DriverSettings.createProperty("user", "user name", true, null, null), DriverSettings.createProperty("password", "user password", true, null, null), DriverSettings.createProperty("autocommitmode", "auto commit mode", false, "STRICT", new String[]{"CURSOR_SENSITIVE", "STRICT", "STRICT_ON_UPDATES"}), DriverSettings.createProperty("tbxlayer", "tbx layer class name", false, "transbase.tbx.java.TBXJavaObjectFactory", null), DriverSettings.createProperty("escapesyntax", "parsing of escape syntax at startup", false, "ENABLED", new String[]{"DISABLED", "ENABLED"}), DriverSettings.createProperty("characterencoding", "encoding for String conversion", false, DEFAULT_CHARACTER_ENCODING, null)};

    private static DriverPropertyInfo createProperty(String string, String string2, boolean bl, String string3, String[] stringArray) {
        DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string, null);
        driverPropertyInfo.choices = stringArray;
        driverPropertyInfo.description = string2;
        driverPropertyInfo.required = bl;
        driverPropertyInfo.value = string3;
        return driverPropertyInfo;
    }

    private static int getPropertyPos(String string) {
        if (string == null) {
            return -1;
        }
        for (int i = 0; i < allProperties.length; ++i) {
            if (!DriverSettings.allProperties[i].name.equals(string)) continue;
            return i;
        }
        return -1;
    }

    protected static String getPropertyKey(int n) {
        if (n < 0 || n >= allProperties.length) {
            return null;
        }
        return DriverSettings.allProperties[n].name;
    }

    protected static Object getValue(Properties properties, int n) throws SQLException {
        return DriverSettings.getValue(properties, DriverSettings.getPropertyKey(n));
    }

    protected static Object getValue(Properties properties, String string) throws SQLException {
        int n = DriverSettings.getPropertyPos(string);
        if (n < 0) {
            return null;
        }
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            string2 = DriverSettings.allProperties[n].value;
        }
        if (DriverSettings.allProperties[n].choices == null) {
            return string2;
        }
        String[] stringArray = DriverSettings.allProperties[n].choices;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string2)) continue;
            return new Integer(i);
        }
        throw TBException.getTBException(30029, new String[]{string2, string});
    }

    private static DriverPropertyInfo[] addPropertyInfoElem(DriverPropertyInfo[] driverPropertyInfoArray, DriverPropertyInfo driverPropertyInfo) {
        if (driverPropertyInfoArray == null) {
            driverPropertyInfoArray = new DriverPropertyInfo[]{};
        }
        if (driverPropertyInfo == null) {
            return driverPropertyInfoArray;
        }
        DriverPropertyInfo[] driverPropertyInfoArray2 = new DriverPropertyInfo[driverPropertyInfoArray.length + 1];
        System.arraycopy(driverPropertyInfoArray, 0, driverPropertyInfoArray2, 0, driverPropertyInfoArray.length);
        driverPropertyInfoArray2[driverPropertyInfoArray.length] = driverPropertyInfo;
        return driverPropertyInfoArray2;
    }

    protected static DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{};
        TBURL tBURL = new TBURL(string);
        if (!tBURL.isTransbase() || !tBURL.isValid()) {
            throw TBException.getTBException(30031, new String[]{string});
        }
        Properties properties2 = tBURL.getProperties();
        for (int i = 0; i < allProperties.length; ++i) {
            String string2 = properties.getProperty(DriverSettings.allProperties[i].name);
            if (string2 == null) {
                string2 = properties2.getProperty(DriverSettings.allProperties[i].name);
            }
            if (DriverSettings.allProperties[i].choices != null) {
                DriverSettings.getValue(properties, DriverSettings.allProperties[i].name);
            }
            if (string2 != null) continue;
            DriverPropertyInfo driverPropertyInfo = allProperties[i];
            driverPropertyInfoArray = DriverSettings.addPropertyInfoElem(driverPropertyInfoArray, driverPropertyInfo);
        }
        return driverPropertyInfoArray;
    }

    protected static void checkRequired(String string, Properties properties) throws SQLException {
        TBURL tBURL = new TBURL(string);
        if (!tBURL.isTransbase() || !tBURL.isValid()) {
            throw TBException.getTBException(30031, new String[]{string});
        }
        Properties properties2 = tBURL.getProperties();
        for (int i = 0; i < allProperties.length; ++i) {
            if (DriverSettings.getValue(properties, i) == null) {
                if (DriverSettings.getValue(properties2, i) != null || !DriverSettings.allProperties[i].required) continue;
                throw TBException.getTBException(30029, new String[]{"<null>", DriverSettings.getPropertyKey(i)});
            }
            if (DriverSettings.getValue(properties2, i) == null || i != 3) continue;
            ((Hashtable)properties).put(DriverSettings.getPropertyKey(i), DriverSettings.getValue(properties2, i));
        }
    }
}

