/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import transbase.jdbc.ConnectionControl;
import transbase.jdbc.ResultSet;
import transbase.jdbc.ResultSetMetaData;
import transbase.jdbc.SQLParser;
import transbase.jdbc.Statement;
import transbase.jdbc.TBJDBCLog;
import transbase.jdbc.TBNativeSQL;
import transbase.jdbc.TBTypeMapEntry;
import transbase.jdbc.TBTypeProperties;
import transbase.tbx.TBException;
import transbase.tbx.TBXCursor;
import transbase.tbx.TBXCursorIf;
import transbase.tbx.TBXQuery;
import transbase.tbx.TBXStoredQuery;
import transbase.tbx.types.TypeInfo;
import transbase.tbx.types.TypeToClass;
import transbase.tbx.types.helpers.TBObject;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private String statement;
    protected TBXStoredQuery storedQuery;
    private boolean positionedStatement = false;
    private boolean positionedDelete = false;
    private String statementCursorName = null;
    private TBJDBCLog mLog;

    public PreparedStatement(ConnectionControl connectionControl, String string, int n, int n2, TBJDBCLog tBJDBCLog) throws SQLException {
        super(connectionControl, n, n2, tBJDBCLog);
        this.mLog = tBJDBCLog;
        this.mLog.logJDBCMethodCall(this, null, new Object[]{connectionControl, string});
        this.statement = this.escapeProcessing ? new TBNativeSQL(string, connectionControl).getNativeSQL() : string;
        SQLParser sQLParser = new SQLParser(string);
        this.positionedStatement = sQLParser.isPositionedStatement();
        this.positionedDelete = sQLParser.isPositionedDelete();
        this.statementCursorName = sQLParser.getCursorName();
        this.storedQuery = this.layer.storeQuery(this.statement, connectionControl.getConnection(), this.mLog);
        this.mLog.logJDBCReturnValue(this, null, null);
    }

    public void close() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "close", null);
        super.close();
        this.storedQuery.close();
        this.mLog.logJDBCReturnValue(this, "close", null);
    }

    public java.sql.ResultSet executeQuery() throws SQLException {
        TBXCursor tBXCursor;
        this.mLog.logJDBCMethodCall(this, "executeQuery", null);
        this.getWarningQueue().clearWarnings();
        this.closeCurrentResultSet();
        this.lastResult = null;
        this.connectionControl.tryAutoCommit(2);
        try {
            int n = 0;
            if (this.getResultSetType() == 1004) {
                n = n | 2 | 1;
            }
            tBXCursor = this.storedQuery.open(this.connectionControl.getTransaction(), n);
        }
        catch (SQLException sQLException) {
            try {
                this.connectionControl.tryAutoCommit(3);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw sQLException;
            }
            throw sQLException;
        }
        ResultSet resultSet = new ResultSet(this.connectionControl, tBXCursor, this.maxRows, this.maxFieldSize, this.cursorName, this, this.mLog);
        this.setCurrentResultSet(resultSet);
        this.mLog.logJDBCReturnValue(this, "executeQuery", resultSet);
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        Object object;
        this.mLog.logJDBCMethodCall(this, "executeUpdate", null);
        this.getWarningQueue().clearWarnings();
        this.closeCurrentResultSet();
        this.lastResult = null;
        if (this.positionedStatement) {
            TBXCursorIf tBXCursorIf = this.connectionControl.getCursorByName(this.statementCursorName.toUpperCase(), true);
            if (this.positionedDelete) {
                tBXCursorIf.deletePositionedStored(this.storedQuery);
            } else {
                tBXCursorIf.updatePositionedStored(this.storedQuery);
            }
            object = new Integer(1);
        } else {
            this.connectionControl.tryAutoCommit(3);
            try {
                object = this.storedQuery.run(this.connectionControl.getTransaction());
            }
            catch (SQLException sQLException) {
                try {
                    this.connectionControl.tryAutoCommit(3);
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw sQLException;
                }
                throw sQLException;
            }
            this.connectionControl.tryAutoCommit(3);
        }
        int n = 0;
        if (object != null) {
            try {
                n = (Integer)object;
            }
            catch (ClassCastException classCastException) {
                throw new TBException(30009);
            }
        }
        this.mLog.logJDBCReturnValue(this, "executeUpdate", new Integer(n));
        return n;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setNull", new Object[]{new Integer(n), new Integer(n2)});
        TBTypeMapEntry tBTypeMapEntry = TBTypeProperties.mapToTB(n2);
        int n3 = 15;
        if (tBTypeMapEntry != null) {
            n3 = tBTypeMapEntry.getTBType();
        }
        this.storedQuery.setNull(n, n3);
        this.mLog.logJDBCReturnValue(this, "setNull", null);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setBoolean", new Object[]{new Integer(n), new Boolean(bl)});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(-7, this.mCharEncodingFactory);
        tBObject.setBoolean(bl);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setBoolean", null);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setByte", new Object[]{new Integer(n), new Byte(by)});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(-6, this.mCharEncodingFactory);
        tBObject.setByte(by);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setByte", null);
    }

    public void setShort(int n, short s) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setShort", new Object[]{new Integer(n), new Short(s)});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(5, this.mCharEncodingFactory);
        tBObject.setShort(s);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setShort", null);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setInt", new Object[]{new Integer(n), new Integer(n2)});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(4, this.mCharEncodingFactory);
        tBObject.setInt(n2);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setInt", null);
    }

    public void setLong(int n, long l) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setLong", new Object[]{new Integer(n), new Long(l)});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(-5, this.mCharEncodingFactory);
        tBObject.setLong(l);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setLong", null);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setFloat", new Object[]{new Integer(n), new Float(f)});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(6, this.mCharEncodingFactory);
        tBObject.setFloat(f);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setFloat", null);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setDouble", new Object[]{new Integer(n), new Double(d)});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(8, this.mCharEncodingFactory);
        tBObject.setDouble(d);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setDouble", null);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setBigDecimal", new Object[]{new Integer(n), bigDecimal});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(2, this.mCharEncodingFactory);
        tBObject.setBigDecimal(bigDecimal);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setBigDecimal", null);
    }

    public void setString(int n, String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setString", new Object[]{new Integer(n), string});
        TypeInfo typeInfo = null;
        TBObject tBObject = null;
        try {
            tBObject = TBTypeProperties.getPreferedTBObject(12, this.mCharEncodingFactory);
            typeInfo = TypeInfo.createTypeInfo(tBObject.getTBType(), null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (typeInfo == null || typeInfo.getMaxprec() < string.length()) {
            tBObject = TBTypeProperties.getPreferedTBObject(-1, this.mCharEncodingFactory);
        }
        tBObject.setString(string);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setString", null);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setBytes", new Object[]{new Integer(n), "byte x[] of length ".concat(String.valueOf(String.valueOf(byArray.length)))});
        TypeInfo typeInfo = null;
        TBObject tBObject = null;
        try {
            tBObject = TBTypeProperties.getPreferedTBObject(-3, this.mCharEncodingFactory);
            typeInfo = TypeInfo.createTypeInfo(tBObject.getTBType(), null);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (typeInfo == null || typeInfo.getMaxprec() < byArray.length) {
            tBObject = TBTypeProperties.getPreferedTBObject(-4, this.mCharEncodingFactory);
        }
        tBObject.setBytes(byArray);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setBytes", null);
        this.mLog.logJDBCReturnValue(this, "setBytes", null);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setDate", new Object[]{new Integer(n), date});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(91, this.mCharEncodingFactory);
        tBObject.setDate(date);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setDate", null);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setTime", new Object[]{new Integer(n), time});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(92, this.mCharEncodingFactory);
        tBObject.setTime(time);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setTime", null);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setTimestamp", new Object[]{new Integer(n), timestamp});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(93, this.mCharEncodingFactory);
        tBObject.setTimestamp(timestamp);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setTimestamp", null);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setAsciiStream", new Object[]{new Integer(n), inputStream, new Integer(n2)});
        int n3 = this.storedQuery.getExpectedType(n);
        TBObject tBObject = null;
        try {
            tBObject = TypeToClass.getInstance(n3, this.mCharEncodingFactory);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (tBObject == null) {
            TypeInfo typeInfo = null;
            try {
                tBObject = TBTypeProperties.getPreferedTBObject(12, this.mCharEncodingFactory);
                typeInfo = TypeInfo.createTypeInfo(tBObject.getTBType(), null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (typeInfo == null || typeInfo.getMaxprec() < n2) {
                tBObject = TBTypeProperties.getPreferedTBObject(-1, this.mCharEncodingFactory);
            }
        }
        tBObject.setAsciiStream(inputStream, n2);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setAsciiStream", null);
    }

    private TBObject getUnicodeWrapper(int n, int n2) throws SQLException {
        TBObject tBObject = null;
        int n3 = this.storedQuery.getExpectedType(n);
        try {
            tBObject = TypeToClass.getInstance(n3, this.mCharEncodingFactory);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (tBObject == null) {
            TypeInfo typeInfo = null;
            try {
                tBObject = TBTypeProperties.getPreferedTBObject(12, this.mCharEncodingFactory);
                typeInfo = TypeInfo.createTypeInfo(tBObject.getTBType(), null);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (typeInfo == null || typeInfo.getMaxprec() < n2) {
                tBObject = TBTypeProperties.getPreferedTBObject(-1, this.mCharEncodingFactory);
            }
        }
        return tBObject;
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setUnicodeStream", new Object[]{new Integer(n), inputStream, new Integer(n2)});
        TBObject tBObject = this.getUnicodeWrapper(n, n2 / 2);
        tBObject.setUnicodeStream(inputStream, n2);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setUnicodeStream", null);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setBinaryStream", new Object[]{new Integer(n), inputStream, new Integer(n2)});
        int n3 = this.storedQuery.getExpectedType(n);
        TBObject tBObject = null;
        try {
            tBObject = TypeToClass.getInstance(n3, this.mCharEncodingFactory);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (tBObject == null) {
            tBObject = TBTypeProperties.getPreferedTBObject(-4, this.mCharEncodingFactory);
        }
        tBObject.setBinaryStream(inputStream, n2);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setBinaryStream", null);
    }

    public void clearParameters() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "clearParameters", null);
        this.storedQuery.clearParameters();
        this.mLog.logJDBCReturnValue(this, "clearParameters", null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setObject", new Object[]{new Integer(n), object, new Integer(n2), new Integer(n3)});
        if (n2 == 1111) {
            if (!(object instanceof TBObject)) throw new TBException(30038, object.getClass().getName());
            this.storedQuery.setObject(n, (TBObject)object);
        } else {
            TBObject tBObject = TBTypeProperties.getPreferedTBObject(n2, this.mCharEncodingFactory);
            int n4 = TBTypeProperties.getJavaClassCode(object);
            switch (n4) {
                case 1: {
                    tBObject.setString((String)object);
                    break;
                }
                case 2: {
                    BigDecimal bigDecimal = ((BigDecimal)object).setScale(n3, 1);
                    tBObject.setBigDecimal(bigDecimal);
                    break;
                }
                case 3: {
                    tBObject.setBoolean((Boolean)object);
                    break;
                }
                case 4: {
                    tBObject.setInt((Integer)object);
                    break;
                }
                case 5: {
                    tBObject.setLong((Long)object);
                    break;
                }
                case 6: {
                    tBObject.setFloat(((Float)object).floatValue());
                    break;
                }
                case 7: {
                    tBObject.setDouble((Double)object);
                    break;
                }
                case 8: {
                    tBObject.setBytes((byte[])object);
                    break;
                }
                case 9: {
                    tBObject.setDate((Date)object);
                    break;
                }
                case 10: {
                    tBObject.setTime((Time)object);
                    break;
                }
                case 11: {
                    tBObject.setTimestamp((Timestamp)object);
                    break;
                }
                default: {
                    throw TBException.getTBException(30027, object.getClass().getName());
                }
            }
            this.storedQuery.setObject(n, tBObject);
        }
        this.mLog.logJDBCReturnValue(this, "setObject", null);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setObject", new Object[]{new Integer(n), object, new Integer(n2)});
        this.setObject(n, object, n2, 0);
        this.mLog.logJDBCReturnValue(this, "setObject", null);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setObject", new Object[]{new Integer(n), object});
        if (object instanceof TBObject) {
            this.setObject(n, object, 1111, 0);
        } else {
            int n2;
            int n3 = TBTypeProperties.getJavaClassCode(object);
            switch (n3) {
                case 1: {
                    n2 = 12;
                    TBTypeMapEntry tBTypeMapEntry = TBTypeProperties.mapToTB(n2);
                    if (tBTypeMapEntry != null && (tBTypeMapEntry == null || ((String)object).length() <= tBTypeMapEntry.getTBTypeInfo().getMaxprec())) break;
                    n2 = -1;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = -7;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 5: {
                    n2 = -5;
                    break;
                }
                case 6: {
                    n2 = 7;
                    break;
                }
                case 7: {
                    n2 = 8;
                    break;
                }
                case 8: {
                    n2 = -3;
                    TBTypeMapEntry tBTypeMapEntry = TBTypeProperties.mapToTB(n2);
                    if (tBTypeMapEntry != null && (tBTypeMapEntry == null || ((String)object).length() <= tBTypeMapEntry.getTBTypeInfo().getMaxprec())) break;
                    n2 = -4;
                    break;
                }
                case 9: {
                    n2 = 91;
                    break;
                }
                case 10: {
                    n2 = 92;
                    break;
                }
                case 11: {
                    n2 = 93;
                    break;
                }
                default: {
                    throw TBException.getTBException(30027, object.getClass().getName());
                }
            }
            this.setObject(n, object, n2, 0);
        }
        this.mLog.logJDBCReturnValue(this, "setObject", null);
    }

    public boolean execute() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "execute", null);
        this.closeCurrentResultSet();
        this.lastResult = null;
        this.lastResult = TBXQuery.isQuerySelectClass(this.storedQuery.getQueryDescriptor().getQueryType()) ? this.executeQuery() : new Integer(this.executeUpdate());
        boolean bl = this.getLastResultType();
        this.mLog.logJDBCReturnValue(this, "execute", new Boolean(bl));
        return bl;
    }

    public void addBatch() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "addBatch", null);
        throw new TBException(30203);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setCharacterStream", new Object[]{new Integer(n), new Integer(n2)});
        TBObject tBObject = this.getUnicodeWrapper(n, n2);
        tBObject.setCharacterStream(reader, n2);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setCharacterStream", null);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setRef", new Object[]{new Integer(n), ref});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(2006, this.mCharEncodingFactory);
        tBObject.setRef(ref);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setRef", null);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setBlob", new Object[]{new Integer(n), blob});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(2004, this.mCharEncodingFactory);
        tBObject.setBlob(blob);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setBlob", null);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setClob", new Object[]{new Integer(n), clob});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(2005, this.mCharEncodingFactory);
        tBObject.setClob(clob);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setClob", null);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setArray", new Object[]{new Integer(n), array});
        TBObject tBObject = TBTypeProperties.getPreferedTBObject(2003, this.mCharEncodingFactory);
        tBObject.setArray(array);
        this.storedQuery.setObject(n, tBObject);
        this.mLog.logJDBCReturnValue(this, "setArray", null);
    }

    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMetaData", null);
        ResultSetMetaData resultSetMetaData = new ResultSetMetaData(this.storedQuery.getQueryDescriptor(), this.mLog);
        this.mLog.logJDBCReturnValue(this, "getMetaData", resultSetMetaData);
        return resultSetMetaData;
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setDate", new Object[]{new Integer(n), date, calendar});
        this.setDate(n, date);
        this.mLog.logJDBCReturnValue(this, "setDate", null);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setTime", new Object[]{new Integer(n), time, calendar});
        this.setTime(n, time);
        this.mLog.logJDBCReturnValue(this, "setTime", null);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setTimestamp", new Object[]{new Integer(n), timestamp, calendar});
        this.setTimestamp(n, timestamp);
        this.mLog.logJDBCReturnValue(this, "setTimestamp", null);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setNull", new Object[]{new Integer(n), new Integer(n2), string});
        this.setNull(n, n2);
        this.mLog.logJDBCReturnValue(this, "setNull", null);
    }
}

