/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import transbase.tbx.TBException;

public class SQLParser {
    public static final int UNDEFINED = 0;
    public static final int STRING_LITERAL = 1;
    public static final int COMMENT = 2;
    public static final int ESCAPE_SEQUENCE = 3;
    public static final int SQL = 4;
    public static final int SPACE = 5;
    private String sql;
    private Vector tokens = new Vector(10, 10);
    private int tokenCursor = 0;
    private boolean positionedStatement = false;
    private boolean positionedDelete = false;
    private String cursorName = null;

    public SQLParser(String string) throws SQLException {
        this.sql = string;
        this.scan();
        if (this.isPositionedStatement()) {
            this.validatePositioned();
        }
    }

    public boolean isPositionedStatement() {
        return this.positionedStatement;
    }

    public boolean isPositionedDelete() {
        return this.positionedDelete;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    public String getOriginalStatement() {
        return this.sql;
    }

    public void reset() {
        this.tokenCursor = 0;
    }

    public boolean hasMoreTokens() {
        return this.tokenCursor < this.tokens.size();
    }

    private void addToken(String string, int n) {
        this.tokens.addElement(new Object[]{string, new Integer(n)});
    }

    private String tokenAt(int n) {
        String string = null;
        if (n >= 0 && n < this.tokens.size()) {
            string = (String)((Object[])this.tokens.elementAt(n))[0];
        }
        return string;
    }

    private int typeAt(int n) {
        int n2 = 0;
        if (n >= 0 && n < this.tokens.size()) {
            n2 = (Integer)((Object[])this.tokens.elementAt(n))[1];
        }
        return n2;
    }

    public String nextToken() {
        String string = null;
        if (this.hasMoreTokens()) {
            string = this.tokenAt(this.tokenCursor);
            ++this.tokenCursor;
        }
        return string;
    }

    public int getTokenType() {
        return this.typeAt(this.tokenCursor);
    }

    private void scan() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.sql, "{}'-\n\t ()", true);
        String string2 = "";
        int n2 = 5;
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            n3 = 4;
            if (!bl2 && !bl) {
                if (string.equals("-")) {
                    if (string3.equals("-")) {
                        bl = true;
                    }
                    n3 = 2;
                    n2 = 2;
                }
                if (string3.equals("{")) {
                    n3 = 3;
                    ++n;
                }
                if (string3.equals("}")) {
                    n3 = 3;
                    --n;
                }
                if (string3.equals(" ") || string3.equals("\n") || string3.equals("\t")) {
                    n3 = 5;
                }
            }
            if (string3.equals("\n") && bl) {
                bl = false;
                n3 = 2;
            }
            if (string3.equals("'") && !bl) {
                bl2 = !bl2;
                n3 = 1;
            }
            if (bl2) {
                n3 = 1;
            }
            if (bl) {
                n3 = 2;
            }
            if (n > 0) {
                n3 = 3;
            }
            if (n3 == 4 && string3.equalsIgnoreCase("current")) {
                this.positionedStatement = true;
            }
            if (n2 == n3) {
                string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string3)));
            } else {
                this.addToken(string2, n2);
                string2 = string3;
                n2 = n3;
            }
            string = string3;
        }
        this.addToken(string2, n2);
    }

    public String skipSpacesAndComments() {
        int n;
        String string = "";
        while (this.hasMoreTokens() && ((n = this.getTokenType()) == 5 || n == 2)) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(this.nextToken())));
        }
        return string;
    }

    private void validatePositioned() throws SQLException {
        this.skipSpacesAndComments();
        String string = this.nextToken().toLowerCase();
        if (string.equals("update")) {
            this.cursorName = this.scanForCursorName(false);
        } else if (string.equals("delete")) {
            this.cursorName = this.scanForCursorName(true);
            this.positionedDelete = true;
        } else {
            this.positionedStatement = false;
        }
        this.reset();
        if (this.positionedStatement && this.cursorName == null) {
            throw new TBException(30024);
        }
    }

    private String scanForCursorName(boolean bl) {
        String string = null;
        while (this.hasMoreTokens() && !this.nextToken().equalsIgnoreCase("where")) {
        }
        this.skipSpacesAndComments();
        if (this.hasMoreTokens() && this.nextToken().equalsIgnoreCase("current")) {
            this.skipSpacesAndComments();
            if (this.hasMoreTokens()) {
                String string2 = this.nextToken();
                if (!string2.equalsIgnoreCase("of")) {
                    string = string2;
                }
                this.skipSpacesAndComments();
                if (string == null && this.hasMoreTokens()) {
                    string = this.nextToken();
                }
            }
        } else if (!bl) {
            return this.scanForCursorName(bl);
        }
        this.skipSpacesAndComments();
        if (this.hasMoreTokens()) {
            return null;
        }
        return string;
    }
}

