/*
 * Decompiled with CFR 0.152.
 */
package transbase.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import transbase.jdbc.Connection;
import transbase.jdbc.ConnectionControl;
import transbase.jdbc.ResultSet;
import transbase.jdbc.SQLParser;
import transbase.jdbc.SQLWarningQueue;
import transbase.jdbc.TBJDBCLog;
import transbase.jdbc.TBNativeSQL;
import transbase.tbx.TBException;
import transbase.tbx.TBXCursor;
import transbase.tbx.TBXCursorIf;
import transbase.tbx.TBXObjectFactory;
import transbase.tbx.TBXQuery;
import transbase.tbx.types.helpers.CharEncodingFactory;

public class Statement
implements java.sql.Statement {
    protected ConnectionControl connectionControl;
    protected TBXObjectFactory layer;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected String cursorName = "";
    protected Object lastResult = null;
    protected ResultSet openResultSet;
    protected boolean escapeProcessing = true;
    private static int cursorNameCounter = 0;
    private static Object cursorNameSema = new Object();
    private int timeout = 30;
    private int mFetchDirection = 1002;
    private int mFetchSize = 0;
    private int mResultSetConcurrency;
    private int mResultSetType;
    private SQLWarningQueue mWarningQueue = new SQLWarningQueue();
    protected CharEncodingFactory mCharEncodingFactory;
    private TBJDBCLog mLog;

    protected static String getUniqueCursorName() {
        String string;
        Object object = cursorNameSema;
        synchronized (object) {
            string = "C".concat(String.valueOf(String.valueOf(cursorNameCounter)));
            cursorNameCounter = cursorNameCounter >= 9999999 ? 0 : ++cursorNameCounter;
        }
        return string;
    }

    public Statement(ConnectionControl connectionControl, int n, int n2, TBJDBCLog tBJDBCLog) throws SQLException {
        this.mLog = tBJDBCLog;
        this.mLog.logJDBCMethodCall(this, null, new Object[]{connectionControl});
        this.connectionControl = connectionControl;
        this.mCharEncodingFactory = connectionControl.getCharEncodingFactory();
        this.layer = connectionControl.getObjectFactory();
        this.cursorName = Statement.getUniqueCursorName();
        this.escapeProcessing = connectionControl.getDefaultEscapeProcessing();
        this.mapResultSetType(n, n2);
        this.mLog.logJDBCReturnValue(this, null, null);
    }

    protected void mapResultSetType(int n, int n2) {
        int n3;
        Connection connection = this.connectionControl.getJDBCConnection();
        this.mResultSetConcurrency = n2;
        this.mResultSetType = n;
        if (n != 1003 && n != 1004) {
            n3 = n == 1005 ? 1004 : 1003;
            connection.getWarningQueue().chainWarning(30205, new String[]{ResultSet.getTypeDesc(this.mResultSetType), ResultSet.getTypeDesc(n3)});
            this.mResultSetType = n3;
        }
        if (this.mResultSetConcurrency != 1007) {
            n3 = 1007;
            connection.getWarningQueue().chainWarning(30206, new String[]{ResultSet.getConcurrencyDesc(this.mResultSetConcurrency), ResultSet.getTypeDesc(this.mResultSetType), ResultSet.getConcurrencyDesc(n3)});
            this.mResultSetConcurrency = n3;
        }
    }

    protected java.sql.ResultSet executeMetadataQuery(String string) throws SQLException {
        return this.executeQuery(string, true);
    }

    protected java.sql.ResultSet executeQuery(String string, boolean bl) throws SQLException {
        TBXCursor tBXCursor;
        this.mLog.logJDBCMethodCall(this, "executeQuery", new Object[]{string});
        this.mWarningQueue.clearWarnings();
        this.closeCurrentResultSet();
        this.lastResult = null;
        if (!bl) {
            this.connectionControl.tryAutoCommit(bl ? 1 : 2);
        }
        if (this.escapeProcessing) {
            string = new TBNativeSQL(string, this.connectionControl).getNativeSQL();
        }
        TBXQuery tBXQuery = this.layer.getQuery(string, this.mLog);
        try {
            int n = 0;
            if (this.getResultSetType() == 1004) {
                n = n | 2 | 1;
            }
            tBXCursor = tBXQuery.open(this.connectionControl.getTransaction(), this.connectionControl.getConnection(), n);
        }
        catch (SQLException sQLException) {
            try {
                this.connectionControl.tryAutoCommit(3);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw sQLException;
            }
            throw sQLException;
        }
        ResultSet resultSet = new ResultSet(this.connectionControl, tBXCursor, this.maxRows, this.maxFieldSize, this.cursorName, this, this.mLog);
        this.setCurrentResultSet(resultSet);
        resultSet.setMetaDataResult(bl);
        this.mLog.logJDBCReturnValue(this, "executeQuery", resultSet);
        return resultSet;
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        return this.executeQuery(string, false);
    }

    protected void setCurrentResultSet(ResultSet resultSet) {
        this.openResultSet = resultSet;
    }

    protected void closeCurrentResultSet() {
        if (this.openResultSet != null) {
            try {
                try {
                    this.openResultSet.close();
                }
                catch (SQLException sQLException) {
                    Object var3_2 = null;
                    this.openResultSet = null;
                }
                Object var3_1 = null;
                this.openResultSet = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.openResultSet = null;
                throw throwable;
            }
        }
    }

    public int executeUpdate(String string) throws SQLException {
        Object object;
        this.mLog.logJDBCMethodCall(this, "executeUpdate", new Object[]{string});
        this.mWarningQueue.clearWarnings();
        this.closeCurrentResultSet();
        this.lastResult = null;
        SQLParser sQLParser = new SQLParser(string);
        if (this.escapeProcessing) {
            string = new TBNativeSQL(sQLParser, this.connectionControl).getNativeSQL();
        }
        TBXQuery tBXQuery = this.layer.getQuery(string, this.mLog);
        if (sQLParser.isPositionedStatement()) {
            TBXCursorIf tBXCursorIf = this.connectionControl.getCursorByName(sQLParser.getCursorName().toUpperCase(), true);
            if (sQLParser.isPositionedDelete()) {
                tBXCursorIf.deletePositioned();
            } else {
                tBXCursorIf.updatePositioned(tBXQuery);
            }
            object = new Integer(1);
        } else {
            this.connectionControl.tryAutoCommit(3);
            try {
                object = tBXQuery.run(this.connectionControl.getTransaction(), this.connectionControl.getConnection());
            }
            catch (SQLException sQLException) {
                try {
                    this.connectionControl.tryAutoCommit(3);
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    throw sQLException;
                }
                throw sQLException;
            }
            this.connectionControl.tryAutoCommit(3);
        }
        int n = 0;
        if (object != null) {
            try {
                n = (Integer)object;
            }
            catch (ClassCastException classCastException) {
                throw new TBException(30009);
            }
        }
        this.mLog.logJDBCReturnValue(this, "executeUpdate", new Integer(n));
        return n;
    }

    public void close() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "close", null);
        this.closeCurrentResultSet();
        this.mLog.logJDBCReturnValue(this, "close", null);
    }

    public int getMaxFieldSize() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxFieldSize", null);
        this.mLog.logJDBCReturnValue(this, "getMaxFieldSize", new Integer(this.maxFieldSize));
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setMaxFieldSize", new Object[]{new Integer(n)});
        this.maxFieldSize = n;
        this.mLog.logJDBCReturnValue(this, "setMaxFieldSize", null);
    }

    public int getMaxRows() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMaxRows", null);
        this.mLog.logJDBCReturnValue(this, "getMaxRows", new Integer(this.maxRows));
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setMaxRows", new Object[]{new Integer(n)});
        this.maxRows = n;
        if (this.mFetchSize > 0 && this.maxRows < this.mFetchSize) {
            this.mFetchSize = this.maxRows;
        }
        this.mLog.logJDBCReturnValue(this, "setMaxRows", null);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setEscapeProcessing", new Object[]{new Boolean(bl)});
        this.escapeProcessing = bl;
        this.mLog.logJDBCReturnValue(this, "setEscapeProcessing", null);
    }

    public int getQueryTimeout() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getQueryTimeout", null);
        this.mLog.logJDBCReturnValue(this, "getQueryTimeout", new Integer(this.timeout));
        return this.timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setQueryTimeout", new Object[]{new Integer(n)});
        this.timeout = n;
        this.mLog.logJDBCReturnValue(this, "setQueryTimeout", null);
    }

    public void cancel() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "cancel", null);
        this.mLog.logJDBCReturnValue(this, "cancel", null);
    }

    public SQLWarning getWarnings() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getWarnings", null);
        SQLWarning sQLWarning = this.mWarningQueue.getWarnings();
        this.mLog.logJDBCReturnValue(this, "getWarnings", sQLWarning);
        return sQLWarning;
    }

    public void clearWarnings() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "clearWarnings", null);
        this.mWarningQueue.clearWarnings();
        this.mLog.logJDBCReturnValue(this, "clearWarnings", null);
    }

    protected SQLWarningQueue getWarningQueue() {
        return this.mWarningQueue;
    }

    public void setCursorName(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setCursorName", new Object[]{string});
        this.cursorName = string;
        this.mLog.logJDBCReturnValue(this, "setCursorName", null);
    }

    protected boolean getLastResultType() {
        if (this.lastResult == null) {
            return false;
        }
        try {
            Integer n = (Integer)this.lastResult;
        }
        catch (ClassCastException classCastException) {
            boolean bl = true;
            return bl;
        }
        return false;
    }

    public boolean execute(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "execute", new Object[]{string});
        this.closeCurrentResultSet();
        this.lastResult = null;
        TBXQuery tBXQuery = this.layer.getQuery(string, this.mLog);
        this.lastResult = tBXQuery.getQueryClass() == 42 ? this.executeQuery(string) : new Integer(this.executeUpdate(string));
        boolean bl = this.getLastResultType();
        this.mLog.logJDBCReturnValue(this, "execute", new Boolean(bl));
        return bl;
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getResultSet", null);
        java.sql.ResultSet resultSet = this.getLastResultType() ? (java.sql.ResultSet)this.lastResult : null;
        this.mLog.logJDBCReturnValue(this, "getResultSet", resultSet);
        return resultSet;
    }

    public int getUpdateCount() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getUpdateCount", null);
        int n = this.getLastResultType() || this.lastResult == null ? -1 : (Integer)this.lastResult;
        this.mLog.logJDBCReturnValue(this, "getUpdateCount", new Integer(n));
        return n;
    }

    public boolean getMoreResults() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getMoreResults", null);
        this.closeCurrentResultSet();
        this.lastResult = null;
        this.mLog.logJDBCReturnValue(this, "getMoreResults", new Boolean(false));
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setFetchDirection", new Object[]{new Integer(n)});
        ResultSet.testFetchDirection(n);
        this.mFetchDirection = n;
        this.mLog.logJDBCReturnValue(this, "setFetchDirection", null);
    }

    public int getFetchDirection() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getFetchDirection", null);
        this.mLog.logJDBCReturnValue(this, "getFetchDirection", new Integer(this.mFetchDirection));
        return this.mFetchDirection;
    }

    public void setFetchSize(int n) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "setFetchSize", new Object[]{new Integer(n)});
        int n2 = this.getMaxRows();
        if (n < 0 || n2 != 0 && n > this.getMaxRows()) {
            throw TBException.getTBException(30202, new String[]{Integer.toString(n)});
        }
        this.mFetchSize = n;
        this.mLog.logJDBCReturnValue(this, "setFetchSize", null);
    }

    public int getFetchSize() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getFetchSize", null);
        this.mLog.logJDBCReturnValue(this, "getFetchSize", new Integer(this.mFetchSize));
        return this.mFetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getResultSetConcurrency", null);
        this.mLog.logJDBCReturnValue(this, "getResultSetConcurrency", new Integer(this.mResultSetConcurrency));
        return this.mResultSetConcurrency;
    }

    public int getResultSetType() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getResultSetType", null);
        this.mLog.logJDBCReturnValue(this, "getResultSetType", new Integer(this.mResultSetType));
        return this.mResultSetType;
    }

    public void addBatch(String string) throws SQLException {
        this.mLog.logJDBCMethodCall(this, "addBatch", new Object[]{string});
        throw new TBException(30203);
    }

    public void clearBatch() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "clearBatch", null);
        throw new TBException(30203);
    }

    public int[] executeBatch() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "executeBatch", null);
        throw new TBException(30203);
    }

    public java.sql.Connection getConnection() throws SQLException {
        this.mLog.logJDBCMethodCall(this, "getConnection", null);
        Connection connection = this.connectionControl.getJDBCConnection();
        this.mLog.logJDBCReturnValue(this, "getConnection", connection);
        return connection;
    }
}

