/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import transbase.tbx.TBConst;
import transbase.tbx.TBException;
import transbase.tbx.TBLog;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXCursorIf;
import transbase.tbx.TBXObjectFactory;
import transbase.tbx.TBXQuery;
import transbase.tbx.TBXStoredQuery;
import transbase.tbx.TBXTransactionIf;
import transbase.tbx.requests.TBReqCursorFetchIf;
import transbase.tbx.requests.TBReqEvalIf;
import transbase.tbx.requests.TBReqGetStreamIf;
import transbase.tbx.stypes.TBTypeQd;
import transbase.tbx.tuple.TBAttribute;
import transbase.tbx.tuple.TBTuple;
import transbase.tbx.types.TBBlob;
import transbase.tbx.types.TypeInfo;
import transbase.tbx.types.helpers.BlobStream;
import transbase.tbx.types.helpers.QueryDescriptor;
import transbase.tbx.types.helpers.TBObject;
import transbase.tbx.types.helpers.TSpec;

public class TBXCursor
implements TBXCursorIf {
    static final short EOD_UNDEF = -1;
    static final short EOD_NO_TUPLE = 1;
    static final short EOD_ONE_TUPLE = 2;
    static final short EOD_MORE_TUPLES = 3;
    public static final int CURSOR_INSENSITIVE = 1;
    public static final int CURSOR_SCROLLABLE = 2;
    public static final int CURSOR_POS_REL = 1;
    public static final int CURSOR_POS_ABS = 2;
    public static final short FETCH_FORWARD = 1;
    public static final short FETCH_REVERSE = 0;
    public static final short FETCH_UNKNOWN = -1;
    protected String statement;
    protected TBXConnectionIf con;
    protected TBXTransactionIf trans;
    protected TBTypeQd queryDesc;
    protected int quid = -1;
    protected TBXObjectFactory layer;
    protected TBLog mLog;
    private Object[] tupleBuffer = new TBTuple[0];
    private Hashtable mCursorTupleLookup = null;
    private Vector typeInfoBuffer = new Vector(1, 5);
    private TBTuple actTuple = null;
    private short mUserFetchDirection = (short)-1;
    Boolean mCursorHasResults = null;
    private int mRow = 0;
    private int mMinRowIndex = 0;
    private int mMaxRowIndex = 0;
    private int mTotalRows = -1;
    private int mOpenMode;

    public TBXCursor(TBXConnectionIf tBXConnectionIf, TBXTransactionIf tBXTransactionIf, String string, TBTypeQd tBTypeQd, int n, TBLog tBLog, TBXObjectFactory tBXObjectFactory) throws SQLException {
        this.mLog = tBLog;
        this.statement = new String(string);
        this.con = tBXConnectionIf;
        this.trans = tBXTransactionIf;
        this.queryDesc = tBTypeQd;
        this.quid = tBTypeQd.getQuid();
        this.layer = tBXObjectFactory;
        this.mOpenMode = n;
    }

    private void testClosed() throws SQLException {
        if (this.isClosed()) {
            throw new TBException(30004);
        }
    }

    private void testOnRow() throws SQLException {
        this.testClosed();
        if (!this.isOnRow()) {
            throw new TBException(16006);
        }
    }

    private void testScrollable() throws SQLException {
        if ((this.mOpenMode & 2) == 0) {
            throw new TBException(30040);
        }
    }

    private boolean getTuplesFromDatabase() throws SQLException {
        if (this.mTotalRows >= 0 && this.mMaxRowIndex >= this.mTotalRows) {
            return false;
        }
        TBReqEvalIf tBReqEvalIf = this.layer.getTBReqEval(this.con, this.queryDesc);
        Object[] objectArray = tBReqEvalIf.getTupleVector(0).toArray();
        int n = objectArray.length;
        int n2 = this.mMaxRowIndex - this.mRow;
        TBTuple[] tBTupleArray = new TBTuple[n2 + n];
        System.arraycopy(this.tupleBuffer, this.tupleBuffer.length - n2, tBTupleArray, 0, n2);
        System.arraycopy(objectArray, 0, tBTupleArray, n2, n);
        this.mMinRowIndex = this.mRow + 1;
        this.mMaxRowIndex = this.mRow + n2 + n;
        this.tupleBuffer = tBTupleArray;
        return n > 0;
    }

    private boolean getTuplesFromDatabaseCursor(int n, short s) throws SQLException {
        TBReqCursorFetchIf tBReqCursorFetchIf = this.layer.getTBReqCursorFetch(this.con, this.queryDesc, n, s);
        this.tupleBuffer = tBReqCursorFetchIf.getTupleVector(1).toArray();
        this.mMinRowIndex = tBReqCursorFetchIf.getLeftRowPos();
        this.mMaxRowIndex = tBReqCursorFetchIf.getRightRowPos();
        this.mTotalRows = tBReqCursorFetchIf.getRowCount();
        this.mCursorTupleLookup = new Hashtable(this.tupleBuffer.length);
        for (int i = 0; i < this.tupleBuffer.length; ++i) {
            TBTuple tBTuple = (TBTuple)this.tupleBuffer[i];
            this.mCursorTupleLookup.put(new Integer(tBTuple.getRowIndex()), tBTuple);
        }
        return this.mMinRowIndex == this.mMaxRowIndex;
    }

    public TBTuple getTupleFromBuffer(int n) {
        TBTuple tBTuple = n < this.mMinRowIndex || n > this.mMaxRowIndex ? null : (this.mOpenMode == 0 ? (TBTuple)this.tupleBuffer[n - this.mMinRowIndex] : (TBTuple)this.mCursorTupleLookup.get(new Integer(n)));
        return tBTuple;
    }

    public void setFetchDirection(short s) throws SQLException {
        this.mUserFetchDirection = s;
    }

    private short getTBXFetchDirection(short s) {
        return this.mUserFetchDirection == -1 ? s : this.mUserFetchDirection;
    }

    public boolean next() throws SQLException {
        boolean bl;
        this.testClosed();
        if (this.mTotalRows >= 0 && this.mRow > this.mTotalRows) {
            return false;
        }
        TBTuple tBTuple = this.getTupleFromBuffer(this.mRow + 1);
        if (tBTuple == null) {
            if (this.mOpenMode == 0) {
                this.getTuplesFromDatabase();
            } else {
                this.getTuplesFromDatabaseCursor(this.mRow + 1, this.getTBXFetchDirection((short)1));
            }
            tBTuple = this.getTupleFromBuffer(this.mRow + 1);
        }
        if (tBTuple != null && tBTuple.isEmptyTuple()) {
            tBTuple = null;
            this.mTotalRows = this.mRow;
        }
        this.actTuple = tBTuple;
        if (this.mTotalRows >= 0 && this.mRow >= this.mTotalRows) {
            this.mRow = this.mTotalRows + 1;
            bl = false;
        } else {
            ++this.mRow;
            bl = true;
        }
        return bl;
    }

    public boolean previous() throws SQLException {
        boolean bl;
        this.testClosed();
        this.testScrollable();
        if (this.mRow <= 0) {
            return false;
        }
        if (this.mRow == 1) {
            this.mRow = 0;
            this.actTuple = null;
            return false;
        }
        TBTuple tBTuple = this.getTupleFromBuffer(this.mRow - 1);
        if (tBTuple == null) {
            if (this.mOpenMode == 0) {
                this.getTuplesFromDatabase();
            } else {
                this.getTuplesFromDatabaseCursor(this.mRow - 1, this.getTBXFetchDirection((short)0));
            }
            tBTuple = this.getTupleFromBuffer(this.mRow - 1);
        }
        this.actTuple = tBTuple;
        if (this.mRow <= 1) {
            this.mRow = 0;
            bl = false;
        } else {
            --this.mRow;
            bl = true;
        }
        return bl;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl;
        short s;
        this.testClosed();
        this.testScrollable();
        if (n == 0) {
            TBException.getTBException(30003, "0");
        }
        short s2 = s = n > 0 ? (short)1 : 0;
        if (this.mTotalRows >= 0) {
            if (n < 0) {
                if (-n > this.mTotalRows) {
                    this.mRow = 0;
                    this.actTuple = null;
                    return false;
                }
                n = this.mTotalRows + 1 + n;
            } else if (n > this.mTotalRows) {
                this.mRow = this.mTotalRows + 1;
                this.actTuple = null;
                return false;
            }
        }
        TBTuple tBTuple = null;
        if (n < 0) {
            this.getTuplesFromDatabaseCursor(n, this.getTBXFetchDirection(s));
            n = this.mTotalRows + 1 + n;
            tBTuple = this.getTupleFromBuffer(n);
        } else {
            tBTuple = this.getTupleFromBuffer(n);
            if (tBTuple == null) {
                this.getTuplesFromDatabaseCursor(n, this.getTBXFetchDirection(s));
                tBTuple = this.getTupleFromBuffer(n);
            }
        }
        if (tBTuple != null && tBTuple.isEmptyTuple()) {
            tBTuple = null;
            this.mTotalRows = n - 1;
        }
        this.actTuple = tBTuple;
        if (this.actTuple == null) {
            this.mRow = s == 0 ? 0 : this.mTotalRows + 1;
            bl = false;
        } else {
            this.mRow = this.actTuple.getRowIndex();
            if (this.mRow != n) {
                throw new TBException(2);
            }
            bl = true;
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        short s;
        this.testClosed();
        this.testScrollable();
        this.testOnRow();
        if (this.mTotalRows >= 0 && this.mRow + n > this.mTotalRows) {
            this.mRow = this.mTotalRows + 1;
            this.actTuple = null;
            return false;
        }
        if (n < 0 && this.mTotalRows >= 0 && this.mRow + n <= 0) {
            this.mRow = 0;
            this.actTuple = null;
            return false;
        }
        TBTuple tBTuple = this.getTupleFromBuffer(this.mRow + n);
        if (tBTuple == null) {
            s = n > 0 ? this.getTBXFetchDirection((short)1) : this.getTBXFetchDirection((short)0);
            this.getTuplesFromDatabaseCursor(this.mRow + n, this.getTBXFetchDirection(s));
            tBTuple = this.getTupleFromBuffer(this.mRow + n);
        }
        if (tBTuple != null && tBTuple.isEmptyTuple()) {
            tBTuple = null;
            this.mTotalRows = this.mRow + n - 1;
        }
        this.actTuple = tBTuple;
        if (this.actTuple == null) {
            this.mRow = n < 0 ? 0 : this.mTotalRows + 1;
            s = 0;
        } else {
            this.mRow = this.actTuple.getRowIndex();
            s = 1;
        }
        return s != 0;
    }

    public void afterLast() throws SQLException {
        this.testClosed();
        this.testScrollable();
        if (this.mTotalRows < 0) {
            this.absolute(-1);
        }
        if (this.mTotalRows < 0) {
            throw new TBException(2);
        }
        this.actTuple = null;
        this.mRow = this.mTotalRows == 0 ? 0 : this.mTotalRows + 1;
    }

    public void beforeFirst() throws SQLException {
        this.testClosed();
        this.testScrollable();
        this.actTuple = null;
        this.mRow = 0;
    }

    public synchronized void close(boolean bl) throws SQLException {
        this.mLog.println(String.valueOf(String.valueOf(new StringBuffer("CLOSE ").append(this.toString()).append("; sendReq: ").append(bl).append("; QUID: ").append(this.quid))));
        if (!this.isClosed()) {
            if (bl) {
                this.layer.getTBReqClose(this.con, this.quid);
            } else {
                try {
                    this.layer.getTBReqClose(this.con, this.quid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.con.freeQuid(this.quid);
            this.quid = -1;
            this.actTuple = null;
        }
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.quid == -1;
    }

    public synchronized boolean isOnRow() throws SQLException {
        return !this.isClosed() && this.actTuple != null;
    }

    public int getColumnCount() throws SQLException {
        return this.queryDesc.getAttrNo();
    }

    private void checkColumnIndex(int n) throws SQLException {
        if (n < 1 || n > this.getColumnCount()) {
            throw TBException.getTBException(30003, Integer.toString(n));
        }
    }

    private void verifyColumnType(int n, int n2) throws SQLException {
        if (this.getColumnTBType(n) != n2) {
            throw TBException.getTBException(30006, new String[]{TBConst.getTBTypeName(this.getColumnTBType(n)), Integer.toString(n), TBConst.getTBTypeName(n2)});
        }
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.queryDesc.getFieldName(n);
    }

    public int getColumnTBType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.queryDesc.getFieldType(n);
    }

    public TSpec getTSpec(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.queryDesc.getTspec(n);
    }

    public TypeInfo getTypeInfo(int n) throws SQLException {
        Object object;
        this.checkColumnIndex(n);
        int n2 = this.getColumnCount();
        if (this.typeInfoBuffer.size() < n2) {
            this.typeInfoBuffer.setSize(n2);
        }
        if ((object = this.typeInfoBuffer.elementAt(n - 1)) == null) {
            object = TypeInfo.createTypeInfo(this.getTSpec(n));
            this.typeInfoBuffer.setElementAt(object, n - 1);
        }
        return (TypeInfo)object;
    }

    public boolean isNull(int n) throws SQLException {
        this.testOnRow();
        this.checkColumnIndex(n);
        TBAttribute tBAttribute = this.actTuple.getColumnValue(n);
        return tBAttribute.isNull();
    }

    public TBObject getObject(int n) throws SQLException {
        this.testOnRow();
        this.checkColumnIndex(n);
        TBAttribute tBAttribute = this.actTuple.getColumnValue(n);
        if (tBAttribute.getTBType() == 13) {
            ((TBBlob)tBAttribute.getValue()).setCursor(this);
        }
        return tBAttribute.getValue();
    }

    public InputStream getNextBlobStreamPart(BlobStream blobStream, int n, int n2) throws SQLException {
        this.testOnRow();
        int n3 = this.con.getCommVersion();
        if (n3 <= 2) {
            TBReqGetStreamIf tBReqGetStreamIf = this.layer.getTBReqGetBlob(this.con, this.trans, blobStream);
            return tBReqGetStreamIf.getStream();
        }
        TBReqGetStreamIf tBReqGetStreamIf = this.layer.getTBReqGetBlobPart(this.con, this.trans, blobStream, n, n2);
        return tBReqGetStreamIf.getStream();
    }

    public void updatePositioned(TBXQuery tBXQuery) throws SQLException {
        this.testOnRow();
        this.testClosed();
        this.layer.getTBReqUpdpos(this.con, this.queryDesc.getQuid(), tBXQuery.getStatement());
    }

    public void updatePositionedStored(TBXStoredQuery tBXStoredQuery) throws SQLException {
        this.testOnRow();
        TBTuple tBTuple = tBXStoredQuery.getParameters();
        this.layer.getTBReqUpdSto(this.con, this.queryDesc.getQuid(), tBXStoredQuery.getStatementId(), tBTuple.getTupleBuffer());
    }

    public void deletePositioned() throws SQLException {
        this.testOnRow();
        this.testClosed();
        this.layer.getTBReqDelpos(this.con, this.queryDesc.getQuid());
        this.actTuple = null;
    }

    public void deletePositionedStored(TBXStoredQuery tBXStoredQuery) throws SQLException {
        this.testOnRow();
        this.testClosed();
        this.layer.getTBReqDelSto(this.con, this.queryDesc.getQuid(), tBXStoredQuery.getStatementId());
        this.actTuple = null;
    }

    protected void finalize() {
        try {
            if (!this.isClosed()) {
                this.close(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public QueryDescriptor getQueryDescriptor() {
        return this.queryDesc;
    }

    private boolean isEmptyResultSet() throws SQLException {
        if (this.mCursorHasResults != null) {
            return this.mCursorHasResults == false;
        }
        boolean bl = false;
        if (this.mRow == 0 && this.mTotalRows <= 0) {
            TBTuple tBTuple = this.getTupleFromBuffer(1);
            if (tBTuple == null) {
                if (this.mOpenMode == 0) {
                    this.getTuplesFromDatabase();
                } else {
                    this.getTuplesFromDatabaseCursor(1, (short)1);
                }
                tBTuple = this.getTupleFromBuffer(1);
            }
            if (tBTuple == null || tBTuple.isEmptyTuple()) {
                this.mTotalRows = 0;
                bl = true;
            }
        }
        this.mCursorHasResults = new Boolean(!bl);
        return bl;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.testClosed();
        return this.mRow == 0 && !this.isEmptyResultSet();
    }

    public boolean isAfterLast() throws SQLException {
        this.testClosed();
        return this.mTotalRows >= 0 && this.mRow > this.mTotalRows;
    }

    public boolean isFirst() throws SQLException {
        this.testClosed();
        return this.mRow == 1;
    }

    public boolean isLast() throws SQLException {
        this.testClosed();
        if (this.mTotalRows < 0 && this.mRow > 0) {
            TBTuple tBTuple = this.getTupleFromBuffer(this.mRow + 1);
            if (tBTuple == null) {
                if (this.mOpenMode == 0) {
                    this.getTuplesFromDatabase();
                } else {
                    this.getTuplesFromDatabaseCursor(this.mRow + 1, (short)1);
                }
                tBTuple = this.getTupleFromBuffer(this.mRow + 1);
            }
            if (tBTuple == null || tBTuple.isEmptyTuple()) {
                this.mTotalRows = this.mRow;
            }
        }
        return this.mRow == this.mTotalRows;
    }

    public int getRow() throws SQLException {
        if (!this.isOnRow()) {
            return 0;
        }
        return this.mRow;
    }
}

