/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import transbase.tbx.TBException;
import transbase.tbx.TBLog;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXCursor;
import transbase.tbx.TBXObjectFactory;
import transbase.tbx.TBXTransactionIf;
import transbase.tbx.requests.TBReqGetQdIf;
import transbase.tbx.requests.TBReqGetStreamIf;
import transbase.tbx.requests.TBReqRuSpcIf;
import transbase.tbx.requests.TBReqRunMQLIf;
import transbase.tbx.requests.TBReqSpoolRequestIf;
import transbase.tbx.requests.TBRequest;
import transbase.tbx.stypes.TBTypeCt;
import transbase.tbx.stypes.TBTypeQd;
import transbase.tbx.types.helpers.BlobStream;

public class TBXQuery {
    protected TBLog mLog;
    private TBXObjectFactory layer;
    protected String statement;
    public static final int SEL_TYPE = 41;
    public static final int MQLCL = 42;
    public static final int SPCL = 22;
    public static final int DMLCL = 33;
    public static final int DDLCL = 15;
    public static final int LCKCL = 52;
    public static final int LOADCL = 68;
    public static final int CALL_TYPE = 141;
    public static final int TBMODECL = 49;
    private static final int SPOOL_FILE = 21;
    private static final int SPOOL_RELATION = 22;
    protected static Hashtable keyTab = new Hashtable();

    public TBXQuery(String string, TBLog tBLog, TBXObjectFactory tBXObjectFactory) throws SQLException {
        this.mLog = tBLog;
        this.layer = tBXObjectFactory;
        this.statement = string;
    }

    public String getStatement() {
        return this.statement;
    }

    public Object run(TBXTransactionIf tBXTransactionIf, TBXConnectionIf tBXConnectionIf) throws SQLException {
        Object object = null;
        tBXTransactionIf.tryBeginTA(tBXConnectionIf);
        int n = this.getQueryClass();
        switch (n) {
            case 68: {
                TBRequest tBRequest = this.layer.getTBReqRunLoad(tBXConnectionIf, tBXTransactionIf, this.statement);
                break;
            }
            case 15: {
                TBRequest tBRequest = this.layer.getTBReqRunDDL(tBXConnectionIf, tBXTransactionIf, this.statement);
                break;
            }
            case 22: {
                TBXConnectionIf tBXConnectionIf2 = tBXConnectionIf;
                synchronized (tBXConnectionIf2) {
                    TBReqRuSpcIf tBReqRuSpcIf = this.layer.getTBReqRuSpc(tBXConnectionIf, tBXTransactionIf, this.statement);
                    object = this.run_spool(tBReqRuSpcIf, tBXTransactionIf, tBXConnectionIf);
                    break;
                }
            }
            case 52: {
                TBRequest tBRequest = this.layer.getTBReqRunLCK(tBXConnectionIf, tBXTransactionIf, this.statement);
                break;
            }
            case 49: {
                TBRequest tBRequest = this.layer.getTBReqTbMode(tBXConnectionIf, tBXTransactionIf, this.statement);
                break;
            }
            default: {
                TBReqRunMQLIf tBReqRunMQLIf = this.layer.getTBReqRunMQL(tBXConnectionIf, tBXTransactionIf, this.statement);
                TBTypeQd tBTypeQd = tBReqRunMQLIf.getQueryDescriptor();
                object = TBXQuery.isQuerySelectClass(tBTypeQd.getQueryType()) ? new TBXCursor(tBXConnectionIf, tBXTransactionIf, this.statement, tBTypeQd, 0, this.mLog, this.layer) : new Integer(tBReqRunMQLIf.getCount().getNTuples());
            }
        }
        return object;
    }

    public TBXCursor open(TBXTransactionIf tBXTransactionIf, TBXConnectionIf tBXConnectionIf, int n) throws SQLException {
        TBTypeQd tBTypeQd;
        int n2 = this.getQueryClass();
        if (!TBXQuery.isQuerySelectClass(n2)) {
            throw new TBException(30025);
        }
        tBXTransactionIf.tryBeginTA(tBXConnectionIf);
        int n3 = tBXConnectionIf.getQuid();
        try {
            if (n == 0) {
                TBReqGetQdIf tBReqGetQdIf = this.layer.getTBReqDML(tBXConnectionIf, tBXTransactionIf, this.statement, n3);
                tBTypeQd = tBReqGetQdIf.getQueryDescriptor();
            } else {
                TBReqGetQdIf tBReqGetQdIf = this.layer.getTBReqCursorOpen(tBXConnectionIf, tBXTransactionIf, this.statement, n3, n);
                tBTypeQd = tBReqGetQdIf.getQueryDescriptor();
            }
        }
        catch (SQLException sQLException) {
            tBXConnectionIf.freeQuid(n3);
            throw sQLException;
        }
        return new TBXCursor(tBXConnectionIf, tBXTransactionIf, this.statement, tBTypeQd, n, this.mLog, this.layer);
    }

    public int getQueryClass() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.statement.toLowerCase(), " \t\n()", false);
        int n = 0;
        if (stringTokenizer.hasMoreTokens()) {
            Integer n2 = (Integer)keyTab.get(stringTokenizer.nextToken());
            n = n2 == null ? 0 : n2;
        }
        return n;
    }

    public static boolean isQuerySelectClass(int n) {
        return n >= 41 && n <= 42 || n == 141;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer run_spool(TBReqRuSpcIf tBReqRuSpcIf, TBXTransactionIf tBXTransactionIf, TBXConnectionIf tBXConnectionIf) throws SQLException {
        TBTypeQd tBTypeQd = tBReqRuSpcIf.getQueryDescriptor();
        String string = tBReqRuSpcIf.getFileName();
        Integer n2 = null;
        int n = 0;
        if (string.indexOf("\\") > -1) {
            TBException tBException = new TBException(30211);
            tBXConnectionIf.handleHardError(tBException);
            throw tBException;
        }
        boolean bl = false;
        if (string.length() == 0) {
            bl = true;
        }
        if (tBTypeQd.getQueryType() == 21) {
            File file2 = null;
            try {
                try {
                    boolean bl2 = false;
                    file2 = File.createTempFile("tbtmp", ".blf");
                    file2.deleteOnExit();
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    FileOutputStream fileOutputStream2 = new FileOutputStream(string);
                    TBReqSpoolRequestIf tBReqSpoolRequestIf = this.layer.getTBReqRuSpf(tBXConnectionIf, tBXTransactionIf, fileOutputStream, fileOutputStream2);
                    fileOutputStream.flush();
                    fileOutputStream2.flush();
                    PushbackReader pushbackReader = new PushbackReader(new FileReader(file2));
                    int n3 = pushbackReader.read();
                    bl2 = n3 > 0;
                    pushbackReader.unread(n3);
                    if (bl2) {
                        n2 = this.spoolOutBlobs(tBXTransactionIf, tBXConnectionIf, string, file2);
                    }
                    pushbackReader.close();
                    ((OutputStream)fileOutputStream2).close();
                    ((OutputStream)fileOutputStream).close();
                    n = tBReqSpoolRequestIf.getNTuples();
                }
                catch (IOException iOException) {
                    TBException tBException = TBException.getTBException(1813, iOException.getMessage());
                    tBXConnectionIf.handleHardError(tBException);
                    throw tBException;
                }
                Object var17_29 = null;
            }
            catch (Throwable throwable) {
                Object var17_30 = null;
                try {
                    if (file2 == null) throw throwable;
                    file2.delete();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            if (file2 == null) return new Integer(n);
            file2.delete();
            return new Integer(n);
        }
        File file = null;
        try {
            try {
                boolean bl3 = false;
                if (!bl) {
                    file = File.createTempFile("tbtmp", ".blf");
                    file.deleteOnExit();
                    FileInputStream fileInputStream = new FileInputStream(string);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    TBReqSpoolRequestIf tBReqSpoolRequestIf = this.layer.getTBReqRuSpr(tBXConnectionIf, tBXTransactionIf, fileInputStream, fileOutputStream);
                    fileOutputStream.flush();
                    PushbackReader pushbackReader = new PushbackReader(new FileReader(file));
                    int n4 = pushbackReader.read();
                    bl3 = n4 > 0;
                    pushbackReader.unread(n4);
                    if (bl3) {
                        TBTypeCt tBTypeCt = new TBTypeCt();
                        n2 = this.spoolInBlobs(tBXTransactionIf, tBXConnectionIf, pushbackReader, string, tBTypeCt);
                        n = tBReqSpoolRequestIf.getNTuples();
                    }
                    ((InputStream)fileInputStream).close();
                    ((OutputStream)fileOutputStream).close();
                    pushbackReader.close();
                } else {
                    TBReqSpoolRequestIf tBReqSpoolRequestIf = this.layer.getTBReqRuSpr(tBXConnectionIf, tBXTransactionIf, null, null);
                    n = tBReqSpoolRequestIf.getNTuples();
                }
            }
            catch (IOException iOException) {
                TBException tBException = TBException.getTBException(1813, iOException.getMessage());
                tBXConnectionIf.handleHardError(tBException);
                throw tBException;
            }
            Object var20_35 = null;
        }
        catch (Throwable throwable) {
            Object var20_36 = null;
            try {
                if (file == null) throw throwable;
                file.delete();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (file == null) return new Integer(n);
        file.delete();
        return new Integer(n);
    }

    private String getAbsName(String string, TBXConnectionIf tBXConnectionIf) {
        String string2 = string.replace('/', File.separatorChar);
        File file = new File(string2);
        return file.getAbsolutePath();
    }

    /*
     * Loose catch block
     */
    private Integer spoolOutBlobs(TBXTransactionIf tBXTransactionIf, TBXConnectionIf tBXConnectionIf, String string, File file) throws SQLException {
        Comparable<Integer> comparable;
        String string2 = string;
        File file2 = file;
        String string3 = file2.getAbsolutePath();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        short s = 0;
        String string4 = new String();
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new FileReader(file2));
        String string5 = null;
        TBReqGetStreamIf tBReqGetStreamIf = null;
        File file3 = null;
        BlobStream blobStream = null;
        int n4 = 0;
        int n5 = 0;
        String string6 = null;
        String string7 = null;
        Object var22_24 = null;
        OutputStream outputStream = null;
        String string8 = new String();
        int[] nArray = new int[]{0, -1, -1};
        while ((string5 = bufferedReader.readLine()) != null) {
            try {
                string8 = string4;
                n5 = string5.indexOf(" ");
                n = Integer.parseInt(string5.substring(0, n5));
                n4 = n5 + 1;
                n5 = string5.indexOf(" ", n4);
                n2 = Integer.parseInt(string5.substring(n4, n5));
                n4 = n5 + 1;
                n5 = string5.indexOf(" ", n4);
                n3 = Integer.parseInt(string5.substring(n4, n5));
                n4 = n5 + 1;
                n5 = string5.indexOf(" ", n4);
                s = Short.parseShort(string5.substring(n4, n5));
                n4 = n5 + 1;
                while (string5.toCharArray()[n4] == ' ') {
                    ++n4;
                }
                nArray[0] = 0;
                nArray[1] = -1;
                nArray[2] = -1;
                if (string5.toCharArray()[n4] == '<') {
                    nArray = this.parseOffsetSpec(string5.substring(n4 + 1, string5.length()));
                    n5 = string5.indexOf(">", n4) + 1;
                }
                if (n5 < string5.length()) {
                    string4 = string5.substring(n5);
                    string4 = string4.substring(string4.indexOf("b_"));
                    string4 = string4.replace('/', File.separatorChar);
                } else {
                    string4 = "";
                }
            }
            catch (Exception exception) {
                throw TBException.getTBException(1904, new String[]{string5});
            }
            if (string4 != "" && string4 != string8 && (nArray[1] == 0 || nArray[1] == -1) || nArray[0] == 0) {
                if (outputStream != null) {
                    outputStream.close();
                }
                string7 = this.getAbsName(string2, tBXConnectionIf);
                comparable = new File(string7);
                string6 = String.valueOf(String.valueOf(((File)comparable).getParent())).concat(String.valueOf(String.valueOf(File.separator)));
                String string9 = new String(String.valueOf(String.valueOf(string6)).concat(String.valueOf(String.valueOf(string4))));
                comparable = new File(string9);
                file3 = new File(((File)comparable).getParent());
                file3.mkdir();
                outputStream = new FileOutputStream(string9);
            }
            blobStream = new BlobStream(n, n2, 1, 1, n3, s);
            tBReqGetStreamIf = this.layer.getTBReqGetBlob(tBXConnectionIf, tBXTransactionIf, blobStream, outputStream);
        }
        if (outputStream != null) {
            outputStream.close();
        }
        comparable = new Integer(1);
        Object var29_31 = null;
        file2.delete();
        try {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new Integer(1);
        {
            catch (IOException iOException) {
                TBException tBException = TBException.getTBException(1813, iOException.getMessage());
                tBXConnectionIf.handleHardError(tBException);
                throw tBException;
            }
        }
        catch (Throwable throwable) {
            Object var29_32 = null;
            file2.delete();
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new Integer(1);
        }
    }

    private int[] parseOffsetSpec(String string) throws Exception {
        int[] nArray = new int[]{0, -1, -1};
        StringTokenizer stringTokenizer = new StringTokenizer(string, ">", false);
        if (string.indexOf(">") != -1) {
            string = stringTokenizer.nextToken();
        }
        if ((stringTokenizer = new StringTokenizer(string, ":", false)).countTokens() == 1) {
            string = stringTokenizer.nextToken();
            nArray[2] = Integer.parseInt(string);
            if (nArray[2] >= -1) {
                nArray[0] = 1;
            }
        } else if (stringTokenizer.countTokens() == 2) {
            nArray[1] = Integer.parseInt(stringTokenizer.nextToken());
            nArray[2] = Integer.parseInt(stringTokenizer.nextToken());
            if (nArray[2] >= -1 && nArray[1] >= -1) {
                nArray[0] = 2;
            }
        }
        return nArray;
    }

    private Integer spoolInBlobs(TBXTransactionIf tBXTransactionIf, TBXConnectionIf tBXConnectionIf, Reader reader, String string, TBTypeCt tBTypeCt) throws IOException, SQLException {
        String string2 = null;
        String string3 = null;
        String string4 = new String();
        String string5 = new String();
        String string6 = new String("");
        int[] nArray = new int[]{0, -1, -1};
        int n = 0;
        byte by = 1;
        try {
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader = new BufferedReader(reader);
            while (by == 1) {
                Object object;
                boolean bl = false;
                string2 = bufferedReader.readLine();
                if (string2 != null && string2.length() == 0) {
                    throw TBException.getTBException(1904, new String[]{"empty line in blob file"});
                }
                if (string2 == null) {
                    by = 0;
                    nArray[0] = 0;
                    nArray[1] = -1;
                    nArray[2] = -1;
                } else {
                    if (string2.toCharArray()[0] == '<') {
                        try {
                            nArray = this.parseOffsetSpec(string2.substring(1));
                            if (string2.indexOf(">") + 1 == string2.length()) {
                                string4 = "";
                            }
                            string4 = string2.substring(string2.indexOf(">") + 1);
                        }
                        catch (Exception exception) {
                            throw TBException.getTBException(1904, new String[]{string2});
                        }
                    } else {
                        string4 = string2;
                        nArray[0] = 0;
                        nArray[1] = -1;
                        nArray[2] = -1;
                    }
                    object = new String(this.getAbsName(string, tBXConnectionIf));
                    File file = new File((String)object);
                    string3 = String.valueOf(String.valueOf(file.getParent())).concat(String.valueOf(String.valueOf(File.separator)));
                    if (string4 != "") {
                        string5 = String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(string4)));
                    }
                    if (nArray[0] == 0 || string6 != string5 && string4 != "") {
                        string6 = string5;
                        if (fileInputStream != null) {
                            fileInputStream.close();
                            fileInputStream = null;
                        }
                    }
                }
                if (by == 1 && fileInputStream == null) {
                    fileInputStream = new FileInputStream(string5);
                    n = 0;
                }
                if (nArray[1] != -1) {
                    if (nArray[1] < n) {
                        if (bufferedReader != null) {
                            fileInputStream.close();
                            fileInputStream = new FileInputStream(string5);
                            fileInputStream.skip(nArray[1]);
                        }
                    } else if (nArray[1] != n) {
                        fileInputStream.skip(nArray[1] - n);
                    }
                }
                n = nArray[2];
                object = this.layer.getTBReqBlSpin(tBXConnectionIf, tBXTransactionIf, fileInputStream, nArray[2], by);
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            TBException tBException = TBException.getTBException(1813, fileNotFoundException.getMessage());
            tBXConnectionIf.handleHardError(tBException);
            throw tBException;
        }
        return new Integer(1);
    }

    static {
        keyTab.put("select", new Integer(42));
        keyTab.put("spool", new Integer(22));
        keyTab.put("insert", new Integer(33));
        keyTab.put("update", new Integer(33));
        keyTab.put("delete", new Integer(33));
        keyTab.put("create", new Integer(15));
        keyTab.put("drop", new Integer(15));
        keyTab.put("grant", new Integer(15));
        keyTab.put("alter", new Integer(15));
        keyTab.put("revoke", new Integer(15));
        keyTab.put("lock", new Integer(52));
        keyTab.put("unlock", new Integer(52));
        keyTab.put("load", new Integer(68));
        keyTab.put("unload", new Integer(68));
        keyTab.put("tbmode", new Integer(49));
    }
}

