/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx;

import java.sql.SQLException;
import java.util.Vector;
import transbase.tbx.TBException;
import transbase.tbx.TBLog;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXCursor;
import transbase.tbx.TBXObjectFactory;
import transbase.tbx.TBXQuery;
import transbase.tbx.TBXTransactionIf;
import transbase.tbx.requests.TBReqGetQdIf;
import transbase.tbx.requests.TBReqRunStoIf;
import transbase.tbx.requests.TBReqStoreIf;
import transbase.tbx.requests.TBRequest;
import transbase.tbx.stypes.TBTypeQd;
import transbase.tbx.tuple.TBAttr;
import transbase.tbx.tuple.TBAttrBinchar;
import transbase.tbx.tuple.TBAttrBits;
import transbase.tbx.tuple.TBAttrBlob;
import transbase.tbx.tuple.TBAttrBool;
import transbase.tbx.tuple.TBAttrChar;
import transbase.tbx.tuple.TBAttrDatetime;
import transbase.tbx.tuple.TBAttrFloat;
import transbase.tbx.tuple.TBAttrInteger;
import transbase.tbx.tuple.TBAttrNull;
import transbase.tbx.tuple.TBAttrNumeric;
import transbase.tbx.tuple.TBAttrTimespan;
import transbase.tbx.tuple.TBAttrUndef;
import transbase.tbx.tuple.TBTuple;
import transbase.tbx.types.TBBinchar;
import transbase.tbx.types.TBBits;
import transbase.tbx.types.TBBlob;
import transbase.tbx.types.TBBool;
import transbase.tbx.types.TBDatetime;
import transbase.tbx.types.TBDouble;
import transbase.tbx.types.TBFloat;
import transbase.tbx.types.TBInteger;
import transbase.tbx.types.TBNumeric;
import transbase.tbx.types.TBSmallint;
import transbase.tbx.types.TBTimespan;
import transbase.tbx.types.TBTinyint;
import transbase.tbx.types.helpers.BlobStream;
import transbase.tbx.types.helpers.QueryDescriptor;
import transbase.tbx.types.helpers.TBObject;
import transbase.tbx.types.helpers.TSpec;

public class TBXStoredQuery
extends TBXQuery {
    private TBXConnectionIf connection;
    private int statementId = -1;
    private TBTypeQd queryDesc;
    private TBTuple parameters = null;
    private Vector blobs = null;
    private Vector blobNames = null;
    private int paramNo = 0;
    private TBXObjectFactory layer;
    TBLog mLog;

    public TBXStoredQuery(String string, TBXConnectionIf tBXConnectionIf, TBLog tBLog, TBXObjectFactory tBXObjectFactory) throws SQLException {
        super(string, tBLog, tBXObjectFactory);
        this.mLog = tBLog;
        this.layer = tBXObjectFactory;
        this.connection = tBXConnectionIf;
        TBXTransactionIf tBXTransactionIf = tBXConnectionIf.getBoundTransactionInternal();
        TBReqStoreIf tBReqStoreIf = tBXObjectFactory.getTBReqStore(tBXConnectionIf, tBXTransactionIf, string);
        this.statementId = tBReqStoreIf.getStatementId();
        this.queryDesc = tBReqStoreIf.getQueryDescriptor();
    }

    protected int getStatementId() throws SQLException {
        this.checkOpened();
        return this.statementId;
    }

    protected TBTuple getParameters() throws SQLException {
        this.checkOpened();
        return this.parameters;
    }

    public void checkProcAllRegistered() throws SQLException {
        int n;
        for (n = 1; n <= this.parameters.getColumnCount(); ++n) {
            if (this.parameters.getColumnValue(n).getTBType() != 15) continue;
            throw TBException.getTBException(30215, new String[]{Integer.toString(n)});
        }
        if (this.queryDesc.getParamNo() + 1 != n) {
            throw TBException.getTBException(30214, new String[]{Integer.toString(n), Integer.toString(this.queryDesc.getParamNo())});
        }
    }

    public void close() throws SQLException {
        if (this.statementId != -1) {
            TBRequest tBRequest = this.layer.getTBReqDropSto(this.connection, this.statementId);
        }
        this.statementId = -1;
    }

    public Object run(TBXTransactionIf tBXTransactionIf) throws SQLException {
        this.checkOpened();
        Object object = null;
        tBXTransactionIf.tryBeginTA(this.connection);
        this.makeBlobs(tBXTransactionIf);
        TBReqRunStoIf tBReqRunStoIf = this.layer.getTBReqRunSto(this.connection, tBXTransactionIf, this.statementId, this.parameters.getTupleBuffer());
        TBTypeQd tBTypeQd = tBReqRunStoIf.getQueryDescriptor();
        object = TBXQuery.isQuerySelectClass(tBTypeQd.getQueryType()) ? new TBXCursor(this.connection, tBXTransactionIf, this.statement, tBTypeQd, 0, this.mLog, this.layer) : new Integer(tBReqRunStoIf.getCount().getNTuples());
        return object;
    }

    public TBXCursor open(TBXTransactionIf tBXTransactionIf, int n) throws SQLException {
        TBTypeQd tBTypeQd;
        this.checkOpened();
        if (!TBXQuery.isQuerySelectClass(this.queryDesc.getQueryType())) {
            throw new TBException(30025);
        }
        tBXTransactionIf.tryBeginTA(this.connection);
        this.makeBlobs(tBXTransactionIf);
        int n2 = this.connection.getQuid();
        try {
            if (n == 0) {
                TBReqGetQdIf tBReqGetQdIf = this.layer.getTBReqOpenSto(this.connection, tBXTransactionIf, this.statementId, n2, this.parameters.getTupleBuffer());
                tBTypeQd = tBReqGetQdIf.getQueryDescriptor();
            } else {
                TBReqGetQdIf tBReqGetQdIf = this.layer.getTBReqCursorOpenStored(this.connection, tBXTransactionIf, this.statementId, n2, this.parameters.getTupleBuffer(), n);
                tBTypeQd = tBReqGetQdIf.getQueryDescriptor();
            }
        }
        catch (SQLException sQLException) {
            this.connection.freeQuid(n2);
            throw sQLException;
        }
        return new TBXCursor(this.connection, tBXTransactionIf, this.statement, tBTypeQd, n, this.mLog, this.layer);
    }

    private void checkOpened() throws SQLException {
        if (this.statementId < 0) {
            throw new TBException(30010);
        }
        if (this.parameters == null) {
            this.parameters = new TBTuple();
        }
    }

    private void checkValues(int n, int n2) throws SQLException {
        this.checkOpened();
    }

    public void setObject(int n, TBObject tBObject) throws SQLException {
        int n2 = tBObject.getTBType();
        this.checkValues(n, n2);
        TBAttr tBAttr = null;
        switch (n2) {
            case 12: {
                tBAttr = new TBAttrBinchar((TBBinchar)tBObject);
                break;
            }
            case 14: 
            case 30: {
                tBAttr = new TBAttrBits(n2, (TBBits)tBObject);
                break;
            }
            case 13: {
                TBBlob tBBlob = (TBBlob)tBObject;
                BlobStream blobStream = tBBlob.getBlobStream();
                String string = "B".concat(String.valueOf(String.valueOf(n)));
                if (this.blobNames == null) {
                    this.blobNames = new Vector();
                }
                if (this.blobNames.size() < n) {
                    this.blobNames.setSize(n);
                }
                this.blobNames.setElementAt(string, n - 1);
                blobStream.setName(string);
                if (this.blobs == null) {
                    this.blobs = new Vector();
                }
                if (this.blobs.size() < n) {
                    this.blobs.setSize(n);
                }
                this.blobs.setElementAt(tBBlob.getBinaryStream(), n - 1);
                tBAttr = new TBAttrBlob((TBBlob)tBObject);
                break;
            }
            case 11: {
                tBAttr = new TBAttrBool((TBBool)tBObject);
                break;
            }
            case 4: 
            case 29: {
                tBAttr = new TBAttrChar(tBObject);
                break;
            }
            case 8: {
                tBAttr = new TBAttrDatetime((TBDatetime)tBObject);
                break;
            }
            case 2: {
                tBAttr = new TBAttrFloat((TBDouble)tBObject);
                break;
            }
            case 7: {
                tBAttr = new TBAttrFloat((TBFloat)tBObject);
                break;
            }
            case 1: {
                tBAttr = new TBAttrInteger((TBInteger)tBObject);
                break;
            }
            case 3: {
                tBAttr = new TBAttrNumeric((TBNumeric)tBObject);
                break;
            }
            case 6: {
                tBAttr = new TBAttrInteger((TBSmallint)tBObject);
                break;
            }
            case 9: {
                tBAttr = new TBAttrTimespan((TBTimespan)tBObject);
                break;
            }
            case 5: {
                tBAttr = new TBAttrInteger((TBTinyint)tBObject);
                break;
            }
            default: {
                tBAttr = new TBAttrUndef();
            }
        }
        this.parameters.setColumnValue(n, tBAttr);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.checkValues(n, 15);
        TBAttrNull tBAttrNull = new TBAttrNull(n2);
        this.parameters.setColumnValue(n, tBAttrNull);
    }

    public void clearParameters() throws SQLException {
        this.checkOpened();
        this.parameters = null;
        this.blobs = null;
    }

    public int getExpectedType(int n) throws SQLException {
        this.checkOpened();
        int n2 = this.getExpectedParameterCount();
        if (n < 1 || n > n2) {
            return 0;
        }
        return this.queryDesc.getParamFieldType(n);
    }

    public TSpec getTSpec(int n) throws SQLException {
        this.checkOpened();
        int n2 = this.getExpectedParameterCount();
        if (n < 1 || n > n2) {
            return this.queryDesc.getTspec(n);
        }
        return null;
    }

    public int getExpectedParameterCount() throws SQLException {
        this.checkOpened();
        return this.queryDesc.getParamNo();
    }

    private void makeBlobs(TBXTransactionIf tBXTransactionIf) throws SQLException {
        if (this.blobs == null) {
            return;
        }
        for (int i = 0; i < this.blobs.size(); ++i) {
            BlobStream blobStream = (BlobStream)this.blobs.elementAt(i);
            if (blobStream == null) continue;
            this.layer.getTBReqMakeBlob(this.connection, tBXTransactionIf, blobStream, (String)this.blobNames.elementAt(i));
        }
    }

    public QueryDescriptor getQueryDescriptor() {
        return this.queryDesc;
    }
}

