/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.coman;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.TBIdVector;
import transbase.tbx.TBLog;
import transbase.tbx.TBStreamInterface;
import transbase.tbx.TBURL;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXTransactionIf;
import transbase.tbx.coman.TBXComanTransaction;
import transbase.tbx.stypes.TBTypeError;
import transbase.tbx.types.helpers.CharEncodingFactory;

public class TBXComanConnection
implements TBXConnectionIf {
    private static final int commVersion = 0;
    private static final int dbState = 2;
    private CharEncodingFactory mCharEncodingFactory;
    private TBURL url;
    private TBXComanTransaction transaction = null;
    private TBLog mLog;
    private TBIdVector quids = new TBIdVector(11, 11032);

    public TBXComanConnection(TBURL tBURL, String string, TBLog tBLog) throws SQLException {
        this.mCharEncodingFactory = new CharEncodingFactory();
        this.url = tBURL;
        this.mLog = tBLog;
    }

    public byte[] send(TBStreamInterface tBStreamInterface) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            tBStreamInterface.writeTBStream(dataOutputStream, this);
        }
        catch (IOException iOException) {
            throw TBException.getTBException(30209, iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void receive(byte[] byArray, TBStreamInterface tBStreamInterface) throws SQLException {
        try {
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                TBTypeError tBTypeError = new TBTypeError();
                tBTypeError.readTBStream(dataInputStream, this);
                if (tBTypeError.getErrorCode() != 0) {
                    TBException tBException = TBException.getTBServerException(tBTypeError.getErrorCode(), tBTypeError.getErrorMessage());
                    throw tBException;
                }
                tBStreamInterface.readTBStream(dataInputStream, this);
            }
            catch (TBException tBException) {
                if (tBException.getErrorCode() == 30036) {
                    // empty if block
                }
                throw tBException;
            }
            catch (EOFException eOFException) {
                throw TBException.getTBException(30209, "EOF on communication channel: ".concat(String.valueOf(String.valueOf(eOFException.getMessage()))));
            }
            catch (IOException iOException) {
                throw TBException.getTBException(30209, iOException.getMessage());
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            throw throwable;
        }
    }

    public int getCommVersion() {
        return 0;
    }

    public int getDbState() throws SQLException {
        return 2;
    }

    public void login(String string, String string2) throws SQLException {
    }

    public void close() throws SQLException {
    }

    public synchronized void bindTransaction(TBXComanTransaction tBXComanTransaction) throws SQLException {
        if (this.transaction != null) {
            throw TBException.getTBException(11027, new String[]{String.valueOf(String.valueOf(Integer.toString(this.transaction.getTaid()))).concat(" (bindTransaction) "), this.url.getUrl()});
        }
        this.transaction = tBXComanTransaction;
    }

    public void freeTransaction(TBXComanTransaction tBXComanTransaction) throws SQLException {
        if (this.transaction == null) {
            throw TBException.getTBException(11027, new String[]{String.valueOf(String.valueOf(Integer.toString(this.transaction.getTaid()))).concat(" (freeTransaction) "), this.url.getUrl()});
        }
        this.transaction = null;
    }

    public boolean isBoundToTransaction() {
        return this.transaction != null;
    }

    public TBURL getUrl() throws SQLException {
        return this.url;
    }

    public int getQuid() throws SQLException {
        return this.quids.getId();
    }

    public void freeQuid(int n) throws SQLException {
        if (!this.quids.freeId(n)) {
            throw new TBException(5005, Integer.toString(n));
        }
    }

    public String getDatabaseVersionString() throws SQLException {
        throw TBException.getTBException(30011, "getDatabaseVersionString not implemented");
    }

    public String getDatabaseVersion() throws SQLException {
        throw TBException.getTBException(30011, "getDatabaseVersion not implemented");
    }

    public void testLogged() throws SQLException {
    }

    public CharEncodingFactory getCharEncodingFactory() {
        return this.mCharEncodingFactory;
    }

    public TBLog getLogInstance() {
        return this.mLog;
    }

    public void handleHardError(TBException tBException) {
    }

    public TBXTransactionIf getBoundTransactionInternal() {
        return null;
    }
}

