/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.coman;

import java.sql.SQLException;
import java.util.Vector;
import transbase.tbx.TBException;
import transbase.tbx.TBLog;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXTransactionIf;
import transbase.tbx.coman.TBXComanConnection;
import transbase.tbx.coman.requests.TBReqAT;
import transbase.tbx.coman.requests.TBReqBT;
import transbase.tbx.coman.requests.TBReqCT;
import transbase.tbx.coman.requests.TBReqExcl;
import transbase.tbx.stypes.TBTypeMl;
import transbase.tbx.stypes.TBTypeMt;
import transbase.tbx.stypes.TBTypeTs;

public class TBXComanTransaction
implements TBXTransactionIf {
    private static final int TS_UNDEF = 0;
    private static final int taid = 0;
    private int consistency = 3;
    private static final int timeout = 60;
    private static final boolean rollbackByTBX = false;
    private int taState = 2;
    private TBTypeMt mtaId = new TBTypeMt();
    private Vector dbList = new Vector(0, 1);
    private TBTypeTs timestamp = new TBTypeTs(0);
    private TBXComanConnection connection;
    private TBLog mLog;

    public TBXComanTransaction(TBLog tBLog) throws SQLException {
        this.mLog = tBLog;
    }

    public boolean isTBXAborted() {
        return false;
    }

    public synchronized int getTaState() throws SQLException {
        return this.taState;
    }

    public synchronized int tryBeginTA(TBXConnectionIf tBXConnectionIf) throws SQLException {
        TBXComanConnection tBXComanConnection;
        try {
            tBXComanConnection = (TBXComanConnection)tBXConnectionIf;
        }
        catch (ClassCastException classCastException) {
            throw new TBException(30002);
        }
        if (this.taState == 2) {
            this.taState = 4;
        }
        if (this.isConnectionUsed(tBXComanConnection)) {
            return this.taState;
        }
        new TBReqBT(tBXComanConnection, this.consistency);
        tBXComanConnection.bindTransaction(this);
        this.connection = tBXComanConnection;
        return this.taState;
    }

    public synchronized int commit() throws SQLException {
        if (this.timestamp.getValue() != 0) {
            TBTypeMl tBTypeMl = new TBTypeMl();
            for (int i = 0; i < this.dbList.size(); ++i) {
                TBReqExcl tBReqExcl = new TBReqExcl((TBXComanConnection)this.dbList.elementAt(i), 0, 60);
                if (tBReqExcl.getState() != 0) {
                    throw new TBException(2);
                }
                tBTypeMl.merge(tBReqExcl.getDatabaseList());
            }
            if (tBTypeMl.size() > 1) {
                throw new TBException(29999);
            }
        }
        try {
            this.taState = this.capTa(13);
        }
        catch (TBException tBException) {
            if (tBException.isHardError()) {
                this.capTa(14);
                this.taState = 32;
            } else {
                this.taState = 4;
            }
            throw TBException.getTBException(11004, new String[]{Integer.toString(0), this.taState == 1 ? "undefined" : (this.taState == 16 ? "committed" : (this.taState == 4 ? "active" : "aborted")), tBException.getMessage()});
        }
        return this.taState;
    }

    public synchronized int abort() throws SQLException {
        try {
            this.taState = this.capTa(14);
        }
        catch (TBException tBException) {
            this.taState = 1;
            throw TBException.getTBException(11000, new String[]{Integer.toString(0), tBException.getMessage()});
        }
        return this.taState;
    }

    public synchronized void abortOutband() throws SQLException {
        this.abort();
    }

    private int capTa(int n) throws SQLException {
        int n2 = 0;
        int n3 = 1;
        SQLException sQLException = null;
        TBException tBException = null;
        switch (n) {
            case 14: {
                n2 = 32;
                break;
            }
            case 13: {
                n2 = 16;
                break;
            }
            case 15: {
                n2 = 8;
                break;
            }
            case 16: {
                n2 = 1;
            }
        }
        try {
            switch (n) {
                case 14: {
                    TBReqAT tBReqAT = new TBReqAT(this.connection);
                    n3 = tBReqAT.getState();
                    break;
                }
                case 13: {
                    TBReqCT tBReqCT = new TBReqCT(this.connection);
                    n3 = tBReqCT.getState();
                }
            }
            if ((n3 & 0x30) > 0) {
                this.connection.freeTransaction(this);
                this.connection = null;
            }
            n2 |= n3;
        }
        catch (TBException tBException2) {
            if (tBException2.isHardError()) {
                sQLException = tBException2;
            } else {
                tBException = tBException2;
            }
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        if (sQLException != null) {
            throw sQLException;
        }
        if (tBException != null) {
            throw tBException;
        }
        return n2;
    }

    private boolean isConnectionUsed(TBXComanConnection tBXComanConnection) {
        return tBXComanConnection.isBoundToTransaction();
    }

    public void setConsistency(int n) throws SQLException {
        this.consistency = n;
    }

    public int getConsistency() throws SQLException {
        return this.consistency;
    }

    public int getTaid() {
        return 0;
    }

    public void setTimeout(int n) throws SQLException {
        throw TBException.getTBException(30011, "setTimeout not implemented");
    }

    public int getTimeout() throws SQLException {
        return 60;
    }
}

