/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.java;

import java.sql.SQLException;
import java.util.Vector;
import transbase.tbx.TBException;
import transbase.tbx.TBIdFactory;
import transbase.tbx.TBLog;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.TBXTransactionIf;
import transbase.tbx.java.GlobMtaId;
import transbase.tbx.java.TBXJavaConnection;
import transbase.tbx.java.requests.TBReqAT;
import transbase.tbx.java.requests.TBReqBT;
import transbase.tbx.java.requests.TBReqCT;
import transbase.tbx.java.requests.TBReqExcl;
import transbase.tbx.java.requests.TBReqSndSig;
import transbase.tbx.stypes.TBTypeMl;
import transbase.tbx.stypes.TBTypeMt;
import transbase.tbx.stypes.TBTypePd;
import transbase.tbx.stypes.TBTypeTs;

public class TBXJavaTransaction
implements TBXTransactionIf {
    private static final int TS_UNDEF = 0;
    private TBTypeMt mtaId = new TBTypeMt();
    private int consistency = 3;
    private int timeout = 60;
    private TBTypeTs timestamp;
    private static Object semaphore = new Object();
    private int taState = 2;
    private int taid = -1;
    private Vector dbList = new Vector(0, 1);
    private boolean killed;
    private boolean rollbackByTBX;
    private TBLog mLog;

    public TBXJavaTransaction(TBLog tBLog) throws SQLException {
        this.mLog = tBLog;
        this.resetTA();
    }

    public synchronized int getTaState() throws SQLException {
        return this.taState;
    }

    private synchronized void resetTA() throws SQLException {
        this.killed = false;
        this.rollbackByTBX = false;
        this.timestamp = new TBTypeTs(0);
        this.mtaId.setMtaLn(GlobMtaId.getNextTaLn());
        if (this.dbList.size() > 0) {
            throw TBException.getTBException(30011, "TBXJavaTransaction: dbList not cleaned");
        }
        if (this.taid >= 0) {
            throw TBException.getTBException(30011, "TBXJavaTransaction: taid not cleaned");
        }
    }

    public synchronized int tryBeginTA(TBXConnectionIf tBXConnectionIf) throws SQLException {
        TBXJavaConnection tBXJavaConnection;
        try {
            tBXJavaConnection = (TBXJavaConnection)tBXConnectionIf;
        }
        catch (ClassCastException classCastException) {
            throw new TBException(30002);
        }
        if (this.taState == 2) {
            this.resetTA();
            this.taState = 4;
            this.taid = TBIdFactory.get(1);
        }
        if (this.taState != 4) {
            if (this.rollbackByTBX) {
                throw TBException.getTBException(11029, "");
            }
            throw new TBException(30026);
        }
        if (this.isConnectionUsed(tBXJavaConnection)) {
            return this.taState;
        }
        tBXJavaConnection.bindTransaction(this);
        try {
            tBXJavaConnection.testLogged();
            if (this.dbList.size() == 1) {
                throw new TBException(29999);
            }
            if (this.dbList.size() == 0) {
                GlobMtaId.assignApId(this.mtaId);
            }
            new TBReqBT(tBXJavaConnection, this.mtaId, this.getTaid(), this.timestamp, (short)this.consistency);
        }
        catch (SQLException sQLException) {
            tBXJavaConnection.freeTransaction(this);
            throw sQLException;
        }
        this.addConnection(tBXJavaConnection);
        return this.taState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int commit() throws SQLException {
        block11: {
            if (this.timestamp.getValue() != 0) {
                TBTypeMl tBTypeMl = new TBTypeMl();
                for (int i = 0; i < this.dbList.size(); ++i) {
                    TBReqExcl tBReqExcl = new TBReqExcl((TBXJavaConnection)this.dbList.elementAt(i), this.taid, this.timeout);
                    if (tBReqExcl.getState() != 0) {
                        throw new TBException(2);
                    }
                    tBTypeMl.merge(tBReqExcl.getDatabaseList());
                }
                if (tBTypeMl.size() > 1) {
                    throw new TBException(29999);
                }
            }
            try {
                try {
                    this.taState = this.capTa(13);
                }
                catch (TBException tBException) {
                    if (tBException.isHardError()) {
                        this.capTa(14);
                        this.taState = 32;
                        throw TBException.getTBException(11004, new String[]{Integer.toString(this.taid), this.taState == 1 ? "undefined" : (this.taState == 16 ? "committed" : (this.taState == 4 ? "active" : "aborted")), tBException.getMessage()});
                    } else {
                        this.taState = 4;
                    }
                    throw TBException.getTBException(11004, new String[]{Integer.toString(this.taid), this.taState == 1 ? "undefined" : (this.taState == 16 ? "committed" : (this.taState == 4 ? "active" : "aborted")), tBException.getMessage()});
                }
                Object var5_5 = null;
                if (this.taState == 4) break block11;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (this.taState == 4) throw throwable;
                this.removeAllConnections();
                throw throwable;
            }
            this.removeAllConnections();
        }
        this.freeTaid();
        return this.taState;
    }

    public synchronized int abort() throws SQLException {
        try {
            try {
                this.taState = this.capTa(14);
            }
            catch (TBException tBException) {
                this.taState = 1;
                throw TBException.getTBException(11000, new String[]{Integer.toString(this.taid), tBException.getMessage()});
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.removeAllConnections();
            throw throwable;
        }
        this.removeAllConnections();
        this.taState = 32;
        this.freeTaid();
        return this.taState;
    }

    public synchronized void abortOutband() throws SQLException {
        if (this.taState == 4) {
            int n = this.dbList.size();
            for (int i = 0; i < n; ++i) {
                TBXJavaConnection tBXJavaConnection = (TBXJavaConnection)this.dbList.get(i);
                if (tBXJavaConnection.isExecuting()) {
                    TBTypePd tBTypePd = tBXJavaConnection.getRemoteProcessId();
                    new TBReqSndSig(tBXJavaConnection, tBTypePd);
                    continue;
                }
                this.abort();
            }
        }
    }

    public synchronized int abortTBX() throws SQLException {
        this.rollbackByTBX = true;
        return this.abort();
    }

    public boolean isTBXAborted() {
        return this.rollbackByTBX;
    }

    private int capTa(int n) throws SQLException {
        int n2 = 0;
        int n3 = 1;
        SQLException sQLException = null;
        TBException tBException = null;
        if (this.dbList.size() == 0) {
            switch (n) {
                case 14: {
                    n2 = 32;
                    break;
                }
                case 13: {
                    n2 = 16;
                    break;
                }
                case 15: {
                    n2 = 8;
                    break;
                }
                case 16: {
                    n2 = 1;
                }
            }
        }
        for (int i = 0; i < this.dbList.size(); ++i) {
            TBXJavaConnection tBXJavaConnection = (TBXJavaConnection)this.dbList.elementAt(i);
            try {
                switch (n) {
                    case 14: {
                        TBReqAT tBReqAT = new TBReqAT(tBXJavaConnection, this.mtaId, this.getTaid());
                        n3 = tBReqAT.getState();
                        break;
                    }
                    case 13: {
                        TBReqCT tBReqCT = new TBReqCT(tBXJavaConnection, this.mtaId, this.getTaid(), this.timeout);
                        n3 = tBReqCT.getState();
                    }
                }
                if ((n3 & 0x30) > 0) {
                    this.removeConnection(tBXJavaConnection);
                }
                n2 |= n3;
                continue;
            }
            catch (TBException tBException2) {
                if (tBException2.isHardError()) {
                    sQLException = tBException2;
                    continue;
                }
                tBException = tBException2;
                continue;
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        if (sQLException != null) {
            throw sQLException;
        }
        if (tBException != null) {
            throw tBException;
        }
        return n2;
    }

    private boolean isConnectionUsed(TBXJavaConnection tBXJavaConnection) {
        return this.dbList.contains(tBXJavaConnection);
    }

    private boolean addConnection(TBXJavaConnection tBXJavaConnection) throws SQLException {
        if (!this.isConnectionUsed(tBXJavaConnection)) {
            tBXJavaConnection.bindTransaction(this);
            this.dbList.addElement(tBXJavaConnection);
            return true;
        }
        return false;
    }

    private void removeAllConnections() throws SQLException {
        for (int i = 0; i < this.dbList.size(); ++i) {
            ((TBXJavaConnection)this.dbList.elementAt(i)).freeTransaction(this);
        }
        this.dbList.removeAllElements();
        this.dbList.trimToSize();
    }

    private void removeConnection(TBXJavaConnection tBXJavaConnection) throws SQLException {
        tBXJavaConnection.freeTransaction(this);
        this.dbList.removeElement(tBXJavaConnection);
    }

    public void setTimeout(int n) throws SQLException {
        this.timeout = n;
    }

    public int getTimeout() throws SQLException {
        return this.timeout;
    }

    public void setConsistency(int n) throws SQLException {
        this.consistency = n;
    }

    public int getConsistency() throws SQLException {
        return this.consistency;
    }

    public int getTaid() {
        return this.taid >= 0 ? 0 : this.taid;
    }

    private void freeTaid() throws SQLException {
        if (this.taid >= 0) {
            TBIdFactory.free(this.taid, 1);
            this.taid = -1;
        }
    }

    protected void finalize() {
        try {
            this.freeTaid();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

