/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.java.requests;

import java.sql.SQLException;
import java.util.Vector;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.java.TBXJavaConnection;
import transbase.tbx.requests.TBReqCursorFetchIf;
import transbase.tbx.requests.TBRequest;
import transbase.tbx.stypes.TBType;
import transbase.tbx.stypes.TBTypeLo;
import transbase.tbx.stypes.TBTypeM;
import transbase.tbx.stypes.TBTypeQd;
import transbase.tbx.stypes.TBTypeR;
import transbase.tbx.stypes.TBTypeSh;
import transbase.tbx.stypes.TBTypeTb;

public class TBReqCursorFetch
extends TBRequest
implements TBReqCursorFetchIf {
    private static final TBTypeR request = new TBTypeR(64);
    private TBTypeM mQueryIdOnDB;
    private TBTypeLo mCursorPos;
    private TBTypeSh mAscending;
    private TBTypeTb mTupleBuffer = new TBTypeTb();
    private TBTypeLo mLeftRowPos = new TBTypeLo();
    private TBTypeLo mRightRowPos = new TBTypeLo();
    private TBTypeLo mNRows = new TBTypeLo();
    private TBTypeQd mQueryDesc;

    public TBReqCursorFetch(TBXJavaConnection tBXJavaConnection, TBTypeQd tBTypeQd, int n, short s) throws SQLException {
        this.mQueryDesc = tBTypeQd;
        this.mQueryIdOnDB = new TBTypeM(tBTypeQd.getQuid());
        this.mCursorPos = new TBTypeLo(n);
        this.mAscending = new TBTypeSh(s);
        TBXJavaConnection tBXJavaConnection2 = tBXJavaConnection;
        synchronized (tBXJavaConnection2) {
            tBXJavaConnection.send(this);
            tBXJavaConnection.receive(this);
        }
    }

    public TBTypeR getRequestCode() {
        return request;
    }

    public Vector getTupleVector(int n) throws SQLException {
        return this.mTupleBuffer.getTupleVector(this.mQueryDesc, n);
    }

    public int getRowCount() {
        return this.mNRows.getValue();
    }

    public int getLeftRowPos() {
        return this.mLeftRowPos.getValue();
    }

    public int getRightRowPos() {
        return this.mRightRowPos.getValue();
    }

    public TBType[] getValuesToSend(TBXConnectionIf tBXConnectionIf) {
        return new TBType[]{request, this.mQueryIdOnDB, this.mCursorPos, this.mAscending};
    }

    public TBType[] getValuesToReceive(TBXConnectionIf tBXConnectionIf) {
        return new TBType[]{this.mLeftRowPos, this.mRightRowPos, this.mNRows, this.mTupleBuffer};
    }
}

