/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.java.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.java.TBXJavaConnection;
import transbase.tbx.java.TBXJavaTransaction;
import transbase.tbx.requests.TBRequest;
import transbase.tbx.stypes.TBType;
import transbase.tbx.stypes.TBTypeBl;
import transbase.tbx.stypes.TBTypeM;
import transbase.tbx.stypes.TBTypeR;
import transbase.tbx.stypes.TBTypeSt;
import transbase.tbx.types.helpers.BlobStream;

public class TBReqMakeBlob
extends TBRequest {
    private static final TBTypeR request = new TBTypeR(45);
    private TBTypeSt blobName;
    private TBTypeM taid;
    private TBTypeBl blobPackage;

    public TBReqMakeBlob(TBXJavaConnection tBXJavaConnection, TBXJavaTransaction tBXJavaTransaction, BlobStream blobStream, String string) throws SQLException {
        this.blobName = new TBTypeSt(string);
        this.taid = new TBTypeM(tBXJavaTransaction.getTaid());
        this.blobPackage = new TBTypeBl(blobStream, blobStream.getSize());
        TBXJavaConnection tBXJavaConnection2 = tBXJavaConnection;
        synchronized (tBXJavaConnection2) {
            tBXJavaConnection.send(this);
            tBXJavaConnection.receive(this);
        }
    }

    public TBTypeR getRequestCode() {
        return request;
    }

    public TBType[] getValuesToSend(TBXConnectionIf tBXConnectionIf) {
        return new TBType[]{request, this.blobName, this.taid, this.blobPackage};
    }

    public TBType[] getValuesToReceive(TBXConnectionIf tBXConnectionIf) {
        return new TBType[0];
    }

    public void readTBStream(DataInput dataInput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
    }

    public void writeTBStream(DataOutput dataOutput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        request.writeTBStream(dataOutput, tBXConnectionIf);
        this.blobName.writeTBStream(dataOutput, tBXConnectionIf);
        this.taid.writeTBStream(dataOutput, tBXConnectionIf);
        this.blobPackage.writeTBStream(dataOutput, tBXConnectionIf);
    }
}

