/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.stypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.TBStreamInterface;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.stypes.TBType;
import transbase.tbx.stypes.TBTypeBy;

public class TBTypeH
implements TBStreamInterface,
TBType {
    private TBTypeBy addrnet = new TBTypeBy(4);
    private byte addrlen = 0;
    private byte addrtype = (byte)2;
    private TBTypeBy addrnode = new TBTypeBy(6);
    private int comVersion;

    public TBTypeH(byte[] byArray) {
        this.setHostAddr(byArray);
    }

    public TBTypeH() {
        this.addrlen = 0;
        this.addrnet = new TBTypeBy(new byte[0]);
    }

    public void setHostAddr(byte[] byArray) {
        if (byArray.length == 4) {
            this.addrnet = new TBTypeBy(byArray);
            this.addrlen = (byte)4;
        }
        if (byArray.length == 6) {
            this.addrnode = new TBTypeBy(byArray);
            this.addrlen = (byte)6;
        }
    }

    public byte[] getHostAddr() {
        byte[] byArray = new byte[]{};
        if (this.addrlen == 4) {
            byArray = this.addrnet.getValue();
        }
        if (this.addrlen == 6) {
            byArray = this.addrnode.getValue();
        }
        return byArray;
    }

    public int getHostAddrAsInt() {
        byte[] byArray = this.addrnet.getValue();
        return (byArray[0] << 3) + (byArray[1] << 2) + (byArray[2] << 1) + (byArray[3] << 0);
    }

    public String getLogString(TBXConnectionIf tBXConnectionIf) {
        return String.valueOf(String.valueOf(new StringBuffer("H(").append(this.addrnet.getLogString(tBXConnectionIf)).append(", By(").append(this.addrlen).append("), By(").append(this.addrtype).append("), ").append(this.addrnode.getLogString(tBXConnectionIf)).append(")")));
    }

    public void readTBStream(DataInput dataInput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        if (tBXConnectionIf.getCommVersion() <= 1) {
            throw TBException.getTBException(30000, new String[]{Integer.toString(tBXConnectionIf.getCommVersion()), "TBTypeH"});
        }
        this.addrnet.readTBStream(dataInput, tBXConnectionIf);
        this.addrlen = dataInput.readByte();
        this.addrtype = dataInput.readByte();
        this.addrnode.readTBStream(dataInput, tBXConnectionIf);
    }

    public void writeTBStream(DataOutput dataOutput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        if (tBXConnectionIf.getCommVersion() <= 1) {
            throw TBException.getTBException(30000, new String[]{Integer.toString(tBXConnectionIf.getCommVersion()), "TBTypeH"});
        }
        this.addrnet.writeTBStream(dataOutput, tBXConnectionIf);
        dataOutput.writeByte(this.addrlen);
        dataOutput.writeByte(this.addrtype);
        this.addrnode.writeTBStream(dataOutput, tBXConnectionIf);
    }
}

