/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.stypes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import transbase.tbx.TBConst;
import transbase.tbx.TBException;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.stypes.TBShort;
import transbase.tbx.stypes.TBType;
import transbase.tbx.types.helpers.TSpec;

public class TBTypeTspec
implements TSpec,
TBType {
    private int typeCode;
    private short val1 = (short)-1;
    private short val2 = (short)-1;
    private short strPrec = (short)-1;

    public TBTypeTspec(int n) {
        this.typeCode = n;
    }

    public TBTypeTspec(int n, short s) {
        this.typeCode = n;
        this.strPrec = s;
    }

    public TBTypeTspec(int n, short s, short s2) {
        this.typeCode = n;
        this.val1 = s;
        this.val2 = s2;
    }

    public short getLowf() {
        switch (this.typeCode) {
            case 8: 
            case 9: {
                return this.val1;
            }
        }
        return 0;
    }

    public short getHighf() {
        switch (this.typeCode) {
            case 8: 
            case 9: {
                return this.val2;
            }
        }
        return 0;
    }

    public short getPrecision() {
        switch (this.typeCode) {
            case 3: {
                return this.val1;
            }
        }
        return 0;
    }

    public short getScale() {
        switch (this.typeCode) {
            case 3: {
                return this.val2;
            }
        }
        return 0;
    }

    public short getStrPrec() {
        switch (this.typeCode) {
            case 4: 
            case 12: 
            case 14: 
            case 29: 
            case 30: {
                return this.strPrec;
            }
        }
        return 0;
    }

    public int getType() {
        return this.typeCode;
    }

    public String getLogString(TBXConnectionIf tBXConnectionIf) {
        switch (this.typeCode) {
            case 4: 
            case 12: 
            case 14: 
            case 29: 
            case 30: {
                return String.valueOf(String.valueOf(new StringBuffer("TSpec(").append(this.strPrec).append(")")));
            }
            case 3: 
            case 8: 
            case 9: {
                return String.valueOf(String.valueOf(new StringBuffer("TSpec(").append(this.val1).append(", ").append(this.val2).append(")")));
            }
        }
        return "";
    }

    public void readTBStream(DataInput dataInput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        switch (this.typeCode) {
            case 4: 
            case 12: 
            case 14: 
            case 29: 
            case 30: {
                TBShort tBShort = new TBShort();
                tBShort.readTBStream(dataInput, tBXConnectionIf);
                this.strPrec = tBShort.getValue();
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                this.val1 = (short)dataInput.readUnsignedByte();
                this.val2 = (short)dataInput.readUnsignedByte();
                break;
            }
            default: {
                if (TBConst.isSupportedTBType(this.typeCode)) break;
                throw TBException.getTBException(30036, new String[]{Integer.toString(this.typeCode)});
            }
        }
    }

    public void writeTBStream(DataOutput dataOutput, TBXConnectionIf tBXConnectionIf) throws SQLException, IOException {
        switch (this.typeCode) {
            case 4: 
            case 12: 
            case 14: 
            case 29: 
            case 30: {
                new TBShort(this.strPrec).writeTBStream(dataOutput, tBXConnectionIf);
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                dataOutput.write(this.val1);
                dataOutput.write(this.val2);
            }
        }
    }
}

