/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.tuple;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Vector;
import transbase.tbx.TBException;
import transbase.tbx.TBXConnectionIf;
import transbase.tbx.stypes.TBTypeQd;
import transbase.tbx.stypes.TBTypeTb;
import transbase.tbx.tuple.TBAlignment;
import transbase.tbx.tuple.TBAttrBinchar;
import transbase.tbx.tuple.TBAttrBits;
import transbase.tbx.tuple.TBAttrBlob;
import transbase.tbx.tuple.TBAttrBool;
import transbase.tbx.tuple.TBAttrChar;
import transbase.tbx.tuple.TBAttrDatetime;
import transbase.tbx.tuple.TBAttrFloat;
import transbase.tbx.tuple.TBAttrInteger;
import transbase.tbx.tuple.TBAttrNull;
import transbase.tbx.tuple.TBAttrNumeric;
import transbase.tbx.tuple.TBAttrTimespan;
import transbase.tbx.tuple.TBAttrUndef;
import transbase.tbx.tuple.TBAttribute;

public class TBTuple {
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_ENHANCED = 1;
    private Vector columnValues;
    private int bytesPulled = 0;
    private int columnCount = 0;
    private boolean isEmptyTuple;
    private int mRowIndex = -1;
    private int mEnhancedFlags = 0;
    private byte[] mEmptyTuple = new byte[]{0, 8, 0, 0, 0, 0, 0, 0};

    public TBTuple() throws SQLException {
        this.isEmptyTuple = true;
        this.columnValues = new Vector(0);
    }

    public TBTuple(TBTypeQd tBTypeQd, InputStream inputStream, TBXConnectionIf tBXConnectionIf, int n) throws IOException, SQLException {
        this.constructFromStream(tBTypeQd, inputStream, tBXConnectionIf, n);
    }

    private void constructFromStream(TBTypeQd tBTypeQd, InputStream inputStream, TBXConnectionIf tBXConnectionIf, int n) throws IOException, SQLException {
        int n2;
        Vector<TBAttribute> vector = new Vector<TBAttribute>(0, 1);
        if (n == 1) {
            this.mRowIndex = this.getIntFromStream(inputStream);
            this.mEnhancedFlags = this.getIntFromStream(inputStream);
        }
        int n3 = this.getOffset(inputStream);
        int[] nArray = new int[n3 / 2];
        nArray[0] = n3;
        for (n2 = 1; n2 < nArray.length; ++n2) {
            nArray[n2] = this.getOffset(inputStream);
        }
        this.columnCount = nArray[0] > nArray[nArray.length - 1] ? nArray[nArray.length - 1] : nArray.length - 1;
        boolean bl = this.isEmptyTuple = this.columnCount == 0;
        if (this.isEmptyTuple) {
            this.columnValues = new Vector(0);
            return;
        }
        if (this.columnCount != tBTypeQd.getAttrNo()) {
            throw new IOException("Internal Error in TBTuple: columns in stream != columns in qd!");
        }
        this.columnValues = new Vector(this.columnCount);
        TBAttribute tBAttribute = null;
        for (n2 = 1; n2 <= this.columnCount; ++n2) {
            byte[] byArray = this.getAttributeFromStream(inputStream, nArray[n2 - 1], nArray[n2]);
            int n4 = tBTypeQd.getFieldType(n2);
            switch (n4) {
                case 4: {
                    tBAttribute = new TBAttrChar(tBXConnectionIf, byArray, 4);
                    break;
                }
                case 1: {
                    tBAttribute = new TBAttrInteger(tBXConnectionIf, byArray, 1);
                    break;
                }
                case 5: {
                    tBAttribute = new TBAttrInteger(tBXConnectionIf, byArray, 5);
                    break;
                }
                case 6: {
                    tBAttribute = new TBAttrInteger(tBXConnectionIf, byArray, 6);
                    break;
                }
                case 2: 
                case 7: {
                    tBAttribute = new TBAttrFloat(tBXConnectionIf, byArray, n4);
                    vector.addElement(tBAttribute);
                    break;
                }
                case 3: {
                    tBAttribute = new TBAttrNumeric(tBXConnectionIf, byArray);
                    break;
                }
                case 11: {
                    tBAttribute = new TBAttrBool(tBXConnectionIf, byArray);
                    break;
                }
                case 8: {
                    tBAttribute = new TBAttrDatetime(tBXConnectionIf, byArray);
                    break;
                }
                case 9: {
                    tBAttribute = new TBAttrTimespan(tBXConnectionIf, byArray);
                    break;
                }
                case 12: {
                    tBAttribute = new TBAttrBinchar(tBXConnectionIf, byArray);
                    break;
                }
                case 14: {
                    tBAttribute = new TBAttrBits(tBXConnectionIf, byArray, 14);
                    break;
                }
                case 30: {
                    tBAttribute = new TBAttrBits(tBXConnectionIf, byArray, 30);
                    break;
                }
                case 15: {
                    tBAttribute = new TBAttrNull(tBXConnectionIf, byArray);
                    break;
                }
                case 13: {
                    tBAttribute = new TBAttrBlob(tBXConnectionIf, byArray);
                    break;
                }
                case 29: {
                    tBAttribute = new TBAttrChar(tBXConnectionIf, byArray, 29);
                    break;
                }
                default: {
                    tBAttribute = new TBAttrUndef();
                }
            }
            this.columnValues.addElement(tBAttribute);
        }
        this.moveStreamToPos(inputStream, nArray[this.columnCount]);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            tBAttribute = (TBAttribute)vector.elementAt(n2);
            this.bytesPulled += ((TBAttrFloat)tBAttribute).setValueFromStream(inputStream);
        }
        if (vector.size() > 0 && this.bytesPulled % 8 != 0) {
            int n5 = this.bytesPulled + 8 - this.bytesPulled % 8;
            this.moveStreamToPos(inputStream, n5);
        }
    }

    private byte[] getAttributeFromStream(InputStream inputStream, int n, int n2) throws IOException {
        byte[] byArray = new byte[n2 - n];
        this.moveStreamToPos(inputStream, n);
        if (byArray.length > 0) {
            int n3 = inputStream.read(byArray);
            this.bytesPulled += n3;
            if (n3 < byArray.length) {
                throw new IOException("Internal Error in TBTuple: no more bytes on stream");
            }
        }
        return byArray;
    }

    private void moveStreamToPos(InputStream inputStream, int n) throws IOException {
        long l = n - this.bytesPulled;
        if (inputStream.skip(l) < l) {
            throw new IOException("Internal Error in TBTuple: no more bytes on stream");
        }
        this.bytesPulled += (int)l;
    }

    private int getOffset(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        this.bytesPulled += 2;
        if (n < 0 || n2 < 0) {
            throw new IOException("Internal Error in TBTuple: no more bytes on stream");
        }
        return (n << 8) + (n2 << 0);
    }

    private int getIntFromStream(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        this.bytesPulled += 4;
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IOException("Internal Error in TBTuple: no more bytes on stream");
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public boolean isEmptyTuple() {
        return this.isEmptyTuple;
    }

    public TBAttribute getColumnValue(int n) throws SQLException {
        return (TBAttribute)this.columnValues.elementAt(n - 1);
    }

    public void setColumnValue(int n, TBAttribute tBAttribute) throws SQLException {
        this.isEmptyTuple = false;
        if (n > this.columnCount) {
            this.columnValues.setSize(n);
            for (int i = this.columnCount; i < n; ++i) {
                this.columnValues.setElementAt(new TBAttrNull(15), i);
            }
            this.columnCount = n;
        }
        this.columnValues.setElementAt(tBAttribute, n - 1);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    private byte[] getEmptyTuple() {
        return this.mEmptyTuple;
    }

    private byte[] getTypeTuple() throws SQLException, IOException {
        int n;
        if (this.columnCount == 0) {
            return this.getEmptyTuple();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        for (n = 0; n < this.columnCount; ++n) {
            dataOutputStream.writeShort((this.columnCount + 1 + n) * 2);
        }
        int n2 = this.columnCount * 4 + 2;
        int n3 = 8 - n2 % 8;
        n3 = n3 == 8 ? 0 : n3;
        dataOutputStream.writeShort(n2);
        block5: for (n = 0; n < this.columnCount; ++n) {
            int n4 = ((TBAttribute)this.columnValues.elementAt(n)).getTBType();
            switch (n4) {
                case 13: {
                    dataOutputStream.writeShort(27);
                    continue block5;
                }
                case 29: {
                    dataOutputStream.writeShort(4);
                    continue block5;
                }
                default: {
                    dataOutputStream.writeShort(n4);
                }
            }
        }
        for (n = 0; n < n3; ++n) {
            dataOutputStream.write(0);
        }
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] getDataTuple() throws SQLException, IOException {
        byte[] byArray;
        TBAttribute tBAttribute;
        int n;
        if (this.columnCount == 0) {
            return this.getEmptyTuple();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int[] nArray = new int[this.columnCount + 1];
        int n2 = (this.columnCount + 1) * 2;
        for (n = 0; n < this.columnCount; ++n) {
            tBAttribute = (TBAttribute)this.columnValues.elementAt(n);
            nArray[n] = n2 = this.align(byteArrayOutputStream2, n2, TBAlignment.getRequiredAlignment(tBAttribute.getTBType()));
            byArray = tBAttribute.getInternalValue();
            byteArrayOutputStream2.write(byArray);
            n2 += byArray.length;
        }
        nArray[this.columnCount] = n2;
        boolean bl = false;
        for (n = 0; n < this.columnCount; ++n) {
            tBAttribute = (TBAttribute)this.columnValues.elementAt(n);
            int n3 = tBAttribute.getTBType();
            if (n3 != 2 && n3 != 7) continue;
            bl = true;
            byArray = tBAttribute.isNull() ? new byte[]{0} : ((TBAttrFloat)tBAttribute).getStringArray();
            n2 += byArray.length;
            byteArrayOutputStream2.write(byArray);
        }
        int n4 = 8 - n2 % 8;
        n4 = n4 == 8 ? 0 : n4;
        for (n = 0; n < n4; ++n) {
            byteArrayOutputStream2.write(0);
        }
        for (n = this.columnCount - 1; n >= 0; --n) {
            tBAttribute = (TBAttribute)this.columnValues.elementAt(n);
            if (!tBAttribute.isNull() || nArray[n] >= nArray[n + 1]) continue;
            nArray[n] = nArray[n + 1];
        }
        for (n = 0; n <= this.columnCount; ++n) {
            dataOutputStream.writeShort(nArray[n]);
        }
        dataOutputStream.flush();
        byteArrayOutputStream.flush();
        byteArrayOutputStream2.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byte[] byArray3 = byteArrayOutputStream2.toByteArray();
        byArray = new byte[byArray2.length + byArray3.length];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray, byArray2.length, byArray3.length);
        short s = (short)((byArray[nArray[0] - 2] << 8) + byArray[nArray[0] - 1]);
        if (s == 0) {
            s = (short)this.columnCount;
            byArray[nArray[0] - 2] = (byte)((s & 0xFF00) >> 8);
            byArray[nArray[0] - 1] = (byte)(s & 0xFF);
        }
        return byArray;
    }

    public TBTypeTb getTupleBuffer() throws SQLException {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        try {
            byArray3 = this.getTypeTuple();
            byArray2 = this.getDataTuple();
            byArray = this.getEmptyTuple();
        }
        catch (IOException iOException) {
            throw TBException.getTBException(30011, new String[]{"transbase.tbx.java.tuple.TBTuple"});
        }
        byte[] byArray4 = new byte[byArray3.length + byArray2.length + byArray.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, byArray3.length, byArray2.length);
        System.arraycopy(byArray, 0, byArray4, byArray3.length + byArray2.length, byArray.length);
        return new TBTypeTb(byArray4);
    }

    private int align(OutputStream outputStream, int n, int n2) throws IOException {
        while (n % n2 != 0) {
            outputStream.write(0);
            ++n;
        }
        return n;
    }

    public int getRowIndex() {
        return this.mRowIndex;
    }

    public int getEnhancedFlags() {
        return this.mEnhancedFlags;
    }
}

