/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types;

import java.math.BigDecimal;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBObjectBase;

public class TBBool
extends TBObjectBase {
    private Boolean value = null;

    public boolean isNull() throws SQLException {
        return this.value == null;
    }

    public void setNull() throws SQLException {
        this.value = null;
    }

    public int getTBType() {
        return 11;
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value != false ? "TRUE" : "FALSE";
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value;
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value != false ? 1 : 0;
    }

    public float getFloat() throws SQLException {
        return this.getByte();
    }

    public double getDouble() throws SQLException {
        return this.getByte();
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.getByte());
    }

    public void setBoolean(boolean bl) throws SQLException {
        this.value = new Boolean(bl);
    }

    public void setLong(long l) throws SQLException {
        if (l != (long)1 && l != (long)0) {
            throw new TBException(30034);
        }
        this.value = new Boolean(l == (long)1);
    }

    public void setFloat(float f) throws SQLException {
        this.setDouble(f);
    }

    public void setDouble(double d) throws SQLException {
        if (d != 1.0 && d != 0.0) {
            throw new TBException(30034);
        }
        this.value = new Boolean(d == 1.0);
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal != null) {
            if (bigDecimal.compareTo(new BigDecimal(0.0)) == 0) {
                this.value = new Boolean(false);
            }
            if (bigDecimal.compareTo(new BigDecimal(1.0)) == 0) {
                this.value = new Boolean(true);
            }
            throw new TBException(30034);
        }
        this.value = null;
    }

    public void setString(String string) throws SQLException {
        if (string != null) {
            String string2 = string.trim().toUpperCase();
            if (string2.equals("TRUE")) {
                this.value = new Boolean(true);
            }
            if (string2.equals("FALSE")) {
                this.value = new Boolean(false);
            }
            throw new TBException(30034);
        }
        this.value = null;
    }
}

