/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBObjectBase;

public class TBNumeric
extends TBObjectBase {
    private BigDecimal value = null;
    private final int MASK = 127;
    private final byte ASCOFFS = 48;
    private final char POINT = '.';
    private final char PLUSOUT = ' ';
    private final char PLUSSIGN = '+';
    private final char MINUSSIGN = '-';
    private static char[] charBuffer = new char[1024];
    private static final int[] aShiftMap = new int[]{0, 0x800000, 0xC00000, 0xE00000, 0xF00000, 0xF80000, 0xFC0000, 0xFE0000};

    public boolean isNull() throws SQLException {
        return this.value == null;
    }

    public void setNull() throws SQLException {
        this.value = null;
    }

    public int getTBType() {
        return 3;
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value.toString();
    }

    public boolean getBoolean() throws SQLException {
        long l = this.getLong();
        if (l == (long)0) {
            return false;
        }
        if (l == (long)1) {
            return true;
        }
        throw new TBException(30034);
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        long l = this.value.longValue();
        if (this.value.compareTo(new BigDecimal((double)l)) != 0) {
            throw new TBException(30034);
        }
        return l;
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value.doubleValue();
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value.movePointRight(0);
    }

    public void setBoolean(boolean bl) throws SQLException {
        this.value = new BigDecimal((double)(bl ? 1 : 0));
    }

    public void setLong(long l) throws SQLException {
        this.value = new BigDecimal((double)l);
    }

    public void setFloat(float f) throws SQLException {
        this.value = new BigDecimal(f);
    }

    public void setDouble(double d) throws SQLException {
        this.value = new BigDecimal(d);
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.value = bigDecimal == null ? null : bigDecimal.add(new BigDecimal(0.0));
    }

    public void setString(String string) throws SQLException {
        this.value = string == null ? null : new BigDecimal(string);
    }

    public void setBcdArray(byte[] byArray) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            this.value = null;
        } else {
            byte[] byArray2 = this.initBcd();
            int n = byArray.length > byArray2.length ? byArray2.length : byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n);
            try {
                this.value = new BigDecimal(this.fixBigInt(byArray2), this.getScale(byArray2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TBException(30034);
            }
        }
    }

    public byte[] getBcdArray() throws SQLException {
        if (this.isNull()) {
            return new byte[0];
        }
        byte[] byArray = this.scanFix(this.value.toString());
        int n = this.getPrec(byArray);
        int n2 = (n + 3) / 2 + 1;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private byte[] initBcd() {
        return new byte[17];
    }

    private int getSign(byte[] byArray) {
        return (byArray[0] & 0x80) != 0 ? 1 : 0;
    }

    private void putSign(byte[] byArray, int n) {
        byArray[0] = (byte)((byArray[0] & 0x7F | (byte)(n << 7)) & 0xFF);
    }

    private int getScale(byte[] byArray) {
        return byArray[1] & 0x7F;
    }

    private void putScale(byte[] byArray, int n) {
        byArray[1] = (byte)(n & 0x7F);
    }

    private int getPrec(byte[] byArray) {
        return byArray[0] & 0x7F;
    }

    private void putPrec(byte[] byArray, int n) {
        byArray[0] = (byte)((byArray[0] & 0x80 | n & 0x7F) & 0xFF);
    }

    private int getDigit(byte[] byArray, int n) {
        int n2 = (n + 3) / 2;
        if (n % 2 == 0) {
            return byArray[n2] & 0xF;
        }
        return (byArray[n2] & 0xF0) >> 4;
    }

    private void putDigit(byte[] byArray, int n, int n2) {
        int n3 = (n + 3) / 2;
        byArray[n3] = n % 2 == 0 ? (byte)((byArray[n3] & 0xF0 | n2 & 0xF) & 0xFF) : (byte)((byArray[n3] & 0xF | n2 << 4) & 0xFF);
    }

    private String fixString(byte[] byArray) {
        char[] cArray = charBuffer;
        synchronized (cArray) {
            int n = 0;
            int n2 = this.getSign(byArray);
            int n3 = this.getScale(byArray);
            int n4 = this.getPrec(byArray);
            int n5 = TBNumeric.charBuffer[n++] = n2 == 1 ? 45 : 32;
            if (n4 == 0) {
                TBNumeric.charBuffer[n++] = 48;
            } else {
                int n6;
                if (n4 == n3) {
                    TBNumeric.charBuffer[n++] = 48;
                }
                for (n6 = n4; n6 > n3; --n6) {
                    TBNumeric.charBuffer[n++] = (char)(48 + this.getDigit(byArray, n6));
                }
                if (n3 != 0) {
                    TBNumeric.charBuffer[n++] = 46;
                    for (n6 = n3; n6 > 0; --n6) {
                        TBNumeric.charBuffer[n++] = (char)(48 + this.getDigit(byArray, n6));
                    }
                }
            }
            String string = new String(charBuffer, 0, n);
            return string;
        }
    }

    private void shiftLeftArray(int[] nArray, int n) {
        int n2;
        for (n2 = 0; n2 < 4; ++n2) {
            nArray[n2] = 0xFFFFFF & nArray[n2] << n | (nArray[n2 + 1] & aShiftMap[n]) >> 24 - n;
        }
        nArray[n2] = nArray[n2] << n & 0xFFFFFF;
    }

    private void timesTenArrayAndAdd(int[] nArray, int[] nArray2, int n) {
        System.arraycopy(nArray, 0, nArray2, 0, 5);
        this.shiftLeftArray(nArray, 3);
        this.shiftLeftArray(nArray2, 1);
        for (int i = 4; i >= 0; --i) {
            n = nArray[i] + nArray2[i] + n;
            nArray[i] = n & 0xFFFFFF;
            n >>= 24;
        }
    }

    private BigInteger fixBigInt(byte[] byArray) {
        int n;
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        for (int i = this.getPrec(byArray); i > 0; --i) {
            n = this.getDigit(byArray, i);
            this.timesTenArrayAndAdd(nArray, nArray2, n);
        }
        n = this.getSign(byArray) == 0 ? 1 : -1;
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < 5; ++i) {
            byArray2[i * 3 + 1] = (byte)((nArray[i] & 0xFF0000) >> 16);
            byArray2[i * 3 + 2] = (byte)((nArray[i] & 0xFF00) >> 8);
            byArray2[i * 3 + 3] = (byte)(nArray[i] & 0xFF);
        }
        return new BigInteger(n, byArray2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] scanFix(String string) throws SQLException {
        byte[] byArray = this.initBcd();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        while (cArray2[n3] == ' ' || cArray2[n3] == '\t' || cArray2[n3] == '\n') {
            ++n3;
        }
        if (cArray2[n3] == '-') {
            n4 = 1;
            ++n3;
        } else if (cArray2[n3] == '+' || cArray2[n3] == ' ') {
            ++n3;
        }
        boolean bl = false;
        while (cArray2[n3] == '0') {
            bl = true;
            ++n3;
        }
        while (Character.isDigit(cArray2[n3])) {
            ++n5;
            ++n3;
        }
        n2 = n3;
        if (cArray2[n3] == '.') {
            ++n3;
            while (Character.isDigit(cArray2[n3])) {
                ++n6;
                ++n3;
            }
            n2 = n3--;
            n5 += n6;
        } else {
            --n3;
        }
        if (n5 == 0) {
            if (!bl) throw TBException.getTBException(19003, new String[]{string, "NUMERIC"});
            this.fixMkZero(byArray);
            return byArray;
        } else {
            if (n5 > 30) {
                throw TBException.getTBException(19004, new String[]{string, "NUMERIC"});
            }
            boolean bl2 = true;
            for (n = 1; n <= n5; ++n) {
                if (cArray2[n3] != '0') {
                    bl2 = false;
                }
                if (cArray2[n3] == '.') {
                    // empty if block
                }
                int n7 = --n3;
                --n3;
                this.putDigit(byArray, n, cArray2[n7] - 48);
            }
            this.putPrec(byArray, n5);
            this.putScale(byArray, n6);
            this.putSign(byArray, bl2 ? 0 : n4);
        }
        return byArray;
    }

    private void fixMkZero(byte[] byArray) {
        this.putSign(byArray, 0);
        this.putPrec(byArray, 0);
        this.putScale(byArray, 0);
    }
}

