/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types;

import java.sql.SQLException;
import transbase.tbx.TBConst;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TSpec;
import transbase.tbx.types.info.TBBincharInfo;
import transbase.tbx.types.info.TBBitssInfo;
import transbase.tbx.types.info.TBBlobInfo;
import transbase.tbx.types.info.TBBoolInfo;
import transbase.tbx.types.info.TBCharInfo;
import transbase.tbx.types.info.TBDatetimeInfo;
import transbase.tbx.types.info.TBDoubleInfo;
import transbase.tbx.types.info.TBFloatInfo;
import transbase.tbx.types.info.TBIntegerInfo;
import transbase.tbx.types.info.TBNulltypInfo;
import transbase.tbx.types.info.TBNumericInfo;
import transbase.tbx.types.info.TBSmallintInfo;
import transbase.tbx.types.info.TBTimespanInfo;
import transbase.tbx.types.info.TBTinyintInfo;
import transbase.tbx.types.info.TBVarcharInfo;

public abstract class TypeInfo {
    protected TSpec mTypeSpec;

    protected TypeInfo(TSpec tSpec) {
        this.mTypeSpec = tSpec;
    }

    public static TypeInfo createTypeInfo(int n, TSpec tSpec) throws SQLException {
        switch (n) {
            case 12: {
                return new TBBincharInfo(tSpec);
            }
            case 13: {
                return new TBBlobInfo(tSpec);
            }
            case 11: {
                return new TBBoolInfo(tSpec);
            }
            case 4: {
                return new TBCharInfo(tSpec);
            }
            case 8: {
                return new TBDatetimeInfo(tSpec);
            }
            case 2: {
                return new TBDoubleInfo(tSpec);
            }
            case 7: {
                return new TBFloatInfo(tSpec);
            }
            case 3: {
                return new TBNumericInfo(tSpec);
            }
            case 1: {
                return new TBIntegerInfo(tSpec);
            }
            case 6: {
                return new TBSmallintInfo(tSpec);
            }
            case 5: {
                return new TBTinyintInfo(tSpec);
            }
            case 9: {
                return new TBTimespanInfo(tSpec);
            }
            case 15: {
                return new TBNulltypInfo(tSpec);
            }
            case 29: {
                return new TBVarcharInfo(tSpec);
            }
            case 14: {
                return new TBBitssInfo(tSpec, 14);
            }
            case 30: {
                return new TBBitssInfo(tSpec, 30);
            }
        }
        throw TBException.getTBException(30036, Integer.toString(n));
    }

    public static TypeInfo createTypeInfo(TSpec tSpec) throws SQLException {
        int n = tSpec.getType();
        return TypeInfo.createTypeInfo(n, tSpec);
    }

    public abstract int getTypeCode();

    public String getTypeName() {
        return TBConst.getTBTypeName(this.getTypeCode());
    }

    public String getLocalTypeName() {
        return this.getTypeName();
    }

    public boolean getAutoIncrement() {
        return false;
    }

    public String getFullTypeDesc() {
        return String.valueOf(String.valueOf(this.getTypeName())).concat(String.valueOf(String.valueOf(this.getCreateParams())));
    }

    public abstract int getPrecision();

    public abstract String getLiteralPrefix();

    public abstract String getLiteralSuffix();

    public abstract String getCreateParams();

    public int getNullable() {
        return 1;
    }

    public abstract boolean getCaseSensitive();

    public abstract int getSearchable();

    public abstract boolean getUnsignedAttribute();

    public abstract boolean getFixedPrecScale();

    public abstract int getMinimumScale();

    public abstract int getMaximumScale();

    public int getScale() {
        return this.getMaximumScale();
    }

    public abstract int getNumPrecRadix();

    public abstract int getMaxprec();

    public String getTypeLikeExpr(String string) {
        String string2 = this.mTypeSpec == null ? String.valueOf(String.valueOf(this.getTypeName())).concat("%") : this.getFullTypeDesc();
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" like '").append(string2).append("' ")));
    }

    public String getTypeColSizeExpr(String string) {
        return Integer.toString(this.getPrecision());
    }

    public String getTypeDecDigitExpr(String string) {
        return "0";
    }

    public String getTypeOctLenExpr(String string) {
        return this.getTypeColSizeExpr(string);
    }
}

