/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.helpers;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.TBXCursor;

public class BlobStream
extends InputStream {
    private static final int BUFFER_SIZE = 512000;
    private int size = 0;
    private int segid = 0;
    private int haddr = 0;
    private short laddr = 0;
    private byte stype = 0;
    private byte dev = 0;
    private byte[] blobBuffer = new byte[0];
    private InputStream internalStream = null;
    private String name = "";
    private int read = 0;
    private TBXCursor cursor = null;
    private boolean closed = false;
    private boolean isTransBaseKernelStream = false;
    int mLastKernelOffset = 0;
    int mLastKernelRange = 0;
    private int mCurrentReadlimit = 0;
    private int mCurrentMark = -1;

    public BlobStream(int n, int n2, byte by, byte by2, int n3, short s) {
        this.size = n;
        this.segid = n2;
        this.haddr = n3;
        this.laddr = s;
        this.stype = by;
        this.dev = by2;
        this.isTransBaseKernelStream = true;
        this.internalStream = new ByteArrayInputStream(this.blobBuffer);
    }

    public void setCursor(TBXCursor tBXCursor) {
        this.cursor = tBXCursor;
    }

    public BlobStream(byte[] byArray) {
        this.blobBuffer = byArray;
        this.size = this.blobBuffer.length;
        this.internalStream = new ByteArrayInputStream(this.blobBuffer);
    }

    public BlobStream(InputStream inputStream, int n) {
        this.size = n;
        this.internalStream = new BufferedInputStream(inputStream, 512000);
    }

    private void refillInternalStream() throws IOException {
        if (!this.isTransBaseKernelStream) {
            return;
        }
        if (this.cursor != null) {
            int n = this.mLastKernelOffset = this.read;
            int n2 = this.size - this.read;
            if (n2 > 512000) {
                n2 = 512000;
            }
            this.mLastKernelRange = n2;
            try {
                this.internalStream = this.cursor.getNextBlobStreamPart(this, n, n2);
            }
            catch (SQLException sQLException) {
                throw new IOException("Error while receiving part of BLOB from database: ".concat(String.valueOf(String.valueOf(sQLException.getMessage()))));
            }
        } else {
            throw new IOException("Error while reading from BLOB input stream: ".concat(String.valueOf(String.valueOf(new TBException(30021).getMessage()))));
        }
    }

    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int n = this.internalStream.read();
        if (n == -1 && this.read < this.size && this.isTransBaseKernelStream) {
            this.refillInternalStream();
            n = this.internalStream.read();
        }
        if (n != -1) {
            ++this.read;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray.length == 0) {
            return 0;
        }
        if (this.closed || this.size == 0) {
            return -1;
        }
        int n = 0;
        int n2 = byArray.length;
        while (n < n2) {
            int n3 = this.internalStream.read(byArray, n, n2 - n);
            if (n3 >= 0) {
                n += n3;
                this.read += n3;
            }
            if (this.read == this.size) {
                return n == 0 ? -1 : n;
            }
            if (n3 >= 0) continue;
            if (this.isTransBaseKernelStream) {
                this.refillInternalStream();
                continue;
            }
            return n == 0 ? -1 : n;
        }
        return n;
    }

    public void close() throws IOException {
        this.closed = true;
        this.internalStream.close();
    }

    public byte[] getByteArray() throws IOException {
        if (this.closed) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.getSize()];
        this.read(byArray);
        return byArray;
    }

    public int getSize() {
        return this.size;
    }

    public int getSegid() {
        return this.segid;
    }

    public int getHaddr() {
        return this.haddr;
    }

    public short getLaddr() {
        return this.laddr;
    }

    public byte getStype() {
        return this.stype;
    }

    public byte getDev() {
        return this.dev;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean markSupported() {
        if (this.isTransBaseKernelStream) {
            return true;
        }
        return super.markSupported();
    }

    public void mark(int n) {
        if (this.isTransBaseKernelStream) {
            this.mCurrentReadlimit = n;
            this.mCurrentMark = this.read;
        } else {
            super.mark(n);
        }
    }

    public void reset() throws IOException {
        if (this.isTransBaseKernelStream) {
            if (this.mCurrentMark < 0) {
                throw new IOException("mark() not called before reset() on this stream");
            }
            if (this.read - this.mCurrentMark > this.mCurrentReadlimit) {
                throw new IOException("readlimit of last call to mark() exceeded");
            }
            this.gotoPosition(this.mCurrentMark);
        } else {
            super.reset();
        }
    }

    private void gotoPosition(int n) throws IOException {
        if (this.internalStream != null && this.internalStream.markSupported() && n >= this.mLastKernelOffset && n < this.mLastKernelOffset + this.mLastKernelRange) {
            this.internalStream.reset();
            this.internalStream.skip(n - this.mLastKernelOffset);
            this.read = n;
        } else {
            this.read = n;
            this.internalStream = new ByteArrayInputStream(new byte[0]);
            this.mLastKernelOffset = this.read;
            this.mLastKernelRange = 0;
        }
    }

    public long skip(long l) throws IOException {
        if (this.isTransBaseKernelStream) {
            if (l < (long)0) {
                l = 0L;
            }
            int n = 0;
            if (l + (long)this.read > (long)this.size) {
                l = this.size - this.read;
                n = this.size;
            } else {
                n = (int)(l + (long)this.read);
            }
            this.gotoPosition(n);
            return l;
        }
        return super.skip(l);
    }
}

