/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.helpers;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBCharToByteStream;
import transbase.tbx.types.helpers.TBEncodingConvertStream;

public class CharEncodingFactory {
    public static final int CPG_INVALID = 0;
    public static final int CPG_TEST = 1;
    public static final int CPG_PROPRIET = 2;
    public static final int CPG_ASCII = 3;
    public static final int CPG_SINGLEBYTE = 4;
    public static final int CPG_UTF8 = 5;
    public static final int CPG_EUC = 6;
    public static final int CPG_JIS = 7;
    private String mCharEncoding;
    private boolean mUseDefault;
    private static CharEncodingFactory aStandardPlatformEncoding = new CharEncodingFactory();

    public CharEncodingFactory(String string) throws SQLException {
        this.mUseDefault = string == null || string.length() == 0;
        this.mCharEncoding = string;
        this.getBytes("TransAction");
    }

    public CharEncodingFactory() {
        this.mUseDefault = true;
        this.mCharEncoding = null;
    }

    public CharEncodingFactory(int n) throws SQLException {
        this.mCharEncoding = CharEncodingFactory.mapTransBaseEncoding(n);
        this.mUseDefault = this.mCharEncoding == null || this.mCharEncoding.length() == 0;
        try {
            this.getBytes("TransAction");
        }
        catch (SQLException sQLException) {
            throw TBException.getTBException(30039, new String[]{CharEncodingFactory.getTransBaseEncodingDescription(n)});
        }
    }

    private void throwEncodingException() throws SQLException {
        throw TBException.getTBException(30039, new String[]{this.mCharEncoding});
    }

    public static CharEncodingFactory getPlatformEncoding() {
        return aStandardPlatformEncoding;
    }

    public String getString(byte[] byArray) throws SQLException {
        return this.getString(byArray, 0, byArray.length);
    }

    public String getString(byte[] byArray, int n, int n2) throws SQLException {
        String string = null;
        try {
            string = this.mUseDefault ? new String(byArray, n, n2) : new String(byArray, n, n2, this.mCharEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.throwEncodingException();
        }
        return string;
    }

    public byte[] getBytes(String string) throws SQLException {
        byte[] byArray = null;
        try {
            byArray = this.mUseDefault ? string.getBytes() : string.getBytes(this.mCharEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.throwEncodingException();
        }
        return byArray;
    }

    public TBCharToByteStream getCharToByteStream(Reader reader) throws SQLException {
        TBCharToByteStream tBCharToByteStream = null;
        tBCharToByteStream = this.mUseDefault ? new TBCharToByteStream(reader) : new TBCharToByteStream(reader, this.mCharEncoding);
        return tBCharToByteStream;
    }

    public Reader getInputStreamReader(InputStream inputStream) throws SQLException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = this.mUseDefault ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, this.mCharEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.throwEncodingException();
        }
        return inputStreamReader;
    }

    public InputStream getUnicodeStream(InputStream inputStream) throws SQLException {
        TBEncodingConvertStream tBEncodingConvertStream = null;
        tBEncodingConvertStream = this.mUseDefault ? new TBEncodingConvertStream(inputStream, null, "UnicodeBigUnmarked") : new TBEncodingConvertStream(inputStream, this.mCharEncoding, "UnicodeBigUnmarked");
        return tBEncodingConvertStream;
    }

    public InputStream getUnicodeToByteStream(InputStream inputStream) throws SQLException {
        TBEncodingConvertStream tBEncodingConvertStream = null;
        tBEncodingConvertStream = this.mUseDefault ? new TBEncodingConvertStream(inputStream, "UnicodeBig", null) : new TBEncodingConvertStream(inputStream, "UnicodeBig", this.mCharEncoding);
        return tBEncodingConvertStream;
    }

    public InputStream getASCIIStream(InputStream inputStream) {
        TBEncodingConvertStream tBEncodingConvertStream = null;
        tBEncodingConvertStream = this.mUseDefault ? new TBEncodingConvertStream(inputStream, null, "ASCII") : new TBEncodingConvertStream(inputStream, this.mCharEncoding, "ASCII");
        return tBEncodingConvertStream;
    }

    public InputStream getASCIIToByteStream(InputStream inputStream) throws SQLException {
        TBEncodingConvertStream tBEncodingConvertStream = null;
        tBEncodingConvertStream = this.mUseDefault ? new TBEncodingConvertStream(inputStream, "ASCII", null) : new TBEncodingConvertStream(inputStream, "ASCII", this.mCharEncoding);
        return tBEncodingConvertStream;
    }

    public static String mapTransBaseEncoding(int n) {
        String string = "???";
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                string = null;
                break;
            }
            case 3: {
                string = "ASCII";
                break;
            }
            case 4: {
                string = null;
                break;
            }
            case 5: {
                string = "UTF8";
                break;
            }
            case 6: {
                string = "EUC_JP";
                break;
            }
            case 7: {
                string = "SJIS";
            }
        }
        return string;
    }

    public static String getTransBaseEncodingDescription(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Invalid TransBase Encoding";
                break;
            }
            case 1: {
                string = "TransBase Debug and Test Encoding";
                break;
            }
            case 2: {
                string = "TransBase proprietary Encoding";
                break;
            }
            case 3: {
                string = "ASCII (American Standard Code for Information Interchange)";
                break;
            }
            case 4: {
                string = "TransBase uninterpreted single byte encoding";
                break;
            }
            case 5: {
                string = "Eight-bit Unicode Transformation Format";
                break;
            }
            case 6: {
                string = "JIS X 0201, 0208, 0212, EUC encoding, Japanese";
                break;
            }
            case 7: {
                string = "Shift-JIS, Japanese";
                break;
            }
            default: {
                string = String.valueOf(String.valueOf(new StringBuffer("Unknown TransBase Encoding (").append(n).append(")")));
            }
        }
        return string;
    }
}

