/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBObjectBase;

public class TBCharBase
extends TBObjectBase {
    private byte[] value = null;
    private int type;

    public TBCharBase(int n) {
        this.type = n;
    }

    public int getTBType() {
        return this.type;
    }

    public boolean isNull() throws SQLException {
        return this.value == null;
    }

    public void setNull() throws SQLException {
        this.value = null;
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getString(this.value);
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        String string = this.getString().trim().toUpperCase();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw new TBException(30034);
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            long l = Long.parseLong(this.getString().trim());
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new TBException(30034);
        }
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            float f = Float.valueOf(this.getString().trim()).floatValue();
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            throw new TBException(30034);
        }
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            double d = Double.valueOf(this.getString().trim());
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new TBException(30034);
        }
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        try {
            BigDecimal bigDecimal = new BigDecimal(this.getString().trim());
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            throw new TBException(30034);
        }
    }

    public Date getDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        try {
            Date date = Date.valueOf(this.getString().trim());
            return date;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TBException(30034);
        }
    }

    public Time getTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        try {
            Time time = Time.valueOf(this.getString().trim());
            return time;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TBException(30034);
        }
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        try {
            Timestamp timestamp = Timestamp.valueOf(this.getString().trim());
            return timestamp;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TBException(30034);
        }
    }

    private InputStream getInternalBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getBytes());
    }

    private void setInternalBinaryStream(InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.value = null;
        } else {
            int n = 0;
            byte[] byArray = new byte[2048];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                while ((n = inputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw TBException.getTBException(30012, new String[]{this.toString(), "setBinaryStream: ".concat(String.valueOf(String.valueOf(iOException.getMessage())))});
            }
            this.value = byteArrayOutputStream.toByteArray();
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getASCIIStream(this.getInternalBinaryStream());
    }

    public InputStream getUnicodeStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getUnicodeStream(this.getInternalBinaryStream());
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getCharEncoding().getInputStreamReader(this.getInternalBinaryStream());
    }

    public void setBoolean(boolean bl) throws SQLException {
        String string = bl ? "TRUE" : "FALSE";
        this.value = this.getCharEncoding().getBytes(string);
    }

    public void setLong(long l) throws SQLException {
        String string = Long.toString(l);
        this.value = this.getCharEncoding().getBytes(string);
    }

    public void setFloat(float f) throws SQLException {
        String string = Float.toString(f);
        this.value = this.getCharEncoding().getBytes(string);
    }

    public void setDouble(double d) throws SQLException {
        String string = Double.toString(d);
        this.value = this.getCharEncoding().getBytes(string);
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.value = null;
        } else {
            String string = bigDecimal.toString();
            this.value = this.getCharEncoding().getBytes(string);
        }
    }

    public void setString(String string) throws SQLException {
        this.value = (byte[])(string == null ? null : this.getCharEncoding().getBytes(string));
    }

    public void setBytes(byte[] byArray) throws SQLException {
        this.value = (byte[])(byArray == null ? null : byArray);
    }

    public byte[] getBytes() throws SQLException {
        return this.value;
    }

    public void setDate(Date date) throws SQLException {
        this.value = (byte[])(date == null ? null : this.getCharEncoding().getBytes(date.toString()));
    }

    public void setTime(Time time) throws SQLException {
        this.value = (byte[])(time == null ? null : this.getCharEncoding().getBytes(time.toString()));
    }

    public void setTimestamp(Timestamp timestamp) throws SQLException {
        this.value = (byte[])(timestamp == null ? null : this.getCharEncoding().getBytes(timestamp.toString()));
    }

    public void setCharacterStream(Reader reader, int n) throws SQLException {
        if (reader == null) {
            this.value = null;
        } else {
            this.setInternalBinaryStream(this.getCharEncoding().getCharToByteStream(reader));
        }
    }
}

