/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.helpers;

import java.math.BigDecimal;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBObjectBase;

public abstract class TBDoubleBase
extends TBObjectBase {
    private Double value = null;
    private int type;

    public TBDoubleBase(int n) {
        this.type = n;
    }

    public int getTBType() {
        return this.type;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public void setNull() throws SQLException {
        this.value = null;
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value.toString();
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        int n = this.getInt();
        if (n == 1) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        throw new TBException(30034);
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value.intValue();
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value.toString());
    }

    public void setBoolean(boolean bl) throws SQLException {
        this.value = new Double(bl ? 1 : 0);
    }

    public void setLong(long l) throws SQLException {
        this.setString(Long.toString(l));
    }

    public void setFloat(float f) throws SQLException {
        this.value = new Double(f);
    }

    public void setDouble(double d) throws SQLException {
        this.value = new Double(d);
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.value = null;
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    public void setString(String string) throws SQLException {
        if (string == null) {
            this.value = null;
        } else {
            try {
                this.value = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TBException(30034);
            }
        }
    }
}

