/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.types.helpers;

import java.math.BigDecimal;
import java.sql.SQLException;
import transbase.tbx.TBException;
import transbase.tbx.types.helpers.TBObjectBase;

public abstract class TBIntegerBase
extends TBObjectBase {
    private Integer value;
    private int type;

    public TBIntegerBase(int n) {
        this.type = n;
    }

    public int getTBType() {
        return this.type;
    }

    public void setNull() {
        this.value = null;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value.toString();
    }

    public boolean getBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        int n = this.getInt();
        if (n == 1) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        throw new TBException(30034);
    }

    public long getLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value.intValue();
    }

    public float getFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    public double getDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value.doubleValue();
    }

    public BigDecimal getBigDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal((double)this.value.longValue());
    }

    public void setBoolean(boolean bl) throws SQLException {
        this.value = new Integer(bl ? 1 : 0);
    }

    public void setLong(long l) throws SQLException {
        long l2 = 0L;
        long l3 = 0L;
        switch (this.getTBType()) {
            case 5: {
                l2 = 127L;
                l3 = -128L;
                break;
            }
            case 6: {
                l2 = 32767L;
                l3 = -32768L;
                break;
            }
            case 1: {
                l2 = Integer.MAX_VALUE;
                l3 = Integer.MIN_VALUE;
            }
        }
        if (l > l2 || l < l3) {
            throw new TBException(30034);
        }
        this.value = new Integer((int)l);
    }

    public void setFloat(float f) throws SQLException {
        this.setString(Float.toString(f));
    }

    public void setDouble(double d) throws SQLException {
        this.setString(Double.toString(d));
    }

    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.value = null;
        } else {
            this.setString(bigDecimal.toString());
        }
    }

    public void setString(String string) throws SQLException {
        if (string == null) {
            this.value = null;
        } else {
            try {
                long l = Long.parseLong(string);
                this.setLong(l);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TBException(30034);
            }
        }
    }
}

