/*
 * Decompiled with CFR 0.152.
 */
package transbase.tbx.util;

import java.sql.SQLException;
import transbase.tbx.TBXCursorIf;
import transbase.tbx.util.TBXCursorWrapper;

public class TBXMaxRowCursor
extends TBXCursorWrapper {
    private int mMaxRows;
    private int mCurrentRow;
    private int mTotalRows;

    public TBXMaxRowCursor(TBXCursorIf tBXCursorIf, int n) {
        super(tBXCursorIf);
        this.mMaxRows = n;
        this.mCurrentRow = 0;
        this.mTotalRows = -1;
    }

    public boolean next() throws SQLException {
        boolean bl = false;
        if (this.mMaxRows > 0 && this.mCurrentRow > this.mMaxRows) {
            return false;
        }
        bl = this.mCursor.next();
        if (bl) {
            ++this.mCurrentRow;
            if (this.mMaxRows > 0 && this.mCurrentRow > this.mMaxRows) {
                return false;
            }
        } else {
            if (this.mTotalRows < 0) {
                this.mTotalRows = this.mCurrentRow;
            }
            this.mCurrentRow = this.mTotalRows + 1;
        }
        return bl;
    }

    public boolean isOnRow() throws SQLException {
        if (this.mMaxRows > 0 && this.mCurrentRow > this.mMaxRows) {
            return false;
        }
        return this.mCursor.isOnRow();
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.mCursor.isBeforeFirst();
    }

    public boolean isAfterLast() throws SQLException {
        boolean bl = this.mCursor.isAfterLast() || this.mMaxRows > 0 && this.mCurrentRow > this.mMaxRows;
        return bl;
    }

    public boolean isFirst() throws SQLException {
        return this.mCursor.isFirst();
    }

    public boolean isLast() throws SQLException {
        boolean bl = this.mMaxRows > 0 ? (this.mCursor.isOnRow() && this.mMaxRows == this.mCurrentRow ? true : (this.mCurrentRow > this.mMaxRows ? false : this.mCursor.isLast())) : this.mCursor.isLast();
        return bl;
    }

    public boolean previous() throws SQLException {
        boolean bl = this.mCursor.previous();
        this.mCurrentRow = bl ? this.mCursor.getRow() : 0;
        return bl;
    }

    public boolean absolute(int n) throws SQLException {
        boolean bl;
        int n2;
        if (this.mTotalRows < 0) {
            n2 = this.mCursor.absolute(-1);
            this.mTotalRows = n2 != 0 ? this.mCursor.getRow() : 0;
        }
        int n3 = n2 = this.mTotalRows < this.mMaxRows ? this.mTotalRows : this.mMaxRows;
        if (this.mMaxRows < this.mTotalRows && n < 0) {
            n -= this.mTotalRows - this.mMaxRows;
        }
        if (bl = this.mCursor.absolute(n)) {
            this.mCurrentRow = this.mCursor.getRow();
            if (this.mCurrentRow > this.mMaxRows) {
                this.mCursor.absolute(n2 + 1);
                this.mCurrentRow = n2 + 1;
                bl = false;
            }
        } else {
            this.mCurrentRow = n > 0 ? n2 + 1 : 0;
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        this.testOnRow();
        int n2 = this.mCurrentRow + n;
        boolean bl = false;
        if (n2 <= 0) {
            this.mCurrentRow = 0;
        } else if (n2 > this.mMaxRows) {
            this.mCurrentRow = this.mMaxRows + 1;
        } else {
            bl = this.mCursor.relative(n);
            this.mCurrentRow = this.mCursor.getRow();
        }
        return bl;
    }

    public void afterLast() throws SQLException {
        if (this.mCursor.absolute(-1)) {
            this.mCurrentRow = this.mCursor.getRow();
            this.mCurrentRow = this.mCurrentRow > this.mMaxRows ? this.mMaxRows + 1 : ++this.mCurrentRow;
            this.mCursor.absolute(this.mCurrentRow);
        } else {
            this.mCurrentRow = 0;
        }
    }

    public void beforeFirst() throws SQLException {
        this.mCursor.beforeFirst();
        this.mCurrentRow = 0;
    }

    public int getRow() throws SQLException {
        if (this.mCurrentRow > this.mMaxRows) {
            return 0;
        }
        return this.mCursor.getRow();
    }
}

