/*
 * Decompiled with CFR 0.152.
 */
package com.bmw.etk.rest;

import com.bmw.etk.rest.AbstractCommandPublisher;
import com.bmw.etk.rest.TransferableCommandExecutor;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import webetk.InvalidSessionException;
import webetk.communication.LoginException;
import webetk.communication.transferables.Command;
import webetk.communication.transferables.TrfHashMap;
import webetk.javaserver.framework.SessionInfo;
import webetk.javaserver.servlet.ClientService;

@Path(value="/etk_webservices/trf_hash_map")
public class TrfHashMapCommandPublisher
extends AbstractCommandPublisher {
    protected Logger log = Logger.getLogger(TrfHashMapCommandPublisher.class);

    @POST
    @Path(value="/do_transfer")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public TrfHashMap executeTrfHashMapCommand(@Context HttpServletRequest request, TrfHashMap pTrfHashMap) {
        SessionInfo sessionInfo = this.updateCurrentSession(request, pTrfHashMap);
        TransferableCommandExecutor<TrfHashMap> commandExecutor = new TransferableCommandExecutor<TrfHashMap>();
        return commandExecutor.executeCommand(pTrfHashMap, sessionInfo);
    }

    private SessionInfo updateCurrentSession(HttpServletRequest request, TrfHashMap trfHashMap) {
        try {
            if (Command.LOGIN.equals(trfHashMap.getCommand())) {
                this.log.debug("Command.LOGIN. Session required.");
                return new ClientService().getCurrentSession(request, trfHashMap);
            }
        }
        catch (InvalidSessionException e) {
            trfHashMap.setError(e);
        }
        catch (LoginException e) {
            trfHashMap.setError(e);
        }
        return this.getSessionInfo(request, trfHashMap);
    }
}

