/*
 * Decompiled with CFR 0.152.
 */
package webetk;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.LanguageUtils;
import webetk.app.ServerGlobalObjects;
import webetk.javaserver.app.Constants;

public abstract class MultiLingualMsg
extends ResourceBundle {
    private static Vector MsgKeys = null;
    private static HashMap MsgResourceBundles = new HashMap();
    protected String msLanguage;
    protected String msCountry;
    private Properties mpResourcen = null;
    private static Logger log = Logger.getLogger(MultiLingualMsg.class);

    public MultiLingualMsg() throws InstantiationException {
        log.debug("Initializing resource bundle with default language ...");
        this.msLanguage = "en";
        this.msCountry = "UK";
        Logger.getLogger(MultiLingualMsg.class).debug("Commencing init routine ...");
        try {
            this.init();
        }
        catch (IOException e) {
            log.error("Property File could not be found! Properties are now empty.", e);
            this.mpResourcen = new Properties();
            return;
        }
        Logger.getLogger(MultiLingualMsg.class).debug("Init task accomplished ...");
    }

    public MultiLingualMsg(String sLang, String sCountry) throws InstantiationException {
        log.debug("Initializing resource bundle with language: " + sLang + "/" + sCountry);
        this.msLanguage = sLang;
        this.msCountry = sCountry;
        Logger.getLogger(MultiLingualMsg.class).debug("Commencing init routine ...");
        try {
            this.init();
        }
        catch (IOException e) {
            log.error("Property File could not be found! Properties are now empty.", e);
            this.mpResourcen = new Properties();
            return;
        }
        log.debug("Init task accomplished ...");
    }

    private void init() throws IOException, InstantiationException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        String sLang = this.msLanguage + (this.msCountry != null ? "_" + this.msCountry : "");
        String sFileNameCountry = gObj.getResourcePropertyFileName() + "_" + sLang + "." + gObj.getResourcePropertyFileExtension();
        String sFileName = gObj.getResourcePropertyFileName() + "_" + this.msLanguage + "." + gObj.getResourcePropertyFileExtension();
        Logger.getLogger(MultiLingualMsg.class).info("Creating ResourceBundle for Language: " + sLang);
        if (MsgKeys == null) {
            Logger.getLogger(MultiLingualMsg.class).debug("Loading Keys from Constants ...");
            List<String> cKeys = Arrays.asList(Constants.MSG_RESOURCE_KEYS);
            MsgKeys = new Vector<String>(cKeys);
            Logger.getLogger(MultiLingualMsg.class).debug("Loading Keys from Constants DONE");
        }
        Logger.getLogger(MultiLingualMsg.class).debug("Constructing property filename ...");
        this.mpResourcen = new Properties();
        if (this.msCountry != null) {
            Logger.getLogger(MultiLingualMsg.class).info("Trying to load resources from file: " + sFileNameCountry);
            try {
                this.mpResourcen.load(this.getClass().getResourceAsStream(sFileNameCountry));
            }
            catch (NullPointerException e) {
                Logger.getLogger(MultiLingualMsg.class).warn("No property file <" + sFileNameCountry + "> found. Trying without country.");
            }
        }
        Logger.getLogger(MultiLingualMsg.class).info("Trying to load resources from file: " + sFileName);
        try {
            this.mpResourcen.load(this.getClass().getResourceAsStream(sFileName));
        }
        catch (NullPointerException e) {
            log.error("Property file <" + sFileName + "> does not exist!!", e);
            throw new InstantiationException("Property file <" + sFileName + "> does not exist!!");
        }
    }

    public Enumeration getKeys() {
        if (MsgKeys == null) {
            return new StringTokenizer("");
        }
        return MsgKeys.elements();
    }

    @Override
    public Object handleGetObject(String key) throws NullPointerException {
        if (key == null) {
            Logger.getLogger(MultiLingualMsg.class).error("The key is null");
            throw new NullPointerException("Illegal call of resource retrieval 'handleGetObject': key is null!");
        }
        Logger.getLogger(MultiLingualMsg.class).debug("Retrieving Resource for key: " + key);
        if (MsgKeys.contains(key)) {
            Logger.getLogger(MultiLingualMsg.class).debug("The key <" + key + "> is known.");
            String sResource = null;
            Logger.getLogger(MultiLingualMsg.class).debug("Trying to retrieve resource from property file.");
            sResource = this.mpResourcen.getProperty(key);
            if (sResource != null) {
                log.info("Key <" + key + "> mapped to: " + sResource);
            } else {
                log.info("No mapping found for key: " + key);
            }
            return sResource;
        }
        Logger.getLogger(MultiLingualMsg.class).info("The key <" + key + "> is not valid, thus resource is null!");
        return null;
    }

    public static ResourceBundle getMsgResources(String strLang, String strCountry) {
        ResourceBundle res = null;
        if (strCountry != null) {
            res = MultiLingualMsg.getMsgResources(strLang + "_" + strCountry);
        }
        if (res != null) {
            return res;
        }
        return MultiLingualMsg.getMsgResources(strLang);
    }

    private static ResourceBundle getMsgResources(String strLang) {
        String sBundleName = "webetk.MultiLingualMsg_" + strLang;
        MultiLingualMsg resBundle = (MultiLingualMsg)MsgResourceBundles.get(sBundleName);
        if (resBundle != null) {
            return resBundle;
        }
        try {
            Class<?> oClass = Class.forName(sBundleName);
            resBundle = (MultiLingualMsg)oClass.newInstance();
            MsgResourceBundles.put(sBundleName, resBundle);
            return resBundle;
        }
        catch (NoClassDefFoundError e) {
            Logger.getLogger(MultiLingualMsg.class).error("Couldn't find resource bundle: " + sBundleName + " : " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            Logger.getLogger(MultiLingualMsg.class).error("Couldn't find resource bundle: " + sBundleName + " : " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            Logger.getLogger(MultiLingualMsg.class).error("Couldn't instantiate resource bundle: " + sBundleName + " : " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            Logger.getLogger(MultiLingualMsg.class).error("Couldn't access resource bundle: " + sBundleName + " : " + e.getMessage(), e);
        }
        catch (ClassCastException e) {
            Logger.getLogger(MultiLingualMsg.class).error("Couldn't cast instance to resource bundle: " + sBundleName + " : " + e.getMessage(), e);
        }
        return null;
    }

    public static String getMsgText(String sKey, String sLang, String sCountry) {
        ResourceBundle res = MultiLingualMsg.getMsgResources(sLang, sCountry);
        if (res != null) {
            try {
                return res.getString(sKey);
            }
            catch (MissingResourceException e) {
                return e.getMessage();
            }
        }
        return "Der Meldungstext f\u00fcr die Resource konnte nicht gefunden werden: " + sKey;
    }

    public static String getMsgText(String sKey, String sCompoundLang) {
        return MultiLingualMsg.getMsgText(sKey, LanguageUtils.toLanguage(sCompoundLang), LanguageUtils.toRegion(sCompoundLang, false));
    }
}

