/*
 * Decompiled with CFR 0.152.
 */
package webetk;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.app.BlaetternButton;
import webetk.app.ImageCache;

public class WebetkUtils {
    private static Logger log = Logger.getLogger(WebetkUtils.class);
    private static final JexlEngine jexl = new JexlEngine();

    public static String getTodayYYYYMMDD() {
        Calendar oToday = Calendar.getInstance();
        long lToday = (long)oToday.get(1) * 10000L + (long)((oToday.get(2) + 1) * 100) + (long)oToday.get(5);
        String sToday = Long.toString(lToday);
        return sToday;
    }

    public static String modifyDate(String sJahr, String sMonat, int nMonate) {
        GregorianCalendar dDate = new GregorianCalendar();
        dDate.set(new Integer(sJahr), new Integer(sMonat) - 1, 1);
        dDate.add(2, nMonate);
        int iJahr = dDate.get(1);
        int iMonat = dDate.get(2) + 1;
        sJahr = new Integer(iJahr).toString();
        sMonat = new Integer(iMonat).toString();
        if (iMonat < 10) {
            sMonat = "0" + sMonat;
        }
        return sJahr + sMonat + "00";
    }

    public static Date getDateFromLong(long lDate) {
        GregorianCalendar objCalendar = new GregorianCalendar();
        int nYear = (int)(lDate / 10000L);
        int nMonth = (int)((lDate - (long)(nYear * 10000)) / 100L);
        int nDay = (int)(lDate - (long)(nYear * 10000) - (long)(nMonth * 100));
        objCalendar.set(nYear, --nMonth, nDay);
        return objCalendar.getTime();
    }

    public static Date getDateTimeFromLong(long lDate) {
        GregorianCalendar objCalendar = new GregorianCalendar();
        long lYear = lDate / 100000000L;
        long lRest = lDate - lYear * 100000000L;
        long lMonth = lRest / 1000000L;
        long lDay = (lRest -= lMonth * 1000000L) / 10000L;
        long lHour = (lRest -= lDay * 10000L) / 100L;
        long lMin = lRest -= lHour * 100L;
        objCalendar.set((int)lYear, (int)(--lMonth), (int)lDay, (int)lHour, (int)lMin);
        return objCalendar.getTime();
    }

    public static String getStringFromDate(Date dDate, String sLang, int nDateFormat) {
        DateFormat df = DateFormat.getDateInstance(nDateFormat, WebetkUtils.getLocale(sLang));
        return df.format(dDate);
    }

    public static String getStringFromDateTime(Date dDate, String sLang, int nDateFormat, int nTimeFormat) {
        Locale locale = WebetkUtils.getLocale(sLang);
        DateFormat df = DateFormat.getDateTimeInstance(nDateFormat, nTimeFormat, locale);
        return df.format(dDate);
    }

    public static Date getDateFromString(String sDate, String sLang, int nDateFormat) throws ParseException {
        Locale locale = WebetkUtils.getLocale(sLang);
        return DateFormat.getDateInstance(nDateFormat, locale).parse(sDate);
    }

    private static Locale getLocale(String sLang) {
        Locale locale = null;
        if (sLang.equals("de")) {
            locale = new Locale("de", "DE");
        } else if (sLang.equals("en")) {
            locale = new Locale("cs", "CZ");
        } else if (sLang.equals("en")) {
            locale = new Locale("en", "GB");
        } else if (sLang.equals("enUS")) {
            locale = new Locale("en", "US");
        } else if (sLang.equals("enUS")) {
            locale = new Locale("el", "GR");
        } else if (sLang.equals("es")) {
            locale = new Locale("es", "ES");
        } else if (sLang.equals("fr")) {
            locale = new Locale("fr", "FR");
        } else if (sLang.equals("it")) {
            locale = new Locale("it", "IT");
        } else if (sLang.equals("ja")) {
            locale = new Locale("ja", "JP");
        } else if (sLang.equals("ko")) {
            locale = new Locale("ko", "KR");
        } else if (sLang.equals("nl")) {
            locale = new Locale("nl", "NL");
        } else if (sLang.equals("pl")) {
            locale = new Locale("pl", "PL");
        } else if (sLang.equals("pt")) {
            locale = new Locale("pt", "PT");
        } else if (sLang.equals("ru")) {
            locale = new Locale("ru", "RU");
        } else if (sLang.equals("sv")) {
            locale = new Locale("sv", "SE");
        } else if (sLang.equals("th")) {
            locale = new Locale("th", "TH");
        } else if (sLang.equals("tr")) {
            locale = new Locale("tr", "TR");
        } else if (sLang.equals("zh")) {
            locale = new Locale("zh", "CN");
        } else if (sLang.equals("zhTW")) {
            locale = new Locale("zh", "TW");
        } else {
            log.error("Error: Unsupported Language " + sLang);
            locale = new Locale("en", "US");
        }
        return locale;
    }

    public static long getLongFromDate(Date objDate) {
        GregorianCalendar objCalendar = new GregorianCalendar();
        objCalendar.setTime(objDate);
        long lDate = objCalendar.get(1) * 10000 + (objCalendar.get(2) + 1) * 100 + objCalendar.get(5);
        return lDate;
    }

    public static long getLongFromDateDDMMYYYY(Date objDate) {
        GregorianCalendar objCalendar = new GregorianCalendar();
        objCalendar.setTime(objDate);
        long lDate = objCalendar.get(5) * 1000000 + (objCalendar.get(2) + 1) * 10000 + objCalendar.get(1);
        return lDate;
    }

    public static long getLongFromTime(Date objDate) {
        GregorianCalendar objCalendar = new GregorianCalendar();
        objCalendar.setTime(objDate);
        long lDate = objCalendar.get(11) * 10000 + objCalendar.get(12) * 100 + objCalendar.get(13);
        return lDate;
    }

    public static void closeQuery(ResultSet rset) {
        if (rset == null) {
            return;
        }
        try {
            Statement stmt = rset.getStatement();
            rset.close();
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            log.warn("Unable to close statement and/or resultset!", e);
        }
    }

    public static String getFileEnding(String sGrafic) {
        if (sGrafic.equalsIgnoreCase("png")) {
            return ".png";
        }
        if (sGrafic.equalsIgnoreCase("gif")) {
            return ".gif";
        }
        if (sGrafic.equalsIgnoreCase("jpg")) {
            return ".jpg";
        }
        return null;
    }

    public static String constructFilename(String sBildId, String sBildForm, String sTimestamp) {
        if (sBildId == null || sBildForm == null || sTimestamp == null || !sBildForm.equals("N") && !sBildForm.equals("T") && !sBildForm.equals("Z")) {
            return null;
        }
        return sBildId + "_" + sBildForm + "_" + sTimestamp;
    }

    public static String getMimeType(String sFormat) {
        if (sFormat == null) {
            return null;
        }
        if (sFormat.equalsIgnoreCase("gif")) {
            return "image/gif";
        }
        if (sFormat.equalsIgnoreCase("jpg")) {
            return "image/jpeg";
        }
        if (sFormat.equalsIgnoreCase("png")) {
            return "image/png";
        }
        return null;
    }

    public static String extractGraficFormat(String sFilename) {
        String sFile = sFilename.toLowerCase();
        if (sFile.endsWith(".png")) {
            return "png";
        }
        if (sFile.endsWith(".gif")) {
            return "gif";
        }
        if (sFile.endsWith(".jpg") || sFilename.endsWith(".jpeg")) {
            return "jpg";
        }
        return null;
    }

    public static String getPriceString(double dPrice) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat decimalFormat = new DecimalFormat("0.00", symbols);
        String sResult = decimalFormat.format(dPrice);
        return sResult;
    }

    public static byte[] ladeGrafik(String sBildId, String sBildFactor) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String sFormat = ImageCache.requestImageAsByteArray(out, sBildId, sBildFactor);
            if (sFormat == null) {
                log.error("Image could not be loaded! Cause unknown.");
                return null;
            }
            byte[] theData = out.toByteArray();
            byte[] data = new byte[theData.length];
            System.arraycopy(theData, 0, data, 0, theData.length);
            return data;
        }
        catch (IOException ex) {
            log.error("I/O Error loading image from database!", ex);
            return null;
        }
        catch (DatabaseBusyException ex) {
            log.error("Database access failed during image loading!", ex);
            return null;
        }
        catch (SQLException ex) {
            log.error("SQL Error during image loading!", ex);
            return null;
        }
    }

    public static Collection evalHgBlaetterButtons(int nAnzahlTeile, int nAnzahlPakete, int nIndex) {
        Vector<BlaetternButton> cButtons = new Vector<BlaetternButton>();
        if (nAnzahlTeile < 100) {
            return cButtons;
        }
        int nMaxIndex = nAnzahlPakete - 1;
        boolean bSensitiv = nIndex > 0;
        int nButtonIndex = 0;
        int nButtonVon = 1;
        int nButtonBis = nAnzahlTeile < 99 ? nAnzahlTeile : 99;
        BlaetternButton cButton = new BlaetternButton(bSensitiv, 1, nButtonIndex, nButtonVon, nButtonBis);
        cButtons.add(cButton);
        bSensitiv = nIndex > 0;
        nButtonIndex = nIndex - 1 < 0 ? 0 : nIndex - 1;
        nButtonVon = nButtonIndex * 100;
        nButtonBis = nAnzahlTeile < nButtonIndex * 100 + 99 ? nAnzahlTeile : nButtonIndex * 100 + 99;
        cButton = new BlaetternButton(bSensitiv, 2, nButtonIndex, nButtonVon, nButtonBis);
        cButtons.add(cButton);
        int nCounter = 1;
        int nIndexVon = nIndex + 1;
        int nIndexBis = nMaxIndex >= nIndexVon + 4 ? nIndexVon + 4 : nMaxIndex;
        for (int i = nIndexVon; i <= nIndexBis; ++i) {
            bSensitiv = true;
            nButtonIndex = i;
            nButtonVon = i * 100;
            nButtonBis = nAnzahlTeile < i * 100 + 99 ? nAnzahlTeile : i * 100 + 99;
            int nAction = 0;
            if (nCounter == 1) {
                nAction = 3;
            }
            if (nCounter == 2) {
                nAction = 4;
            }
            if (nCounter == 3) {
                nAction = 5;
            }
            if (nCounter == 4) {
                nAction = 6;
            }
            if (nCounter == 5) {
                nAction = 7;
            }
            cButton = new BlaetternButton(bSensitiv, nAction, nButtonIndex, nButtonVon, nButtonBis);
            cButtons.add(cButton);
            ++nCounter;
        }
        bSensitiv = nIndex < nMaxIndex;
        nButtonIndex = nIndex + 1 > nMaxIndex ? nMaxIndex : nIndex + 1;
        nButtonVon = nButtonIndex * 100;
        nButtonBis = nAnzahlTeile < nButtonIndex * 100 + 99 ? nAnzahlTeile : nButtonIndex * 100 + 99;
        cButton = new BlaetternButton(bSensitiv, 8, nButtonIndex, nButtonVon, nButtonBis);
        cButtons.add(cButton);
        bSensitiv = nIndex < nMaxIndex;
        nButtonIndex = nMaxIndex;
        nButtonVon = nMaxIndex * 100;
        nButtonBis = nAnzahlTeile < nMaxIndex * 100 + 99 ? nAnzahlTeile : nMaxIndex * 100 + 99;
        cButton = new BlaetternButton(bSensitiv, 9, nButtonIndex, nButtonVon, nButtonBis);
        cButtons.add(cButton);
        return cButtons;
    }

    public static String formatiereTeilenummer(String teilenummer) {
        StringBuffer formatiert = new StringBuffer("");
        formatiert.append(teilenummer.substring(0, 2));
        formatiert.append(" " + teilenummer.substring(2, 4));
        formatiert.append(" " + teilenummer.substring(4, 5));
        formatiert.append(" " + teilenummer.substring(5, 8));
        formatiert.append(" " + teilenummer.substring(8, 11));
        return formatiert.toString();
    }

    public static String formatiereSachnummer(String sachnummer) {
        StringBuffer formatiert = new StringBuffer("");
        formatiert.append(sachnummer.substring(0, 1));
        formatiert.append(" " + sachnummer.substring(1, 4));
        formatiert.append(" " + sachnummer.substring(4, 7));
        return formatiert.toString();
    }

    public static byte[] removeZeroBytes(byte[] bdata) {
        int length = 0;
        for (int i = 0; i < bdata.length; ++i) {
            if (bdata[i] != 0) continue;
            length = i;
            break;
        }
        byte[] bdataNew = new byte[length];
        boolean k = false;
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                bdataNew[i] = bdata[i];
            }
            return bdataNew;
        }
        return bdata;
    }

    public static byte[] getBytes(byte[] bdata, int length) {
        for (int i = 0; i < bdata.length; ++i) {
            if (bdata[i] != 0) continue;
            length = i;
            break;
        }
        byte[] bdataNew = new byte[length];
        boolean k = false;
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                bdataNew[i] = bdata[i];
            }
            return bdataNew;
        }
        return bdata;
    }

    public static JexlEngine getJexlEngine() {
        return jexl;
    }

    public static Boolean getBoolFromAusweisung(String ausweisung) {
        if (!ausweisung.isEmpty() && "T".equals(ausweisung)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static {
        jexl.setLenient(true);
        jexl.setSilent(true);
    }
}

