/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import webetk.mrkprd.MarkeProdukt;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="webetk.app.Markt")
public class Markt
implements Serializable,
Comparable<Markt> {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    private int mMarktId;
    protected String mName;
    private String mKuerzel;
    private Collection<String> mProdukte;
    private String mLkz;
    private String mISOkz;
    private ArrayList<MarkeProdukt> mMarkeProduktartList;

    Markt() {
    }

    public Markt(int marktId, String name, String kuerzel) {
        this.mMarktId = marktId;
        this.mName = name;
        this.mKuerzel = kuerzel;
    }

    public Markt(Markt src) {
        this.mMarktId = src.getMarktId();
        this.mName = src.getName();
        this.mKuerzel = src.getKuerzel();
        this.mLkz = src.getLkz();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Markt)) {
            return false;
        }
        Markt markt = (Markt)obj;
        return markt.getMarktId() == this.mMarktId;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.mMarktId;
        return result;
    }

    public void setLkz(String lkz) {
        this.mLkz = lkz;
    }

    public String getLkz() {
        return this.mLkz;
    }

    public String getKuerzel() {
        return this.mKuerzel;
    }

    public void setKuerzel(String kuerzel) {
        this.mKuerzel = kuerzel;
    }

    public Collection<String> getProdukte() {
        return this.mProdukte;
    }

    public void setProdukte(Collection<String> produkte) {
        this.mProdukte = produkte;
    }

    public int getMarktId() {
        return this.mMarktId;
    }

    public void setMarktId(int marktId) {
        this.mMarktId = marktId;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.mName);
        if (this.mKuerzel.length() > 0) {
            ret.append(" (" + this.mKuerzel + ")");
        }
        return ret.toString();
    }

    public ArrayList<MarkeProdukt> getMarkeProduktartList() {
        return this.mMarkeProduktartList;
    }

    public void setMarkeProduktartList(ArrayList<MarkeProdukt> mMarkeProduktartList) {
        this.mMarkeProduktartList = mMarkeProduktartList;
    }

    public void setmISOkz(String mISOkz) {
        this.mISOkz = mISOkz;
    }

    public String getmISOkz() {
        return this.mISOkz;
    }

    public boolean isUSA() {
        return this.mKuerzel != null && this.mKuerzel.equals("US");
    }

    @Override
    public int compareTo(String sKuerzel) {
        if (this.mKuerzel == null) {
            return -1;
        }
        if (sKuerzel == null) {
            return 1;
        }
        return this.mKuerzel.compareTo(sKuerzel);
    }

    @Override
    public int compareTo(Markt oMarkt) {
        String sKuerzel = oMarkt == null ? null : oMarkt.mKuerzel;
        return this.compareTo(sKuerzel);
    }

    public boolean equals(Markt oMarkt) {
        String sKuerzel = oMarkt == null ? null : oMarkt.mKuerzel;
        boolean result = this.equals(sKuerzel);
        return result;
    }

    public boolean equals(String sKuerzel) {
        int result = this.compareTo(sKuerzel);
        return result == 0;
    }
}

