/*
 * Decompiled with CFR 0.152.
 */
package webetk.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import webetk.ConnectionPool;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.LanguageUtils;
import webetk.WebetkUtils;
import webetk.app.Bedingung;
import webetk.db.dbaccess.FzgIdDbAccess;
import webetk.db.dbaccess.SettingsDbAccess;
import webetk.fix.Constants;
import webetk.utils.StringUtils;

public class ServerGlobalObjects {
    private static Logger log = Logger.getLogger(ServerGlobalObjects.class);
    private static final Object lock = new Object();
    private Properties props;
    private String m_strHomePath;
    private String m_strImageCache;
    @XmlTransient
    private static DataSource dataSourcePubl;
    private static String pathPropertyFile;
    private static ServerGlobalObjects GlobalObjectsInstance;
    private ConnectionPool m_objConnPool;
    private ConnectionPool m_objConnPool_ETKNutzer;
    private ConnectionPool m_objConnPool_ETKPreise;
    private static String profile;
    private static String data;
    private static String lib;
    private static String logDir;
    private static String hostName;
    private static String classpathProperty;

    private ServerGlobalObjects(String sPropFile, ServletContext p_objContext, boolean pbGF) throws FileNotFoundException, IOException, InvalidInitializationException {
        this.loadProperties(sPropFile, p_objContext, pbGF);
        log.debug("Reading misc attributes...");
        this.readGeneralProps(p_objContext);
        log.debug("Reading misc attributes DONE.");
        this.logProperties(log, Level.ALL, this.props);
        if (classpathProperty != null) {
            this.initConnectionPoolGF();
        } else {
            this.initConnectionPoolJS();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerGlobalObjects getInstance(ServletContext servletContext) {
        boolean bGF = false;
        Object object = lock;
        synchronized (object) {
            if (GlobalObjectsInstance == null) {
                log.warn(" SERVERGlobalObjectsInstance is null");
                String sPropFile = "bmwetk.properties";
                if (servletContext != null) {
                    log.warn(" SERVERGlobalObjects servlet context not null");
                    if (hostName != null) {
                        bGF = true;
                        sPropFile = lib != null ? lib + File.separator + profile.toLowerCase() + File.separator + "bmwetk.properties" : servletContext.getInitParameter("bmwetk.properties");
                        log.warn(" SERVERGlobalObjects following bmwetk property file will be used :" + sPropFile);
                    } else {
                        sPropFile = servletContext.getInitParameter("PropertyFileName");
                        log.warn(" SERVERGlobalObjects Propertyfile is: " + sPropFile);
                        if (sPropFile == null) {
                            sPropFile = "bmwetk.properties";
                            log.warn(" SERVERGlobalObjects The filename for the property file for WebETK is missing! Using default: " + sPropFile);
                        }
                    }
                }
                try {
                    GlobalObjectsInstance = new ServerGlobalObjects(sPropFile, servletContext, bGF);
                }
                catch (Exception e) {
                    log.fatal("Initialization of GlobalObjects failed! Reason: " + e.getMessage(), e);
                    return null;
                }
                log.info(" SERVERGlobalObjects Instance of GlobalObjects created.");
            }
        }
        return GlobalObjectsInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerGlobalObjects getInstance() {
        Object object = lock;
        synchronized (object) {
            if (GlobalObjectsInstance == null) {
                String sPropDatei = "bmwetk.properties";
                log.info("Propertyfile is: " + sPropDatei);
                try {
                    GlobalObjectsInstance = new ServerGlobalObjects(sPropDatei, null, false);
                }
                catch (Exception e) {
                    log.fatal("Initialization of GlobalObjects failed! Reason: " + e.getMessage(), e);
                    return null;
                }
                log.info("Instance of GlobalObjects created.");
            }
        }
        return GlobalObjectsInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerGlobalObjects getInstance(String propFile) {
        pathPropertyFile = propFile;
        Object object = lock;
        synchronized (object) {
            if (GlobalObjectsInstance == null) {
                log.info("Propertyfile is: " + pathPropertyFile);
                try {
                    GlobalObjectsInstance = new ServerGlobalObjects(pathPropertyFile, null, false);
                }
                catch (Exception e) {
                    log.fatal("Initialization of GlobalObjects failed! Reason: " + e.getMessage(), e);
                    return null;
                }
                log.info("Instance of GlobalObjects created.");
            }
        }
        return GlobalObjectsInstance;
    }

    private void loadProperties(String sPropFile, ServletContext p_objContext, boolean pbGF) throws FileNotFoundException, IOException {
        File fPropFile;
        String strPropFile = sPropFile;
        InputStream iStreamIn = null;
        this.props = new Properties();
        if (!pbGF && p_objContext != null) {
            strPropFile = p_objContext.getRealPath(strPropFile);
            log.warn("Real path of Propertyfile from context(web.xml)is: " + sPropFile);
        }
        if ((fPropFile = new File(strPropFile)).exists()) {
            log.warn("Real path of Propertyfile is: " + sPropFile);
            try {
                iStreamIn = new FileInputStream(strPropFile);
            }
            catch (FileNotFoundException e) {
                log.fatal("Cannot find general property file " + strPropFile, e);
                throw new FileNotFoundException("The given property file <" + strPropFile + "> could not be found!");
            }
        } else {
            strPropFile = "/" + strPropFile;
            iStreamIn = this.getClass().getResourceAsStream(strPropFile);
        }
        if (iStreamIn == null) {
            log.fatal("Input stream of the general Propertyfile is mysteriously null!");
        } else {
            try {
                this.props.load(iStreamIn);
            }
            catch (IOException e) {
                log.fatal("Cannot read general property file " + strPropFile, e);
                throw new IOException("Read access denied on given property file <" + strPropFile + ">!");
            }
        }
        if (iStreamIn != null) {
            iStreamIn.close();
        }
    }

    private void readGeneralProps(ServletContext p_objContext) {
        if (p_objContext != null) {
            this.m_strHomePath = p_objContext.getRealPath("/");
        }
        this.m_strImageCache = this.props.getProperty("cache.directory", ".");
        if (this.m_strImageCache.startsWith(".")) {
            this.m_strImageCache = this.m_strImageCache.substring(1);
            if (p_objContext != null) {
                this.m_strImageCache = p_objContext.getRealPath(this.m_strImageCache);
            } else {
                String catalinaHome = System.getProperty("catalina.home");
                this.m_strImageCache = catalinaHome + File.separator + "webapps" + File.separator + "javaserver" + this.m_strImageCache;
            }
        }
        log.info("Image cache directory is: " + this.m_strImageCache);
    }

    private void initConnectionPoolGF() {
        try {
            InitialContext ic = new InitialContext();
            dataSourcePubl = (DataSource)ic.lookup(this.props.getProperty("database.connectionpool.name", "jdbc/webetk"));
        }
        catch (NamingException e) {
            e.printStackTrace();
            dataSourcePubl = null;
            throw new ExceptionInInitializerError(e);
        }
    }

    private void initConnectionPoolJS() throws InvalidInitializationException {
        String strDriver = this.props.getProperty("database.driver", "transbase.jdbc.Driver");
        log.log(Level.ALL, "Trying to use JDBC driver: " + strDriver);
        try {
            Class.forName(strDriver);
        }
        catch (ClassNotFoundException e) {
            log.error("JDBC driver not found: " + strDriver, e);
            throw new InvalidInitializationException("The class for the given JDBC driver could not be found!");
        }
        log.debug("Reading databse access parameters ...");
        String strUser = this.props.getProperty("database.user");
        String strPass = Constants.TRANSBASE_PASSWORD;
        String strConn = this.props.getProperty("database.connectionString");
        if (strPass == null) {
            strPass = Constants.TRANSBASE_PASSWORD;
        }
        int nMaxConn = Integer.parseInt(this.props.getProperty("database.maxConnections", "1"));
        int nIniConn = Integer.parseInt(this.props.getProperty("database.initConnections", "1"));
        int nTimeout = Integer.parseInt(this.props.getProperty("database.timeout", "5"));
        log.warn("database.maxConnections: " + nMaxConn);
        log.warn("database.initConnections: " + nIniConn);
        log.warn("database.timeout: " + nTimeout);
        log.debug("Creating Connection Pool ...");
        this.m_objConnPool = new ConnectionPool(strUser, strPass, strConn, nMaxConn, nIniConn, nTimeout);
        String etkNutzerConnectionString = StringUtils.substituteStringStraight(strConn, "etk_publ", "etk_nutzer");
        String etkPreiseConnectionString = StringUtils.substituteStringStraight(strConn, "etk_publ", "etk_preise");
        this.m_objConnPool_ETKNutzer = new ConnectionPool(strUser, strPass, etkNutzerConnectionString, nMaxConn, nIniConn, nTimeout);
        this.m_objConnPool_ETKPreise = new ConnectionPool(strUser, strPass, etkPreiseConnectionString, nMaxConn, nIniConn, nTimeout);
        log.info("Connection Pool created!");
    }

    public void log(Logger log, Level level, String sMessage, Throwable eError) {
        if (eError != null) {
            log.log(level, sMessage, eError);
        } else {
            log.log(level, sMessage);
        }
    }

    public int getSessionTimeout() {
        return Integer.parseInt(this.props.getProperty("session.timeout", "600"));
    }

    public String getHomePath() {
        return this.m_strHomePath;
    }

    public String getRequestEncoding() {
        return this.props.getProperty("request.encoding", "ISO-8859-1");
    }

    public String getResourcePropertyFileName() {
        return this.props.getProperty("resource.property.file", null);
    }

    public String getResourcePropertyFileExtension() {
        return this.props.getProperty("resource.property.extension", null);
    }

    public String getCacheDir() {
        return this.m_strImageCache;
    }

    public String getMailHost() {
        return this.props.getProperty("mail.host", "");
    }

    public String getMailFrom() {
        return this.props.getProperty("mail.from", "");
    }

    public String getMailAttachmentNamePartslist() {
        return this.props.getProperty("mail.AttachmentName.Partslist", "");
    }

    public String getMailAttachmentNameDiagram() {
        return this.props.getProperty("mail.AttachmentName.Diagram", "");
    }

    public String getApplicationInfo() {
        String sName = this.props.getProperty("application.name");
        String sVersion = this.props.getProperty("application.version");
        return sName + " " + sVersion;
    }

    public void logCollection(Logger logger, Level logLevel, String p_strMessage, Collection<String> cCol) {
        StringBuffer sbResult = new StringBuffer();
        Iterator<String> iter = cCol.iterator();
        while (iter.hasNext()) {
            sbResult.append("<");
            sbResult.append(iter.next());
            sbResult.append(">");
        }
        logger.log(logLevel, p_strMessage + ": " + sbResult.toString());
    }

    private void logProperties(Logger log, Level level, Properties props) {
        log.log(level, "Property Listing:");
        Enumeration<Object> eProps = props.keys();
        while (eProps.hasMoreElements()) {
            String sPropName = (String)eProps.nextElement();
            log.log(level, sPropName + " = " + props.getProperty(sPropName));
        }
    }

    public Connection getDBConnection(String sPos) throws SQLException, DatabaseBusyException {
        if (sPos != null) {
            log.debug("Getting connection from: " + sPos);
        }
        if (classpathProperty != null) {
            return dataSourcePubl.getConnection();
        }
        return this.m_objConnPool.getConnection();
    }

    public Connection getDBConnectionNutzer(String sPos) throws SQLException, DatabaseBusyException {
        if (sPos != null) {
            log.debug("Getting connection from: " + sPos);
        }
        if (classpathProperty != null) {
            return dataSourcePubl.getConnection();
        }
        return this.m_objConnPool_ETKNutzer.getConnection();
    }

    public Connection getDBConnectionPreise(String sPos) throws SQLException, DatabaseBusyException {
        if (sPos != null) {
            log.debug("Getting connection from: " + sPos);
        }
        return this.m_objConnPool_ETKPreise.getConnection();
    }

    public void freeDBConnection(Connection p_objConn, String sPos) throws SQLException {
        if (sPos != null) {
            log.debug("Freeing connection from: " + sPos);
        }
        if (classpathProperty != null) {
            p_objConn.close();
        } else {
            this.m_objConnPool.freeConnection(p_objConn);
        }
    }

    public void freeDBConnectionNutzer(Connection p_objConn, String sPos) throws SQLException {
        if (sPos != null) {
            log.debug("Freeing connection from: " + sPos);
        }
        if (classpathProperty != null) {
            p_objConn.close();
        } else {
            this.m_objConnPool_ETKNutzer.freeConnection(p_objConn);
        }
    }

    public void freeDBConnectionPreise(Connection p_objConn, String sPos) throws SQLException {
        if (sPos != null) {
            log.debug("Freeing connection from: " + sPos);
        }
        if (classpathProperty != null) {
            p_objConn.close();
        } else {
            this.m_objConnPool_ETKPreise.freeConnection(p_objConn);
        }
    }

    public void reinitialize(ServletContext servletContext) {
        boolean bGF = false;
        String sPropFile = "bmwetk.properties";
        if (servletContext != null) {
            if (classpathProperty != null && System.getProperty("com.bmw.mastersolutions.gf.hostName") != null) {
                bGF = true;
                sPropFile = lib != null ? lib + File.separator + profile.toLowerCase() + File.separator + "bmwetk.properties" : servletContext.getInitParameter("bmwetk.properties");
            } else {
                sPropFile = servletContext.getInitParameter("PropertyFileName");
                log.info("Propertyfile is: " + sPropFile);
                if (sPropFile == null) {
                    log.fatal("The filename for the property file for WebETK is missing!");
                    sPropFile = "bmwetk.properties";
                }
            }
        }
        log.warn(" following bmwetk property file will be used :" + sPropFile);
        try {
            this.loadProperties(sPropFile, servletContext, bGF);
        }
        catch (IOException ex) {
            log.fatal("Could not load the properties from file: " + sPropFile, ex);
            return;
        }
        this.logProperties(log, Level.ALL, this.props);
        this.readGeneralProps(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Bedingung> appendSchnittstellenBedingungenInfo(Collection<Bedingung> cBedingungen, String sProddatum, String sProduktart, String sLang) {
        Long lDummyElementId = new Long(-1L);
        Vector<Bedingung> cBedingungenResult = new Vector<Bedingung>();
        String sISO = LanguageUtils.toLanguage(sLang);
        String sRegISO = LanguageUtils.toRegion(sLang, true);
        ResultSet res = null;
        Connection con = null;
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Iterator<Bedingung> iterator = cBedingungen.iterator();
        while (iterator.hasNext()) {
            Bedingung oBedingung = iterator.next();
            String sCodeSS = oBedingung.getCodeSS();
            String sBenennungSS = oBedingung.getNameSS();
            String sBedingungsartSS = oBedingung.getBedingungsartSS();
            if (sCodeSS == null || sCodeSS.trim().equals("")) continue;
            String sLackArt = null;
            String sLackCode = null;
            String sSalaArt = null;
            String sSalaPrimanummer = null;
            String sSalaHZaehler = null;
            try {
                con = globs.getDBConnection("Bedingungsmenge.appendSchnittstellenBedingungenInfo");
                if (sBedingungsartSS.equals("AF")) {
                    boolean bPolstercode = oBedingung.isPolstercodeSS();
                    res = FzgIdDbAccess.getBedingungenZuCode(con, sISO, sRegISO, sProddatum, sCodeSS, bPolstercode, true);
                }
                if (sBedingungsartSS.equals("L")) {
                    sLackArt = oBedingung.getLackArtSS();
                    sLackCode = oBedingung.getLackCodeSS();
                    res = FzgIdDbAccess.getBedingungenZuCode(con, sISO, sRegISO, sProddatum, sLackArt, sLackCode);
                }
                if (sBedingungsartSS.equals("S_SONDER") || sBedingungsartSS.equals("S_SERIE") || sBedingungsartSS.equals("S_INFORMATION")) {
                    sSalaArt = oBedingung.getSalaArtSS();
                    sSalaPrimanummer = oBedingung.getSalaPrimanummerSS();
                    sSalaHZaehler = oBedingung.getSalaHZaehlerSS();
                    res = FzgIdDbAccess.getBedingungenZuCode(con, sISO, sRegISO, sProddatum, sProduktart, sSalaArt, sSalaPrimanummer, sSalaHZaehler);
                }
                boolean bFound = false;
                while (res != null && res.next()) {
                    String sVorhandenInfo;
                    bFound = true;
                    Long lId = new Long(res.getLong("ElementId"));
                    String sBedCode = res.getString("Code");
                    String sBedName = res.getString("Benennung");
                    boolean bExclusiveGruppe = res.getString("Exklusiv").equalsIgnoreCase("J");
                    String sGruppe = bExclusiveGruppe ? res.getString("EGruppenId") : null;
                    long lGruppenPos = res.getLong("EGruppenPosition");
                    String sPrimaNr = null;
                    boolean bIsSicherheitsrelevant = false;
                    boolean bIsSAZ = true;
                    if (oBedingung.getBedingungsOberart() == 'S') {
                        sPrimaNr = res.getString("PrimaNr");
                        String sIsSicher = res.getString("Sicher");
                        bIsSicherheitsrelevant = sIsSicher != null && sIsSicher.equalsIgnoreCase("J");
                        String sIsSAZ = res.getString("SAZ");
                        bIsSAZ = sIsSAZ != null && sIsSAZ.equalsIgnoreCase("J");
                    }
                    Bedingung oNewBedingung = null;
                    if (sBedingungsartSS.equals("AF")) {
                        String sBedingungsart = res.getString("Bedingungsart");
                        oNewBedingung = new Bedingung(lId, sBedCode, sBedName, sBenennungSS, sGruppe, lGruppenPos, sBedingungsart);
                    }
                    if (sBedingungsartSS.equals("L")) {
                        oNewBedingung = new Bedingung(lId, sBedCode, sBedName, sBenennungSS, sGruppe, lGruppenPos, sBedingungsartSS);
                    }
                    if (sBedingungsartSS.equals("S_SONDER") || sBedingungsartSS.equals("S_SERIE") || sBedingungsartSS.equals("S_INFORMATION")) {
                        oNewBedingung = new Bedingung(lId, sBedCode, sBedName, sBenennungSS, sGruppe, lGruppenPos, sPrimaNr, sBedingungsartSS);
                    }
                    boolean bVorhandenInfo = (sVorhandenInfo = res.getString("VorhandenInfo")) != null && sVorhandenInfo.equalsIgnoreCase("J");
                    oNewBedingung.hasBedZusatzInfo(bVorhandenInfo);
                    oNewBedingung.isSicherheitsrelevant(bIsSicherheitsrelevant);
                    oNewBedingung.isSAZ(bIsSAZ);
                    cBedingungenResult.add(oNewBedingung);
                }
                if (!bFound) {
                    String sCode;
                    Bedingung oNewBedingung = null;
                    if (sBedingungsartSS.equals("AF")) {
                        oNewBedingung = new Bedingung(lDummyElementId, sCodeSS, "", sBenennungSS, null, -1L, sBedingungsartSS);
                    }
                    if (sBedingungsartSS.equals("L")) {
                        sCode = sLackArt == null ? sLackCode : sLackArt + sLackCode;
                        oNewBedingung = new Bedingung(lDummyElementId, sCode, "", sBenennungSS, null, -1L, sBedingungsartSS);
                    }
                    if (sBedingungsartSS.equals("S_SONDER") || sBedingungsartSS.equals("S_SERIE") || sBedingungsartSS.equals("S_INFORMATION")) {
                        sCode = sSalaArt == null ? sSalaPrimanummer : sSalaArt + sSalaPrimanummer;
                        sCode = sSalaHZaehler == null ? sCode : sCode + sSalaHZaehler;
                        oNewBedingung = new Bedingung(lDummyElementId, sCode, "", sBenennungSS, null, -1L, sSalaPrimanummer, sBedingungsartSS);
                    }
                    cBedingungenResult.add(oNewBedingung);
                    lDummyElementId = new Long(lDummyElementId - 1L);
                }
                try {
                    WebetkUtils.closeQuery(res);
                    ServerGlobalObjects.getInstance().freeDBConnection(con, "Bedingungsmenge.appendSchnittstellenBedingungenInfo");
                }
                catch (SQLException e) {
                    log.warn("Could not close statement!", e);
                }
            }
            catch (SQLException e) {
                log.error("Database access error! Schnittstellen-Conditions could not be loaded!", e);
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (DatabaseBusyException e2) {
                    log.error("Database is busy! Schnittstellen-Conditions could not be loaded!", e2);
                }
            }
            finally {
                try {
                    WebetkUtils.closeQuery(res);
                    ServerGlobalObjects.getInstance().freeDBConnection(con, "Bedingungsmenge.appendSchnittstellenBedingungenInfo");
                }
                catch (SQLException e) {
                    log.warn("Could not close statement!", e);
                }
            }
        }
        return cBedingungenResult;
    }

    public String getBtTypeForBtArt(String sBtArt) {
        if (sBtArt == null) {
            return null;
        }
        if (sBtArt.equals("G")) {
            return "FZG";
        }
        return "ASS";
    }

    public void closeAllConnections() {
        this.m_objConnPool.closeAllConnections();
        this.m_objConnPool_ETKNutzer.closeAllConnections();
        this.m_objConnPool_ETKPreise.closeAllConnections();
    }

    public static String getProfile() {
        return profile;
    }

    public static String getLib() {
        return lib;
    }

    public static String getLogDir() {
        return logDir;
    }

    public static String getHostName() {
        return hostName;
    }

    public static String getData() {
        return data;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    public String getPathPropertyFile() {
        return pathPropertyFile;
    }

    public void setPathPropertyFile(String pathPropertyFile) {
        ServerGlobalObjects.pathPropertyFile = pathPropertyFile;
    }

    public boolean isSecurityFilterActive() {
        return Boolean.valueOf(this.props.getProperty("securityFilterActive", "true"));
    }

    public List<String> getSecurityCheckIgnorableHostNames() {
        String propertyValue = this.props.getProperty("securityCheckIgnorableHostNames", "");
        return Arrays.asList(propertyValue.split("\\s*,\\s*"));
    }

    public String getAsapPUrl() {
        return this.props.getProperty("asapportalurl", "");
    }

    public boolean isTimerDBLogginRequired() {
        return Boolean.valueOf(this.props.getProperty("webetk.timer.db.logging.required", "true"));
    }

    public Object getBmwnetzPreset() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSammelUserRestriction() {
        List<String> restrictions = null;
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("getSammelUserRestriction");
            restrictions = SettingsDbAccess.loadSammelUserRestrictions(con);
        }
        catch (Exception e) {
            log.error("W_SAMMELUSER_RESTR konnte nicht geladen werden");
            log.error(e);
        }
        finally {
            try {
                ServerGlobalObjects.getInstance().freeDBConnection(con, "getSammelUserRestriction");
            }
            catch (SQLException e) {
                log.warn("Could not close statement!", e);
            }
        }
        return restrictions;
    }

    static {
        pathPropertyFile = null;
        GlobalObjectsInstance = null;
        profile = System.getProperty("com.bmw.mastersolutions.gf.profile");
        data = System.getProperty("com.bmw.mastersolutions.gf.project.data");
        lib = System.getProperty("com.bmw.mastersolutions.gf.project.lib");
        logDir = System.getProperty("com.bmw.mastersolutions.gf.project.logs");
        hostName = System.getProperty("com.bmw.mastersolutions.gf.hostName");
        classpathProperty = System.getProperty("com.sun.aas.installRoot");
    }
}

