/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.asssuche;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.SearchBTETeile;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.asssuche.AssSucheInfo;
import webetk.db.dbaccess.TeileSucheAssDbAccess;
import webetk.framework.ServerSessionInfo;

@XmlRootElement(name="BenennungSucheAss")
@XmlType(name="webetk.app.asssuche.BenennungSuche")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BenennungSuche
extends SearchBTETeile
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(BenennungSuche.class);
    private String msBenennungInit;
    private String msBenennung;

    public BenennungSuche() {
    }

    public BenennungSuche(String sBenennung) {
        this.msBenennungInit = sBenennung;
        if (sBenennung.charAt(sBenennung.length() - 1) != '*') {
            sBenennung = sBenennung + "*";
        }
        this.msBenennung = sBenennung;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int performSearch(SucheInfo oSucheInfo, String sLang, ServerSessionInfo oServerSessionInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        if (!(oSucheInfo instanceof AssSucheInfo)) {
            log.error("oSucheInfo is no instance of AssSucheInfo!");
            return 4;
        }
        AssSucheInfo oAssSucheInfo = (AssSucheInfo)oSucheInfo;
        oSucheInfo.setSuchBenennung(this.msBenennungInit);
        boolean bIGDOM = oSucheInfo.isIGDOM();
        this.mcBTEs.clear();
        this.mcTeile.clear();
        Connection con = null;
        ResultSet res = null;
        try {
            SearchBTETeile.PartOrBTE obj;
            con = gObj.getDBConnection("BenennungSuche.performSearch");
            String sMarke = oAssSucheInfo.getMarke();
            String sProduktart = oAssSucheInfo.getProduktart();
            String sKatUmfang = oAssSucheInfo.getKatalogumfang();
            res = TeileSucheAssDbAccess.searchBildtafel_Benennung(con, this.msBenennung, sLang, sMarke, sProduktart, sKatUmfang);
            while (res != null && res.next()) {
                obj = BenennungSuche.readResultIntoBte(res, sLang, sProduktart, null, bIGDOM);
                this.mcBTEs.add(obj);
            }
            WebetkUtils.closeQuery(res);
            res = TeileSucheAssDbAccess.searchSachnummern_Benennung(con, this.msBenennung, sLang, sMarke, sProduktart, sKatUmfang);
            while (res != null && res.next()) {
                obj = BenennungSuche.readResultIntoPart(res);
                this.mcTeile.add(obj);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "BenennungSuche.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "BenennungSuche.performSearch");
        if (this.mcBTEs.size() == 0 && this.mcTeile.size() == 0) {
            return 4;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() != 0) {
            return 3;
        }
        if (this.mcBTEs.size() != 0 && this.mcTeile.size() == 0) {
            return 1;
        }
        return 2;
    }
}

