/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.bteanzeige;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.log4j.Logger;

@XmlRootElement(name="webetk.app.bteanzeige.Changepoint")
@XmlType(name="webetk.app.bteanzeige.Changepoint")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Changepoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String msTyp = null;
    private String msWerk = null;
    private String msArt = null;
    private Long mlDatum = null;
    private String msVin = null;
    private Long mlVinProddatum = null;
    private String msVinMin = null;
    private String msVinMax = null;
    private String msArtNummer = null;
    private String msNummer = null;
    private Long cpAlter = null;
    @XmlTransient
    private static Logger log = Logger.getLogger(Changepoint.class);

    public Changepoint() {
    }

    public Changepoint(String sTyp, String sWerk, String sArt, Long lDatum, String sVin, Long lVinProddatum, String sVinMin, String sVinMax, String sArtNummer, String sNummer, Long cpAlter) {
        this.msTyp = sTyp;
        this.msWerk = sWerk;
        this.msArt = sArt;
        this.mlDatum = lDatum;
        this.msVin = sVin;
        this.mlVinProddatum = lVinProddatum;
        this.msVinMin = sVinMin;
        this.msVinMax = sVinMax;
        this.msArtNummer = sArtNummer;
        this.msNummer = sNummer;
        this.cpAlter = cpAlter;
    }

    public Changepoint(Changepoint ChangepointSrc) {
        this.msTyp = ChangepointSrc.msTyp;
        this.msWerk = ChangepointSrc.msWerk;
        this.msArt = ChangepointSrc.msArt;
        this.mlDatum = ChangepointSrc.mlDatum;
        this.msVin = ChangepointSrc.msVin;
        this.mlVinProddatum = ChangepointSrc.mlVinProddatum;
        this.msVinMin = ChangepointSrc.msVinMin;
        this.msVinMax = ChangepointSrc.msVinMax;
        this.msArtNummer = ChangepointSrc.msArtNummer;
        this.msNummer = ChangepointSrc.msNummer;
        this.cpAlter = ChangepointSrc.cpAlter;
    }

    public String getArt() {
        return this.msArt;
    }

    public void setArt(String sArt) {
        this.msArt = sArt;
    }

    public String getTyp() {
        return this.msTyp;
    }

    public void setTyp(String sTyp) {
        this.msTyp = sTyp;
    }

    public String getWerk() {
        return this.msWerk;
    }

    public void setWerk(String sWerk) {
        this.msWerk = sWerk;
    }

    public Number getDatum() {
        return this.mlDatum;
    }

    public void setDatum(Long lDatum) {
        this.mlDatum = lDatum;
    }

    public String getVin() {
        return this.msVin;
    }

    public void setVin(String sVin) {
        this.msVin = sVin;
    }

    public Number getVinProddatum() {
        return this.mlVinProddatum;
    }

    public void setVinProddatum(Long lVinProddatum) {
        this.mlVinProddatum = lVinProddatum;
    }

    public String getVinMin() {
        return this.msVinMin;
    }

    public void setVinMin(String sVinMin) {
        this.msVinMin = sVinMin;
    }

    public String getVinMax() {
        return this.msVinMax;
    }

    public void setVinMax(String sVinMax) {
        this.msVinMax = sVinMax;
    }

    public String getArtNummer() {
        return this.msArtNummer;
    }

    public void setCpAlter(Long cpAlter) {
        this.cpAlter = cpAlter;
    }

    public Long getCpAlter() {
        return this.cpAlter;
    }

    public void setArtNummer(String sArtNummer) {
        this.msArtNummer = sArtNummer;
    }

    public String getNummer() {
        return this.msNummer;
    }

    public void setNummer(String sNummer) {
        this.msNummer = sNummer;
    }

    public boolean auswertenChangepointDatum(Long lTypProddatum) {
        log.info("auswertenChangepointDatum");
        if (lTypProddatum == null) {
            return true;
        }
        if (this.mlDatum == null) {
            return true;
        }
        String sTypProddatum = lTypProddatum.toString();
        if (sTypProddatum.length() != 8) {
            log.error("\u00fcbergebenes Produktionsdatum " + sTypProddatum + " ist inkorrekt!");
            return true;
        }
        boolean bTagesgenau = true;
        if (sTypProddatum.substring(6).equals("00")) {
            bTagesgenau = false;
        }
        String sCPDatum = this.mlDatum.toString();
        String sTypDatum = sTypProddatum;
        if (!bTagesgenau) {
            sCPDatum = sCPDatum.substring(0, 6);
            sTypDatum = sTypDatum.substring(0, 6);
        }
        long lCPDatum = Long.parseLong(sCPDatum);
        long lTypDatum = Long.parseLong(sTypDatum);
        if (this.msArt.equals("FROM")) {
            return lTypDatum >= lCPDatum;
        }
        return lTypDatum <= lCPDatum;
    }

    public boolean auswertenChangepointVin(Long lTypProddatum, String sVin) {
        log.info("auswertenChangepointVin");
        if (lTypProddatum == null) {
            return true;
        }
        if (this.msVin == null) {
            return true;
        }
        String sTypProddatum = lTypProddatum.toString();
        if (sTypProddatum.length() != 8) {
            log.error("\u00fcbergebenes Produktionsdatum " + sTypProddatum + " ist inkorrekt!");
            return true;
        }
        String sCPDatum = this.mlVinProddatum.toString();
        String sTypDatum = sTypProddatum.substring(0, 6);
        long lCPDatum = Long.parseLong(sCPDatum);
        long lTypDatum = Long.parseLong(sTypDatum);
        if (this.msArt.equals("FROM")) {
            if (lTypDatum > lCPDatum) {
                return true;
            }
            if (lTypDatum < lCPDatum) {
                return false;
            }
            int nCompareIntervall = sVin.compareToIgnoreCase(this.msVinMin);
            int nCompareCP = sVin.compareToIgnoreCase(this.msVin);
            return nCompareIntervall >= 0 && nCompareCP >= 0;
        }
        if (lTypDatum < lCPDatum) {
            return true;
        }
        if (lTypDatum > lCPDatum) {
            return false;
        }
        int nCompareIntervall = sVin.compareToIgnoreCase(this.msVinMin);
        int nCompareCP = sVin.compareToIgnoreCase(this.msVin);
        return nCompareIntervall >= 0 && nCompareCP <= 0;
    }

    public boolean auswertenChangePointKB(Long lTypProddatum) {
        String DATE_FORMAT = "yyyyMMdd";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Calendar c1 = Calendar.getInstance();
        int abz = 0;
        if (this.cpAlter == null) {
            return true;
        }
        abz = 0 - this.cpAlter.intValue();
        c1.add(2, abz);
        String sJetztDatum = sdf.format(c1.getTime());
        log.info("Changepoint: " + this.toString());
        log.info("msArt: " + this.msArt);
        log.info("Datum minus " + this.cpAlter + ": " + sJetztDatum);
        log.info("lTypProddatum: " + lTypProddatum);
        long lJetztDatum = Long.parseLong(sJetztDatum);
        if (this.msArt.equals("FROM")) {
            if (lTypProddatum >= lJetztDatum) {
                log.info("Produktionsdatum ist kleiner als Changepoint Datum (FROM)");
                return false;
            }
            return true;
        }
        if (lTypProddatum <= lJetztDatum) {
            log.info("Produktionsdatum ist gr\u00f6sser als Changepoint Datum (TO)");
            return false;
        }
        return true;
    }

    public String toString() {
        return "cpAlter: " + this.cpAlter + " mlDatum: " + this.mlDatum + " mlVinProddatum: " + this.mlVinProddatum + " msArt: " + this.msArt + " msArtNummer: " + this.msArtNummer + " msNummer: " + this.msNummer + " msTyp: " + this.msTyp + " msVin: " + this.msVin + " msVinMax: " + this.msVinMax + " msVinMin: " + this.msVinMin + " msWerk: " + this.msWerk;
    }
}

