/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.bteanzeige;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.BTEBedingungsmenge;
import webetk.app.Bedingung;
import webetk.app.Bedingungsmenge;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.bteanzeige.AbstractZeile;
import webetk.app.bteanzeige.BTVerweisZeile;
import webetk.app.bteanzeige.Changepoint;
import webetk.app.bteanzeige.DruckansichtObject;
import webetk.app.bteanzeige.Element;
import webetk.app.bteanzeige.Hotspot;
import webetk.app.bteanzeige.InteractiveTextTeil;
import webetk.app.bteanzeige.KommZeile;
import webetk.app.bteanzeige.Obergruppe;
import webetk.app.bteanzeige.RawKommZeile;
import webetk.app.bteanzeige.RawZeile;
import webetk.app.bteanzeige.Textteil;
import webetk.app.bteanzeige.TextteilObject;
import webetk.app.bteanzeige.Zeile;
import webetk.app.cache.CBTEBedingungsmenge;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.BedAuswertungDbAccess;
import webetk.db.dbaccess.BteAnzeigeDbAccess;
import webetk.framework.ServerBTEManager;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CurrentBTE
extends InteractiveTextTeil
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(CurrentBTE.class);
    protected long mlModellspalte = 0L;
    protected String msSprache = null;
    protected String msVerweisTrenner = null;
    protected long mlBildID;
    protected boolean mbBildZoomed;
    protected String msImageTimestamp;
    protected Collection<Hotspot> mcHotspotsNormal = new ArrayList<Hotspot>();
    protected Collection<Hotspot> mcHotspotsZoomed = new ArrayList<Hotspot>();
    protected boolean mbExpandBNB;
    protected boolean mbNachruestRelevant;
    protected Boolean mbUSATyp;
    protected Boolean mbVinIdentif;
    private boolean mbIGDOMaktiv = false;
    protected String msBTEBedKuerzel = null;
    protected boolean mbFiltern = true;
    protected String msBedFilterModus = "btanzeige_gefiltert";
    protected String msTextJa = null;
    protected String msTextNein = null;
    protected String msHighlightPosNr;
    protected boolean mbZeilenContainSatzteil = false;
    protected boolean mbZeilenContainSteckerteil = false;
    protected BTEBedingungsmenge mBedingungen;
    protected Vector<webetk.app.bteanzeige.Bedingung> mcBedingungen = null;
    protected Hashtable<String, Boolean> mhBedingungen;
    protected Hashtable<String, Vector<String>> mhUeberBedingungen;
    protected Vector<Changepoint> mcChangepoints = new Vector();
    protected boolean mbZubehoerBte = false;
    protected String msLkz = null;
    private boolean aspgNeedVIN = false;
    private boolean mbBoolExpUsed = false;
    private static final int FZG_VERGL_TYP_LENKUNG = 10;
    private static final int FZG_VERGL_TYP_GETRIEBE = 20;
    private static final int FZG_VERGL_TYP_EINSATZ = 30;
    private static final int FZG_VERGL_TYP_AUSLAUF = 40;
    private static HashMap<String, String> mhSachnummern = null;

    public void setBTEBedingungsmenge(BTEBedingungsmenge oBedingungen) {
        this.mBedingungen = oBedingungen;
    }

    public CurrentBTE() {
    }

    public CurrentBTE(boolean bIGDOM) {
        this.mbIGDOMaktiv = bIGDOM;
    }

    public CurrentBTE(String sVerweisTrenner, String sBTENr, String sMarke, String sProduktart, String sKatalogumfang, long lModellspalte, String sSprache, boolean bExpandedBNB, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif, Bedingungsmenge oBeds, boolean bLoad, boolean bIGDOM) throws InvalidInitializationException, SQLException, DatabaseBusyException {
        this.mlModellspalte = lModellspalte;
        this.msHG = null;
        this.msFG = null;
        this.msBTENummer = sBTENr;
        this.msSprache = sSprache;
        this.msVerweisTrenner = sVerweisTrenner;
        this.mbExpandBNB = bExpandedBNB;
        this.mbNachruestRelevant = bNachruestRelevant;
        this.mbUSATyp = bUSATyp;
        this.mbVinIdentif = bVinIdentif;
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.msBTEType = "FZG";
        this.mbIGDOMaktiv = bIGDOM;
        if (bLoad) {
            try {
                if (!this.load(oBeds)) {
                    log.error("No BTE found for number: " + sBTENr);
                    throw new InvalidInitializationException("Error loading MOSP!");
                }
            }
            catch (SQLException e) {
                log.error("SQL Error while retrieving BTE: " + sBTENr, e);
                throw e;
            }
            catch (DatabaseBusyException e) {
                log.error("Database is busy when retrieving BTE: " + sBTENr, e);
                throw e;
            }
        }
    }

    public CurrentBTE(String sVerweisTrenner, String sBTENr, String sMarke, String sProduktart, String sKatalogumfang, String sLang, boolean bExpandedBNB, boolean bNachruestRelevant, Boolean bUSATyp, Boolean bVinIdentif, boolean bLoad, boolean bIGDOM) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        this.msHG = null;
        this.msFG = null;
        this.msBTENummer = sBTENr;
        this.msSprache = sLang;
        this.msVerweisTrenner = sVerweisTrenner;
        this.mbExpandBNB = bExpandedBNB;
        this.mbNachruestRelevant = bNachruestRelevant;
        this.mbUSATyp = bUSATyp;
        this.mbVinIdentif = bVinIdentif;
        this.msMarke = sMarke;
        this.msProduktart = sProduktart;
        this.msKatalogumfang = sKatalogumfang;
        this.msBTEType = "ASS";
        this.mbIGDOMaktiv = bIGDOM;
        if (bLoad) {
            try {
                if (!this.load(null)) {
                    log.error("No BTE found for number: " + sBTENr);
                    throw new InvalidInitializationException("Error loading MOSP!");
                }
            }
            catch (SQLException e) {
                log.error("SQL Error while retrieving BTE: " + sBTENr, e);
                throw e;
            }
            catch (DatabaseBusyException e) {
                log.error("Database is busy when retrieving BTE: " + sBTENr, e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(Bedingungsmenge oBeds) throws SQLException, DatabaseBusyException {
        String zubBtenr;
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block18: {
            block17: {
                block16: {
                    block15: {
                        boolean bl;
                        globs = ServerGlobalObjects.getInstance();
                        con = null;
                        res = null;
                        try {
                            con = globs.getDBConnection("CurrentBTE.load");
                            log.debug("Loading BTE <" + this.msBTENummer + "> ...");
                            res = BedAuswertungDbAccess.loadBTE(con, this.msBTENummer, this.msSprache);
                            if (res != null && res.next()) break block15;
                            bl = false;
                        }
                        catch (Throwable throwable) {
                            WebetkUtils.closeQuery(res);
                            globs.freeDBConnection(con, "CurrentBTE.load");
                            CBTEBedingungsmenge oCache = CBTEBedingungsmenge.getObject();
                            if (this.mBedingungen != null) {
                                oCache.add(this.mBedingungen);
                            }
                            throw throwable;
                        }
                        WebetkUtils.closeQuery(res);
                        globs.freeDBConnection(con, "CurrentBTE.load");
                        CBTEBedingungsmenge oCache = CBTEBedingungsmenge.getObject();
                        if (this.mBedingungen != null) {
                            oCache.add(this.mBedingungen);
                        }
                        return bl;
                    }
                    this.msHG = res.getString("HG");
                    this.msFG = res.getString("FG");
                    this.msBTENummer = res.getString("BildtafelNr");
                    if (!res.wasNull()) break block16;
                    log.error("Loading error: BTE number is not retrieved for: " + this.msBTENummer);
                    boolean bl = false;
                    WebetkUtils.closeQuery(res);
                    globs.freeDBConnection(con, "CurrentBTE.load");
                    CBTEBedingungsmenge oCache = CBTEBedingungsmenge.getObject();
                    if (this.mBedingungen != null) {
                        oCache.add(this.mBedingungen);
                    }
                    return bl;
                }
                this.msBTEUeberschrift = res.getString("Benennung");
                if (!res.wasNull()) break block17;
                log.error("Loading error: BTE \u00dcberschrift is not retrieved for: " + this.msBTENummer);
                boolean bl = false;
                WebetkUtils.closeQuery(res);
                globs.freeDBConnection(con, "CurrentBTE.load");
                CBTEBedingungsmenge oCache = CBTEBedingungsmenge.getObject();
                if (this.mBedingungen != null) {
                    oCache.add(this.mBedingungen);
                }
                return bl;
            }
            this.msBTEBedKuerzel = res.getString("BedKuerzel");
            this.msLkz = res.getString("Lkz");
            this.mlBildID = res.getLong("GrafikId");
            if (!res.wasNull()) break block18;
            log.error("Loading error: ID of BTE picture is not retrieved for: " + this.msBTENummer);
            boolean bl = false;
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "CurrentBTE.load");
            CBTEBedingungsmenge oCache = CBTEBedingungsmenge.getObject();
            if (this.mBedingungen != null) {
                oCache.add(this.mBedingungen);
            }
            return bl;
        }
        this.msImageTimestamp = res.getString("ModStamp");
        if (res.wasNull()) {
            log.warn("Loading warning: The timestamp of the BTE picture is null! Images will not be cached for: " + this.msBTENummer);
        }
        boolean bl = this.mbZubehoerBte = (zubBtenr = res.getString("ZubBtnr")) != null;
        if (this.msBTEType.equals("FZG")) {
            this.mBedingungen = new BTEBedingungsmenge(this.msBTENummer, this.mlModellspalte, oBeds);
            this.mBedingungen.load(this.msSprache, this.mbNachruestRelevant, this.mbIGDOMaktiv, this.mbUSATyp, this.mbVinIdentif);
            String sVorhandenCP = res.getString("VorhandenCP");
            if (sVorhandenCP.equals("J")) {
                this.loadChangepoints();
            }
        }
        this.mbBildZoomed = false;
        this.loadHotspots();
        boolean bl2 = true;
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "CurrentBTE.load");
        CBTEBedingungsmenge oCache = CBTEBedingungsmenge.getObject();
        if (this.mBedingungen != null) {
            oCache.add(this.mBedingungen);
        }
        return bl2;
    }

    public BTEBedingungsmenge getBedingungen() {
        return this.mBedingungen;
    }

    public void clear() {
        this.mBedingungen = null;
        this.mcBedingungen = null;
        this.mcExpandedZeilen = null;
        this.mcHotspotsNormal = null;
        this.mcHotspotsZoomed = null;
        this.mcRawZeilen = null;
        this.mcRawZeilenTemp = null;
        this.mcZeilen = null;
        this.mcBTVerweisZeilen = null;
        this.mhBedingungen = null;
        this.mhUeberBedingungen = null;
        this.mhKommentare = null;
        this.mlBildID = 0L;
        this.mlModellspalte = 0L;
        this.msHighlightPosNr = null;
        this.msScrollTarget = null;
        this.msHG = null;
        this.msFG = null;
        this.msBTENummer = null;
        this.msBTEType = null;
        this.msBTEUeberschrift = null;
        this.msImageTimestamp = null;
        this.msSprache = null;
        this.msVerweisTrenner = null;
        this.msTextJa = null;
        this.msTextNein = null;
        this.msMarke = null;
        this.msProduktart = null;
    }

    @Override
    protected void loadTextteilFromDBFzg(FzgSucheInfo oFzgSucheInfo, String sLandkuerzel) throws SQLException, DatabaseBusyException, InvalidDataException {
        this.ladenBedingungenFzg();
        this.ladenKommentareFzg();
        this.ladenBTVerweiseFzgDB();
        if (this.ladenZeilenFzgDB(oFzgSucheInfo, sLandkuerzel)) {
            String sFgstnr = oFzgSucheInfo.getFahrgestellnummer();
            boolean bIdentifiedByFgstnr = sFgstnr != null && !sFgstnr.equals("");
            this.auswertenEinschraenkungFzg(oFzgSucheInfo.getLenkung(), oFzgSucheInfo.getGetriebe(), oFzgSucheInfo.getBaujahr(), oFzgSucheInfo.getZulassungsmonat(), bIdentifiedByFgstnr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenKommentareUgb() throws SQLException, DatabaseBusyException {
        if (this.mcRawZeilen != null) {
            return;
        }
        if (this.mhKommentare == null) {
            this.mhKommentare = new Hashtable();
        } else {
            this.mhKommentare.clear();
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.ladenKommentareUgb");
            res = BteAnzeigeDbAccess.loadKommentareUgb(con, this.msBTENummer, this.getMarke(), this.msSprache);
            long lKommIdMerk = -1L;
            Vector<RawKommZeile> cKommentar = null;
            boolean bInHashTable = false;
            while (res != null && res.next()) {
                String sText;
                long lKommId = res.getLong("KommId");
                if (lKommIdMerk != lKommId) {
                    if (cKommentar != null && lKommIdMerk != -1L) {
                        this.mhKommentare.put(new Long(lKommIdMerk), cKommentar);
                        bInHashTable = true;
                    }
                    cKommentar = new Vector<RawKommZeile>();
                    bInHashTable = false;
                    lKommIdMerk = lKommId;
                }
                if ((sText = res.getString("Text")).equals("*****")) continue;
                RawKommZeile Zeile2 = new RawKommZeile();
                Zeile2.setText(sText);
                cKommentar.add(Zeile2);
            }
            if (!bInHashTable && cKommentar != null) {
                this.mhKommentare.put(new Long(lKommIdMerk), cKommentar);
            }
            log.debug("Kommentare: \n" + this.mhKommentare.toString());
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenKommentareUgb");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenKommentareUgb");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenZeilenUgbDB(String sPArt, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        if (this.mcRawZeilen != null) {
            return;
        }
        if (this.mcExpandedZeilen == null) {
            this.mcExpandedZeilen = new Vector();
        } else {
            this.mcExpandedZeilen.clear();
        }
        this.mcRawZeilen = new Vector();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.ladenZeilenUgbDB");
            res = BteAnzeigeDbAccess.loadZeilenUgb(con, this.msBTENummer, this.getMarke(), this.getProduktart(), this.getKatalogumfang(), this.msSprache, sLandkuerzel);
            int nBildnummerMerk = 0;
            int nPosMerk = -1;
            RawZeile Zeile2 = null;
            while (res != null && res.next()) {
                int nPos = res.getInt("Pos");
                long lBlockNr = res.getLong("BlockNr");
                long lGruppeId = res.getLong("GruppeId");
                if (nPos != nPosMerk) {
                    nPosMerk = nPos;
                    Zeile2 = new RawZeile(false, nPos, lBlockNr, lGruppeId);
                    String sBildnummer = res.getString("Bildnummer");
                    if (sBildnummer != null) {
                        if (!sBildnummer.equals("--")) {
                            nBildnummerMerk = res.getInt("Bildnummer");
                            if (this.mbExpandBNB && !this.mcExpandedZeilen.contains(sBildnummer)) {
                                this.mcExpandedZeilen.add(sBildnummer);
                            }
                        }
                    } else {
                        nBildnummerMerk = 0;
                    }
                    Zeile2.setBildnummer(sBildnummer, nBildnummerMerk);
                    String sSatzSachnummer = res.getString("Satz_Sachnummer");
                    boolean bIstSatz = sSatzSachnummer != null;
                    String sHG = res.getString("Teil_HG");
                    String sUG = res.getString("Teil_UG");
                    String sSachnummer = res.getString("Teil_Sachnummer");
                    String sBenennung = res.getString("Teil_Benennung");
                    String sBnbBen = res.getString("BnbBenText");
                    String sZusatz = res.getString("Teil_Zusatz");
                    String sEntfall = res.getString("Teil_Entfall");
                    long lKommentarId = res.getLong("Teil_Kommentar_Id");
                    String sKommentar = res.getString("Teil_Kommentar");
                    long lTextcodePI = res.getLong("Teil_Komm_PI");
                    String sSI = res.getString("Teil_SI");
                    String sTC = res.getString("Teil_TC");
                    String sReach = res.getString("Teil_Reach");
                    String sAspg = res.getString("Teil_Aspg");
                    String sStecker = res.getString("Teil_Stecker");
                    String sDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null ? res.getString("Teil_Diebstahlrelevant") : "N";
                    Zeile2.setTeil(sHG, sUG, sSachnummer, sBenennung, sZusatz, sEntfall, lKommentarId, sKommentar, lTextcodePI, sSI, sTC, bIstSatz, sBnbBen, sReach, sAspg, sStecker, sDiebstahlrelevant);
                    Zeile2.setMengenAss(res.getString("MMG"), res.getString("EMG"));
                    Zeile2.setEinsatzAuslauf(res.getString("Einsatz"), res.getString("Auslauf"));
                    Zeile2.setKommentare(res.getLong("KommBT"), res.getLong("KommVor"), res.getLong("KommNach"));
                    Zeile2.appendSIDokArt(res.getString("SI_DokArt"));
                    this.mcRawZeilen.add(Zeile2);
                    continue;
                }
                Zeile2.appendSIDokArt(res.getString("SI_DokArt"));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenZeilenUgbDB");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenZeilenUgbDB");
    }

    @Override
    protected void loadTextteilFromDBUgb(SucheInfo oSucheInfo, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        this.ladenKommentareUgb();
        this.ladenBTVerweiseUgbDB();
        this.ladenZeilenUgbDB(oSucheInfo.getProduktart(), sLandkuerzel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenKommentareFzg() throws SQLException, DatabaseBusyException {
        if (this.mcRawZeilen != null) {
            return;
        }
        if (this.mhKommentare == null) {
            this.mhKommentare = new Hashtable();
        } else {
            this.mhKommentare.clear();
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.ladenKommentareFzg");
            res = BteAnzeigeDbAccess.loadJaNein(con, this.msSprache);
            while (res != null && res.next()) {
                String sText = res.getString("Bezeichnung");
                if (sText.equals("+")) {
                    this.msTextJa = res.getString("Benennung");
                }
                if (!sText.equals("-")) continue;
                this.msTextNein = res.getString("Benennung");
            }
            WebetkUtils.closeQuery(res);
            res = BteAnzeigeDbAccess.loadKommentareFzg(con, this.msBTENummer, this.mlModellspalte, this.msSprache);
            long lKommIdMerk = -1L;
            Vector<RawKommZeile> cKommentar = null;
            boolean bInHashTable = false;
            while (res != null && res.next()) {
                String sText;
                long lKommId = res.getLong("KommId");
                if (lKommIdMerk != lKommId) {
                    if (cKommentar != null && lKommIdMerk != -1L) {
                        this.mhKommentare.put(new Long(lKommIdMerk), cKommentar);
                        bInHashTable = true;
                    }
                    cKommentar = new Vector<RawKommZeile>();
                    bInHashTable = false;
                    lKommIdMerk = lKommId;
                }
                if ((sText = res.getString("Text")).equals("*****")) {
                    String sVorzeichen = res.getString("VZ");
                    if (!sVorzeichen.equals("+") && !sVorzeichen.equals("-")) continue;
                    RawKommZeile ZeileLast = (RawKommZeile)cKommentar.lastElement();
                    String sVorzeichenHelp = ZeileLast.getVorzeichen();
                    if (!sVorzeichenHelp.equals(" ") && !sVorzeichenHelp.equals(sVorzeichen)) {
                        log.debug("Error bei Vorzeichen-Verschiebung");
                        continue;
                    }
                    ZeileLast.setVorzeichen(sVorzeichen);
                    if (sVorzeichen.equals("+")) {
                        ZeileLast.setVorzeichenString(this.msTextJa);
                    }
                    if (!sVorzeichen.equals("-")) continue;
                    ZeileLast.setVorzeichenString(this.msTextNein);
                    continue;
                }
                RawKommZeile Zeile2 = new RawKommZeile();
                Zeile2.setText(res.getString("Text"));
                Zeile2.setCode(res.getString("Code"));
                String sVorzeichen = res.getString("VZ");
                Zeile2.setVorzeichen(sVorzeichen);
                if (sVorzeichen.equals("+")) {
                    Zeile2.setVorzeichenString(this.msTextJa);
                }
                if (sVorzeichen.equals("-")) {
                    Zeile2.setVorzeichenString(this.msTextNein);
                }
                Zeile2.setDarstellung(res.getString("Darstellung"));
                Zeile2.setTiefe(res.getInt("Tiefe"));
                cKommentar.add(Zeile2);
            }
            if (!bInHashTable && cKommentar != null) {
                this.mhKommentare.put(new Long(lKommIdMerk), cKommentar);
            }
            log.debug("Kommentare: \n" + this.mhKommentare.toString());
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenKommentareFzg");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenKommentareFzg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenBedingungenFzg() throws SQLException, DatabaseBusyException {
        if (this.mcRawZeilen != null) {
            return;
        }
        if (this.mcBedingungen == null) {
            this.mcBedingungen = new Vector();
        } else {
            this.mcBedingungen.clear();
        }
        if (this.mhUeberBedingungen == null) {
            this.mhUeberBedingungen = new Hashtable();
        } else {
            this.mhUeberBedingungen.clear();
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.ladenBedingungenFzg");
            res = BteAnzeigeDbAccess.loadBedingungenFzg(con, this.msBTENummer, this.mlModellspalte);
            webetk.app.bteanzeige.Bedingung Bed = null;
            Obergruppe OG = null;
            Element Elem = null;
            String sKuerzelMerk = "";
            String sOgIdMerk = "";
            String sGesamtterm_VZ = null;
            String sGesamtterm = null;
            String sFZeile = null;
            int nPos = 0;
            boolean bET = false;
            while (res != null && res.next()) {
                String sOgId;
                String sKuerzel = res.getString("Kuerzel");
                if (!sKuerzelMerk.equals(sKuerzel)) {
                    sGesamtterm_VZ = res.getString("GesamttermVZ");
                    sGesamtterm = res.getString("Gesamtterm");
                    Bed = new webetk.app.bteanzeige.Bedingung(sKuerzel, sGesamtterm_VZ, sGesamtterm);
                    this.mcBedingungen.add(Bed);
                    sKuerzelMerk = sKuerzel;
                    sOgIdMerk = "";
                }
                if (!sOgIdMerk.equals(sOgId = res.getString("OG"))) {
                    String sVArt = res.getString("VArt");
                    sFZeile = res.getString("FZeile");
                    OG = new Obergruppe(sOgId, sVArt, sFZeile);
                    bET = sVArt.equals("E") || sVArt.equals("B");
                    nPos = 1;
                    if (bET) {
                        Bed.setAusweisung(OG.getAusweisung());
                    }
                    Bed.appendObergruppe(OG);
                    sOgIdMerk = sOgId;
                }
                String sAusweisung = " ";
                String sRegelzeile = null;
                if (bET) {
                    sAusweisung = sFZeile;
                    if (sGesamtterm_VZ.equals("+")) {
                        sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "X", " ");
                        sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "0", "-");
                    } else {
                        sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "X", "-");
                        sAusweisung = StringUtils.substituteStringStraight(sAusweisung, "0", " ");
                    }
                    int nLength = sFZeile.length();
                    sRegelzeile = "";
                    int nGrenzeA = (int)Math.pow(2.0, nPos - 1);
                    for (int i = 1; i <= nGrenzeA; ++i) {
                        int j;
                        int nPow = (int)Math.pow(2.0, nPos);
                        int nGrenzeB = nLength / nPow;
                        for (j = 1; j <= nGrenzeB; ++j) {
                            sRegelzeile = sRegelzeile + "X";
                        }
                        for (j = 1; j <= nGrenzeB; ++j) {
                            sRegelzeile = sRegelzeile + "0";
                        }
                    }
                    ++nPos;
                }
                String sElementVZ = res.getString("ElementVZ");
                long lElementId = res.getLong("ElementId");
                Elem = new Element(sElementVZ, lElementId, sRegelzeile, sAusweisung);
                OG.appendElement(Elem);
            }
            WebetkUtils.closeQuery(res);
            Iterator<webetk.app.bteanzeige.Bedingung> iterator = this.mcBedingungen.iterator();
            while (iterator.hasNext()) {
                log.debug("Zeile: " + iterator.next().toString());
            }
            res = BteAnzeigeDbAccess.loadUeberbedingungenFzg(con, this.msBTENummer, this.mlModellspalte);
            sKuerzelMerk = "";
            Vector<String> cUeberBed = null;
            while (res != null && res.next()) {
                String sKuerzel = res.getString("Kuerzel");
                String sKuerzelUeber = res.getString("KuerzelUeber");
                if (!sKuerzelMerk.equals(sKuerzel)) {
                    cUeberBed = new Vector<String>();
                    cUeberBed.add(sKuerzelUeber);
                    this.mhUeberBedingungen.put(sKuerzel, cUeberBed);
                    sKuerzelMerk = sKuerzel;
                    continue;
                }
                cUeberBed.add(sKuerzelUeber);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenBedingungenFzg");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenBedingungenFzg");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenBTVerweiseFzgDB() throws SQLException, DatabaseBusyException {
        if (this.mcBTVerweisZeilen != null) {
            return;
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            BTVerweisZeile oZeile;
            con = gObj.getDBConnection("CurrentBTE.ladenBTVerweiseFzgDB");
            res = BteAnzeigeDbAccess.loadBTVerweiseFzg(con, this.msBTENummer, this.mlModellspalte, this.msSprache);
            String sBildtafelnummerMerk = "";
            String sBildtafelnummer = "";
            String sUeberschriftMerk = "";
            String sUeberschrift = "";
            String sTextMerk = "";
            String sText = "";
            while (res != null && res.next()) {
                sBildtafelnummer = res.getString("Bildtafelnummer");
                sUeberschrift = res.getString("Ueberschrift");
                sText = res.getString("Text");
                if (!sBildtafelnummerMerk.equals(sBildtafelnummer)) {
                    if (!sBildtafelnummerMerk.equals("")) {
                        oZeile = new BTVerweisZeile(sTextMerk, sBildtafelnummerMerk, sUeberschriftMerk);
                        this.getBTVerweisZeilen().add(oZeile);
                    }
                    sBildtafelnummerMerk = sBildtafelnummer;
                    sUeberschriftMerk = sUeberschrift;
                    sTextMerk = sText;
                    continue;
                }
                if (sText.equals("*****")) continue;
                sTextMerk = sTextMerk + this.msVerweisTrenner + sText;
            }
            if (!sBildtafelnummerMerk.equals("")) {
                oZeile = new BTVerweisZeile(sTextMerk, sBildtafelnummerMerk, sUeberschriftMerk);
                this.getBTVerweisZeilen().add(oZeile);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenBTVerweiseFzgDB");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenBTVerweiseFzgDB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ladenBTVerweiseUgbDB() throws SQLException, DatabaseBusyException {
        if (this.mcBTVerweisZeilen != null) {
            return;
        }
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            BTVerweisZeile oZeile;
            con = gObj.getDBConnection("CurrentBTE.ladenBTVerweiseUgbDB");
            res = BteAnzeigeDbAccess.loadBTVerweiseUgb(con, this.msBTENummer, this.msProduktart, this.getMarke(), this.msSprache);
            String sBildtafelnummerMerk = "";
            String sBildtafelnummer = "";
            String sText = "";
            String sUeberschrift = "";
            while (res != null && res.next()) {
                sBildtafelnummer = res.getString("Bildtafelnummer");
                sUeberschrift = res.getString("Ueberschrift");
                if (sBildtafelnummerMerk.equals(sBildtafelnummer)) {
                    if (!sBildtafelnummerMerk.equals("")) {
                        oZeile = new BTVerweisZeile(sText, sBildtafelnummerMerk, sUeberschrift);
                        this.getBTVerweisZeilen().add(oZeile);
                    }
                    sText = res.getString("Text");
                    sBildtafelnummerMerk = sBildtafelnummer;
                    continue;
                }
                sText = sText + " " + res.getString("Text");
            }
            if (!sBildtafelnummerMerk.equals("")) {
                oZeile = new BTVerweisZeile(sText, sBildtafelnummerMerk, sUeberschrift);
                this.getBTVerweisZeilen().add(oZeile);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenBTVerweiseUgbDB");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenBTVerweiseUgbDB");
    }

    protected Vector<webetk.app.bteanzeige.Bedingung> setzenAusweisungenElemente(Vector<webetk.app.bteanzeige.Bedingung> cBedingungen) {
        if (cBedingungen == null || cBedingungen.isEmpty()) {
            return cBedingungen;
        }
        BTEBedingungsmenge Bedingungen = this.getBedingungen();
        Hashtable<Long, Bedingung> elementCodes = Bedingungen.getMoBedingungen().getMhBedingungen();
        for (webetk.app.bteanzeige.Bedingung Bed : cBedingungen) {
            for (Obergruppe OG : Bed.getObergruppen()) {
                if (OG.getVArt().equals("T")) {
                    this.setMbBoolExpUsed(true);
                }
                for (Element Elem : OG.getElemente()) {
                    String sWertNutzer = Bedingungen.getBedWert(new Long(Elem.getElemId()));
                    Elem.setAusweisung(sWertNutzer);
                    Bedingung elementBed = elementCodes.get(new Long(Elem.getElemId()));
                    if (elementBed == null) continue;
                    String sWertCode = elementBed.getCode();
                    Elem.setCode(sWertCode);
                }
            }
        }
        Iterator<webetk.app.bteanzeige.Bedingung> iterator = cBedingungen.iterator();
        while (iterator.hasNext()) {
            log.debug("Bedingung: " + iterator.next().toString());
        }
        return cBedingungen;
    }

    public boolean checkForSatzteile() {
        this.mbZeilenContainSatzteil = false;
        Iterator<AbstractZeile> rows = this.getZeilen().iterator();
        while (rows.hasNext()) {
            try {
                Zeile row = (Zeile)rows.next();
                this.mbZeilenContainSatzteil = row.getSatzteilIndikator();
                if (!this.mbZeilenContainSatzteil) continue;
                break;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return this.mbZeilenContainSatzteil;
    }

    public boolean checkForSteckerteil() {
        this.mbZeilenContainSteckerteil = false;
        Iterator<AbstractZeile> rows = this.getZeilen().iterator();
        while (rows.hasNext()) {
            try {
                Zeile row = (Zeile)rows.next();
                this.mbZeilenContainSteckerteil = row.isTeilStecker();
                if (!this.mbZeilenContainSteckerteil) continue;
                break;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return this.mbZeilenContainSteckerteil;
    }

    protected Hashtable<String, Boolean> auswertenAusweisungen(Vector<webetk.app.bteanzeige.Bedingung> cBedingungen) {
        if (cBedingungen == null || cBedingungen.isEmpty()) {
            return null;
        }
        Hashtable<String, Boolean> hBedingungen = new Hashtable<String, Boolean>();
        for (webetk.app.bteanzeige.Bedingung Bed : cBedingungen) {
            Hashtable<String, Boolean> hBedingungenRelevant = Bed.auswerten();
            Enumeration<String> eBedingungenRelevant = hBedingungenRelevant.keys();
            while (eBedingungenRelevant.hasMoreElements()) {
                String sKuerzel = eBedingungenRelevant.nextElement();
                Boolean bVollstaendigAusgewertet = hBedingungenRelevant.get(sKuerzel);
                hBedingungen.put(sKuerzel, bVollstaendigAusgewertet);
            }
        }
        Iterator<webetk.app.bteanzeige.Bedingung> iterator = cBedingungen.iterator();
        while (iterator.hasNext()) {
            log.debug("Bedingung: " + iterator.next().toString());
        }
        log.debug("Hash-Tabelle:\n " + hBedingungen.toString());
        return hBedingungen;
    }

    protected Vector<RawZeile> removeZeilenNichtRelevant(Vector<RawZeile> cZeilen, Hashtable<String, Boolean> hBedingungen, Hashtable<String, Vector<String>> hUeberBedingungen) {
        if (this.msBTEBedKuerzel != null && (hBedingungen == null || this.copyBedingungenOhneRegelnummer(hBedingungen).get(this.msBTEBedKuerzel) == null)) {
            cZeilen.clear();
        }
        Vector<Long> cBlocknr = new Vector<Long>();
        this.removeZeilenNichtRelevantByBed(cZeilen, hBedingungen, cBlocknr);
        this.removeZeilenNichtRelevantOhneBed(cZeilen, hBedingungen, cBlocknr);
        this.removeZeilenNichtRelevantByUeberBed(cZeilen, hBedingungen, hUeberBedingungen, cBlocknr);
        this.checkZeilenByBlockNr(cZeilen, cBlocknr);
        return cZeilen;
    }

    protected Hashtable<String, Boolean> copyBedingungenOhneRegelnummer(Hashtable<String, Boolean> hBeds) {
        Hashtable<String, Boolean> hBedsNew = new Hashtable<String, Boolean>();
        Enumeration<String> en = hBeds.keys();
        while (en.hasMoreElements()) {
            String str = en.nextElement();
            String strNew = str.replaceAll("[0-9]*", "").trim();
            hBedsNew.put(strNew, hBeds.get(str));
        }
        return hBedsNew;
    }

    public void removeZeilenNichtRelevantByBed(Vector<RawZeile> cZeilen, Hashtable<String, Boolean> hBedingungen, Collection<Long> cBlocknr) {
        for (int i = 0; i < cZeilen.size(); ++i) {
            RawZeile Zeile2 = cZeilen.get(i);
            String sKuerzel = Zeile2.getBedingungKZ();
            if (sKuerzel == null || hBedingungen != null && hBedingungen.get(sKuerzel) != null) continue;
            if (CurrentBTE.debugSachnummern(Zeile2.getSachnummer())) {
                log.debug("--> removeZeilenNichtRelevantByBed: entf\u00e4llt SNR: " + Zeile2.getSachnummer());
            }
            this.addLong(cBlocknr, Zeile2.getBlockNr());
            cZeilen.remove(i);
            while (i < cZeilen.size() && "--".equals(cZeilen.get(i).getBildnummer())) {
                if (CurrentBTE.debugSachnummern(cZeilen.get(i).getSachnummer())) {
                    log.debug("--> removeZeilenNichtRelevantByBed: entf\u00e4llt dazugeh\u00f6rige SNR: " + cZeilen.get(i).getSachnummer());
                }
                cZeilen.remove(i);
            }
            --i;
        }
    }

    protected void removeZeilenNichtRelevantOhneBed(Collection<RawZeile> cZeilen, Hashtable<String, Boolean> hBedingungen, Collection<Long> cBlocknr) {
        if (hBedingungen == null || hBedingungen.size() == 0) {
            return;
        }
        Vector<Integer> cBildposNrMitVollstaendigerBedingung = new Vector<Integer>();
        for (RawZeile Zeile2 : cZeilen) {
            Boolean Vollstaendig;
            boolean bVollstaendig;
            String sKuerzel = Zeile2.getBedingungKZ();
            if (sKuerzel == null || hBedingungen.get(sKuerzel) == null || !(bVollstaendig = (Vollstaendig = hBedingungen.get(sKuerzel)).booleanValue())) continue;
            this.addInteger(cBildposNrMitVollstaendigerBedingung, Zeile2.getBildnummerInt());
            this.addLong(cBlocknr, Zeile2.getBlockNr());
        }
        Iterator iter = cBildposNrMitVollstaendigerBedingung.iterator();
        while (iter.hasNext()) {
            int nBildPosNr = (Integer)iter.next();
            this.removeAlleZeilenOhneBedingung(cZeilen, nBildPosNr);
        }
    }

    public void removeZeilenNichtRelevantByUeberBed(Vector<RawZeile> cZeilen, Hashtable<String, Boolean> hBedingungen, Hashtable<String, Vector<String>> hUeberBedingungen, Collection<Long> cBlocknr) {
        if (hBedingungen == null || hBedingungen.size() == 0) {
            return;
        }
        if (hUeberBedingungen == null || hUeberBedingungen.size() == 0) {
            return;
        }
        block0: for (int i = 0; i < cZeilen.size(); ++i) {
            Collection cUeberBed;
            RawZeile Zeile2 = cZeilen.get(i);
            String sKuerzel = Zeile2.getBedingungKZ();
            if (sKuerzel == null || hBedingungen.get(sKuerzel) == null || (cUeberBed = (Collection)hUeberBedingungen.get(sKuerzel)) == null || cUeberBed.size() == 0) continue;
            for (String szKuerzelUeber : cUeberBed) {
                long lGruppeId;
                boolean bGefundenZeileMitUeberBed;
                boolean bVollstaendig;
                Boolean Vollstaendig = hBedingungen.get(szKuerzelUeber);
                if (Vollstaendig == null || !(bVollstaendig = Vollstaendig.booleanValue()) || !(bGefundenZeileMitUeberBed = this.findZeileMitBed(cZeilen, lGruppeId = Zeile2.getGruppeId(), szKuerzelUeber, Zeile2.getChangepoints()))) continue;
                if (CurrentBTE.debugSachnummern(Zeile2.getSachnummer())) {
                    log.debug("--> removeZeilenNichtRelevantByUeberBed: entf\u00e4llt SNR: " + Zeile2.getSachnummer());
                }
                this.addLong(cBlocknr, Zeile2.getBlockNr());
                cZeilen.remove(i);
                while (i < cZeilen.size() && "--".equals(cZeilen.get(i).getBildnummer())) {
                    if (CurrentBTE.debugSachnummern(cZeilen.get(i).getSachnummer())) {
                        log.debug("--> removeZeilenNichtRelevantByUeberBed: entf\u00e4llt dazugeh\u00f6rige SNR: " + cZeilen.get(i).getSachnummer());
                    }
                    cZeilen.remove(i);
                }
                --i;
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ladenZeilenFzgDB(FzgSucheInfo oFzgSucheInfo, String sLandkuerzel) throws SQLException, DatabaseBusyException {
        boolean bl;
        if (this.mcRawZeilen != null) {
            return false;
        }
        if (this.mcExpandedZeilen == null) {
            this.mcExpandedZeilen = new Vector();
        } else {
            this.mcExpandedZeilen.clear();
        }
        this.mcRawZeilen = new Vector();
        String sProduktart = oFzgSucheInfo.getProduktart();
        log.debug("Produktionsdatum Tagesgenau: " + oFzgSucheInfo.isProduktionsdatumTagesgenau());
        this.setIGDOMaktiv(oFzgSucheInfo.isProduktionsdatumTagesgenau());
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        Connection con2 = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("CurrentBTE.ladenZeilenFzgDB");
            con2 = gObj.getDBConnection("CurrentBTE.ladenZeilenFzgDB (showTCKez)");
            String sTyp = null;
            String sFgstnr = oFzgSucheInfo.getFahrgestellnummer();
            Collection<String> cTypmenge = oFzgSucheInfo.getTypmenge();
            if (sFgstnr != null && cTypmenge.size() == 1) {
                sTyp = (String)cTypmenge.toArray()[0];
            }
            String sWerk = oFzgSucheInfo.getWerk();
            res = BteAnzeigeDbAccess.loadZeilenFzg(con, this.msBTENummer, this.mlModellspalte, sTyp, this.msSprache, this.getMarke(), sProduktart, sLandkuerzel);
            int nBildnummerMerk = 0;
            int nPosMerk = 0;
            RawZeile Zeile2 = null;
            while (res != null && res.next()) {
                int nPos = res.getInt("Pos");
                long lBlockNr = res.getLong("BlockNr");
                long lGruppeId = res.getLong("GruppeId");
                if (nPosMerk != nPos) {
                    String sTCProddatRelevant;
                    nPosMerk = nPos;
                    Zeile2 = new RawZeile(true, nPos, lBlockNr, lGruppeId);
                    String sBildnummer = res.getString("Bildnummer");
                    if (sBildnummer != null) {
                        if (!sBildnummer.equals("--")) {
                            nBildnummerMerk = res.getInt("Bildnummer");
                            if (this.mbExpandBNB && !this.mcExpandedZeilen.contains(sBildnummer)) {
                                this.mcExpandedZeilen.add(sBildnummer);
                            }
                        }
                    } else {
                        nBildnummerMerk = 0;
                    }
                    Zeile2.setBildnummer(sBildnummer, nBildnummerMerk);
                    String sSatzSachnummer = res.getString("Satz_Sachnummer");
                    boolean bIstSatz = sSatzSachnummer != null;
                    String sHG = res.getString("Teil_HG");
                    String sUG = res.getString("Teil_UG");
                    String sSachnummer = res.getString("Teil_Sachnummer");
                    String sBenennung = res.getString("Teil_Benennung");
                    String sBnbBen = res.getString("BnbBenText");
                    String sZusatz = res.getString("Teil_Zusatz");
                    String sEntfall = res.getString("Teil_Entfall");
                    long lKommentarId = res.getLong("Teil_Kommentar_Id");
                    String sKommentar = res.getString("Teil_Kommentar");
                    long lTextcodePI = res.getLong("Teil_Komm_PI");
                    String sSI = res.getString("Teil_SI");
                    String sTC = res.getString("Teil_TC");
                    String sReach = res.getString("Teil_Reach");
                    String sAspg = res.getString("Teil_Aspg");
                    String sStecker = res.getString("Teil_Stecker");
                    String sDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null ? res.getString("Teil_Diebstahlrelevant") : "N";
                    String sBedkezPG = res.getString("Teil_BedkezPG");
                    String sBedingungArt = res.getString("BedingungArt");
                    int nBedingungAlter = res.getInt("BedingungAlter");
                    boolean BtZAlter = false;
                    if (res.getString("BtZAlter") != null && res.getString("BtZAlter").equals("J")) {
                        BtZAlter = true;
                    }
                    if ((sTCProddatRelevant = res.getString("Teil_TC_ProdDatRelevant")).equals("J")) {
                        long lModellspalte = oFzgSucheInfo.getModellspalte();
                        String sProdDatumMin = oFzgSucheInfo.getProduktionsdatumMin();
                        String sProdDatumMax = oFzgSucheInfo.getProduktionsdatumMax();
                        if (!StringUtils.isEmpty(sProdDatumMin, true) && !StringUtils.isEmpty(sProdDatumMax, true)) {
                            sTC = BteAnzeigeDbAccess.ermittleTCKezBzglProddatum(con2, sSachnummer, lModellspalte, sProdDatumMin, sProdDatumMax, sLandkuerzel);
                        }
                    }
                    Zeile2.setTeil(sHG, sUG, sSachnummer, sBenennung, sZusatz, sEntfall, lKommentarId, sKommentar, lTextcodePI, sSI, sTC, bIstSatz, sBnbBen, sReach, sAspg, sStecker, sDiebstahlrelevant);
                    Zeile2.setMenge(res.getString("Menge"));
                    Zeile2.setAusweisungen(res.getString("Kat_KZ"), res.getString("Lenkung_KZ"), res.getString("Getriebe_KZ"));
                    Zeile2.setEinsatzAuslauf(res.getString("Einsatz"), res.getString("Auslauf"));
                    Zeile2.setBedingungKZ(res.getString("Bedingung_KZ"));
                    Zeile2.setKommentare(res.getLong("KommBT"), res.getLong("KommVor"), res.getLong("KommNach"));
                    Zeile2.setBtZAlter(BtZAlter);
                    Zeile2.appendSIDokArt(res.getString("SI_DokArt"));
                    String sGRPLeitAW = null;
                    String sGRPLeitAW_PA = res.getString("GRP_PA");
                    String sGRPLeitAW_HG = res.getString("GRP_HG");
                    String sGRPLeitAW_UG = res.getString("GRP_UG");
                    String sGRPLeitAW_Nummer = res.getString("GRP_lfdNr");
                    if (sGRPLeitAW_PA != null) {
                        sGRPLeitAW = sGRPLeitAW_PA + " " + sGRPLeitAW_HG + " " + sGRPLeitAW_UG + " " + sGRPLeitAW_Nummer;
                    }
                    Zeile2.appendGRPLeitAW(sGRPLeitAW);
                    Zeile2.setBedkezPG(sBedkezPG);
                    Zeile2.setBedingungArt(sBedingungArt);
                    Zeile2.setBedingungAlter(nBedingungAlter);
                    this.mcRawZeilen.add(Zeile2);
                    continue;
                }
                Zeile2.appendSIDokArt(res.getString("SI_DokArt"));
                String sGRPLeitAW = null;
                String sGRPLeitAW_PA = res.getString("GRP_PA");
                String sGRPLeitAW_HG = res.getString("GRP_HG");
                String sGRPLeitAW_UG = res.getString("GRP_UG");
                String sGRPLeitAW_Nummer = res.getString("GRP_lfdNr");
                if (sGRPLeitAW_PA != null) {
                    sGRPLeitAW = sGRPLeitAW_PA + " " + sGRPLeitAW_HG + " " + sGRPLeitAW_UG + " " + sGRPLeitAW_Nummer;
                }
                Zeile2.appendGRPLeitAW(sGRPLeitAW);
            }
            WebetkUtils.closeQuery(res);
            res = BteAnzeigeDbAccess.loadZeilenCPFzg(con, this.msBTENummer, this.mlModellspalte, sTyp, sWerk);
            log.info("***Laden der Changepoints");
            int i = 0;
            while (res != null && res.next()) {
                int nPos = res.getInt("Pos");
                String sTypDB = res.getString("Typ");
                String sWerkDB = res.getString("Werk");
                String sArt = res.getString("Art");
                long lDatumHelp = res.getLong("Datum");
                Long lDatum = res.wasNull() ? null : new Long(lDatumHelp);
                String sVin = res.getString("Vin");
                long lVinProddatumHelp = res.getLong("VinProddatum");
                Long lVinProddatum = res.wasNull() ? null : new Long(lVinProddatumHelp);
                String sVinMin = res.getString("VinMin");
                String sVinMax = res.getString("VinMax");
                String sArtNummer = res.getString("ArtNummer");
                String sNummer = res.getString("Nummer");
                long cpAlterHelp = res.getInt("CPAlter");
                Long cpAlter = res.wasNull() ? null : new Long(cpAlterHelp);
                Changepoint oChangepoint = new Changepoint(sTypDB, sWerkDB, sArt, lDatum, sVin, lVinProddatum, sVinMin, sVinMax, sArtNummer, sNummer, cpAlter);
                this.addChangepoint(nPos, oChangepoint);
                log.info("Durchlauf: " + ++i + oChangepoint.toString());
            }
            bl = true;
            this.setKoppelTeilFlags();
            this.debugRawZeilen();
        }
        catch (Throwable throwable) {
            this.setKoppelTeilFlags();
            this.debugRawZeilen();
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "CurrentBTE.ladenZeilenFzgDB");
            gObj.freeDBConnection(con2, "CurrentBTE.ladenZeilenFzgDB");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "CurrentBTE.ladenZeilenFzgDB");
        gObj.freeDBConnection(con2, "CurrentBTE.ladenZeilenFzgDB");
        return bl;
    }

    private void setKoppelTeilFlags() {
        Iterator it = this.mcRawZeilen.iterator();
        int ankerPos = 0;
        while (it.hasNext()) {
            RawZeile rZ = (RawZeile)it.next();
            if (rZ.getBildnummer().equals("--")) {
                if (ankerPos <= 0) continue;
                rZ.setAnkerPos(ankerPos);
                continue;
            }
            if (rZ.isTeilASPG()) {
                ankerPos = rZ.getPos();
                continue;
            }
            ankerPos = 0;
        }
    }

    protected void auswertenEinschraenkungFzg(String sLenkung, String sGetriebe, String sBaujahr, String sZulassungsmonat, boolean bIdentifiedByFgstnr) throws InvalidDataException {
        DebugInfos dInfos = null;
        if (this.mcRawZeilen == null) {
            log.error("The internal rows for the BTE are not loaded!!");
            throw new InvalidDataException("mcRawZeilen is null!!");
        }
        if (sLenkung == null) {
            sLenkung = "kA";
        }
        if (sGetriebe == null) {
            sGetriebe = "kA";
        }
        if (sBaujahr == null) {
            sBaujahr = "kA";
        }
        if (sZulassungsmonat == null) {
            sZulassungsmonat = "kA";
        }
        if (sLenkung.equals("kA") && sGetriebe.equals("kA") && sBaujahr.equals("kA") && sZulassungsmonat.equals("kA")) {
            return;
        }
        String sProdDatumEinsatzComp = "";
        String sProdDatumAuslaufComp = "";
        long lProdDatumEinsatzComp = 0L;
        long lProdDatumAuslaufComp = 0L;
        if (!sBaujahr.equals("kA")) {
            if (sZulassungsmonat.equals("kA")) {
                sProdDatumEinsatzComp = sBaujahr + "12" + "00";
                sProdDatumAuslaufComp = sBaujahr + "01" + "00";
            } else {
                sProdDatumEinsatzComp = sBaujahr + sZulassungsmonat + "00";
                sProdDatumAuslaufComp = sBaujahr + sZulassungsmonat + "00";
            }
            lProdDatumEinsatzComp = Long.decode(sProdDatumEinsatzComp);
            lProdDatumAuslaufComp = Long.decode(sProdDatumAuslaufComp);
        }
        for (int i = this.mcRawZeilen.size() - 1; i >= 0; --i) {
            int nMonat;
            String sAuslaufZeile;
            RawZeile Zeile2 = (RawZeile)this.mcRawZeilen.get(i);
            if (CurrentBTE.debugSachnummern(Zeile2.getSachnummer())) {
                log.debug("--> auswertenEinschraenkungFzg: rowCnt: " + i + " SNR: " + Zeile2.getSachnummer() + " POS: " + Zeile2.getPos() + " Lenkung: " + Zeile2.getLenkung());
            }
            if (!sLenkung.equals("kA")) {
                String sLenkungZeile = Zeile2.getLenkung();
                String string = sLenkungZeile = sLenkungZeile.equals("") ? null : sLenkungZeile;
                if (sLenkungZeile != null && !sLenkungZeile.equals(sLenkung)) {
                    if (CurrentBTE.debugSachnummern(Zeile2.getSachnummer())) {
                        log.debug("--> auswertenEinschraenkungFzg: rowCnt: " + i + " aufruf removePartsFromRawZeilen aus >>>Lenkungs-Einschr\u00e4nkung<<< f\u00fcr SNR: " + Zeile2.getSachnummer() + " POS: " + Zeile2.getPos());
                    }
                    dInfos = new DebugInfos(Zeile2.getSachnummer(), Zeile2.getPos(), "--> auswertenEinschraenkungFzg: rowCnt: " + i + " " + sLenkungZeile + " Lenkung SNR ungleich " + sLenkung + " Fzg");
                    this.removePartsFromRawZeilenMitStringVergleich(i, Zeile2.getBildnummer(), 10, sLenkung, dInfos);
                    continue;
                }
            }
            if (!sGetriebe.equals("kA")) {
                String sGetriebeZeile = Zeile2.getGetriebe();
                String string = sGetriebeZeile = sGetriebeZeile.equals("") ? null : sGetriebeZeile;
                if (sGetriebeZeile != null && !sGetriebeZeile.equals(sGetriebe)) {
                    if (CurrentBTE.debugSachnummern(Zeile2.getSachnummer())) {
                        log.debug("--> auswertenEinschraenkungFzg: rowCnt: " + i + " aufruf removePartsFromRawZeilen aus >>>Getriebe-Einschr\u00e4nkung<<< f\u00fcr SNR: " + Zeile2.getSachnummer() + " POS: " + Zeile2.getPos());
                    }
                    dInfos = new DebugInfos(Zeile2.getSachnummer(), Zeile2.getPos(), "--> auswertenEinschraenkungFzg: rowCnt: " + i + " " + sGetriebeZeile + " Getriebe SNR ungleich " + sGetriebe + " Fzg");
                    this.removePartsFromRawZeilenMitStringVergleich(i, Zeile2.getBildnummer(), 20, sGetriebe, dInfos);
                    continue;
                }
            }
            if (sBaujahr.equals("kA")) continue;
            String sEinsatzZeile = Zeile2.getEinsatz();
            String string = sEinsatzZeile = sEinsatzZeile.equals("") ? null : sEinsatzZeile;
            if (sEinsatzZeile != null) {
                int nMonat2;
                String sMonat = sEinsatzZeile.substring(4, 6);
                String sJahr = sEinsatzZeile.substring(0, 4);
                String sZeileEinsatzComp = WebetkUtils.modifyDate(sJahr, sMonat, nMonat2 = bIdentifiedByFgstnr ? 0 : -2);
                long lZeileEinsatzComp = Long.decode(sZeileEinsatzComp);
                if (lProdDatumEinsatzComp < lZeileEinsatzComp) {
                    if (CurrentBTE.debugSachnummern(Zeile2.getSachnummer())) {
                        log.debug("--> auswertenEinschraenkungFzg: rowCnt: " + i + " aufruf removePartsFromRawZeilen aus >>>Baujahr (und ggf. Zulassungsmonat)-Einschr\u00e4nkung Einsatz<<< f\u00fcr SNR: " + Zeile2.getSachnummer() + " POS: " + Zeile2.getPos());
                    }
                    dInfos = new DebugInfos(Zeile2.getSachnummer(), Zeile2.getPos(), "--> auswertenEinschraenkungFzg: rowCnt: " + i + " " + lZeileEinsatzComp + " prod. Einsatzdatum SNR ungleich (<)" + lProdDatumEinsatzComp + " Fzg");
                    this.removePartsFromRawZeilenMitDatumsVergleich(i, Zeile2.getBildnummer(), 30, lProdDatumEinsatzComp, bIdentifiedByFgstnr, dInfos);
                    continue;
                }
            }
            String string2 = sAuslaufZeile = (sAuslaufZeile = Zeile2.getAuslauf()).equals("") ? null : sAuslaufZeile;
            if (sAuslaufZeile == null) continue;
            String sMonat = sAuslaufZeile.substring(4, 6);
            String sJahr = sAuslaufZeile.substring(0, 4);
            String sZeileAuslaufComp = WebetkUtils.modifyDate(sJahr, sMonat, nMonat = bIdentifiedByFgstnr ? -1 : 1);
            long lZeileAuslaufComp = Long.decode(sZeileAuslaufComp);
            if (lProdDatumAuslaufComp <= lZeileAuslaufComp) continue;
            if (CurrentBTE.debugSachnummern(Zeile2.getSachnummer())) {
                log.debug("--> auswertenEinschraenkungFzg: rowCnt: " + i + " aufruf removePartsFromRawZeilen aus >>>Baujahr (und ggf. Zulassungsmonat)-Einschr\u00e4nkung Auslauf<<< f\u00fcr SNR: " + Zeile2.getSachnummer() + " POS: " + Zeile2.getPos());
            }
            dInfos = new DebugInfos(Zeile2.getSachnummer(), Zeile2.getPos(), "--> auswertenEinschraenkungFzg: rowCnt: " + i + " " + lZeileAuslaufComp + " prod. Auslaufdatum SNR ungleich (>)" + lProdDatumAuslaufComp + " Fzg");
            this.removePartsFromRawZeilenMitDatumsVergleich(i, Zeile2.getBildnummer(), 40, lProdDatumAuslaufComp, bIdentifiedByFgstnr, dInfos);
        }
    }

    private void removePartsFromRawZeilenMitStringVergleich(int i, String psBildnummer, int piVergleichsTyp, String psOperandFzg, DebugInfos pDI) {
        int j = i + 1;
        if (!"--".equals(psBildnummer)) {
            RawZeile zeile2;
            while (this.mcRawZeilen.size() > j && "--".equals((zeile2 = (RawZeile)this.mcRawZeilen.get(j)).getBildnummer())) {
                String sOperandTeil = null;
                switch (piVergleichsTyp) {
                    case 10: {
                        sOperandTeil = zeile2.getLenkung().equals("") ? null : zeile2.getLenkung();
                        break;
                    }
                    case 20: {
                        sOperandTeil = zeile2.getGetriebe().equals("") ? null : zeile2.getGetriebe();
                        break;
                    }
                    default: {
                        log.error("!!! Vergleichstyp fehlt, ist unbekannt !!!");
                    }
                }
                if (sOperandTeil != null && !sOperandTeil.equals(psOperandFzg)) {
                    if (CurrentBTE.debugSachnummern(zeile2.getSachnummer())) {
                        log.debug("--> removePartsFromRawZeilen, die dazugeh\u00f6ren (wegen >" + pDI.getDebugText() + "<) SNR:" + zeile2.getSachnummer() + " POS: " + zeile2.getPos());
                    }
                    this.mcRawZeilen.remove(j);
                    continue;
                }
                ++j;
            }
        }
        if (CurrentBTE.debugSachnummern(pDI.getSnr())) {
            log.debug("--> removePartsFromRawZeilen, die (wegen >" + pDI.getDebugText() + "< SNR: " + pDI.getSnr() + " POS: " + pDI.getPos());
        }
        this.mcRawZeilen.remove(i);
    }

    private void removePartsFromRawZeilenMitDatumsVergleich(int i, String psBildnummer, int piVergleichsTyp, long plOperandFzg, boolean bIdentifiedByFgstnr, DebugInfos pDI) {
        int j = i + 1;
        if (!"--".equals(psBildnummer)) {
            RawZeile zeile2;
            while (this.mcRawZeilen.size() > j && "--".equals((zeile2 = (RawZeile)this.mcRawZeilen.get(j)).getBildnummer())) {
                String sOperandTeil = null;
                switch (piVergleichsTyp) {
                    case 30: {
                        sOperandTeil = zeile2.getEinsatz().equals("") ? null : zeile2.getEinsatz();
                        break;
                    }
                    case 40: {
                        sOperandTeil = zeile2.getAuslauf().equals("") ? null : zeile2.getAuslauf();
                        break;
                    }
                    default: {
                        log.error("!!! Vergleichstyp fehlt, ist unbekannt !!!");
                    }
                }
                if (sOperandTeil != null) {
                    String sMonat = sOperandTeil.substring(4, 6);
                    String sJahr = sOperandTeil.substring(0, 4);
                    int iMonat = 0;
                    switch (piVergleichsTyp) {
                        case 30: {
                            iMonat = bIdentifiedByFgstnr ? 0 : -2;
                            break;
                        }
                        case 40: {
                            iMonat = bIdentifiedByFgstnr ? -1 : 1;
                        }
                    }
                    sOperandTeil = WebetkUtils.modifyDate(sJahr, sMonat, iMonat);
                    long lOperandTeil = Long.decode(sOperandTeil);
                    switch (piVergleichsTyp) {
                        case 30: {
                            if (plOperandFzg < lOperandTeil) {
                                if (CurrentBTE.debugSachnummern(zeile2.getSachnummer())) {
                                    log.debug("--> removePartsFromRawZeilen, die dazugeh\u00f6ren (wegen >" + pDI.getDebugText() + "<) SNR:" + zeile2.getSachnummer() + " POS: " + zeile2.getPos());
                                }
                                this.mcRawZeilen.remove(j);
                                break;
                            }
                            ++j;
                            break;
                        }
                        case 40: {
                            if (plOperandFzg > lOperandTeil) {
                                if (CurrentBTE.debugSachnummern(zeile2.getSachnummer())) {
                                    log.debug("--> removePartsFromRawZeilen, die dazugeh\u00f6ren (wegen >" + pDI.getDebugText() + "<) SNR:" + zeile2.getSachnummer() + " POS: " + zeile2.getPos());
                                }
                                this.mcRawZeilen.remove(j);
                                break;
                            }
                            ++j;
                        }
                    }
                    continue;
                }
                ++j;
            }
        }
        if (CurrentBTE.debugSachnummern(pDI.getSnr())) {
            log.debug("--> removePartsFromRawZeilen, die (wegen >" + pDI.getDebugText() + "< SNR: " + pDI.getSnr() + " POS: " + pDI.getPos());
        }
        this.mcRawZeilen.remove(i);
    }

    public void loadHotspots() throws SQLException, DatabaseBusyException {
        log.debug("Loading hotspots for formfactor 'normal' ...");
        this.mcHotspotsNormal = ServerBTEManager.loadHotspotsForBildId(this.getBildId(), "N");
        log.debug("Loading hotspots for formfactor 'zoomed' ...");
        this.mcHotspotsZoomed = ServerBTEManager.loadHotspotsForBildId(this.getBildId(), "Z");
    }

    public Collection<Hotspot> getHotspots() {
        return this.getBildZoomed() ? this.mcHotspotsZoomed : this.mcHotspotsNormal;
    }

    public String getBTEBedKuerzel() {
        return this.msBTEBedKuerzel;
    }

    public long getBildId() {
        return this.mlBildID;
    }

    public String getBildIdAsString() {
        return Long.toString(this.mlBildID);
    }

    public boolean getBildZoomed() {
        return this.mbBildZoomed;
    }

    public void setBildZoomed(boolean bZoomed) {
        this.mbBildZoomed = bZoomed;
    }

    public boolean getFilterZustand() {
        return this.mbFiltern;
    }

    public void setFilterZustand(boolean bFiltern) {
        this.mbFiltern = bFiltern;
    }

    public String getBedFilterModus() {
        return this.msBedFilterModus;
    }

    public void setBedFilterModus(String sBedFilterModus) {
        this.msBedFilterModus = sBedFilterModus;
    }

    public void setHighlight(String sBildnummer) {
        this.msHighlightPosNr = sBildnummer;
    }

    @Override
    public String getHighlight() {
        return this.msHighlightPosNr;
    }

    public String getBildTimestamp() {
        return this.msImageTimestamp;
    }

    public boolean getExpandBNB() {
        return this.mbExpandBNB;
    }

    public boolean getNachruestungenRelevant() {
        return this.mbNachruestRelevant;
    }

    public Boolean getUSATyp() {
        return this.mbUSATyp;
    }

    public Boolean getVinIdentif() {
        return this.mbVinIdentif;
    }

    public void setVinIdentif(Boolean mbVinIdentif) {
        this.mbVinIdentif = mbVinIdentif;
    }

    @Override
    public boolean performObjectInit() {
        return true;
    }

    protected Vector<RawZeile> constructTextteilRawZeilen() {
        Vector<RawZeile> cRawZeilen = null;
        cRawZeilen = this.msBTEType.equals("ASS") || !this.mbFiltern ? (Vector<RawZeile>)this.mcRawZeilen.clone() : this.anwendenBedingungsauswertung();
        return cRawZeilen;
    }

    @Override
    protected void auswertenBedingungen() {
        if (this.mcBedingungen == null || this.mcBedingungen.isEmpty()) {
            return;
        }
        if (this.msBTEType.equals("ASS") || !this.mbFiltern) {
            return;
        }
        this.mcBedingungen = this.setzenAusweisungenElemente(this.mcBedingungen);
        this.mhBedingungen = this.auswertenAusweisungen(this.mcBedingungen);
        this.mcRawZeilenTemp = this.removeZeilenNichtRelevant(this.mcRawZeilenTemp, this.mhBedingungen, this.mhUeberBedingungen);
    }

    @Override
    protected boolean removeKommentareVorBedingungen(String sBTENr) {
        if (this.mBedingungen == null) {
            return false;
        }
        boolean bIsIGDOM = this.mbIGDOMaktiv;
        boolean bAlleBedingungenGesetzt = this.mBedingungen.alleBedingungswerteEindeutig();
        boolean bAlleBedingungenOriginal = this.mBedingungen.alleWerteOriginal(sBTENr);
        boolean bIsBedFilter = this.getFilterZustand();
        return bIsBedFilter && bIsIGDOM && bAlleBedingungenGesetzt && bAlleBedingungenOriginal;
    }

    @Override
    protected void auswertenChangepoints(FzgSucheInfo oFzgSucheInfo) {
        if (oFzgSucheInfo == null) {
            return;
        }
        String sVin = oFzgSucheInfo.getFahrgestellnummer();
        if (StringUtils.isEmpty(sVin, true)) {
            return;
        }
        String sTypProddatum = oFzgSucheInfo.getProduktionsdatum(true);
        Long lTypProddatum = Long.valueOf(sTypProddatum);
        Iterator<Changepoint> iter = this.mcChangepoints.iterator();
        boolean bBildtafNichtRelevant = false;
        while (iter.hasNext()) {
            Changepoint oChangepoint = iter.next();
            boolean bRelevantByDatum = oChangepoint.auswertenChangepointDatum(lTypProddatum);
            if (bRelevantByDatum) continue;
            bBildtafNichtRelevant = true;
        }
        if (bBildtafNichtRelevant) {
            this.mcRawZeilenTemp.removeAllElements();
            return;
        }
        Collection<String> cTypmenge = oFzgSucheInfo.getTypmenge();
        if (cTypmenge.size() != 1) {
            return;
        }
        String sTyp = (String)cTypmenge.toArray()[0];
        String sWerk = oFzgSucheInfo.getWerk();
        if (StringUtils.isEmpty(sWerk, true)) {
            return;
        }
        if (sTyp == null || sWerk == null || lTypProddatum == null) {
            return;
        }
        Iterator iterZeile = this.mcRawZeilenTemp.iterator();
        boolean bRemoveAnhaengigeTeile = false;
        while (iterZeile.hasNext()) {
            RawZeile oZeile = (RawZeile)iterZeile.next();
            if (bRemoveAnhaengigeTeile && "--".equals(oZeile.getBildnummer())) {
                iterZeile.remove();
                continue;
            }
            bRemoveAnhaengigeTeile = false;
            boolean bRelevant = oZeile.auswertenChangepoints(sTyp, sVin, sWerk, lTypProddatum);
            if (bRelevant) continue;
            bRemoveAnhaengigeTeile = !"--".equals(oZeile.getBildnummer());
            iterZeile.remove();
        }
    }

    @Override
    protected void removeKabelbaumRows() {
        boolean noMbVinIdentif = false;
        if (this.mbVinIdentif != null) {
            noMbVinIdentif = this.mbVinIdentif;
        }
        log.info("***mbIGDOMaktiv: " + this.mbIGDOMaktiv);
        log.info("***mbVinIdentif: " + noMbVinIdentif);
        if (!noMbVinIdentif || !this.mbIGDOMaktiv) {
            log.info("***removeKabelbaumRows()");
            Iterator iter = this.mcRawZeilenTemp.iterator();
            while (iter.hasNext()) {
                RawZeile oZeile = (RawZeile)iter.next();
                if (!oZeile.isBtZAlter()) continue;
                iter.remove();
            }
        }
    }

    @Override
    protected void auswertenFahrzeugAlter(FzgSucheInfo oFzgSucheInfo) {
        if (oFzgSucheInfo == null || oFzgSucheInfo.getProduktionsDatum() == null) {
            return;
        }
        long now = new Date().getTime();
        long production = oFzgSucheInfo.getProduktionsDatum().getTime();
        long alterMs = now - production;
        double msProMonat = 2.628E9;
        double alterMonat = (double)alterMs / msProMonat;
        Iterator iter = this.mcRawZeilenTemp.iterator();
        while (iter.hasNext()) {
            RawZeile zeile = (RawZeile)iter.next();
            zeile.getBedingungKZ();
            String bedingunArt = zeile.getBedingungArt();
            if (bedingunArt == null || zeile.getBedingungAlter() == 0) continue;
            int bedingungAlter = zeile.getBedingungAlter();
            if (bedingunArt.equals("A") && alterMonat < (double)bedingungAlter) {
                iter.remove();
            }
            if (!bedingunArt.equals("B") || !(alterMonat > (double)bedingungAlter)) continue;
            iter.remove();
        }
    }

    @Override
    protected void auswertenPGBedingungen() {
        Iterator iter = this.mcRawZeilenTemp.iterator();
        while (iter.hasNext()) {
            String sKuerzel;
            RawZeile zeile = (RawZeile)iter.next();
            if (!zeile.getBildnummer().equals("--") || (sKuerzel = zeile.getBedkezPG()) == null || this.mhBedingungen != null && this.mhBedingungen.get(sKuerzel) != null) continue;
            iter.remove();
        }
    }

    public Vector<RawZeile> anwendenBedingungsauswertung() {
        Vector<RawZeile> cRawZeilenTemp = (Vector<RawZeile>)this.mcRawZeilen.clone();
        if (this.mcBedingungen == null || this.mcBedingungen.isEmpty()) {
            return cRawZeilenTemp;
        }
        if (this.msBTEType.equals("ASS") || !this.mbFiltern) {
            return cRawZeilenTemp;
        }
        Vector<webetk.app.bteanzeige.Bedingung> cBedingungen = (Vector<webetk.app.bteanzeige.Bedingung>)this.mcBedingungen.clone();
        cBedingungen = this.setzenAusweisungenElemente(cBedingungen);
        Hashtable<String, Boolean> hBedingungen = this.auswertenAusweisungen(cBedingungen);
        cRawZeilenTemp = this.removeZeilenNichtRelevant(cRawZeilenTemp, hBedingungen, this.mhUeberBedingungen);
        return cRawZeilenTemp;
    }

    public boolean haveSatzteil() {
        return this.mbZeilenContainSatzteil;
    }

    public boolean haveSteckerteil() {
        return this.mbZeilenContainSteckerteil;
    }

    public Textteil makeSnapshot(String TextTeilTyp, Vector<String> cIdsSelZeilen, SucheInfo oSucheInfo) {
        if (cIdsSelZeilen == null) {
            cIdsSelZeilen = new Vector();
        }
        try {
            if ("TextZoom".equals(TextTeilTyp)) {
                Vector<RawZeile> cRawZeilen = this.constructTextteilRawZeilen();
                TextteilObject oTextteil = new TextteilObject(this.msHG, this.msFG, this.msBTENummer, this.msBTEUeberschrift, this.msMarke, this.msBTEType, cRawZeilen, this.mhKommentare, this.mcZeilen, this.mcExpandedZeilen);
                return oTextteil;
            }
            if ("Druck".equals(TextTeilTyp)) {
                Vector<RawZeile> cRawZeilen = this.constructDruckansichtRawZeilen(cIdsSelZeilen);
                DruckansichtObject oDruckansicht = new DruckansichtObject(this.msHG, this.msFG, this.msBTENummer, this.msBTEUeberschrift, this.msBTEType, this.getBildIdAsString(), this.msImageTimestamp, cRawZeilen, this.mhKommentare, this.mcBTVerweisZeilen);
                oDruckansicht.setzenAZWZeichenBAP(oSucheInfo);
                if (oSucheInfo != null) {
                    oDruckansicht.erzeugenKommZeilen(oSucheInfo.getProduktart());
                }
                return oDruckansicht;
            }
            return null;
        }
        catch (Exception e) {
            log.error("Current BTE <" + this.msBTENummer + "> failes with: " + e.getMessage());
            return null;
        }
    }

    protected Vector<RawZeile> constructDruckansichtRawZeilen(Vector<String> cZeilenId) {
        if (cZeilenId == null) {
            cZeilenId = new Vector();
        }
        boolean bAllRows = true;
        Vector cRawZeilen = new Vector();
        if (cZeilenId.size() > 0) {
            bAllRows = false;
        }
        boolean bAppend = false;
        for (AbstractZeile obj : this.mcZeilen) {
            KommZeile oKommZeile;
            if (obj instanceof Zeile) {
                Zeile oZeile = (Zeile)obj;
                String sId = null;
                String sIdObj = oZeile.getId();
                if (oZeile.getBildnummer().equals("--")) {
                    if (bAppend) {
                        sId = sIdObj;
                    }
                } else {
                    for (String sIdComp : cZeilenId) {
                        if (!sIdComp.equals(sIdObj)) continue;
                        sId = sIdObj;
                        bAppend = true;
                    }
                }
                if (sId != null) {
                    for (RawZeile oRawZeile : this.mcRawZeilenTemp) {
                        String sIdRawZeile = oRawZeile.getId();
                        if (!sIdRawZeile.equals(sId)) continue;
                        cRawZeilen.add(oRawZeile);
                        break;
                    }
                }
            }
            if (!(obj instanceof KommZeile) || !(oKommZeile = (KommZeile)obj).getText().equals("")) continue;
            bAppend = false;
        }
        if (bAllRows) {
            cRawZeilen = (Vector)this.mcRawZeilenTemp.clone();
        }
        return cRawZeilen;
    }

    public boolean hasKomprimierungszeile(String sBildnummer) {
        for (AbstractZeile obj : this.mcZeilen) {
            Zeile oZeile;
            if (!(obj instanceof Zeile) || !(oZeile = (Zeile)obj).getBildnummer().equals(sBildnummer)) continue;
            return oZeile.isKomprimierungszeile();
        }
        return false;
    }

    public int getAnzahlZeilen(String sBildnummer) {
        if (this.mcZeilen == null || sBildnummer == null) {
            return 0;
        }
        int nAnzahl = 0;
        boolean bBildnummerFound = false;
        for (AbstractZeile obj : this.mcZeilen) {
            AbstractZeile oZeile;
            if (obj instanceof KommZeile && ((KommZeile)(oZeile = (KommZeile)obj)).getText().equals("")) {
                nAnzahl = 0;
                continue;
            }
            ++nAnzahl;
            if (!(obj instanceof Zeile)) continue;
            oZeile = (Zeile)obj;
            if (!sBildnummer.equals("--") && !((Zeile)oZeile).getBildnummer().equals(sBildnummer)) {
                nAnzahl = 0;
                continue;
            }
            bBildnummerFound = true;
        }
        if (!bBildnummerFound) {
            return 0;
        }
        return nAnzahl;
    }

    public void addChangepoint(int nPos, Changepoint oChangepoint) {
        for (RawZeile oZeile : this.mcRawZeilen) {
            if (oZeile.getPos() != nPos) continue;
            oZeile.addChangepoint(oChangepoint);
        }
    }

    public boolean hatChangepoints() {
        if (this.mcChangepoints.size() > 0) {
            return true;
        }
        for (Object oObject : this.mcRawZeilen) {
            RawZeile oZeile;
            if (!(oObject instanceof RawZeile) || (oZeile = (RawZeile)oObject).getChangepoints() == null || oZeile.getChangepoints().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isBtZAlter() {
        for (Object oObject : this.mcRawZeilen) {
            RawZeile oZeile;
            if (!(oObject instanceof RawZeile) || !(oZeile = (RawZeile)oObject).isBtZAlter()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChangepoints() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("CurrentBTE.loadChangepoints");
            log.debug("Loading BTE-Changepoints <" + this.msBTENummer + "> ...");
            res = BedAuswertungDbAccess.loadBTEChangepoints(con, this.msBTENummer);
            while (res != null && res.next()) {
                String sArt = res.getString("Art");
                long lDatumHelp = res.getLong("Datum");
                Long lDatum = res.wasNull() ? null : new Long(lDatumHelp);
                Changepoint oChangepoint = new Changepoint(null, null, sArt, lDatum, null, null, null, null, null, null, null);
                this.mcChangepoints.add(oChangepoint);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "CurrentBTE.loadChangepoints");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "CurrentBTE.loadChangepoints");
    }

    private void removeAlleZeilenOhneBedingung(Collection<RawZeile> cZeilen, int nBildPos) {
        Iterator<RawZeile> iterator = cZeilen.iterator();
        while (iterator.hasNext()) {
            String sKuerzel;
            RawZeile Zeile2 = iterator.next();
            if (Zeile2.getBildnummerInt() != nBildPos || (sKuerzel = Zeile2.getBedingungKZ()) != null) continue;
            iterator.remove();
        }
    }

    private boolean findZeileMitBed(Collection<RawZeile> cZeilen, long lGruppeId, String sKuerzel, Collection<Changepoint> cChangepoints) {
        for (RawZeile zeile : cZeilen) {
            String sKuerzelZeile;
            if (zeile.getGruppeId() != lGruppeId || (sKuerzelZeile = zeile.getBedingungKZ()) == null || !sKuerzelZeile.equals(sKuerzel)) continue;
            Collection<Changepoint> cChangepointsZeile = zeile.getChangepoints();
            if (cChangepointsZeile.size() == 0 && !"--".equals(zeile.getBildnummer())) {
                return true;
            }
            if (cChangepoints.size() == 0 || !this.sindIdentischChangepoints(cChangepointsZeile, cChangepoints)) continue;
            return true;
        }
        return false;
    }

    public void checkZeilenByBlockNr(Collection<RawZeile> cZeilen, Collection<Long> cBlocknr) {
        block0: for (long lBlockNr : cBlocknr) {
            if (lBlockNr <= 0L) {
                log.error("checkZeilenByBlockNr: Blocknummer 0 gefunden");
                continue;
            }
            Iterator<RawZeile> iterator = cZeilen.iterator();
            while (iterator.hasNext()) {
                RawZeile Zeile2 = iterator.next();
                if (Zeile2.getBlockNr() != lBlockNr) continue;
                if (!Zeile2.getBildnummer().equals("--")) continue block0;
                log.debug("checkZeilenByBlockNr: '--'-Zeile wird entfernt in BTE " + this.msBTENummer + " (Sachnummer: " + Zeile2.getSachnummer() + ")");
                iterator.remove();
            }
        }
    }

    public void addInteger(Collection<Integer> cIntCollection, int nNummer) {
        for (Integer nNummerComp : cIntCollection) {
            if (nNummer != nNummerComp) continue;
            return;
        }
        cIntCollection.add(new Integer(nNummer));
    }

    public void addLong(Collection<Long> cLongCollection, long lNummer) {
        for (Long lNummerComp : cLongCollection) {
            if (lNummer != lNummerComp) continue;
            return;
        }
        cLongCollection.add(new Long(lNummer));
    }

    public void addString(Collection<String> cStringCollection, String sString) {
        for (String sStringComp : cStringCollection) {
            if (!sString.equalsIgnoreCase(sStringComp)) continue;
            return;
        }
        cStringCollection.add(sString);
    }

    private boolean sindIdentischChangepoints(Collection<Changepoint> cChangepoints1, Collection<Changepoint> cChangepoints2) {
        if (cChangepoints1.size() != cChangepoints2.size()) {
            return false;
        }
        for (Changepoint cCP1 : cChangepoints1) {
            String sTyp1 = cCP1.getTyp() == null ? "" : cCP1.getTyp();
            String sWerk1 = cCP1.getWerk() == null ? "" : cCP1.getWerk();
            String sArt1 = cCP1.getArt() == null ? "" : cCP1.getArt();
            String sVin1 = cCP1.getVin() == null ? "" : cCP1.getVin();
            long lVinProddatum1 = cCP1.getVinProddatum() == null ? 0L : cCP1.getVinProddatum().longValue();
            String sVinMax1 = cCP1.getVinMax() == null ? "" : cCP1.getVinMax();
            String sVinMin1 = cCP1.getVinMin() == null ? "" : cCP1.getVinMin();
            long lDatum1 = cCP1.getDatum() == null ? 0L : cCP1.getDatum().longValue();
            String sArtNummer1 = cCP1.getArtNummer() == null ? "" : cCP1.getArtNummer();
            String sNummer1 = cCP1.getNummer() == null ? "" : cCP1.getNummer();
            for (Changepoint cCP2 : cChangepoints2) {
                String sArtNummer2;
                long lDatum2;
                String sVinMin2;
                String sVinMax2;
                long lVinProddatum2;
                String sVin2;
                String sArt2;
                String sWerk2;
                String sTyp2;
                String string = sTyp2 = cCP2.getTyp() == null ? "" : cCP2.getTyp();
                if (!sTyp1.equals(sTyp2)) {
                    return false;
                }
                String string2 = sWerk2 = cCP2.getWerk() == null ? "" : cCP2.getWerk();
                if (!sWerk1.equals(sWerk2)) {
                    return false;
                }
                String string3 = sArt2 = cCP2.getArt() == null ? "" : cCP2.getArt();
                if (!sArt1.equals(sArt2)) {
                    return false;
                }
                String string4 = sVin2 = cCP2.getVin() == null ? "" : cCP2.getVin();
                if (!sVin1.equals(sVin2)) {
                    return false;
                }
                long l = lVinProddatum2 = cCP2.getVinProddatum() == null ? 0L : cCP2.getVinProddatum().longValue();
                if (lVinProddatum1 != lVinProddatum2) {
                    return false;
                }
                String string5 = sVinMax2 = cCP2.getVinMax() == null ? "" : cCP2.getVinMax();
                if (!sVinMax1.equals(sVinMax2)) {
                    return false;
                }
                String string6 = sVinMin2 = cCP2.getVinMin() == null ? "" : cCP2.getVinMin();
                if (!sVinMin1.equals(sVinMin2)) {
                    return false;
                }
                long l2 = lDatum2 = cCP2.getDatum() == null ? 0L : cCP2.getDatum().longValue();
                if (lDatum1 != lDatum2) {
                    return false;
                }
                String string7 = sArtNummer2 = cCP2.getArtNummer() == null ? "" : cCP2.getArtNummer();
                if (!sArtNummer1.equals(sArtNummer2)) {
                    return false;
                }
                String sNummer2 = cCP2.getNummer() == null ? "" : cCP2.getNummer();
                if (sNummer1.equals(sNummer2)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZubehoerBte() {
        return this.mbZubehoerBte;
    }

    public String getLkz() {
        return this.msLkz;
    }

    public void setIGDOMaktiv(boolean mbIGDOMaktiv) {
        this.mbIGDOMaktiv = mbIGDOMaktiv;
    }

    public boolean isIGDOMaktiv() {
        return this.mbIGDOMaktiv;
    }

    private static boolean debugSachnummern(String pSNR) {
        if (System.getProperty("debugETK") == null || !System.getProperty("debugETK").equals("true")) {
            return false;
        }
        if (mhSachnummern == null) {
            mhSachnummern = new HashMap();
            mhSachnummern.put("8379809", "");
            mhSachnummern.put("8364215", "");
            mhSachnummern.put("8374946", "");
            mhSachnummern.put("8379815", "");
            mhSachnummern.put("8364215", "");
            mhSachnummern.put("8374946", "");
        }
        return mhSachnummern.containsKey(pSNR);
    }

    private void debugRawZeilen() {
        if (System.getProperty("debugETK") == null || !System.getProperty("debugETK").equals("true")) {
            return;
        }
        Iterator it = this.mcRawZeilen.iterator();
        int cnt = 0;
        while (it.hasNext()) {
            RawZeile rZ = (RawZeile)it.next();
            log.debug("***" + cnt + "*** SNR: " + rZ.getSachnummer() + " POS: " + rZ.getPos() + " GRP: " + rZ.getGruppeId() + " BLK: " + rZ.getBlockNr());
            ++cnt;
        }
    }

    public boolean isAspgNeedVIN() {
        return this.aspgNeedVIN;
    }

    public void setAspgNeedVIN(boolean aspgNeedVIN) {
        this.aspgNeedVIN = aspgNeedVIN;
    }

    public boolean isMbBoolExpUsed() {
        return this.mbBoolExpUsed;
    }

    public void setMbBoolExpUsed(boolean mbBoolExpUsed) {
        this.mbBoolExpUsed = mbBoolExpUsed;
    }

    public boolean hasBedingungen() {
        if (this.mcBedingungen == null) {
            return false;
        }
        return this.mcBedingungen.size() != 0;
    }

    protected class DebugInfos {
        private String sDIsnr;
        private int iDIpos;
        private String sDIdebugText;

        protected DebugInfos(String psSNR, int piPos, String psDebugText) {
            this.sDIsnr = psSNR;
            this.iDIpos = piPos;
            this.sDIdebugText = psDebugText;
        }

        protected String getSnr() {
            return this.sDIsnr;
        }

        protected int getPos() {
            return this.iDIpos;
        }

        protected String getDebugText() {
            return this.sDIdebugText;
        }
    }
}

