/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.clientadmintool;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;
import webetk.app.admintool.DBSicherung;

public class LokaleSicherung {
    private static String versionSicherungFile = null;
    private static Logger log = Logger.getLogger(DBSicherung.class);

    public static void setArrayInDatei(String sPath, String sDateiName, byte[] data, boolean append) throws FileNotFoundException, IOException {
        File destinationFile = new File(sPath + "\\" + sDateiName);
        if (destinationFile.exists() && !append) {
            destinationFile.delete();
            log.info("File already existed before deletion");
        }
        FileOutputStream out = new FileOutputStream(destinationFile, append);
        out.write(data);
        out.close();
    }

    public static String getDataFileName() throws FileNotFoundException, IOException {
        String sPath = LokaleSicherung.getSicherungsDir();
        File oDirectory = new File(sPath);
        String fileName = "";
        File currentVersion = new File(oDirectory + File.separator + LokaleSicherung.getVersionSicherungFile());
        if (currentVersion.exists()) {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(oDirectory + File.separator + LokaleSicherung.getVersionSicherungFile())));
            fileName = in.readLine().trim();
            in.close();
        }
        return fileName;
    }

    public static byte[] getDataToArray() throws FileNotFoundException, IOException {
        String fileName = LokaleSicherung.getDataFileName();
        String sPath = LokaleSicherung.getSicherungsDir();
        File oDirectory = new File(sPath);
        File file = new File(oDirectory + File.separator + fileName);
        byte[] data = new byte[1];
        FileInputStream fis = new FileInputStream(file);
        FileChannel fc = fis.getChannel();
        data = new byte[(int)fc.size()];
        ByteBuffer bb = ByteBuffer.wrap(data);
        fc.read(bb);
        fis.close();
        return data;
    }

    public static byte[] getVersionToArray() throws FileNotFoundException, IOException {
        String sPath = LokaleSicherung.getSicherungsDir();
        File oDirectory = new File(sPath);
        File currentVersion = new File(oDirectory + File.separator + LokaleSicherung.getVersionSicherungFile());
        byte[] data = new byte[1];
        FileInputStream fis = new FileInputStream(currentVersion);
        FileChannel fc = fis.getChannel();
        data = new byte[(int)fc.size()];
        ByteBuffer bb = ByteBuffer.wrap(data);
        fc.read(bb);
        fis.close();
        return data;
    }

    public static String getVersionSicherungFile() {
        if (versionSicherungFile == null) {
            versionSicherungFile = "AktuelleVersion.txt";
        }
        return versionSicherungFile;
    }

    public static String getSicherungsDir() {
        String sicherungsDir = "D:\\ETK";
        return sicherungsDir;
    }

    public static void copyDir(File quelle, File ziel) throws FileNotFoundException, IOException {
        File[] files = quelle.listFiles();
        File newFile = null;
        ziel.mkdirs();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                newFile = new File(ziel.getAbsolutePath() + System.getProperty("file.separator") + files[i].getName());
                if (files[i].isDirectory()) {
                    LokaleSicherung.copyDir(files[i], newFile);
                    continue;
                }
                LokaleSicherung.copyFile(files[i], newFile);
            }
        }
    }

    public static void copyFile(File file, File ziel) throws FileNotFoundException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ziel));
        int bytes = 0;
        while ((bytes = in.read()) != -1) {
            out.write(bytes);
        }
        in.close();
        out.close();
    }

    public static void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    LokaleSicherung.deleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
            dir.delete();
        }
    }

    public static void deleteFile(File file) {
        file.delete();
    }

    public static long getDirSize(File dir) {
        long size = 0L;
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    size += LokaleSicherung.getDirSize(files[i]);
                    continue;
                }
                size += files[i].length();
            }
        }
        return size;
    }
}

