/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.federtabelle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.SucheInfo;
import webetk.app.federtabelle.FTZeile;
import webetk.app.federtabelle.FTZeilen;
import webetk.app.federtabelle.PGTeil;
import webetk.app.federtabelle.PunkteSala;
import webetk.app.federtabelle.PunkteTyp;
import webetk.app.federtabelle.SalaZeile;
import webetk.app.federtabelle.SalaZeilen;
import webetk.app.fzgid.FzgIdInfo;
import webetk.db.dbaccess.FedertabelleDbAccess;

public class FedertabelleInfo {
    private static Logger log = Logger.getLogger(FedertabelleInfo.class);
    private String msStatus = "AUSWAHL_SALA";
    private String msMarke = null;
    private SalaZeilen mcSalaZeilen;
    private SalaZeilen mcSalaZeilenLeft;
    private SalaZeilen mcSalaZeilenRight;
    private FTZeilen mcFTZeilen;
    private int mnMaxAnzVAFedern = -1;
    private int mnMaxAnzHAFedern = -1;

    public FedertabelleInfo(String sMarke) {
        this.msMarke = sMarke;
        this.msStatus = "AUSWAHL_SALA";
        this.mcSalaZeilen = new SalaZeilen();
        this.mcSalaZeilenLeft = new SalaZeilen();
        this.mcSalaZeilenRight = new SalaZeilen();
        this.mcFTZeilen = new FTZeilen();
    }

    public String getStatus() {
        if (this.msStatus == null) {
            return "";
        }
        return this.msStatus;
    }

    public String getMarke() {
        if (this.msMarke == null) {
            return "";
        }
        return this.msMarke;
    }

    public FTZeilen getFTZeilen() {
        return this.mcFTZeilen;
    }

    public SalaZeilen getSalaZeilen() {
        return this.mcSalaZeilen;
    }

    public SalaZeilen getSalaZeilenLeft() {
        return this.mcSalaZeilenLeft;
    }

    public SalaZeilen getSalaZeilenRight() {
        return this.mcSalaZeilenRight;
    }

    public boolean hatTabellenHeader2Zeilen() {
        return this.hat2VAFedern() || this.hat2HAFedern();
    }

    public boolean hat2VAFedern() {
        if (this.mnMaxAnzVAFedern == -1) {
            this.mcFTZeilen.first();
            while (true) {
                String szSachnummerVA_links = this.mcFTZeilen.getCurrentSachnummerVA_links();
                String szSachnummerVA_rechts = this.mcFTZeilen.getCurrentSachnummerVA_rechts();
                if (szSachnummerVA_links != null && szSachnummerVA_rechts != null && !szSachnummerVA_links.equals(szSachnummerVA_rechts)) {
                    this.mnMaxAnzVAFedern = 2;
                    return true;
                }
                if (!this.mcFTZeilen.hasNext()) break;
                this.mcFTZeilen.next();
            }
            this.mnMaxAnzVAFedern = 1;
            return false;
        }
        return this.mnMaxAnzVAFedern == 2;
    }

    public boolean hat2HAFedern() {
        if (this.mnMaxAnzHAFedern == -1) {
            this.mcFTZeilen.first();
            while (true) {
                String szSachnummerHA_links = this.mcFTZeilen.getCurrentSachnummerHA_links();
                String szSachnummerHA_rechts = this.mcFTZeilen.getCurrentSachnummerHA_rechts();
                if (szSachnummerHA_links != null && szSachnummerHA_rechts != null && !szSachnummerHA_links.equals(szSachnummerHA_rechts)) {
                    this.mnMaxAnzHAFedern = 2;
                    return true;
                }
                if (!this.mcFTZeilen.hasNext()) break;
                this.mcFTZeilen.next();
            }
            this.mnMaxAnzHAFedern = 1;
            return false;
        }
        return this.mnMaxAnzHAFedern == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performSalaLoad(String sLang, Collection<String> cTypen, String sProduktionsdatum, boolean bIsTagesgenau) throws SQLException, DatabaseBusyException {
        Vector<SalaZeile> cHelp = new Vector<SalaZeile>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("FedertabelleInfo.performSalaLoad");
            log.debug("Loading Sala-Zeilen...");
            res = FedertabelleDbAccess.loadSalas(con, sLang, cTypen, sProduktionsdatum, bIsTagesgenau);
            int nCountLeft = 0;
            int nCountRight = 0;
            while (res != null && res.next()) {
                long lId = res.getLong("Id");
                String sCode = res.getString("Code");
                String sBenennung = res.getString("Benennung");
                SalaZeile oZeile = new SalaZeile(lId, sCode, sBenennung);
                cHelp.add(oZeile);
            }
            int nSizeHalf = cHelp.size() / 2;
            int nModulo = cHelp.size() % 2;
            if (nModulo > 0) {
                ++nSizeHalf;
            }
            int nCounter = 1;
            for (SalaZeile oZeile : cHelp) {
                if (nCounter <= nSizeHalf) {
                    this.mcSalaZeilenLeft.add(oZeile);
                    ++nCountLeft;
                } else {
                    this.mcSalaZeilenRight.add(oZeile);
                    ++nCountRight;
                }
                this.mcSalaZeilen.add(oZeile);
                ++nCounter;
            }
            if (nCountRight < nCountLeft) {
                this.mcSalaZeilenRight.add(new SalaZeile(0L, null, null));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "FedertabelleInfo.performSalaLoad");
            this.msStatus = "AUSWAHL_SALA";
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "FedertabelleInfo.performSalaLoad");
        this.msStatus = "AUSWAHL_SALA";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFedertabelleEval(Collection<String> cTypen, String sProduktionsdatum, boolean bIsTagesgenau, Collection<Object> cSalaIds, FzgIdInfo fzgIdInfo, SucheInfo sucheInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet resSalaPunkte = null;
        ResultSet resTypPunkte = null;
        Vector<PunkteSala> cSalaPunkteSave = new Vector<PunkteSala>();
        Vector<PunkteTyp> cPunkteTypSave = new Vector<PunkteTyp>();
        Vector<PunkteTyp> cPunkteTyp = new Vector<PunkteTyp>();
        this.mnMaxAnzHAFedern = -1;
        this.mnMaxAnzVAFedern = -1;
        try {
            con = gObj.getDBConnection("FedertabelleInfo.performFedertabelleEval (SalaPunkte)");
            this.mcFTZeilen = new FTZeilen();
            if (cSalaIds.size() > 0) {
                resSalaPunkte = this.loadSalaPunkte(con, cTypen, sProduktionsdatum, bIsTagesgenau, cSalaIds);
                while (resSalaPunkte != null && resSalaPunkte.next()) {
                    long lFTIdSala = resSalaPunkte.getLong("FTId");
                    long lSalaId = resSalaPunkte.getLong("SalaId");
                    int nPunkteVA_links = resSalaPunkte.getInt("PunkteVA_links");
                    int nPunkteVA_rechts = resSalaPunkte.getInt("PunkteVA_rechts");
                    int nPunkteHA_links = resSalaPunkte.getInt("PunkteHA_links");
                    int nPunkteHA_rechts = resSalaPunkte.getInt("PunkteHA_rechts");
                    PunkteSala oSalapaPunkte = new PunkteSala(lFTIdSala, lSalaId, nPunkteVA_links, nPunkteVA_rechts, nPunkteHA_links, nPunkteHA_rechts);
                    cSalaPunkteSave.add(oSalapaPunkte);
                }
            }
        }
        finally {
            WebetkUtils.closeQuery(resSalaPunkte);
            gObj.freeDBConnection(con, "FedertabelleInfo.performSalaLoad");
        }
        try {
            con = gObj.getDBConnection("FedertabelleInfo.performFedertabelleEval (SalaTypen)");
            resTypPunkte = this.loadTypPunkte(con, cTypen, sProduktionsdatum, bIsTagesgenau);
            while (resTypPunkte != null && resTypPunkte.next()) {
                long lFTIdTyp = resTypPunkte.getLong("FTId");
                String sTyp = resTypPunkte.getString("Typ");
                int nGrundpunkteVA_links = resTypPunkte.getInt("GrundpunkteVA_links");
                int nGrundpunkteVA_rechts = resTypPunkte.getInt("GrundpunkteVA_rechts");
                int nGrundpunkteHA_links = resTypPunkte.getInt("GrundpunkteHA_links");
                int nGrundpunkteHA_rechts = resTypPunkte.getInt("GrundpunkteHA_rechts");
                PunkteTyp oPunkteTyp = new PunkteTyp(lFTIdTyp, sTyp, nGrundpunkteVA_links, nGrundpunkteVA_rechts, nGrundpunkteHA_links, nGrundpunkteHA_rechts);
                String istASPG = resTypPunkte.getString("Sftid_Ist_Aspg");
                oPunkteTyp.setIstASPG(istASPG);
                if (istASPG != null && istASPG.equals("J")) {
                    oPunkteTyp.setAspgKit(this.loadAspgKit(lFTIdTyp));
                }
                cPunkteTypSave.add(oPunkteTyp);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resTypPunkte);
            gObj.freeDBConnection(con, "FedertabelleInfo.performSalaLoad");
            throw throwable;
        }
        WebetkUtils.closeQuery(resTypPunkte);
        gObj.freeDBConnection(con, "FedertabelleInfo.performSalaLoad");
        Iterator iteratorPunkteTyp = cPunkteTypSave.iterator();
        while (iteratorPunkteTyp.hasNext()) {
            PunkteTyp oPunkteTyp = (PunkteTyp)iteratorPunkteTyp.next();
            cPunkteTyp.add(oPunkteTyp);
            long lFTId = oPunkteTyp.getFTId();
            for (PunkteSala oPunkteSala : cSalaPunkteSave) {
                if (oPunkteSala.getFTId() != lFTId) continue;
                oPunkteTyp.adjustPunkte(oPunkteSala);
            }
            FedertabelleInfoHilfe oHelperVA_links = this.loadFeder("V", "L", lFTId, oPunkteTyp.getPunkteVA_links());
            FedertabelleInfoHilfe oHelperVA_rechts = this.loadFeder("V", "R", lFTId, oPunkteTyp.getPunkteVA_rechts());
            FedertabelleInfoHilfe oHelperHA_links = this.loadFeder("H", "L", lFTId, oPunkteTyp.getPunkteHA_links());
            FedertabelleInfoHilfe oHelperHA_rechts = this.loadFeder("H", "R", lFTId, oPunkteTyp.getPunkteHA_rechts());
            FTZeile oZeile = new FTZeile(oPunkteTyp.getTyp(), oHelperVA_links.sTeilenummer, oHelperVA_links.bIstDiebstahlrelevant, oPunkteTyp.getPunkteVA_links(), oHelperVA_rechts.sTeilenummer, oHelperVA_rechts.bIstDiebstahlrelevant, oPunkteTyp.getPunkteVA_rechts(), oHelperHA_links.sTeilenummer, oHelperHA_links.bIstDiebstahlrelevant, oPunkteTyp.getPunkteHA_links(), oHelperHA_rechts.sTeilenummer, oHelperHA_rechts.bIstDiebstahlrelevant, oPunkteTyp.getPunkteHA_rechts());
            this.mcFTZeilen.add(oZeile);
            if (!oPunkteTyp.getIstASPG().equals("J")) continue;
            oZeile.setAspgKit(true);
            FTZeile oZeileBlank = new FTZeile("", "", false, oPunkteTyp.getPunkteVA_links(), "", false, oPunkteTyp.getPunkteVA_rechts(), "", false, oPunkteTyp.getPunkteHA_links(), "", false, oPunkteTyp.getPunkteHA_rechts());
            this.mcFTZeilen.add(oZeileBlank);
            List aspgKitV = oPunkteTyp.getAspgKitByAchse("V", (int)fzgIdInfo.getModellspalte(), fzgIdInfo, sucheInfo, cSalaIds);
            List aspgKitH = oPunkteTyp.getAspgKitByAchse("H", (int)fzgIdInfo.getModellspalte(), fzgIdInfo, sucheInfo, cSalaIds);
            int count = Math.max(aspgKitV.size(), aspgKitH.size());
            for (int i = 0; i < count; ++i) {
                PGTeil pgTeil;
                String pgTeilenummerV = "";
                boolean diebstahlrelevantV = false;
                String pgTeilenummerH = "";
                boolean diebstahlrelevantH = false;
                if (aspgKitV.size() > i) {
                    pgTeil = (PGTeil)aspgKitV.get(i);
                    pgTeilenummerV = pgTeil.getTeileNummer();
                    diebstahlrelevantV = pgTeil.isDiebstahlrelevant();
                }
                if (aspgKitH.size() > i) {
                    pgTeil = (PGTeil)aspgKitH.get(i);
                    pgTeilenummerH = pgTeil.getTeileNummer();
                    diebstahlrelevantH = pgTeil.isDiebstahlrelevant();
                }
                FTZeile oZeilePG = new FTZeile("--", pgTeilenummerV, diebstahlrelevantV, oPunkteTyp.getPunkteVA_links(), pgTeilenummerV, diebstahlrelevantV, oPunkteTyp.getPunkteVA_rechts(), pgTeilenummerH, diebstahlrelevantH, oPunkteTyp.getPunkteHA_links(), pgTeilenummerH, diebstahlrelevantH, oPunkteTyp.getPunkteHA_rechts());
                this.mcFTZeilen.add(oZeilePG);
            }
            if (!iteratorPunkteTyp.hasNext()) continue;
            this.mcFTZeilen.add(oZeileBlank);
        }
        this.msStatus = "ANZEIGE_FEDERN";
    }

    public void synchroniseCheck(Collection<?> cSalaIds) {
        this.mcSalaZeilenLeft.synchroniseCheck(cSalaIds);
        this.mcSalaZeilenRight.synchroniseCheck(cSalaIds);
        this.mcSalaZeilen.synchroniseCheck(cSalaIds);
    }

    private ResultSet loadTypPunkte(Connection con, Collection<String> cTypen, String sProduktionsdatum, boolean bIsTagesgenau) throws SQLException, DatabaseBusyException {
        log.debug("Loading Typ-Punkte...");
        ResultSet res = FedertabelleDbAccess.loadTypPunkte(con, cTypen, sProduktionsdatum, bIsTagesgenau);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadAspgKit(long lFTId) throws SQLException, DatabaseBusyException {
        ArrayList<PGTeil> arrayList;
        ArrayList<PGTeil> res = new ArrayList<PGTeil>();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet resAspgKit = null;
        try {
            con = gObj.getDBConnection("FedertabelleInfo.loadAspgKit");
            log.debug("Loading Aspg-Kit ...");
            resAspgKit = FedertabelleDbAccess.loadAspgKit(con, lFTId);
            while (resAspgKit != null && resAspgKit.next()) {
                PGTeil pgTeil = new PGTeil();
                pgTeil.setTeileNummer(resAspgKit.getString("Teilenummer"));
                pgTeil.setBtNR(resAspgKit.getString("BTNr"));
                pgTeil.setMospID(resAspgKit.getInt("MospId"));
                pgTeil.setAchse(resAspgKit.getString("Achse"));
                pgTeil.setDiebstahlrelevant(resAspgKit.getString("Teil_Diebstahlrelevant") != null && resAspgKit.getString("Teil_Diebstahlrelevant").equals("J"));
                res.add(pgTeil);
            }
            arrayList = res;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(resAspgKit);
            gObj.freeDBConnection(con, "FedertabelleInfo.loadAspgKit");
            throw throwable;
        }
        WebetkUtils.closeQuery(resAspgKit);
        gObj.freeDBConnection(con, "FedertabelleInfo.loadAspgKit");
        return arrayList;
    }

    private ResultSet loadSalaPunkte(Connection con, Collection<String> cTypen, String sProduktionsdatum, boolean bIsTagesgenau, Collection<Object> cSalaIds) throws SQLException, DatabaseBusyException {
        log.debug("Loading Sala-Punkte...");
        ResultSet res = FedertabelleDbAccess.loadSalaPunkte(con, cTypen, sProduktionsdatum, bIsTagesgenau, cSalaIds);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FedertabelleInfoHilfe loadFeder(String sArt, String sLinksRechts, long lFTId, int nPunkte) throws SQLException, DatabaseBusyException {
        FedertabelleInfoHilfe federtabelleInfoHilfe;
        FedertabelleInfoHilfe oHelper = new FedertabelleInfoHilfe();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("FedertabelleInfo.loadFeder");
            log.debug("Loading Feder...");
            res = FedertabelleDbAccess.loadFeder(con, sArt, sLinksRechts, lFTId, nPunkte);
            if (res.next()) {
                oHelper.sTeilenummer = res.getString("Teilenummer");
                oHelper.bIstDiebstahlrelevant = res.getString("Teil_Diebstahlrelevant") != null && res.getString("Teil_Diebstahlrelevant").equals("J");
            }
            federtabelleInfoHilfe = oHelper;
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "FedertabelleInfo.loadFeder");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "FedertabelleInfo.loadFeder");
        return federtabelleInfoHilfe;
    }

    protected class FedertabelleInfoHilfe {
        protected String sTeilenummer = "";
        protected boolean bIstDiebstahlrelevant = false;

        protected FedertabelleInfoHilfe() {
        }
    }
}

