/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fzgid;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidDataException;
import webetk.InvalidInitializationException;
import webetk.LanguageUtils;
import webetk.NoBrandAuthorizationException;
import webetk.NoDataFoundException;
import webetk.WebetkUtils;
import webetk.app.Bedingung;
import webetk.app.ServerGlobalObjects;
import webetk.app.ValueAndNameSupport;
import webetk.app.federtabelle.FTZeile;
import webetk.app.federtabelle.FedertabelleInfo;
import webetk.app.fzgid.FzgIdControlInfo;
import webetk.app.fzgsuche.FzgSucheInfo;
import webetk.db.dbaccess.FzgIdDbAccess;
import webetk.framework.ServerSessionInfo;
import webetk.framework.ServerUserInfo;
import webetk.mrkprd.Marken;
import webetk.mrkprd.MarkenProdukte;
import webetk.mrkprd.Produkte;
import webetk.utils.StringUtils;
import webetk.utils.communication.HtmlUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FzgIdInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(FzgIdInfo.class);
    protected transient ResourceBundle bundle = null;
    static final int ATTR_MARKE = 1;
    static final int ATTR_PRODUKTART = 1;
    static final int ATTR_KATUMFANG = 1;
    static final int ATTR_BAUART = 2;
    static final int ATTR_BAUREIHE = 3;
    static final int ATTR_KAROSSERIE = 4;
    static final int ATTR_MODELL = 5;
    static final int ATTR_REGION = 6;
    static final int ATTR_LENKUNG = 7;
    static final int ATTR_GETRIEBE = 8;
    static final int ATTR_BAUJAHR = 9;
    static final int ATTR_MONAT = 10;
    protected long mlBaureiheGrafikId = -1L;
    protected String selectedVIN17Typ = null;
    protected boolean noDatafoundForVin = false;
    protected HashMap<String, String> duplicateVin7Map = new HashMap();
    protected long mlBaureiheKarosserieGrafikId = -1L;
    protected long mlModellspalte = 0L;
    protected Vector<ValueAndNameSupport> mcBauarten = new Vector();
    protected Vector<ValueAndNameSupport> mcBaureihen = new Vector();
    protected Vector<ValueAndNameSupport> mcKarosserien = new Vector();
    protected Vector<String> mcModelle = new Vector();
    protected Vector<String> mcKatalogRegion = new Vector();
    protected Vector<String> mcDefaultRegionen = new Vector();
    protected Vector<ValueAndNameSupport> mcLenkungen = new Vector();
    protected Vector<ValueAndNameSupport> mcGetriebe = new Vector();
    protected Vector<ValueAndNameSupport> mcBaujahre = new Vector();
    protected Vector<ValueAndNameSupport> mcZulMonate = new Vector();
    protected List<String> mcTypmenge = new ArrayList<String>();
    protected boolean mbAmbivalentRegion = false;
    protected long mnFIGrafikId = -1L;
    protected String msID;
    protected String msMarke = Marken.getInstance().getMarke("BMW").getBerechtigung();
    protected String msProduktart = Produkte.getInstance().getProdukt("AUTO").getBerechtigung();
    protected String msKatalogumfang = "ST";
    protected String msFIGrafikTimestamp = null;
    protected String msBauart = null;
    protected String msBauartBezeichnung = null;
    protected String msBaureihe = null;
    protected String msBaureiheBezeichnung = null;
    protected String msKarosserie = null;
    protected String msKarosserieBezeichnung = null;
    protected String msModell = null;
    protected String msMotor = null;
    protected String msRegion = null;
    protected String msLenkung = null;
    protected String msGetriebe = null;
    protected String msBaujahr = null;
    protected String msProduktionsdatum = null;
    protected String msZulMonat = null;
    protected String msBaureiheGrafikTimestamp = null;
    protected String msBaureiheKarosserieGrafikTimestamp = null;
    protected String msFahrgestellNr = null;
    protected String msWerk = null;
    protected String msLoadLanguage;
    protected long mlEinsatzTyp = 0L;
    protected boolean mbSicherheitsfahrzeug = false;
    protected Vector<Bedingung> mcFgstnrSala = new Vector();
    protected String msDefaultMarke;
    protected String msDefaultProduktart;
    protected String msDefaultKatUmfang;
    protected String msDefaultLenkung;
    protected String msLoadLanguageRegion;
    public ValueAndNameSupport ALLE_WERTE_VALUE = FzgIdInfo.getAlleWerteValueAndName();
    public ValueAndNameSupport NO_RESTRICT_VALUE = FzgIdInfo.getRestrictedValueAndName();
    protected transient PropertyChangeSupport propertyChangeListeners = new PropertyChangeSupport(this);
    protected transient Collection<String> userMarken = new Vector<String>();
    protected transient Collection<String> userProdukte = new Vector<String>();
    protected transient String userKatalogumfang = "";
    protected String msMarketspecSalesdesc = null;

    public boolean isNoDatafoundForVin() {
        return this.noDatafoundForVin;
    }

    public void setNoDatafoundForVin(boolean noDatafoundForVin) {
        this.noDatafoundForVin = noDatafoundForVin;
    }

    public String getSelectedVIN17Typ() {
        return this.selectedVIN17Typ;
    }

    public void setSelectedVIN17Typ(String selectedVIN17Typ) {
        this.selectedVIN17Typ = selectedVIN17Typ;
    }

    public HashMap<String, String> getDuplicateVin7Map() {
        return this.duplicateVin7Map;
    }

    public void setDuplicateVin7Map(HashMap<String, String> duplicateVin7Map) {
        this.duplicateVin7Map = duplicateVin7Map;
    }

    public FzgIdInfo() {
        this.msID = Long.toString(System.currentTimeMillis());
        this.mbAmbivalentRegion = false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws InvalidInitializationException {
        this.msID = Long.toString(System.currentTimeMillis());
        this.mnFIGrafikId = -1L;
        this.msFIGrafikTimestamp = "";
        Connection con = null;
        ResultSet res = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("FzgIdInfo.FzgIdInfo");
            res = FzgIdDbAccess.getFIGrafikId(con, this.userMarken, this.userProdukte, this.userKatalogumfang);
            if (res != null && res.next()) {
                this.mnFIGrafikId = res.getLong("GrafikId");
                this.msFIGrafikTimestamp = res.getString("ModStamp");
            } else {
                this.mnFIGrafikId = 0L;
                this.msFIGrafikTimestamp = "0";
            }
            if (this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
                this.updateBaureihen();
            } else {
                this.updateBauarten();
            }
        }
        catch (SQLException e) {
            try {
                log.error("Database access error! FIGrafikId could not be loaded!", e);
                throw new InvalidInitializationException("UserInfo is invalid. Not all values are set!");
                catch (DatabaseBusyException e2) {
                    log.error("Database is busy! FIGrafikId could not be loaded!", e2);
                    throw new InvalidInitializationException("UserInfo is invalid. Not all values are set!");
                }
            }
            catch (Throwable throwable) {
                try {
                    WebetkUtils.closeQuery(res);
                    ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.FzgIdInfo");
                    throw throwable;
                }
                catch (SQLException e3) {
                    log.warn("could not close connection.", e3);
                }
                throw throwable;
            }
        }
        try {
            WebetkUtils.closeQuery(res);
            ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.FzgIdInfo");
        }
        catch (SQLException e) {
            log.warn("could not close connection.", e);
        }
        log.log(Level.ALL, "Instantiated FzgId: " + this.toLogString());
    }

    private void resetCollections() {
        this.mcBauarten = new Vector();
        this.mcBaureihen = new Vector();
        this.mcKarosserien = new Vector();
        this.mcModelle = new Vector();
        this.mcDefaultRegionen = new Vector();
        this.mcKatalogRegion = new Vector();
        this.mcLenkungen = new Vector();
        this.mcGetriebe = new Vector();
        this.mcBaujahre = new Vector();
        this.mcZulMonate = new Vector();
    }

    public void init(Collection<String> cUserMarken, Collection<String> sUserProdukte, String sUserKatalogumfang, String sMarke, String sProduktart, String sKatalogumfang, Collection<String> cDefaultRegionen, String sDefaultLenkung, ResourceBundle bundle, boolean bRequiresCompleteFzgId) throws InvalidInitializationException {
        this.bundle = bundle;
        String sSprache = bundle.getLocale().getLanguage();
        this.init(cUserMarken, sUserProdukte, sUserKatalogumfang, sMarke, sProduktart, sKatalogumfang, cDefaultRegionen, sDefaultLenkung, sSprache, null, bRequiresCompleteFzgId);
    }

    public void init(Collection<String> cUserMarken, Collection<String> sUserProdukte, String sUserKatalogumfang, String sMarke, String sProduktart, String sKatalogumfang, Collection<String> cDefaultRegionen, String sDefaultLenkung, String sSprache, String sSpracheRegion, boolean bRequiresCompleteFzgId) throws InvalidInitializationException {
        this.resetCollections();
        this.userMarken = cUserMarken;
        this.userProdukte = sUserProdukte;
        this.userKatalogumfang = sUserKatalogumfang;
        this.msDefaultMarke = sMarke;
        this.msMarke = sMarke;
        this.msDefaultProduktart = sProduktart;
        this.msProduktart = sProduktart;
        this.msDefaultKatUmfang = sKatalogumfang;
        this.msKatalogumfang = sKatalogumfang;
        this.msDefaultLenkung = sDefaultLenkung;
        this.msLenkung = sDefaultLenkung;
        this.msLoadLanguage = sSpracheRegion == null ? sSprache : LanguageUtils.toCompoundLanguage(sSprache, sSpracheRegion);
        this.mlBaureiheGrafikId = -1L;
        this.mlBaureiheKarosserieGrafikId = -1L;
        this.mbAmbivalentRegion = false;
        this.mcDefaultRegionen.addAll(cDefaultRegionen);
        this.mcKatalogRegion.addAll(cDefaultRegionen);
        if (!this.checkAllValues()) {
            log.error("One of the default values is not set! UserInfo is not correctly loaded!");
            throw new InvalidInitializationException("UserInfo is invalid. Not all values are set!");
        }
        this.init();
    }

    private boolean checkAllValues() {
        boolean bAllClear = this.msDefaultMarke != null && !this.msDefaultMarke.equalsIgnoreCase("");
        bAllClear &= this.msDefaultProduktart != null && !this.msDefaultProduktart.equalsIgnoreCase("");
        bAllClear &= this.msDefaultKatUmfang != null && !this.msDefaultKatUmfang.equalsIgnoreCase("");
        bAllClear &= this.msDefaultLenkung != null && !this.msDefaultLenkung.equalsIgnoreCase("");
        return bAllClear &= this.msLoadLanguage != null && !this.msLoadLanguage.equalsIgnoreCase("");
    }

    public FzgIdInfo(ServerSessionInfo sessionInfo) throws InvalidInitializationException {
        this.resetCollections();
        if (sessionInfo == null) {
            log.error("Parameter sessionInfo is null!!");
            throw new InvalidInitializationException("SessionInfo is null!");
        }
        ServerUserInfo userInfo = sessionInfo.getUserInfo();
        if (userInfo == null) {
            log.error("Parameter userInfo is null!!");
            throw new InvalidInitializationException("UserInfo is null!");
        }
        this.bundle = sessionInfo.getBundle();
        log.debug("Initializing FzgIdInfo with defaults from: " + userInfo.toString());
        this.msMarke = this.msDefaultMarke = userInfo.getMarke();
        this.msProduktart = this.msDefaultProduktart = userInfo.getProduktart();
        this.msKatalogumfang = this.msDefaultKatUmfang = userInfo.getKatalogumfang();
        this.msLenkung = this.msDefaultLenkung = userInfo.getLenkung();
        this.msLoadLanguage = LanguageUtils.toCompoundLanguage(userInfo.getSprache(), userInfo.getSpracheRegion());
        this.mlBaureiheGrafikId = -1L;
        this.mlBaureiheKarosserieGrafikId = -1L;
        this.mbAmbivalentRegion = false;
        this.mcDefaultRegionen.addAll(userInfo.getRegionen());
        this.mcKatalogRegion.addAll(userInfo.getRegionen());
        if (!this.checkAllValues()) {
            log.error("One of the default values is not set! UserInfo is not correctly loaded!");
            throw new InvalidInitializationException("UserInfo is invalid. Not all values are set!");
        }
        this.userMarken = sessionInfo.getUserMarken();
        FzgIdControlInfo ctrlFluss = sessionInfo.getFzgIdControlInfo();
        this.userProdukte = sessionInfo.getUserProdukte();
        if (ctrlFluss != null && ctrlFluss.requiresCompleteFzgId()) {
            this.userProdukte.clear();
            this.userProdukte.add(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
        }
        this.userKatalogumfang = sessionInfo.getUserKatUmfang();
        this.init();
    }

    public void setMajorAttributes(String sMarke, String sProdukt, String sKatalogumfang) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        if (!MarkenProdukte.getInstance(1).isMarke(sMarke)) {
            log.error("Invalid Parameter Marke: " + sMarke);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        this.msMarke = sMarke;
        if (!MarkenProdukte.getInstance(1).isProdukt(sProdukt)) {
            log.error("Invalid Parameter Produktart: " + sProdukt);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        this.msProduktart = sProdukt;
        if (!sKatalogumfang.equalsIgnoreCase("VT") && !sKatalogumfang.equalsIgnoreCase("ST")) {
            log.error("Invalid Parameter Katalogumfang: " + sKatalogumfang);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        this.msKatalogumfang = sKatalogumfang;
        if (this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.updateBaureihen();
        } else {
            this.updateBauarten();
        }
    }

    public void setMarke(String sMarke) {
        this.msMarke = sMarke;
    }

    public void setProduktart(String sProduktart) {
        this.msProduktart = sProduktart;
    }

    public void setMarke(String sMarke, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        if (!MarkenProdukte.getInstance(1).isMarke(sMarke)) {
            log.error("Invalid Parameter Marke: " + sMarke);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldMarke = this.msMarke;
        this.msMarke = sMarke;
        if (this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.updateBaureihen();
        } else {
            this.updateBauarten();
        }
        this.propertyChangeListeners.firePropertyChange("marke", oldMarke, this.msMarke);
    }

    public String getMarke() {
        return this.msMarke;
    }

    public void setProduktart(String sProduktart, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        if (Produkte.getInstance().getProduktZurProduktBerechtigung(sProduktart) == null) {
            log.error("Invalid Parameter Produktart: " + sProduktart);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldPArt = this.msProduktart;
        this.msProduktart = sProduktart;
        if (this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.updateBaureihen();
        } else {
            this.updateBauarten();
        }
        this.propertyChangeListeners.firePropertyChange("produktart", oldPArt, this.msProduktart);
    }

    public String getProduktart() {
        return this.msProduktart;
    }

    public String getProduktionsdatum(boolean bTagesgenau) {
        if (this.msProduktionsdatum != null && bTagesgenau) {
            return this.msProduktionsdatum;
        }
        if (this.msProduktionsdatum != null && !bTagesgenau) {
            return this.msProduktionsdatum.substring(0, 4) + this.msProduktionsdatum.substring(5, 7) + "00";
        }
        if (this.msBaujahr != null && this.msZulMonat != null) {
            return this.msBaujahr + this.msZulMonat + "00";
        }
        return null;
    }

    public boolean isProduktionsdatumTagesgenau() {
        return this.msProduktionsdatum != null && this.msProduktionsdatum.length() == 8;
    }

    public void setKatalogumfang(String sKatalogumfang, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        if (!sKatalogumfang.equalsIgnoreCase("VT") && !sKatalogumfang.equalsIgnoreCase("ST")) {
            log.error("Invalid Parameter Katalogumfang: " + sKatalogumfang);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldKatUmfang = this.msKatalogumfang;
        this.msKatalogumfang = sKatalogumfang;
        if (this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            this.updateBaureihen();
        } else {
            this.updateBauarten();
        }
        this.propertyChangeListeners.firePropertyChange("katalogumfang", oldKatUmfang, this.msKatalogumfang);
    }

    public void setKatalogumfang(String sKatUmfang) {
        this.msKatalogumfang = sKatUmfang;
    }

    public String getKatalogumfang() {
        return this.msKatalogumfang;
    }

    public void setBauart(String sBauart, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcBauarten.iterator(), sBauart);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Bauart: " + sBauart);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldBauart = this.msBauart;
        this.msBauart = oFoundValue.getValue();
        this.msBauartBezeichnung = oFoundValue.getName();
        this.updateBaureihen();
        this.propertyChangeListeners.firePropertyChange("bauart", oldBauart, this.msBauart);
        if (this.getBaureihen().size() == 1) {
            Iterator<ValueAndNameSupport> iter = this.getBaureihen().iterator();
            ValueAndNameSupport oBaureihe = iter.next();
            this.setBaureihe(oBaureihe.getValue(), bComplete);
        }
    }

    public void setBauart(String sBauart) {
        this.msBauart = sBauart;
    }

    public String getBauart() {
        return this.msBauart;
    }

    public String getBauartBezeichnung() {
        return this.msBauartBezeichnung;
    }

    public void setBauartBezeichnung(String sBauartBez) {
        this.msBauartBezeichnung = sBauartBez;
    }

    public void setBaureihe(String sBaureihe, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcBaureihen.iterator(), sBaureihe);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Baureihe: " + sBaureihe);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldBaureihe = this.msBaureihe;
        this.msBaureihe = oFoundValue.getValue();
        this.msBaureiheBezeichnung = oFoundValue.getName();
        this.initializeGrafikIdForBaureihe();
        if (this.getProduktart().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            this.msKarosserie = "ohne";
            this.initAttributes(4);
            this.mcKarosserien.add(new ValueAndNameSupport(this.msKarosserie, this.msKarosserie));
            this.updateModelle();
            this.propertyChangeListeners.firePropertyChange("baureihe", oldBaureihe, this.msBaureihe);
            if (this.getModelle().size() == 1) {
                Iterator<String> iter = this.getModelle().iterator();
                String sModell = iter.next();
                this.setModell(sModell, bComplete);
            }
        } else {
            this.updateKarosserien();
            this.propertyChangeListeners.firePropertyChange("baureihe", oldBaureihe, this.msBaureihe);
            if (this.getKarosserien().size() == 1) {
                Iterator<ValueAndNameSupport> iter = this.getKarosserien().iterator();
                ValueAndNameSupport oKarosse = iter.next();
                this.setKarosserie(oKarosse.getValue(), bComplete);
            }
        }
    }

    public String getBaureihe() {
        return this.msBaureihe;
    }

    public String getBaureiheBezeichnung() {
        return this.msBaureiheBezeichnung;
    }

    public void setBaureiheBezeichnung(String sBaureiheBezeichnung) {
        this.msBaureiheBezeichnung = sBaureiheBezeichnung;
    }

    public void setKarosserie(String sKarosserie, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcKarosserien.iterator(), sKarosserie);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Karosserie: " + sKarosserie);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldKaro = this.msKarosserie;
        this.msKarosserie = oFoundValue.getValue();
        this.msKarosserieBezeichnung = oFoundValue.getName();
        this.initializeGrafikIdForBaureiheKarosserie();
        this.updateModelle();
        this.propertyChangeListeners.firePropertyChange("karosserie", oldKaro, this.msKarosserie);
        if (this.getModelle().size() == 1) {
            Iterator<String> iter = this.getModelle().iterator();
            String sModell = iter.next();
            this.setModell(sModell, bComplete);
        }
    }

    public void setKarosserie(String sKarosserie) {
        this.msKarosserie = sKarosserie;
    }

    public String getKarosserie() {
        return this.msKarosserie;
    }

    public String getKarosserieBezeichnung() {
        return this.msKarosserieBezeichnung;
    }

    public void setKarosserieBezeichnung(String sKarosserieBezeichnung) {
        this.msKarosserieBezeichnung = sKarosserieBezeichnung;
    }

    public void setModell(String sModell, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcModelle.iterator(), sModell);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Modell: " + sModell);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldModell = this.msModell;
        this.msModell = oFoundValue.getValue();
        this.updateRegionen();
        this.propertyChangeListeners.firePropertyChange("modell", oldModell, this.msModell);
        if (this.getRegionen().size() == 1) {
            Iterator<String> iter = this.getRegionen().iterator();
            String sRegion = iter.next();
            this.setRegion(sRegion, bComplete);
        }
    }

    public void setModell(String sModell) {
        this.msModell = sModell;
    }

    public String getModell() {
        return this.msModell;
    }

    public void setRegion(String sRegion, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcKatalogRegion.iterator(), sRegion);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Region: " + sRegion);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldRegion = this.msRegion;
        this.msRegion = oFoundValue.getValue();
        if (this.getProduktart().equals(Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung())) {
            this.msLenkung = "kA";
            this.msGetriebe = "kA";
            this.initAttributes(7);
            this.mcLenkungen.add(new ValueAndNameSupport("kA", "kA"));
            this.mcGetriebe.add(new ValueAndNameSupport("kA", "kA"));
            this.updateBaujahre();
            this.propertyChangeListeners.firePropertyChange("region", oldRegion, this.msRegion);
            if (this.getBaujahre().size() == 1) {
                this.setBaujahr(this.getBaujahre().get(0).getValue(), bComplete);
            } else if (!bComplete) {
                this.mcBaujahre.add(0, this.ALLE_WERTE_VALUE);
                this.setBaujahr("AlleWerte", bComplete);
            }
        } else {
            ValueAndNameSupport oLenkung;
            Iterator<ValueAndNameSupport> iter;
            this.updateLenkungen();
            this.propertyChangeListeners.firePropertyChange("region", oldRegion, this.msRegion);
            if (this.getDefaultLenkung() != null && !this.getDefaultLenkung().equalsIgnoreCase("kA")) {
                iter = this.mcLenkungen.iterator();
                oLenkung = null;
                while (iter.hasNext() && oLenkung == null) {
                    oLenkung = iter.next();
                    if (oLenkung.getValue().equalsIgnoreCase(this.getDefaultLenkung())) continue;
                    oLenkung = null;
                }
                if (oLenkung != null) {
                    this.mcLenkungen = new Vector();
                    this.mcLenkungen.add(oLenkung);
                }
            }
            if (this.getLenkungen().size() == 1) {
                iter = this.getLenkungen().iterator();
                oLenkung = iter.next();
                this.setLenkung(oLenkung.getValue(), bComplete);
            } else if (!bComplete) {
                this.mcLenkungen.add(0, this.ALLE_WERTE_VALUE);
                this.setLenkung("AlleWerte", bComplete);
            }
        }
    }

    public void setRegion(String sRegion) {
        this.msRegion = sRegion;
    }

    public String getRegion() {
        return this.msRegion;
    }

    public void setLenkung(String sLenkung, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        if (sLenkung.equals("kA")) {
            this.msLenkung = null;
            this.initAttributes(8);
            return;
        }
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcLenkungen.iterator(), sLenkung);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Lenkung: " + sLenkung);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldLenkung = this.msLenkung;
        this.msLenkung = oFoundValue.getValue();
        this.updateGetriebe();
        this.propertyChangeListeners.firePropertyChange("lenkung", oldLenkung, this.msLenkung);
        if (this.getGetriebewerte().size() == 1) {
            Iterator<ValueAndNameSupport> iter = this.getGetriebewerte().iterator();
            ValueAndNameSupport oGetriebe = iter.next();
            this.setGetriebe(oGetriebe.getValue(), bComplete);
        } else if (!bComplete) {
            this.mcGetriebe.add(0, this.ALLE_WERTE_VALUE);
            this.setGetriebe("AlleWerte", bComplete);
        }
    }

    public void setLenkung(String sLenkung) {
        this.msLenkung = sLenkung;
    }

    public String getLenkung() {
        return this.msLenkung;
    }

    public void setGetriebe(String sGetriebe, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        if (sGetriebe.equals("kA")) {
            this.msGetriebe = null;
            this.initAttributes(9);
            return;
        }
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcGetriebe.iterator(), sGetriebe);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Getriebe: " + sGetriebe);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldGetriebe = this.msGetriebe;
        this.msGetriebe = oFoundValue.getValue();
        this.updateBaujahre();
        this.propertyChangeListeners.firePropertyChange("getriebe", oldGetriebe, this.msGetriebe);
        if (this.getBaujahre().size() == 1) {
            String sBaujahr = this.getBaujahre().iterator().next().getValue();
            this.setBaujahr(sBaujahr, bComplete);
        } else if (!bComplete) {
            this.mcBaujahre.add(0, this.ALLE_WERTE_VALUE);
            this.setBaujahr("AlleWerte", bComplete);
        }
    }

    public void setGetriebe(String sGetriebe) {
        this.msGetriebe = sGetriebe;
    }

    public String getGetriebe() {
        return this.msGetriebe;
    }

    public void setBaujahr(String sBaujahr, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        if (sBaujahr.equals("kA")) {
            this.msBaujahr = null;
            this.initAttributes(10);
            return;
        }
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcBaujahre.iterator(), sBaujahr);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Baujahr: " + sBaujahr);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldBaujahr = this.msBaujahr;
        this.msBaujahr = oFoundValue.getValue();
        this.updateZulassungsmonate();
        this.propertyChangeListeners.firePropertyChange("baujahr", oldBaujahr, this.msBaujahr);
        if (this.getZulassungsmonate().size() == 1) {
            Iterator<ValueAndNameSupport> iter = this.getZulassungsmonate().iterator();
            ValueAndNameSupport oMonat = iter.next();
            this.setZulMonat(oMonat.getValue(), bComplete);
        } else if (!bComplete) {
            this.mcZulMonate.add(0, this.ALLE_WERTE_VALUE);
            this.setZulMonat("AlleWerte", bComplete);
        }
    }

    public void setBaujahr(String sBaujahr) {
        this.msBaujahr = sBaujahr;
    }

    public void setBaureihe(String sBaureihe) {
        this.msBaureihe = sBaureihe;
    }

    public String getBaujahr() {
        return this.msBaujahr;
    }

    public void setZulMonat(String sZulMonat, boolean bComplete) throws IllegalArgumentException, SQLException, DatabaseBusyException {
        if (sZulMonat.equals("kA")) {
            this.msZulMonat = null;
            return;
        }
        ValueAndNameSupport oFoundValue = this.checkValidityOfSelectedValue(this.mcZulMonate.iterator(), sZulMonat);
        if (oFoundValue == null) {
            log.error("Invalid Parameter Zulassungsmonat: " + sZulMonat);
            throw new IllegalArgumentException(this.getGeneralErrorMsg());
        }
        String oldMonat = this.msZulMonat;
        this.msZulMonat = oFoundValue.getValue();
        this.propertyChangeListeners.firePropertyChange("zulMonat", oldMonat, this.msZulMonat);
    }

    public Vector<ValueAndNameSupport> getZulMonate() {
        return this.mcZulMonate;
    }

    public void setZulMonat(String sZulMonat) {
        this.msZulMonat = sZulMonat;
    }

    public String getZulMonat() {
        return this.msZulMonat;
    }

    public String getProduktionsdatum() {
        return this.msProduktionsdatum;
    }

    public Vector<ValueAndNameSupport> getBauarten() {
        return this.mcBauarten;
    }

    public void setBauarten(Vector<ValueAndNameSupport> cBauarten) {
        this.mcBauarten = cBauarten;
    }

    public Vector<ValueAndNameSupport> getBaureihen() {
        return this.mcBaureihen;
    }

    public void setBaureihen(Vector<ValueAndNameSupport> cBaureihen) {
        this.mcBaureihen = cBaureihen;
    }

    public Vector<ValueAndNameSupport> getKarosserien() {
        return this.mcKarosserien;
    }

    public void setKarosserien(Vector<ValueAndNameSupport> cKarosserien) {
        this.mcKarosserien = cKarosserien;
    }

    public Vector<String> getModelle() {
        return this.mcModelle;
    }

    public void setModelle(Vector<String> cModelle) {
        this.mcModelle = cModelle;
    }

    public Vector<String> getRegionen() {
        return this.mcKatalogRegion;
    }

    public void setRegionen(Vector<String> cRegionen) {
        this.mcKatalogRegion = cRegionen;
    }

    public Vector<ValueAndNameSupport> getLenkungen() {
        return this.mcLenkungen;
    }

    public void setLenkungen(Vector<ValueAndNameSupport> cLenkungen) {
        this.mcLenkungen = cLenkungen;
    }

    public Vector<ValueAndNameSupport> getGetriebewerte() {
        return this.mcGetriebe;
    }

    public void setGetriebewerte(Vector<ValueAndNameSupport> cGetriebe) {
        this.mcGetriebe = cGetriebe;
    }

    public Vector<ValueAndNameSupport> getBaujahre() {
        return this.mcBaujahre;
    }

    public void setBaujahre(Vector<ValueAndNameSupport> cBaujahre) {
        this.mcBaujahre = cBaujahre;
    }

    public Vector<ValueAndNameSupport> getZulassungsmonate() {
        return this.mcZulMonate;
    }

    public void setZulassungsmonate(Vector<ValueAndNameSupport> cZulMonate) {
        this.mcZulMonate = cZulMonate;
    }

    public void setProduktionsdatum(String sProduktionsdatum) {
        this.msProduktionsdatum = sProduktionsdatum;
        if (this.msProduktionsdatum != null) {
            this.msBaujahr = this.msProduktionsdatum.substring(0, 4);
            this.msZulMonat = this.msProduktionsdatum.substring(4, 6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long ermittleModellspalte() throws SQLException, DatabaseBusyException {
        Connection con = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("FzgIdInfo.ermittleModellspalte");
            log.debug("Calculating Modellspalte ...");
            this.mlModellspalte = this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) ? FzgIdDbAccess.selectModellspalte(con, this.getBaureihe(), this.getKarosserie(), this.getModell(), this.getRegion()) : FzgIdDbAccess.selectModellspalte(con, this.getBaureihe(), this.getModell(), this.getRegion());
            log.debug("Modellspalte calculated: " + Long.toString(this.mlModellspalte));
        }
        finally {
            ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.ermittleModellspalte");
        }
        return this.getModellspalte();
    }

    public String toString(boolean bDisplayProdDate, String sLCode, String sAFCode) {
        boolean bGetriebeHasValue;
        String sRepString = "";
        boolean bBaujahrHasValue = this.msBaujahr != null && !this.msBaujahr.equals("kA") && !this.msBaujahr.equals("AlleWerte");
        boolean bMonatHasValue = this.msZulMonat != null && !this.msZulMonat.equals("kA") && !this.msZulMonat.equals("AlleWerte");
        boolean bLenkungHasValue = this.msLenkung != null && !this.msLenkung.equals("kA") && !this.msLenkung.equals("AlleWerte");
        boolean bl = bGetriebeHasValue = this.msGetriebe != null && !this.msGetriebe.equals("kA") && !this.msGetriebe.equals("AlleWerte");
        if (this.msFahrgestellNr != null) {
            sRepString = this.msFahrgestellNr + " ";
            if (this.getTyp() != null) {
                sRepString = sRepString + this.getTyp() + " ";
            }
            if (sLCode != null) {
                sRepString = sRepString + sLCode + " ";
            }
            if (sAFCode != null) {
                sRepString = sRepString + sAFCode + " ";
            }
        }
        sRepString = sRepString + this.msBaureiheBezeichnung + " ";
        if (this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            sRepString = sRepString + this.msKarosserieBezeichnung + " ";
        }
        sRepString = this.msMarketspecSalesdesc == null ? sRepString + this.msModell : sRepString + this.msMarketspecSalesdesc;
        if (!this.mbAmbivalentRegion) {
            sRepString = sRepString + " " + this.msRegion;
        }
        if (this.msFahrgestellNr == null) {
            if (bBaujahrHasValue) {
                sRepString = sRepString + " " + this.msBaujahr;
            }
            sRepString = bBaujahrHasValue && bMonatHasValue ? sRepString + "/" : sRepString + " ";
            if (bMonatHasValue) {
                sRepString = sRepString + this.msZulMonat;
            }
        }
        if (bLenkungHasValue) {
            sRepString = sRepString + " " + this.msLenkung;
        }
        if (bGetriebeHasValue) {
            sRepString = sRepString + " " + this.msGetriebe;
        }
        if (this.msFahrgestellNr != null && bDisplayProdDate) {
            if (bBaujahrHasValue) {
                sRepString = sRepString + " " + this.msBaujahr;
            }
            sRepString = bBaujahrHasValue && bMonatHasValue ? sRepString + "/" : sRepString + " ";
            if (bMonatHasValue) {
                sRepString = sRepString + this.msZulMonat;
            }
        }
        return sRepString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void identifyByFgstnr(String sFahrgestellNr, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, String sCurrentLang) throws SQLException, DatabaseBusyException, InvalidDataException, NoDataFoundException, NoBrandAuthorizationException {
        ResultSet res;
        Connection con;
        block12: {
            con = null;
            res = null;
            int count = 0;
            try {
                con = ServerGlobalObjects.getInstance().getDBConnection("FzgIdInfo.identifyByFgstnr");
                String typeCode = this.getSelectedVIN17Typ();
                log.debug("Calculating Modellspalte and Attributes ...");
                res = FzgIdDbAccess.selectFzgIdDatenByFgstnr(con, sFahrgestellNr, sCurrentLang, typeCode);
                if (res == null) {
                    log.warn("No data found for " + sFahrgestellNr);
                    throw new NoDataFoundException("No values found");
                }
                if (HtmlUtils.isConnectionSourceOracle(con)) {
                    this.fillObject(con, sFahrgestellNr, res, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang);
                    break block12;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                int i = 0;
                String previousVinNumber = "";
                String previousVinType = "";
                boolean vinExist = false;
                while (res.next()) {
                    String str = null;
                    vinExist = true;
                    String vinTypeCode = res.getString("Typ");
                    if (!previousVinNumber.equalsIgnoreCase(sFahrgestellNr) || !previousVinType.equalsIgnoreCase(vinTypeCode)) {
                        str = vinTypeCode + "!" + res.getString("ExtBaureihe") + "!" + res.getString("Modell") + "!" + res.getString("Region");
                        previousVinNumber = sFahrgestellNr;
                        previousVinType = vinTypeCode;
                        map.put(sFahrgestellNr + i, str);
                        ++i;
                        ++count;
                        continue;
                    }
                    ++i;
                }
                while (i > 0) {
                    res.previous();
                    --i;
                }
                if (!vinExist) {
                    this.setNoDatafoundForVin(true);
                } else {
                    this.setNoDatafoundForVin(false);
                }
                boolean duplicate = false;
                if (count == 1 && !duplicate) {
                    this.fillObject(con, sFahrgestellNr, res, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang);
                    break block12;
                }
                if (count <= true) break block12;
                if (sFahrgestellNr.length() == 17) {
                    String sType = sFahrgestellNr.substring(3, 7);
                    this.identifyByFgstnrDuplicate(sFahrgestellNr, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang, sType);
                    break block12;
                }
                this.setDuplicateVin7Map(map);
                duplicate = true;
                WebetkUtils.closeQuery(res);
                ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.identifyByFgstnr");
                return;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.identifyByFgstnr");
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.identifyByFgstnr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void identifyByFgstnrDuplicate(String sFahrgestellNr, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, String sCurrentLang, String sType) throws SQLException, DatabaseBusyException, InvalidDataException, NoDataFoundException, NoBrandAuthorizationException {
        ResultSet res;
        Connection con;
        block11: {
            con = null;
            res = null;
            int count = 0;
            try {
                con = ServerGlobalObjects.getInstance().getDBConnection("FzgIdInfo.identifyByFgstnr");
                String typeCode = sType;
                log.debug("Calculating Modellspalte and Attributes ...");
                res = FzgIdDbAccess.selectFzgIdDatenByFgstnr(con, sFahrgestellNr, sCurrentLang, typeCode);
                if (res == null) {
                    log.warn("No data found for " + sFahrgestellNr);
                    throw new NoDataFoundException("No values found");
                }
                if (HtmlUtils.isConnectionSourceOracle(con)) {
                    this.fillObject(con, sFahrgestellNr, res, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang);
                    break block11;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                int i = 0;
                String previousVinNumber = "";
                String previousVinType = "";
                boolean vinExist = false;
                while (res.next()) {
                    String str = null;
                    vinExist = true;
                    String vinTypeCode = res.getString("Typ");
                    if (!previousVinNumber.equalsIgnoreCase(sFahrgestellNr) || !previousVinType.equalsIgnoreCase(vinTypeCode)) {
                        str = vinTypeCode + "!" + res.getString("ExtBaureihe") + "!" + res.getString("Modell") + "!" + res.getString("Region");
                        previousVinNumber = sFahrgestellNr;
                        previousVinType = vinTypeCode;
                        map.put(sFahrgestellNr + i, str);
                        ++i;
                        ++count;
                        continue;
                    }
                    ++i;
                }
                while (i > 0) {
                    res.previous();
                    --i;
                }
                if (!vinExist) {
                    this.setNoDatafoundForVin(true);
                } else {
                    this.setNoDatafoundForVin(false);
                }
                boolean duplicate = false;
                if (count == 1 && !duplicate) {
                    this.fillObject(con, sFahrgestellNr, res, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang);
                    break block11;
                }
                if (count <= true) break block11;
                this.setDuplicateVin7Map(map);
                duplicate = true;
                WebetkUtils.closeQuery(res);
                ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.identifyByFgstnr");
                return;
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.identifyByFgstnr");
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.identifyByFgstnr");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void identifyByTyp(String sFahrgestellNr, String sTyp, String sProdDatum, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, String sCurrentLang) throws SQLException, DatabaseBusyException, InvalidDataException, NoDataFoundException, NoBrandAuthorizationException {
        Connection con = null;
        ResultSet res = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("FzgIdInfo.identifyByTyp");
            log.debug("Calculating Modellspalte and Attributes ...");
            res = FzgIdDbAccess.selectFzgIdDatenByTyp(con, sTyp, sProdDatum, sFahrgestellNr, sCurrentLang);
            if (res == null || !res.next()) {
                log.warn("Query for Typ did not return a valid resultset!");
                throw new NoDataFoundException("No values found");
            }
            this.fillObject(con, sFahrgestellNr, res, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang);
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.identifyByTyp");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.identifyByTyp");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillObject(Connection con, String sFahrgestellNr, ResultSet res, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, String sCurrentLang) throws NoDataFoundException, InvalidDataException, NoBrandAuthorizationException {
        ResultSet resSala = null;
        try {
            String sRegion;
            String sMarke = res.getString("Marke");
            String sPArt = res.getString("Produktart");
            String sKatalogumfang = res.getString("Katalogumfang");
            if (aUserMarken != null && !aUserMarken.isEmpty() && aUserProdukte != null && !aUserProdukte.isEmpty() && sUserKatalogumfang != null) {
                boolean bKatalogumfangOK;
                boolean bMarkeOK = aUserMarken.contains(sMarke);
                boolean bPArtOK = aUserProdukte.contains(sPArt);
                boolean bl = bKatalogumfangOK = sUserKatalogumfang.equals(sKatalogumfang) || sUserKatalogumfang.equals("ALLE");
                if (!(bMarkeOK && bPArtOK && bKatalogumfangOK)) {
                    log.warn("Query for Fahrgestellnummer did not return a valid values due to restrictions on user brand and product!");
                    throw new NoBrandAuthorizationException("Brand, Product Type or Catalogue does not match with the vehicle!");
                }
            }
            this.msMarke = sMarke;
            this.msProduktart = sPArt;
            this.msKatalogumfang = sKatalogumfang;
            this.msBauart = res.getString("Bauart");
            this.msBauartBezeichnung = res.getString("ExtBauart");
            this.msBaureihe = res.getString("Baureihe");
            this.msBaureiheBezeichnung = res.getString("ExtBaureihe");
            this.msKarosserie = res.getString("Karosserie");
            this.msKarosserieBezeichnung = res.getString("ExtKarosserie");
            this.msModell = res.getString("Modell");
            this.msRegion = res.getString("Region");
            this.msLenkung = res.getString("Lenkung");
            this.msGetriebe = res.getString("Getriebe");
            this.mlModellspalte = res.getLong("Modellspalte");
            this.msMotor = res.getString("Motor");
            String sSichtschutz = res.getString("Sichtschutz");
            if (sSichtschutz == null) {
                sSichtschutz = "N";
            }
            this.mbSicherheitsfahrzeug = sSichtschutz.equals("J");
            this.msFahrgestellNr = sFahrgestellNr;
            this.msWerk = res.getString("Werk");
            this.mlEinsatzTyp = res.getLong("Einsatz");
            String sProduktionsdatum = res.getString("Produktionsdatum");
            if (sProduktionsdatum.length() != 0) {
                this.msBaujahr = sProduktionsdatum.substring(0, 4);
                this.msZulMonat = sProduktionsdatum.substring(4, 6);
            } else {
                this.msBaujahr = "";
                this.msZulMonat = "";
            }
            this.mcTypmenge = new Vector<String>();
            this.mcTypmenge.add(res.getString("Typ"));
            if (!this.checkConsistency()) {
                String sMsg = "Calculation with returned inconsistent data!";
                log.error(sMsg);
                throw new InvalidDataException(sMsg);
            }
            if (res.next() && !(sRegion = res.getString("Region")).equals(this.msRegion)) {
                this.mbAmbivalentRegion = true;
            }
            resSala = FzgIdDbAccess.selectSalasZuFahrgestellnummer(con, sFahrgestellNr, sCurrentLang);
            while (resSala != null && resSala.next()) {
                Long lId = new Long(resSala.getLong("ElementId"));
                String sBedCode = resSala.getString("Code");
                String sBedName = resSala.getString("Benennung");
                boolean bExclusiveGruppe = resSala.getString("Exklusiv").equalsIgnoreCase("J");
                String sGruppe = bExclusiveGruppe ? resSala.getString("EGruppenId") : null;
                long lGruppenPos = resSala.getLong("EGruppenPosition");
                String sPrimaNr = resSala.getString("PrimaNr");
                String sIsSicher = resSala.getString("Sicher");
                boolean bIsSicher = sIsSicher != null && sIsSicher.equalsIgnoreCase("J");
                String sIsSAZ = resSala.getString("SAZ");
                boolean bIsSAZ = sIsSAZ != null && sIsSAZ.equalsIgnoreCase("J");
                String sHasBedZusatzInfo = resSala.getString("HasBedText");
                boolean bHasBedZusatzInfo = sHasBedZusatzInfo.equals("J");
                String sShowBedZusatzInfo = resSala.getString("ShowBedText");
                boolean bShowBedZusatzInfo = sShowBedZusatzInfo.equals("J");
                Bedingung oBedingung = new Bedingung(lId, sBedCode, sBedName, sGruppe, lGruppenPos, sPrimaNr);
                oBedingung.isSicherheitsrelevant(bIsSicher);
                oBedingung.isSAZ(bIsSAZ);
                if (bIsSicher) {
                    this.mbSicherheitsfahrzeug = true;
                }
                oBedingung.showBedZusatzInfo(bShowBedZusatzInfo);
                oBedingung.hasBedZusatzInfo(bHasBedZusatzInfo);
                this.mcFgstnrSala.add(oBedingung);
            }
        }
        catch (RuntimeException e) {
            try {
                log.error(e.getMessage());
                throw new NoDataFoundException(e.getMessage());
                catch (Exception e2) {
                    if (e2 instanceof NoBrandAuthorizationException) {
                        throw new NoBrandAuthorizationException(e2.getMessage());
                    }
                    log.error(e2.getMessage());
                    throw new NoDataFoundException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(resSala);
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(resSala);
    }

    protected boolean checkConsistency() {
        if (this.msMarke == null || !MarkenProdukte.getInstance(1).isMarke(this.msMarke)) {
            log.info("Consistency failed because of invalid Marke: " + this.msMarke);
            return false;
        }
        if (this.msProduktart == null || !MarkenProdukte.getInstance(1).isProdukt(this.msProduktart)) {
            log.info("Consistency failed because of invalid Produktart: " + this.msProduktart);
            return false;
        }
        if (this.msKatalogumfang == null || !this.msKatalogumfang.equals("VT") && !this.msKatalogumfang.equals("ST")) {
            log.info("Consistency failed because of invalid Katalogumfang: " + this.msKatalogumfang);
            return false;
        }
        if (this.msProduktart.equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            if (this.msBaureihe == null || this.msKarosserie == null || this.msModell == null || this.msRegion == null) {
                log.info("Consistency failed because one of the attributes Baureihe, Karosserie, Modell or Region is null!");
                return false;
            }
        } else if (this.msBauart == null || this.msBaureihe == null || this.msModell == null || this.msRegion == null) {
            log.info("Consistency failed because one of the attributes Baureihe, Karosserie, Modell or Region is null!");
            return false;
        }
        if (!(this.msLenkung == null || this.msLenkung.equals("kA") || this.msLenkung.equals("AlleWerte") || this.msLenkung.equals("L") || this.msLenkung.equals("R"))) {
            log.info("Consistency failed because of invalid Lenkung: " + this.msLenkung);
            return false;
        }
        if (!(this.msGetriebe == null || this.msGetriebe.equals("kA") || this.msGetriebe.equals("AlleWerte") || this.msGetriebe.equals("A") || this.msGetriebe.equals("M") || this.msGetriebe.equals("N"))) {
            log.info("Consistency failed because of invalid Getriebe: " + this.msGetriebe);
            return false;
        }
        if (this.msBaujahr != null && !this.msBaujahr.equals("kA") && !this.msBaujahr.equals("AlleWerte")) {
            try {
                int nBaujahr = Integer.parseInt(this.msBaujahr);
                if (nBaujahr > 2500 || nBaujahr > 99 && nBaujahr < 1800) {
                    log.info("Consistency failed because of invalid Baujahr: " + this.msBaujahr);
                    return false;
                }
            }
            catch (RuntimeException e) {
                log.info("Consistency failed because of invalid Baujahr: " + this.msBaujahr);
                return false;
            }
            catch (Exception e) {
                log.info("Consistency failed because of invalid Baujahr: " + this.msBaujahr);
                return false;
            }
        }
        if (this.msZulMonat != null && !this.msZulMonat.equals("kA") && !this.msZulMonat.equals("AlleWerte")) {
            try {
                int nMonat = Integer.parseInt(this.msZulMonat);
                if (nMonat < 1 || nMonat > 12) {
                    log.info("Consistency failed because of invalid Zulassungsmonat: " + this.msZulMonat);
                    return false;
                }
            }
            catch (RuntimeException e) {
                log.info("Consistency failed because of invalid Zulassungsmonat: " + this.msZulMonat);
                return false;
            }
            catch (Exception e) {
                log.info("Consistency failed because of invalid Zulassungsmonat: " + this.msZulMonat);
                return false;
            }
        }
        return true;
    }

    public boolean isSicherheitsfahrzeug() {
        return this.mbSicherheitsfahrzeug;
    }

    public void isSicherheitsfahrzeug(boolean bSicherheitsfahrzeug) {
        this.mbSicherheitsfahrzeug = bSicherheitsfahrzeug;
    }

    public Vector<Bedingung> getFgstnrSalas() {
        return this.mcFgstnrSala;
    }

    public void setFgstnrSalas(Vector<Bedingung> cFgstnrSala) {
        this.mcFgstnrSala = cFgstnrSala;
    }

    public String getFahrgestellNr() {
        return this.msFahrgestellNr;
    }

    public void getFahrgestellNr(String sFahrgestellNr) {
        this.msFahrgestellNr = sFahrgestellNr;
    }

    public String getWerk() {
        return this.msWerk;
    }

    public void setWerk(String sWerk) {
        this.msWerk = sWerk;
    }

    public long getEinsatzTyp() {
        return this.mlEinsatzTyp;
    }

    public void setEinsatzTyp(long lEinsatzTyp) {
        this.mlEinsatzTyp = lEinsatzTyp;
    }

    public void resetFahrgestellNr() {
        this.msFahrgestellNr = null;
    }

    public void finalize(FzgSucheInfo oSucheInfo, boolean bDisplayProdDate, String sLCode, String sAFCode) throws SQLException, DatabaseBusyException, NoDataFoundException {
        this.ermittleModellspalte();
        if (!this.ermittleTypmenge()) {
            log.debug("FzgIdInfo is not complete 'vollst\u00e4ndig'. No Typmenge retrieved.");
        }
        if (oSucheInfo != null) {
            this.resetFahrgestellNr();
            this.initFzgSucheInfo(oSucheInfo, bDisplayProdDate, sLCode, sAFCode);
        }
    }

    public long getModellspalte() {
        return this.mlModellspalte;
    }

    public void setModellspalte(long lModellspalte) {
        this.mlModellspalte = lModellspalte;
    }

    public String getLoadLanguage() {
        return this.msLoadLanguage;
    }

    public void setLoadLanguage(String sLoadLanguage) {
        this.msLoadLanguage = sLoadLanguage;
    }

    public String getLoadLanguageRegion() {
        return this.msLoadLanguageRegion;
    }

    public void setLoadLanguageRegion(String sLoadLanguageRegion) {
        this.msLoadLanguageRegion = sLoadLanguageRegion;
    }

    public void setDefaultMarke(String sMarke) {
        this.msDefaultMarke = sMarke;
    }

    public String getDefaultMarke() {
        return this.msDefaultMarke;
    }

    public void setDefaultProduktart(String sProduktart) {
        this.msDefaultProduktart = this.msProduktart;
    }

    public String getDefaultProduktart() {
        return this.msDefaultProduktart;
    }

    public void setDefaultKatUmfang(String sKatUmfang) {
        this.msDefaultKatUmfang = sKatUmfang;
    }

    public String getDefaultKatUmfang() {
        return this.msDefaultKatUmfang;
    }

    public void setDefaultLenkung(String sLenkung) {
        this.msDefaultLenkung = sLenkung;
    }

    public String getDefaultLenkung() {
        return this.msDefaultLenkung;
    }

    public void setDefaultRegionen(Collection<String> cRegionen) {
        if (this.mcDefaultRegionen == null) {
            this.mcDefaultRegionen = new Vector();
        }
        this.mcDefaultRegionen.clear();
        this.mcDefaultRegionen.addAll(cRegionen);
    }

    public Vector<String> getDefaultRegionen() {
        return this.mcDefaultRegionen;
    }

    public String toStringRegionen() {
        return this.toStringRegionen(" ");
    }

    public String toStringRegionen(String sSeparator) {
        String sRegions = "";
        if (this.mcDefaultRegionen == null) {
            return sRegions;
        }
        for (String sReg : this.mcDefaultRegionen) {
            if (sRegions.length() > 0) {
                sRegions = sRegions + sSeparator;
            }
            sRegions = sRegions + sReg;
        }
        return sRegions;
    }

    public void parseRegionen(String sRegionen) {
        this.parseRegionen(sRegionen, " ");
    }

    public void parseRegionen(String sRegionen, String sSeparator) {
        Vector<String> cRegionen = new Vector<String>();
        StringTokenizer regTokens = new StringTokenizer(sRegionen, sSeparator);
        while (regTokens.hasMoreTokens()) {
            cRegionen.add(regTokens.nextToken());
        }
        this.mcDefaultRegionen = cRegionen;
    }

    protected void initAttributes(int nAttr) {
        log.debug("Resetting values from attribute: " + Integer.toString(nAttr));
        switch (nAttr) {
            case 1: {
                break;
            }
            case 2: {
                this.mcBauarten = new Vector();
                this.msBauart = null;
                this.initAttributes(3);
                break;
            }
            case 3: {
                this.mcBaureihen = new Vector();
                this.msBaureihe = null;
                this.msBaureiheBezeichnung = null;
                this.mlBaureiheGrafikId = -1L;
                this.initAttributes(4);
                break;
            }
            case 4: {
                this.mcKarosserien = new Vector();
                this.msKarosserie = null;
                this.mlBaureiheKarosserieGrafikId = -1L;
                this.initAttributes(5);
                break;
            }
            case 5: {
                this.mcModelle = new Vector();
                this.msModell = null;
                this.initAttributes(6);
                break;
            }
            case 6: {
                this.mcKatalogRegion = new Vector();
                this.msRegion = null;
                break;
            }
            case 7: {
                this.mcLenkungen = new Vector();
                this.msLenkung = this.msDefaultLenkung;
                break;
            }
            case 8: {
                this.mcGetriebe = new Vector();
                this.msGetriebe = null;
                break;
            }
            case 9: {
                this.mcBaujahre = new Vector();
                this.msBaujahr = null;
                break;
            }
            default: {
                this.mcZulMonate = new Vector();
                this.msZulMonat = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBauarten() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(2);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgIdInfo.updateBauarten");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectBauarten(con, this.getLoadLanguage(), this.getDefaultRegionen(), this.getMarke(), this.getProduktart(), this.getKatalogumfang());
            while (res != null && res.next()) {
                String sValue = res.getString("Bauart");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtBauart");
                if (res.wasNull()) {
                    log.warn("NULL name retrieved! Using value instead: " + sValue);
                    sName = sValue;
                }
                this.mcBauarten.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateBauarten");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateBauarten");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBaureihen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(3);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgIdInfo.updateBaureihen");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectBaureihen(con, this.getLoadLanguage(), this.getDefaultRegionen(), this.getDefaultLenkung(), this.getMarke(), this.getProduktart(), this.getKatalogumfang(), this.getBauart());
            while (res != null && res.next()) {
                String sValue = res.getString("Baureihe");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtBaureihe");
                if (res.wasNull()) {
                    log.warn("NULL name retrieved! Using value instead: " + sValue);
                    sName = sValue;
                }
                this.mcBaureihen.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateBaureihen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateBaureihen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateKarosserien() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(4);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgInfoId.updateKarosserien");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectKarosserien(con, this.getLoadLanguage(), this.getProduktart(), this.getDefaultRegionen(), this.getDefaultLenkung(), this.getKatalogumfang(), this.getBaureihe());
            while (res != null && res.next()) {
                String sValue = res.getString("Karosserie");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtKarosserie");
                if (res.wasNull()) {
                    log.warn("NULL name retrieved! Using value instead: " + sValue);
                    sName = sValue;
                }
                this.mcKarosserien.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateKarosserien");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateKarosserien");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModelle() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(5);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgInfoId.updateModelle");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectModelle(con, this.getProduktart(), this.getDefaultRegionen(), this.getDefaultLenkung(), this.getKatalogumfang(), this.getBaureihe(), this.getKarosserie());
            while (res != null && res.next()) {
                String sValue = res.getString("Modell");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                this.mcModelle.add(sValue);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateModelle");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateModelle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRegionen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(6);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgInfoId.updateRegionen");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectRegionen(con, this.getProduktart(), this.getDefaultRegionen(), this.getDefaultLenkung(), this.getKatalogumfang(), this.getBaureihe(), this.getKarosserie(), this.getModell());
            while (res != null && res.next()) {
                String sValue = res.getString("Region");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                this.mcKatalogRegion.add(sValue);
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateRegionen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateRegionen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLenkungen() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(7);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgInfoId.updateLenkungen");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectLenkungen(con, this.getLoadLanguage(), this.getKatalogumfang(), this.getBaureihe(), this.getKarosserie(), this.getModell(), this.getRegion());
            while (res != null && res.next()) {
                String sValue = res.getString("Lenkung");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtLenkung");
                if (res.wasNull()) {
                    log.warn("NULL name retrieved! Using value instead: " + sValue);
                    sName = sValue;
                }
                this.mcLenkungen.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateLenkungen");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateLenkungen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateGetriebe() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(8);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgInfoId.updateGetriebe");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectGetriebe(con, this.getLoadLanguage(), this.getKatalogumfang(), this.getBaureihe(), this.getKarosserie(), this.getModell(), this.getRegion(), this.getLenkung());
            while (res != null && res.next()) {
                String sValue = res.getString("Getriebe");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtGetriebe");
                if (res.wasNull()) {
                    log.warn("NULL name retrieved! Using value instead: " + sValue);
                    sName = sValue;
                }
                this.mcGetriebe.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateGetriebe");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateGetriebe");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBaujahre() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(9);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgInfoId.updateBaujahre");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectBaujahre(con, this.getProduktart(), this.getKatalogumfang(), this.getBaureihe(), this.getKarosserie(), this.getModell(), this.getRegion(), this.getLenkung(), this.getGetriebe());
            while (res != null && res.next()) {
                String sValue = res.getString("Baujahr");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                this.mcBaujahre.add(new ValueAndNameSupport(sValue, sValue));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateBaujahre");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateBaujahre");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateZulassungsmonate() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        this.initAttributes(10);
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("FzgInfoId.updateZulassungsmonate");
            log.debug("Executing query ...");
            res = FzgIdDbAccess.selectZulassungsmonate(con, this.getLoadLanguage(), this.getProduktart(), this.getKatalogumfang(), this.getBaureihe(), this.getKarosserie(), this.getModell(), this.getRegion(), this.getLenkung(), this.getGetriebe(), this.getBaujahr());
            while (res != null && res.next()) {
                String sValue = res.getString("Zulassungsmonat");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                    continue;
                }
                String sName = res.getString("ExtZulassungsmonat");
                if (res.wasNull()) {
                    log.warn("NULL name retrieved! Using value instead: " + sValue);
                    sName = sValue;
                }
                this.mcZulMonate.add(new ValueAndNameSupport(sValue, sName));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "FzgIdInfo.updateZulassungsmonate");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.updateZulassungsmonate");
    }

    protected void convertToCompleteFzgId() {
        if (this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            if (this.getBaureihe() == null || this.getBaureihe().equals("kA")) {
                return;
            }
            if (this.getKarosserie() == null || this.getKarosserie().equals("kA")) {
                return;
            }
        } else {
            if (this.getBauart() == null || this.getBauart().equals("kA")) {
                return;
            }
            if (this.getBaureihe() == null || this.getBaureihe().equals("kA")) {
                return;
            }
        }
        if (this.getModell() == null || this.getModell().equals("kA")) {
            return;
        }
        if (this.getRegion() == null || this.getRegion().equals("kA")) {
            return;
        }
        if (this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            if (this.getLenkung() == null || this.getLenkung().equals("kA")) {
                return;
            }
            if (this.getLenkung().equals("AlleWerte")) {
                this.initForComplete(7);
            }
            if (this.getGetriebe() == null || this.getGetriebe().equals("kA")) {
                return;
            }
            if (this.getGetriebe().equals("AlleWerte")) {
                this.initForComplete(8);
            }
        }
        if (this.getBaujahr() == null || this.getBaujahr().equals("kA")) {
            return;
        }
        if (this.getBaujahr().equals("AlleWerte")) {
            this.initForComplete(9);
        }
        if (this.getZulMonat() == null || this.getZulMonat().equals("kA")) {
            return;
        }
        if (this.getZulMonat().equals("AlleWerte")) {
            this.initForComplete(10);
        }
    }

    public boolean isComplete() {
        boolean bProduktAuto;
        boolean bComplete = true;
        boolean bl = bProduktAuto = this.getProduktart() != null && this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
        if (!bProduktAuto) {
            bComplete &= this.getBauart() != null;
        }
        bComplete &= this.getMarke() != null;
        bComplete &= this.getProduktart() != null;
        bComplete &= this.getKatalogumfang() != null;
        bComplete &= this.getBaureihe() != null;
        if (bProduktAuto) {
            bComplete &= this.getKarosserie() != null;
        }
        bComplete &= this.getModell() != null;
        bComplete &= this.getRegion() != null;
        bComplete &= this.getBaujahr() != null && !this.getBaujahr().equals("kA");
        bComplete &= this.getZulMonat() != null && !this.getZulMonat().equals("kA");
        if (!bProduktAuto) {
            return bComplete;
        }
        bComplete &= this.getLenkung() != null && !this.getLenkung().equals("kA");
        return bComplete &= this.getGetriebe() != null && !this.getGetriebe().equals("kA");
    }

    public String getBaureiheGrafikId() {
        return this.mlBaureiheGrafikId > 0L ? Long.toString(this.mlBaureiheGrafikId) : null;
    }

    public void setBaureiheGrafikId(String sBaureiheGrafikId) {
        this.mlBaureiheGrafikId = sBaureiheGrafikId == null ? -1L : Long.parseLong(sBaureiheGrafikId);
    }

    public String getBaureiheGrafikTimestamp() {
        return this.msBaureiheGrafikTimestamp;
    }

    public void setBaureiheGrafikTimestamp(String sBaureiheGrafikTimestamp) {
        this.msBaureiheGrafikTimestamp = sBaureiheGrafikTimestamp;
    }

    public String getBaureiheKarosserieGrafikId() {
        return this.mlBaureiheKarosserieGrafikId > 0L ? Long.toString(this.mlBaureiheKarosserieGrafikId) : null;
    }

    public void setBaureiheKarosserieGrafikId(String sBaureiheKarosserieGrafikId) {
        this.mlBaureiheKarosserieGrafikId = sBaureiheKarosserieGrafikId == null ? -1L : Long.parseLong(sBaureiheKarosserieGrafikId);
    }

    public String getBaureiheKarosserieGrafikTimestamp() {
        return this.msBaureiheKarosserieGrafikTimestamp;
    }

    public void setBaureiheKarosserieGrafikTimestamp(String sBaureiheKarosserieGrafikTimestamp) {
        this.msBaureiheKarosserieGrafikTimestamp = sBaureiheKarosserieGrafikTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeGrafikIdForBaureihe() throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block4: {
            globs = ServerGlobalObjects.getInstance();
            if (this.msBaureihe == null || this.msBaureihe.length() == 0) {
                this.mlBaureiheGrafikId = -1L;
                log.info("No Baureihe selekted. Resetting grafic id to -1!");
                return;
            }
            con = null;
            res = null;
            log.debug("Accessing database to retrieve grafic id ...");
            try {
                con = globs.getDBConnection("FzgInfoId.initializeGrafikIdForBaureihe");
                log.debug("Executing query ...");
                res = FzgIdDbAccess.getBaureiheGrafikId(con, this.getBaureihe());
                if (res != null && res.next()) {
                    this.mlBaureiheGrafikId = res.getLong("GrafikId");
                    this.msBaureiheGrafikTimestamp = res.getString("ModStamp");
                    log.debug("Grafik-Id <" + Long.toString(this.mlBaureiheGrafikId) + ">, Timestamp: " + this.msBaureiheGrafikTimestamp);
                    break block4;
                }
                this.mlBaureiheGrafikId = -1L;
                this.msBaureiheGrafikTimestamp = null;
                log.debug("No Grafik-Id found for Baureihe: " + this.msBaureihe);
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                globs.freeDBConnection(con, "FzgIdInfo.initializeGrafikIdForBaureihe");
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.initializeGrafikIdForBaureihe");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeGrafikIdForBaureiheKarosserie() throws SQLException, DatabaseBusyException {
        ResultSet res;
        Connection con;
        ServerGlobalObjects globs;
        block4: {
            globs = ServerGlobalObjects.getInstance();
            if (!(this.msBaureihe != null && this.msBaureihe.length() != 0 || this.msKarosserie != null && this.msKarosserie.length() != 0)) {
                this.mlBaureiheKarosserieGrafikId = -1L;
                log.info("No Baureihe and Karosserie selekted. Resetting grafic id to -1!");
                return;
            }
            con = null;
            res = null;
            log.debug("Accessing database to retrieve grafic id ...");
            try {
                con = globs.getDBConnection("FzgInfoId.initializeGrafikIdForBaureiheKarosserie");
                log.debug("Executing query ...");
                res = FzgIdDbAccess.getBaureiheKarosserieGrafikId(con, this.getBaureihe(), this.getKarosserie());
                if (res != null && res.next()) {
                    this.mlBaureiheKarosserieGrafikId = res.getLong("GrafikId");
                    this.msBaureiheKarosserieGrafikTimestamp = res.getString("ModStamp");
                    log.debug("Grafik-Id <" + Long.toString(this.mlBaureiheKarosserieGrafikId) + ">, Timestamp: " + this.msBaureiheKarosserieGrafikTimestamp);
                    break block4;
                }
                this.mlBaureiheKarosserieGrafikId = -1L;
                this.msBaureiheKarosserieGrafikTimestamp = null;
                log.debug("No Grafik-Id found for Baureihe/Karosserie: " + this.msBaureihe + "/" + this.msKarosserie);
            }
            catch (Throwable throwable) {
                WebetkUtils.closeQuery(res);
                globs.freeDBConnection(con, "FzgIdInfo.initializeGrafikIdForBaureiheKarosserie");
                throw throwable;
            }
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "FzgIdInfo.initializeGrafikIdForBaureiheKarosserie");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean ermittleTypmenge() throws SQLException, DatabaseBusyException, NoDataFoundException {
        if (!this.isCompletelyIdentified()) {
            return false;
        }
        Connection con = null;
        ResultSet res = null;
        try {
            con = ServerGlobalObjects.getInstance().getDBConnection("FzgIdInfo.ermittleTypmenge");
            log.debug("Calculating Typemenge ...");
            res = this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung()) ? FzgIdDbAccess.selectTypmenge(con, this.getModellspalte(), this.getLenkung(), this.getGetriebe(), this.getBaujahr(), this.getZulMonat()) : FzgIdDbAccess.selectTypmenge(con, this.getModellspalte(), this.getBaujahr(), this.getZulMonat());
            if (res == null) {
                log.warn("Query for Typmenge did not return a valid resultset!");
                throw new NoDataFoundException("No values found");
            }
            this.mcTypmenge = new Vector<String>();
            while (res.next()) {
                String sTyp = res.getString("Typ");
                if (res.wasNull()) {
                    log.error("***ERROR: NULL value retrieved!");
                }
                this.mcTypmenge.add(sTyp);
            }
            if (this.mcTypmenge.isEmpty()) {
                log.warn("Query for Typmenge did not return any values!");
                throw new NoDataFoundException("No values found");
            }
            log.debug("Typmenge retreived.");
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.ermittleTypmenge");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        ServerGlobalObjects.getInstance().freeDBConnection(con, "FzgIdInfo.ermittleTypmenge");
        return true;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.removePropertyChangeListener(l);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeListeners.addPropertyChangeListener(l);
    }

    protected String getTyp() {
        if (this.mcTypmenge == null || this.mcTypmenge.isEmpty()) {
            return null;
        }
        Iterator<String> iter = this.mcTypmenge.iterator();
        try {
            return iter.next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public List<String> getTypmenge() {
        if (this.mcTypmenge == null) {
            return new ArrayList<String>();
        }
        return this.mcTypmenge;
    }

    public void setTypmenge(List<String> cTypmenge) {
        this.mcTypmenge = cTypmenge;
    }

    public FzgSucheInfo initFzgSucheInfo(FzgSucheInfo fzgSuche, boolean bDisplayProdDate, String sLCode, String sAFCode) {
        fzgSuche.setModellspalte(this.getModellspalte());
        fzgSuche.setMarke(this.getMarke());
        fzgSuche.setProduktart(this.getProduktart());
        fzgSuche.setKatalogumfang(this.getKatalogumfang());
        fzgSuche.setBauart(this.getBauart());
        fzgSuche.setBauartBezeichnung(this.getBauartBezeichnung());
        fzgSuche.setBaureihe(this.getBaureihe());
        fzgSuche.setBaureiheBezeichnung(this.getBaureiheBezeichnung());
        fzgSuche.setKarosserie(this.getKarosserie());
        fzgSuche.setKarosserieBezeichnung(this.getKarosserieBezeichnung());
        fzgSuche.setModell(this.getModell());
        fzgSuche.setRegion(this.getRegion());
        fzgSuche.setMotor(this.getMotor());
        fzgSuche.setLenkung(this.getLenkung());
        fzgSuche.setGetriebe(this.getGetriebe());
        fzgSuche.setBaujahr(this.getBaujahr());
        fzgSuche.setZulassungsmonat(this.getZulMonat());
        fzgSuche.setFzgIdString(this.toString(bDisplayProdDate, sLCode, sAFCode));
        fzgSuche.setFahrgestellnummer(this.getFahrgestellNr());
        fzgSuche.setWerk(this.getWerk());
        fzgSuche.isSicherheitsfahrzeug(this.isSicherheitsfahrzeug());
        fzgSuche.setTypmenge(this.getTypmenge());
        return fzgSuche;
    }

    public FzgSucheInfo setFahrgestellNr(String sFahrgestellNr, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, FzgSucheInfo oSucheInfo, String sCurrentLang, boolean bDisplayProdDate, String sLCode, String sAFCode) throws SQLException, DatabaseBusyException, InvalidDataException, NoDataFoundException, NoBrandAuthorizationException {
        this.identifyByFgstnr(sFahrgestellNr, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang);
        if (oSucheInfo != null) {
            this.initFzgSucheInfo(oSucheInfo, bDisplayProdDate, sLCode, sAFCode);
            return oSucheInfo;
        }
        return null;
    }

    public long ermittleModellspalte(FzgSucheInfo oSucheInfo, boolean bDisplayProdDate, String sLCode, String sAFCode) throws SQLException, DatabaseBusyException {
        long lMS = this.ermittleModellspalte();
        if (oSucheInfo != null) {
            this.resetFahrgestellNr();
            this.initFzgSucheInfo(oSucheInfo, bDisplayProdDate, sLCode, sAFCode);
        }
        return lMS;
    }

    public boolean isCompletelyIdentified() {
        if (!this.checkConsistency()) {
            return false;
        }
        boolean bComplete = true;
        boolean bProduktAuto = this.getProduktart() != null && this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung());
        bComplete &= this.getMarke() != null && this.getProduktart() != null && this.getKatalogumfang() != null && this.getBaureihe() != null && this.getModell() != null && this.getRegion() != null;
        bComplete = bProduktAuto ? (bComplete &= this.getKarosserie() != null) : (bComplete &= this.getBauart() != null);
        bComplete &= this.getBaujahr() != null && !this.getBaujahr().equals("kA");
        bComplete &= this.getZulMonat() != null && !this.getZulMonat().equals("kA");
        bComplete &= this.getBaujahr() != null && !this.getBaujahr().equals("AlleWerte") && !this.getBaujahr().equals("kA");
        bComplete &= this.getZulMonat() != null && !this.getZulMonat().equals("AlleWerte") && !this.getZulMonat().equals("kA");
        if (!bProduktAuto) {
            return bComplete;
        }
        bComplete &= this.getLenkung() != null && !this.getLenkung().equals("AlleWerte") && !this.getLenkung().equals("kA");
        return bComplete &= this.getGetriebe() != null && !this.getGetriebe().equals("AlleWerte") && !this.getGetriebe().equals("kA");
    }

    public boolean isCompletelyIdentifiedFedernAspgVIN() {
        String sFgstnr = this.msFahrgestellNr;
        if (!StringUtils.isEmpty(sFgstnr, true)) {
            return true;
        }
        String sMarke = this.getMarke();
        List<String> cTypen = this.getTypmenge();
        String sProduktionsdatum = this.getProduktionsdatum(true);
        boolean bIsTagesgenau = this.isProduktionsdatumTagesgenau();
        Vector<Object> cSalaIds = new Vector<Object>();
        FedertabelleInfo oFTInfo = new FedertabelleInfo(sMarke);
        try {
            oFTInfo.performFedertabelleEval(cTypen, sProduktionsdatum, bIsTagesgenau, cSalaIds, this, null);
        }
        catch (Exception e) {
            return true;
        }
        Collection<FTZeile> zeilen = oFTInfo.getFTZeilen().getZeilen();
        for (FTZeile zeile : zeilen) {
            String sTyp = zeile.getTyp();
            if (!sTyp.equals("--")) continue;
            return false;
        }
        return true;
    }

    public boolean isNormallyIdentified() {
        return this.checkConsistency() && this.isComplete();
    }

    public void finalize(String sFahrgestellNr, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, FzgSucheInfo oSucheInfo, String sCurrentLang, boolean bDisplayProdDate, String sLCode, String sAFCode) throws SQLException, DatabaseBusyException, NoDataFoundException, InvalidDataException, NoBrandAuthorizationException {
        this.identifyByFgstnr(sFahrgestellNr, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang);
        if (oSucheInfo != null) {
            this.initFzgSucheInfo(oSucheInfo, bDisplayProdDate, sLCode, sAFCode);
        }
    }

    public void finalize(String sFahrgestellNr, String sTyp, String sProdDatum, Collection<String> aUserMarken, Collection<String> aUserProdukte, String sUserKatalogumfang, FzgSucheInfo oSucheInfo, String sCurrentLang, boolean bDisplayProdDate, String sLCode, String sAFCode, String marketspecSalesdesc) throws SQLException, DatabaseBusyException, NoDataFoundException, InvalidDataException, NoBrandAuthorizationException {
        this.identifyByTyp(sFahrgestellNr, sTyp, sProdDatum, aUserMarken, aUserProdukte, sUserKatalogumfang, sCurrentLang);
        this.msMarketspecSalesdesc = marketspecSalesdesc;
        if (oSucheInfo != null) {
            this.initFzgSucheInfo(oSucheInfo, bDisplayProdDate, sLCode, sAFCode);
        }
    }

    protected void convertToNormalFzgId() throws SQLException, DatabaseBusyException {
        if (this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            if (this.getBaureihe() == null || this.getBaureihe().equals("kA")) {
                return;
            }
            if (this.getKarosserie() == null || this.getKarosserie().equals("kA")) {
                return;
            }
        } else {
            if (this.getBauart() == null || this.getBauart().equals("kA")) {
                return;
            }
            if (this.getBaureihe() == null || this.getBaureihe().equals("kA")) {
                return;
            }
        }
        if (this.getModell() == null || this.getModell().equals("kA")) {
            return;
        }
        if (this.getRegion() == null || this.getRegion().equals("kA")) {
            return;
        }
        if (this.getProduktart().equals(Produkte.getInstance().getProdukt("AUTO").getBerechtigung())) {
            if (this.getLenkung() == null || this.getLenkung().equals("kA")) {
                this.initForNormal(7);
            }
            if (this.getGetriebe() == null || this.getGetriebe().equals("kA")) {
                this.initForNormal(8);
            }
        }
        if (this.getBaujahr() == null || this.getBaujahr().equals("kA")) {
            this.initForNormal(9);
        }
        if (this.getZulMonat() == null || this.getZulMonat().equals("kA")) {
            this.initForNormal(10);
        }
    }

    public void adjust(boolean bComplete) throws SQLException, DatabaseBusyException {
        if (bComplete) {
            this.convertToCompleteFzgId();
        } else {
            this.convertToNormalFzgId();
        }
    }

    protected void initForComplete(int nAttr) {
        log.debug("Resetting values to complete from attribute: " + Integer.toString(nAttr));
        switch (nAttr) {
            case 7: {
                this.msLenkung = "kA";
                this.setGeneralValue(this.NO_RESTRICT_VALUE, this.ALLE_WERTE_VALUE, this.getLenkungen());
                nAttr = 8;
                break;
            }
            case 8: {
                this.msGetriebe = "kA";
                this.setGeneralValue(this.NO_RESTRICT_VALUE, this.ALLE_WERTE_VALUE, this.getGetriebewerte());
                nAttr = 9;
                break;
            }
            case 9: {
                this.msBaujahr = "kA";
                this.setGeneralValue(this.NO_RESTRICT_VALUE, this.ALLE_WERTE_VALUE, this.getBaujahre());
                nAttr = 10;
                break;
            }
            case 10: {
                this.msZulMonat = "kA";
                this.setGeneralValue(this.NO_RESTRICT_VALUE, this.ALLE_WERTE_VALUE, this.getZulassungsmonate());
                return;
            }
            default: {
                return;
            }
        }
        this.initAttributes(nAttr);
    }

    protected void initForNormal(int nAttr) throws SQLException, DatabaseBusyException {
        log.debug("Resetting values to normal from attribute: " + Integer.toString(nAttr));
        switch (nAttr) {
            case 7: {
                this.setGeneralValue(this.ALLE_WERTE_VALUE, this.NO_RESTRICT_VALUE, this.getLenkungen());
                this.setLenkung("AlleWerte", false);
                return;
            }
            case 8: {
                this.setGeneralValue(this.ALLE_WERTE_VALUE, this.NO_RESTRICT_VALUE, this.getGetriebewerte());
                this.setGetriebe("AlleWerte", false);
                return;
            }
            case 9: {
                this.setGeneralValue(this.ALLE_WERTE_VALUE, this.NO_RESTRICT_VALUE, this.getBaujahre());
                this.setBaujahr("AlleWerte", false);
                return;
            }
            case 10: {
                this.setGeneralValue(this.ALLE_WERTE_VALUE, this.NO_RESTRICT_VALUE, this.getZulassungsmonate());
                this.setZulMonat("AlleWerte", false);
                return;
            }
        }
    }

    protected void setGeneralValue(ValueAndNameSupport oVal, ValueAndNameSupport oSubst, Vector<ValueAndNameSupport> vCol) {
        try {
            ValueAndNameSupport oFirstVal = vCol.get(0);
            if (oFirstVal.getValue().equals(oVal.getValue())) {
                return;
            }
            if (oFirstVal.getValue().equals(oSubst.getValue())) {
                vCol.remove(0);
            }
        }
        catch (ClassCastException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return;
        }
        vCol.add(0, oVal);
    }

    protected String getGeneralErrorMsg() {
        return "A general error has occured!";
    }

    protected static ValueAndNameSupport getRestrictedValueAndName() {
        return new ValueAndNameSupport("kA", "kA");
    }

    protected static ValueAndNameSupport getAlleWerteValueAndName() {
        return new ValueAndNameSupport("AlleWerte", "AlleWerte");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultLenkungBen(ServerUserInfo userInfo) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        try {
            con = gObj.getDBConnection("FzgIdInfo.getDefaultLenkungBen");
            String sLang = userInfo.getSprache();
            String sCountry = userInfo.getSpracheRegion();
            if (sCountry == null || sCountry.length() < 2) {
                sCountry = "  ";
            }
            String string = FzgIdDbAccess.selectLenkungBen(con, sLang, sCountry, this.msDefaultLenkung);
            return string;
        }
        finally {
            gObj.freeDBConnection(con, "FzgIdInfo.getDefaultLenkungBen");
        }
    }

    public String getFIGrafikTimestamp() {
        return this.msFIGrafikTimestamp;
    }

    public void setFIGrafikTimestamp(String sFIGrafikTimestamp) {
        this.msFIGrafikTimestamp = sFIGrafikTimestamp;
    }

    public String getFIGrafikId() {
        return this.mnFIGrafikId > 0L ? Long.toString(this.mnFIGrafikId) : null;
    }

    public void setFIGrafikId(String sFIGrafikId) {
        this.mnFIGrafikId = sFIGrafikId == null ? -1L : Long.parseLong(sFIGrafikId);
    }

    public String getMotor() {
        return this.msMotor;
    }

    public void setMotor(String sMotor) {
        this.msMotor = sMotor;
    }

    private ValueAndNameSupport checkValidityOfSelectedValue(Iterator iter, String sValue) {
        ValueAndNameSupport oFoundValueForName = null;
        while (iter.hasNext()) {
            Object oObject = iter.next();
            if (oObject instanceof String) {
                String sObject = (String)oObject;
                if (!sValue.equalsIgnoreCase((String)oObject)) continue;
                return new ValueAndNameSupport(sObject, sObject);
            }
            ValueAndNameSupport vandn = (ValueAndNameSupport)oObject;
            if (sValue.equalsIgnoreCase(vandn.getValue())) {
                return vandn;
            }
            if (!sValue.equalsIgnoreCase(vandn.getName())) continue;
            oFoundValueForName = vandn;
        }
        return oFoundValueForName;
    }

    public boolean isAmbivalentRegion() {
        return this.mbAmbivalentRegion;
    }

    public void setAmbivalentRegion(boolean bAmbivalentRegion) {
        this.mbAmbivalentRegion = bAmbivalentRegion;
    }

    public void setALLE_WERTE_VALUE(ValueAndNameSupport sWert) {
        this.ALLE_WERTE_VALUE = sWert;
    }

    public void setNO_RESTRICT_VALUE(ValueAndNameSupport sWert) {
        this.NO_RESTRICT_VALUE = sWert;
    }

    public void setFahrgestellNr(String sFgstnr) {
        this.msFahrgestellNr = sFgstnr;
    }

    public void cleanMajorAttributes() {
        this.initAttributes(2);
        this.initAttributes(3);
        this.initAttributes(4);
        this.initAttributes(5);
        this.initAttributes(6);
    }

    public String toLogString() {
        String sString = super.toString();
        sString = sString + "[Marke (" + this.msMarke + "), ";
        sString = sString + "Defaultmarke (" + this.msDefaultMarke + "), ";
        sString = sString + "PArt (" + this.msProduktart + "), ";
        sString = sString + "DefaultPArt (" + this.msDefaultProduktart + "), ";
        sString = sString + "KatUmfang (" + this.msKatalogumfang + "), ";
        sString = sString + "DefaultKatUmfang (" + this.msDefaultKatUmfang + "), ";
        sString = sString + "Lenkung (" + this.msLenkung + "), ";
        sString = sString + "Defaultlenkung (" + this.msDefaultLenkung + "), ";
        sString = sString + "Sprache (" + this.msLoadLanguage + "), ";
        sString = sString + "Regionen (" + Integer.toString(this.mcDefaultRegionen.size()) + "), ";
        sString = sString + "Regionen (" + Integer.toString(this.mcKatalogRegion.size()) + ")]";
        return sString;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public Collection<String> getUserMarke() {
        return this.userMarken;
    }

    public void setUserMarken(Collection<String> userMarken) {
        this.userMarken = userMarken;
    }

    public Collection<String> getUserProduktart() {
        return this.userProdukte;
    }

    public void setUserProduktart(Collection<String> userProdukte) {
        this.userProdukte = userProdukte;
    }

    public String getUserKatalogumfang() {
        return this.userKatalogumfang;
    }

    public void setUserKatalogumfang(String userKatalogumfang) {
        this.userKatalogumfang = userKatalogumfang;
    }

    public String getMsMarketspecSalesdesc() {
        return this.msMarketspecSalesdesc;
    }

    public void setMsMarketspecSalesdesc(String msMarketspecSalesdesc) {
        this.msMarketspecSalesdesc = msMarketspecSalesdesc;
    }
}

