/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.fzgsuche;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import webetk.ThreadSafeSimpleDateFormat;
import webetk.app.Bedingungsmenge;
import webetk.app.SucheInfo;
import webetk.app.ausstattung.Ausstattung;
import webetk.utils.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="webetk.app.fzgsuche.FzgSucheInfo")
public class FzgSucheInfo
extends SucheInfo {
    private static final long serialVersionUID = 1L;
    @XmlElement
    protected long mlModellspalte = 0L;
    @XmlElement
    protected Collection<Long> mcModellspalten = new ArrayList<Long>();
    @XmlElement
    protected String msFzgIdString = null;
    @XmlElement
    protected String msBauart = null;
    @XmlElement
    protected String msBauartBezeichnung = null;
    @XmlElement
    protected String msBaureihe = null;
    @XmlElement
    protected String msBaureiheBezeichnung = null;
    @XmlElement
    protected String msKarosserie = null;
    @XmlElement
    protected String msKarosserieBezeichnung = null;
    @XmlElement
    protected String msModell = null;
    @XmlElement
    protected String msMotor = null;
    @XmlElement
    protected String msRegion = null;
    @XmlElement
    protected String msLenkung = null;
    @XmlElement
    protected String msGetriebe = null;
    @XmlElement
    protected String msBaujahr = null;
    @XmlElement
    protected String msZulassungsmonat = null;
    @XmlElement
    protected String msProduktionsdatum = null;
    @XmlElement
    protected boolean mbGraphicSearch = false;
    @XmlElement
    protected String msFgstNr = null;
    @XmlElement
    protected String msWerk = null;
    @XmlElement
    protected boolean mbSicherheitsfahrzeug = false;
    @XmlElements(value={@XmlElement(type=String.class)})
    protected Collection<String> mcTypmenge;
    @XmlElement
    protected Bedingungsmenge moBedingungswerte = new Bedingungsmenge();
    @XmlElement
    protected Bedingungsmenge moBedingungswerte_BTE = new Bedingungsmenge();
    @XmlElement
    protected Ausstattung mAusstattung = null;
    @XmlElement
    protected boolean mbIGDOMFehler = false;
    @XmlElement
    protected boolean mbVINSpecFehler = false;
    @XmlElement
    protected boolean mbSOWUFehler = false;
    private static ThreadSafeSimpleDateFormat sdf = new ThreadSafeSimpleDateFormat("yyyyMM");
    @XmlElement
    private String msKennzeichen = null;

    public void setGraphicSearch(boolean bGraphicSearch) {
        this.mbGraphicSearch = bGraphicSearch;
    }

    public boolean getGraphicSearch() {
        return this.mbGraphicSearch;
    }

    public void setModellspalte(long lModellspalte) {
        this.mlModellspalte = lModellspalte;
    }

    public long getModellspalte() {
        return this.mlModellspalte;
    }

    public void setFzgIdString(String sFzgIdString) {
        this.msFzgIdString = sFzgIdString;
    }

    public String getFzgIdString() {
        if (this.msFzgIdString == null) {
            return "";
        }
        return this.msFzgIdString;
    }

    public void setBauart(String sBauart) {
        this.msBauart = sBauart;
    }

    public String getBauart() {
        return this.msBauart;
    }

    public void setBauartBezeichnung(String sBauartBezeichnung) {
        this.msBauartBezeichnung = sBauartBezeichnung;
    }

    public String getBauartBezeichnung() {
        return this.msBauartBezeichnung;
    }

    public void setBaureihe(String sBaureihe) {
        this.msBaureihe = sBaureihe;
    }

    public String getBaureihe() {
        return this.msBaureihe;
    }

    public void setBaureiheBezeichnung(String sBaureiheBezeichnung) {
        this.msBaureiheBezeichnung = sBaureiheBezeichnung;
    }

    public String getBaureiheBezeichnung() {
        return this.msBaureiheBezeichnung;
    }

    public void setKarosserie(String sKarosserie) {
        this.msKarosserie = sKarosserie;
    }

    public String getKarosserie() {
        return this.msKarosserie;
    }

    public void setKarosserieBezeichnung(String sKarosserieBezeichnung) {
        this.msKarosserieBezeichnung = sKarosserieBezeichnung;
    }

    public String getKarosserieBezeichnung() {
        return this.msKarosserieBezeichnung;
    }

    public void setModell(String sModell) {
        this.msModell = sModell;
    }

    public String getModell() {
        return this.msModell;
    }

    public void setMotor(String sMotor) {
        this.msMotor = sMotor;
    }

    public String getMotor() {
        return this.msMotor;
    }

    public void setRegion(String sRegion) {
        this.msRegion = sRegion;
    }

    public String getRegion() {
        return this.msRegion;
    }

    public void setLenkung(String sLenkung) {
        this.msLenkung = sLenkung == null || sLenkung.equals("AlleWerte") ? null : sLenkung;
    }

    public String getLenkung() {
        return this.msLenkung;
    }

    public void setGetriebe(String sGetriebe) {
        this.msGetriebe = sGetriebe == null || sGetriebe.equals("AlleWerte") ? null : sGetriebe;
    }

    public String getGetriebe() {
        return this.msGetriebe;
    }

    public void setBaujahr(String sBaujahr) {
        this.msBaujahr = sBaujahr == null || sBaujahr.equals("AlleWerte") ? null : sBaujahr;
    }

    public String getBaujahr() {
        return this.msBaujahr;
    }

    public void setZulassungsmonat(String sZulassungsmonat) {
        this.msZulassungsmonat = sZulassungsmonat == null || sZulassungsmonat.equals("AlleWerte") ? null : sZulassungsmonat;
    }

    public void setProduktionsdatum(String sProduktionsdatum) {
        this.msProduktionsdatum = sProduktionsdatum;
        if (this.msProduktionsdatum != null) {
            this.msBaujahr = this.msProduktionsdatum.substring(0, 4);
            this.msZulassungsmonat = this.msProduktionsdatum.substring(4, 6);
        }
    }

    public void setFahrgestellnummer(String sFgstNr) {
        this.msFgstNr = sFgstNr;
    }

    public void setWerk(String sWerk) {
        this.msWerk = sWerk;
    }

    public void isSicherheitsfahrzeug(boolean bSicherheitsfahrzeug) {
        this.mbSicherheitsfahrzeug = bSicherheitsfahrzeug;
    }

    public String getZulassungsmonat() {
        return this.msZulassungsmonat;
    }

    public String getProduktionsdatum() {
        return this.msProduktionsdatum;
    }

    public String getProduktionsdatum(boolean bTagesgenau) {
        if (this.msProduktionsdatum != null && bTagesgenau) {
            return this.msProduktionsdatum;
        }
        if (this.msProduktionsdatum != null && !bTagesgenau) {
            return this.msProduktionsdatum.substring(0, 4) + this.msProduktionsdatum.substring(5, 7) + "00";
        }
        if (this.msBaujahr != null && this.msZulassungsmonat != null) {
            return this.msBaujahr + this.msZulassungsmonat + "00";
        }
        return null;
    }

    public Date getProduktionsDatum() {
        if (this.msProduktionsdatum != null) {
            try {
                return sdf.parse(this.msProduktionsdatum.substring(0, 6));
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (this.msBaujahr != null && this.msZulassungsmonat != null) {
            try {
                String sProduktionsdatum = this.msBaujahr + this.msZulassungsmonat;
                int length = sProduktionsdatum.length() < 6 ? sProduktionsdatum.length() : 6;
                return sdf.parse((this.msBaujahr + this.msZulassungsmonat).substring(0, length));
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public String getProduktionsdatumMin() {
        if (!StringUtils.isEmpty(this.msProduktionsdatum, true)) {
            if (this.msProduktionsdatum.length() == 6 || this.msProduktionsdatum.substring(6, 8).equals("00")) {
                return this.msProduktionsdatum.substring(0, 6) + "01";
            }
            return this.msProduktionsdatum;
        }
        if (StringUtils.isEmpty(this.msBaujahr, true)) {
            return null;
        }
        if (StringUtils.isEmpty(this.msZulassungsmonat, true)) {
            return this.msBaujahr + "01" + "01";
        }
        return this.msBaujahr + this.msZulassungsmonat + "01";
    }

    public String getProduktionsdatumMax() {
        if (!StringUtils.isEmpty(this.msProduktionsdatum, true)) {
            if (this.msProduktionsdatum.length() == 6 || this.msProduktionsdatum.substring(6, 8).equals("00")) {
                return this.msProduktionsdatum.substring(0, 6) + "31";
            }
            return this.msProduktionsdatum;
        }
        if (StringUtils.isEmpty(this.msBaujahr, true)) {
            return null;
        }
        if (StringUtils.isEmpty(this.msZulassungsmonat, true)) {
            return this.msBaujahr + "12" + "31";
        }
        return this.msBaujahr + this.msZulassungsmonat + "31";
    }

    public String getFahrgestellnummer() {
        return this.msFgstNr;
    }

    public String getWerk() {
        return this.msWerk;
    }

    public boolean isSicherheitsfahrzeug() {
        return this.mbSicherheitsfahrzeug;
    }

    public boolean isProduktionsdatumTagesgenau() {
        return this.msProduktionsdatum != null && this.msProduktionsdatum.length() == 8;
    }

    public Bedingungsmenge getBedingungsMenge() {
        if (this.moBedingungswerte == null) {
            this.moBedingungswerte = new Bedingungsmenge();
        }
        return this.moBedingungswerte;
    }

    public Bedingungsmenge getBedingungsMenge_BTE() {
        if (this.moBedingungswerte_BTE == null) {
            this.moBedingungswerte_BTE = new Bedingungsmenge();
        }
        return this.moBedingungswerte_BTE;
    }

    public void setBedingungsMenge(Bedingungsmenge oBedingungen) {
        this.moBedingungswerte = oBedingungen;
    }

    public void setBedingungsMenge_BTE(Bedingungsmenge oBedingungen) {
        this.moBedingungswerte_BTE = oBedingungen;
    }

    public Collection<String> getTypmenge() {
        return this.mcTypmenge;
    }

    public void setTypmenge(Collection<String> cTypen) {
        if (cTypen == null) {
            cTypen = new Vector<String>();
        }
        this.mcTypmenge = cTypen;
    }

    public void setIGDOMFehler(boolean bIGDOMFehler) {
        this.mbIGDOMFehler = bIGDOMFehler;
    }

    public boolean getIGDOMFehler() {
        return this.mbIGDOMFehler;
    }

    public void setVINSpecFehler(boolean bVINSpecFehler) {
        this.mbVINSpecFehler = bVINSpecFehler;
    }

    public boolean getVINSpecFehler() {
        return this.mbVINSpecFehler;
    }

    public void setSOWUFehler(boolean bSOWUFehler) {
        this.mbSOWUFehler = bSOWUFehler;
    }

    public boolean getSOWUFehler() {
        return this.mbSOWUFehler;
    }

    @Override
    public boolean isIGDOM() {
        return this.mbIGDOM;
    }

    @Override
    public void setIGDOM(boolean bIGDOM) {
        this.mbIGDOM = bIGDOM;
    }

    public void setAusstattung(Ausstattung oAusstattung) {
        this.mAusstattung = oAusstattung;
    }

    public Ausstattung getAusstattung() {
        return this.mAusstattung;
    }

    public String getKennzeichen() {
        return this.msKennzeichen;
    }

    public void setKennzeichen(String sKennzeichen) {
        this.msKennzeichen = sKennzeichen;
    }

    public void uebernehmenBedingungen(FzgSucheInfo oFzgSucheInfoSrc) {
        this.moBedingungswerte = oFzgSucheInfoSrc.getBedingungsMenge();
    }

    public void uebernehmenBedingungen_BTE(FzgSucheInfo oFzgSucheInfoSrc) {
        this.moBedingungswerte_BTE = oFzgSucheInfoSrc.getBedingungsMenge_BTE();
    }

    public Collection<Long> getModellspalten() {
        return this.mcModellspalten;
    }

    public void setModellspalten(Collection<Long> cModellspalten) {
        this.mcModellspalten = cModellspalten;
    }

    public String printOut() {
        return "mAusstattung: " + this.mAusstattung + " mbGraphicSearch: " + this.mbGraphicSearch + " mbIGDOMFehler: " + this.mbIGDOMFehler + " mbSicherheitsfahrzeug: " + this.mbSicherheitsfahrzeug + " mbSOWUFehler: " + this.mbSOWUFehler + " mbVINSpecFehler: " + this.mbVINSpecFehler + " mcModellspalten: " + this.mcModellspalten + " mcTypmenge: " + this.mcTypmenge + " mlModellspalte: " + this.mlModellspalte + " moBedingungswerte: " + this.moBedingungswerte + " msBauart: " + this.msBauart + " msBauartBezeichnung: " + this.msBauartBezeichnung + " msBaujahr: " + this.msBaujahr + " msBaureihe: " + this.msBaureihe + " msBaureiheBezeichnung: " + this.msBaureiheBezeichnung + " msFgstNr: " + this.msFgstNr + " msFzgIdString: " + this.msFzgIdString + " msGetriebe: " + this.msGetriebe + " msKarosserie: " + this.msKarosserie + " msKarosserieBezeichnung: " + this.msKarosserieBezeichnung + " msKennzeichen: " + this.msKennzeichen + " msLenkung: " + this.msLenkung + " msModell: " + this.msModell + " msMotor: " + this.msMotor + " msProduktionsdatum: " + this.msProduktionsdatum + " msRegion: " + this.msRegion + " msWerk: " + this.msWerk + " msZulassungsmonat: " + this.msZulassungsmonat;
    }

    public long getMlModellspalte() {
        return this.mlModellspalte;
    }

    public void setMlModellspalte(long mlModellspalte) {
        this.mlModellspalte = mlModellspalte;
    }

    public Collection<Long> getMcModellspalten() {
        return this.mcModellspalten;
    }

    public void setMcModellspalten(Collection<Long> mcModellspalten) {
        this.mcModellspalten = mcModellspalten;
    }

    public String getMsFzgIdString() {
        return this.msFzgIdString;
    }

    public void setMsFzgIdString(String msFzgIdString) {
        this.msFzgIdString = msFzgIdString;
    }

    public String getMsBauart() {
        return this.msBauart;
    }

    public void setMsBauart(String msBauart) {
        this.msBauart = msBauart;
    }

    public String getMsBauartBezeichnung() {
        return this.msBauartBezeichnung;
    }

    public void setMsBauartBezeichnung(String msBauartBezeichnung) {
        this.msBauartBezeichnung = msBauartBezeichnung;
    }

    public String getMsBaureihe() {
        return this.msBaureihe;
    }

    public void setMsBaureihe(String msBaureihe) {
        this.msBaureihe = msBaureihe;
    }

    public String getMsBaureiheBezeichnung() {
        return this.msBaureiheBezeichnung;
    }

    public void setMsBaureiheBezeichnung(String msBaureiheBezeichnung) {
        this.msBaureiheBezeichnung = msBaureiheBezeichnung;
    }

    public String getMsKarosserie() {
        return this.msKarosserie;
    }

    public void setMsKarosserie(String msKarosserie) {
        this.msKarosserie = msKarosserie;
    }

    public String getMsKarosserieBezeichnung() {
        return this.msKarosserieBezeichnung;
    }

    public void setMsKarosserieBezeichnung(String msKarosserieBezeichnung) {
        this.msKarosserieBezeichnung = msKarosserieBezeichnung;
    }

    public String getMsModell() {
        return this.msModell;
    }

    public void setMsModell(String msModell) {
        this.msModell = msModell;
    }

    public String getMsMotor() {
        return this.msMotor;
    }

    public void setMsMotor(String msMotor) {
        this.msMotor = msMotor;
    }

    public String getMsRegion() {
        return this.msRegion;
    }

    public void setMsRegion(String msRegion) {
        this.msRegion = msRegion;
    }

    public String getMsLenkung() {
        return this.msLenkung;
    }

    public void setMsLenkung(String msLenkung) {
        this.msLenkung = msLenkung;
    }

    public String getMsGetriebe() {
        return this.msGetriebe;
    }

    public void setMsGetriebe(String msGetriebe) {
        this.msGetriebe = msGetriebe;
    }

    public String getMsBaujahr() {
        return this.msBaujahr;
    }

    public void setMsBaujahr(String msBaujahr) {
        this.msBaujahr = msBaujahr;
    }

    public String getMsZulassungsmonat() {
        return this.msZulassungsmonat;
    }

    public void setMsZulassungsmonat(String msZulassungsmonat) {
        this.msZulassungsmonat = msZulassungsmonat;
    }

    public String getMsProduktionsdatum() {
        return this.msProduktionsdatum;
    }

    public void setMsProduktionsdatum(String msProduktionsdatum) {
        this.msProduktionsdatum = msProduktionsdatum;
    }

    public boolean isMbGraphicSearch() {
        return this.mbGraphicSearch;
    }

    public void setMbGraphicSearch(boolean mbGraphicSearch) {
        this.mbGraphicSearch = mbGraphicSearch;
    }

    public String getMsFgstNr() {
        return this.msFgstNr;
    }

    public void setMsFgstNr(String msFgstNr) {
        this.msFgstNr = msFgstNr;
    }

    public String getMsWerk() {
        return this.msWerk;
    }

    public void setMsWerk(String msWerk) {
        this.msWerk = msWerk;
    }

    public boolean isMbSicherheitsfahrzeug() {
        return this.mbSicherheitsfahrzeug;
    }

    public void setMbSicherheitsfahrzeug(boolean mbSicherheitsfahrzeug) {
        this.mbSicherheitsfahrzeug = mbSicherheitsfahrzeug;
    }

    public Collection<String> getMcTypmenge() {
        return this.mcTypmenge;
    }

    public void setMcTypmenge(Collection<String> mcTypmenge) {
        this.mcTypmenge = mcTypmenge;
    }

    public Bedingungsmenge getMoBedingungswerte() {
        return this.moBedingungswerte;
    }

    public void setMoBedingungswerte(Bedingungsmenge moBedingungswerte) {
        this.moBedingungswerte = moBedingungswerte;
    }

    public Bedingungsmenge getMoBedingungswerte_BTE() {
        return this.moBedingungswerte_BTE;
    }

    public void setMoBedingungswerte_BTE(Bedingungsmenge moBedingungswerte_BTE) {
        this.moBedingungswerte_BTE = moBedingungswerte_BTE;
    }

    public Ausstattung getmAusstattung() {
        return this.mAusstattung;
    }

    public void setmAusstattung(Ausstattung mAusstattung) {
        this.mAusstattung = mAusstattung;
    }

    public boolean isMbIGDOMFehler() {
        return this.mbIGDOMFehler;
    }

    public void setMbIGDOMFehler(boolean mbIGDOMFehler) {
        this.mbIGDOMFehler = mbIGDOMFehler;
    }

    public boolean isMbVINSpecFehler() {
        return this.mbVINSpecFehler;
    }

    public void setMbVINSpecFehler(boolean mbVINSpecFehler) {
        this.mbVINSpecFehler = mbVINSpecFehler;
    }

    public boolean isMbSOWUFehler() {
        return this.mbSOWUFehler;
    }

    public void setMbSOWUFehler(boolean mbSOWUFehler) {
        this.mbSOWUFehler = mbSOWUFehler;
    }

    public static ThreadSafeSimpleDateFormat getSdf() {
        return sdf;
    }

    public static void setSdf(ThreadSafeSimpleDateFormat sdf) {
        FzgSucheInfo.sdf = sdf;
    }

    public String getMsKennzeichen() {
        return this.msKennzeichen;
    }

    public void setMsKennzeichen(String msKennzeichen) {
        this.msKennzeichen = msKennzeichen;
    }
}

