/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.hilfe;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.hilfe.Abkuerzung;
import webetk.db.dbaccess.HilfeDbAccess;

public class Abkuerzungsliste
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Abkuerzungsliste.class);
    private String msSprache = null;
    private Collection<Hashtable<String, String>> mcAbkuerzungen = null;

    public Abkuerzungsliste(String sSprache) {
        this.msSprache = sSprache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Abkuerzung> load() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        ArrayList<Abkuerzung> retval = new ArrayList<Abkuerzung>();
        Connection con = null;
        ResultSet res = null;
        try {
            con = globs.getDBConnection("Abkuerzungsliste.load");
            res = HilfeDbAccess.loadAbkuerzungen(con, this.msSprache);
            while (res != null && res.next()) {
                String sAbkuerzung = res.getString("ABKUERZUNG");
                String sBedeutung = res.getString("BEDEUTUNG");
                String sUebersetzung = res.getString("UEBERSETZUNG");
                retval.add(new Abkuerzung(sAbkuerzung, sBedeutung, sUebersetzung));
            }
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Abkuerzungsliste.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Abkuerzungsliste.load");
        return retval;
    }

    public void loadIntoHashtable() throws SQLException, DatabaseBusyException {
        this.mcAbkuerzungen = new Vector<Hashtable<String, String>>();
        List<Abkuerzung> lAbk = this.load();
        for (Abkuerzung abk : lAbk) {
            this.mcAbkuerzungen.add(abk.getHashtable());
        }
    }

    public Collection<Hashtable<String, String>> getAbkuerzungen() {
        if (this.mcAbkuerzungen != null) {
            Iterator<Hashtable<String, String>> iter = this.mcAbkuerzungen.iterator();
            int nLfdNr = 0;
            while (iter.hasNext()) {
                Hashtable<String, String> objHashtable = iter.next();
                String sLfdNr = String.valueOf(++nLfdNr);
                objHashtable.put("LfdNr", sLfdNr);
                if ((nLfdNr - 1) % 15 != 0) continue;
                objHashtable.put("hatUeberschrift", "J");
            }
        }
        return this.mcAbkuerzungen;
    }
}

