/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.hilfe;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.hilfe.Salapa;
import webetk.app.hilfe.SalapaComparator;
import webetk.db.dbaccess.HilfeDbAccess;
import webetk.mrkprd.Produkte;

public class Salapaliste {
    private static Logger log = Logger.getLogger(Salapaliste.class);
    private String msLang = null;
    private List<Salapa> mSalapasPKW = new ArrayList<Salapa>();
    private List<Salapa> mSalapasMotorrad = new ArrayList<Salapa>();

    public Salapaliste(String sLang) {
        this.msLang = sLang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws SQLException, DatabaseBusyException {
        ServerGlobalObjects globs = ServerGlobalObjects.getInstance();
        log.debug("Accessing database ...");
        Connection con = null;
        ResultSet res = null;
        try {
            String sBenennung;
            String sCode;
            con = globs.getDBConnection("Salapaliste.load");
            res = HilfeDbAccess.loadSalapas(con, Produkte.getInstance().getProdukt("AUTO").getBerechtigung(), this.msLang);
            while (res != null && res.next()) {
                sCode = res.getString("Code");
                sBenennung = res.getString("Benennung");
                this.mSalapasPKW.add(new Salapa(sCode, sBenennung));
            }
            Collections.sort(this.mSalapasPKW, new SalapaComparator(new char[]{'S', 'L', 'P'}));
            WebetkUtils.closeQuery(res);
            res = HilfeDbAccess.loadSalapas(con, Produkte.getInstance().getProdukt("MOTORRAD").getBerechtigung(), this.msLang);
            while (res != null && res.next()) {
                sCode = res.getString("Code");
                sBenennung = res.getString("Benennung");
                this.mSalapasMotorrad.add(new Salapa(sCode, sBenennung));
            }
            Collections.sort(this.mSalapasMotorrad, new SalapaComparator(new char[]{'X', 'Y', 'Q'}));
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            globs.freeDBConnection(con, "Salapaliste.load");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        globs.freeDBConnection(con, "Salapaliste.load");
    }

    public List<Salapa> getSalapasPKW() {
        return this.mSalapasPKW;
    }

    public List<Salapa> getSalapasMotorrad() {
        return this.mSalapasMotorrad;
    }
}

