/*
 * Decompiled with CFR 0.152.
 */
package webetk.app.interpretation;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import webetk.DatabaseBusyException;
import webetk.InvalidInitializationException;
import webetk.WebetkUtils;
import webetk.app.ServerGlobalObjects;
import webetk.app.interpretation.IZeile;
import webetk.app.interpretation.IZeilen;
import webetk.db.dbaccess.InterpretationDbAccess;
import webetk.utils.xml.CollectionAdapter;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Interpretation
implements Serializable {
    @XmlTransient
    private static final long serialVersionUID = 1L;
    @XmlTransient
    private static Logger log = Logger.getLogger(Interpretation.class);
    public static final int ANSICHT_UNDEF = -1;
    public static final int ANSICHT_BAUM = 0;
    public static final int ANSICHT_TABELLE = 1;
    public static final int ANSICHT_NORMAL = 2;
    public static final int ANZEIGE_UNDEF = -1;
    public static final int ANZEIGE_GESAMT = 0;
    public static final int ANZEIGE_AKT_ZWEIG = 1;
    private List<String> mcMarken = null;
    private String msSachnummerSuche = null;
    private String msTeilenummerGesucht = null;
    private String msTeilenummerZuBestellen = null;
    @XmlElement
    @XmlJavaTypeAdapter(value=CollectionAdapter.class)
    private List<List<IZeile>> mcZweige = new ArrayList<List<IZeile>>();
    @XmlElement
    @XmlJavaTypeAdapter(value=CollectionAdapter.class)
    private List<List<IZeile>> mcZweigeMitSachnummer = new ArrayList<List<IZeile>>();
    private IZeilen mIZeilen;
    private int mnAnsicht = -1;
    private int mnAnzeige = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Interpretation(Collection<String> cMarkenBerechtigung, String sLang, String sSachnummer) throws SQLException, DatabaseBusyException, InvalidInitializationException {
        this.mnAnsicht = 2;
        this.mnAnzeige = 0;
        this.mcMarken = null;
        this.msSachnummerSuche = sSachnummer;
        this.msTeilenummerGesucht = "";
        this.msTeilenummerZuBestellen = "";
        this.mcZweige.clear();
        this.mcZweigeMitSachnummer.clear();
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Interpretation.Konstuktor");
            log.debug("Checking Sachnummer...");
            List<String> cMarken = InterpretationDbAccess.getMarkenForSachnummer(con, sSachnummer, cMarkenBerechtigung);
            if (cMarken.size() == 0) {
                throw new InvalidInitializationException("Sachnummer nicht im Teilestamm vorhanden!");
            }
            this.setMarken(cMarken);
            this.performSearch(sLang, sSachnummer);
        }
        finally {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "Interpretation.Konstuktor");
        }
    }

    public Interpretation() {
        this.mcMarken = null;
        this.msSachnummerSuche = "";
        this.msTeilenummerGesucht = "";
        this.msTeilenummerZuBestellen = "";
        this.mIZeilen = new IZeilen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSearch(String sLang, String sSachnummer) throws SQLException, DatabaseBusyException {
        ServerGlobalObjects gObj = ServerGlobalObjects.getInstance();
        Connection con = null;
        ResultSet res = null;
        try {
            con = gObj.getDBConnection("Interpretation.performSearch");
            log.debug("Loading Interpretation...");
            res = InterpretationDbAccess.loadInterpretation(con, sLang, sSachnummer);
            int nZweigGemerkt = -1;
            Vector<IZeile> cZweig = null;
            boolean bGefundenBestellbar = false;
            boolean bZuBestellenR = false;
            String sSachnummerGemerkt = "";
            IZeile oZeile = null;
            while (res != null && res.next()) {
                String sSachnummerR;
                int nZweigNr = res.getInt("ZweigNr");
                if (nZweigNr != nZweigGemerkt) {
                    cZweig = new Vector<IZeile>();
                    this.mcZweige.add(cZweig);
                    nZweigGemerkt = nZweigNr;
                }
                if (!sSachnummerGemerkt.equals(sSachnummerR = res.getString("Sachnummer"))) {
                    String sHgR = res.getString("Hg");
                    String sUgR = res.getString("Ug");
                    String sBenennungR = res.getString("Benennung");
                    String sEntfallDatumR = res.getString("EntfallDatum");
                    String sMarke = res.getString("Marke");
                    long lEntfallDatumR = 0L;
                    if (sEntfallDatumR != null) {
                        lEntfallDatumR = Long.parseLong(sEntfallDatumR);
                    }
                    String sBestellbarR = res.getString("Bestellbar");
                    String sTeilenummerR = sHgR + " " + sUgR + " " + sSachnummerR.substring(0, 1) + " " + sSachnummerR.substring(1, 4) + " " + sSachnummerR.substring(4, 7);
                    if (!bGefundenBestellbar && sBestellbarR.equalsIgnoreCase("J")) {
                        bZuBestellenR = true;
                        this.msTeilenummerZuBestellen = sTeilenummerR;
                        bGefundenBestellbar = true;
                    }
                    if (sSachnummerR.equalsIgnoreCase(sSachnummer)) {
                        this.msTeilenummerGesucht = sTeilenummerR;
                    }
                    int nSturkturNr = res.getInt("StrukturNr");
                    oZeile = new IZeile(sSachnummerR, sTeilenummerR, sBenennungR, lEntfallDatumR, bZuBestellenR, sMarke, nSturkturNr);
                    cZweig.add(oZeile);
                    continue;
                }
                String sMarke = res.getString("Marke");
                oZeile.appendMarke(sMarke);
            }
            this.adjustBlattFlag();
            this.adjustVisibleFlag();
        }
        catch (Throwable throwable) {
            WebetkUtils.closeQuery(res);
            gObj.freeDBConnection(con, "IZeilen.performSearch");
            throw throwable;
        }
        WebetkUtils.closeQuery(res);
        gObj.freeDBConnection(con, "IZeilen.performSearch");
    }

    public Collection<String> getMarken() {
        if (this.mcMarken == null) {
            return new Vector<String>();
        }
        return this.mcMarken;
    }

    public String getMarkenKommaSep() {
        if (this.mcMarken == null || this.mcMarken.size() == 0) {
            return "";
        }
        String sMarken = "";
        Iterator<String> iter = this.mcMarken.iterator();
        boolean bFirst = true;
        while (iter.hasNext()) {
            if (!bFirst) {
                sMarken = sMarken + ",";
            }
            sMarken = sMarken + iter.next();
            bFirst = false;
        }
        return sMarken;
    }

    public void setMarken(List<String> cMarken) {
        this.mcMarken = cMarken;
    }

    public String getSachnummerGesucht() {
        if (this.msSachnummerSuche == null || this.msSachnummerSuche.equalsIgnoreCase("")) {
            return "";
        }
        return this.msSachnummerSuche;
    }

    public String getTeilenummerGesucht() {
        if (this.msTeilenummerGesucht == null || this.msTeilenummerGesucht.equalsIgnoreCase("")) {
            return "";
        }
        return this.msTeilenummerGesucht;
    }

    public String getTeilenummerZuBestellen() {
        if (this.msTeilenummerZuBestellen == null || this.msTeilenummerZuBestellen.equalsIgnoreCase("")) {
            return "";
        }
        return this.msTeilenummerZuBestellen;
    }

    public void setAnzeige(int nAnzeige) {
        this.mnAnzeige = nAnzeige;
    }

    public int getAnzeige() {
        return this.mnAnzeige;
    }

    public void setAnsicht(int nAnsicht) {
        this.mnAnsicht = nAnsicht;
    }

    public int getAnsicht() {
        return this.mnAnsicht;
    }

    public Collection<IZeile> getZeilenFuerTabelle() {
        ArrayList<IZeile> aDaten = new ArrayList<IZeile>();
        if (this.isEmpty()) {
            return aDaten;
        }
        IZeile oWurzel = this.getWurzelInterpretation();
        aDaten.add(oWurzel);
        Collection<Collection<IZeile>> cZweige = this.getZweigeOhneWurzel();
        for (Collection<IZeile> cZeilenZweig : cZweige) {
            Iterator<IZeile> iter2 = cZeilenZweig.iterator();
            boolean bOhneAbfrage = false;
            int nStrukturnummer = -1;
            int nIndex = -1;
            while (iter2.hasNext()) {
                IZeile oZeile = iter2.next();
                if (bOhneAbfrage) {
                    if (nIndex == -1) {
                        aDaten.add(oZeile);
                        continue;
                    }
                    aDaten.add(nIndex++, oZeile);
                    continue;
                }
                boolean bGefunden = this.findeZeileInArrayList(aDaten, oZeile);
                if (!bGefunden) {
                    if (nStrukturnummer == -1) {
                        aDaten.add(oZeile);
                        bOhneAbfrage = true;
                        continue;
                    }
                    nIndex = this.getInsertIndex(aDaten, oZeile.getStrukturnummer());
                    aDaten.add(nIndex++, oZeile);
                    bOhneAbfrage = true;
                    continue;
                }
                nStrukturnummer = oZeile.getStrukturnummer();
            }
        }
        return aDaten;
    }

    public IZeile getWurzelInterpretation() {
        Collection cHelp = (Collection)this.mcZweige.toArray()[0];
        IZeile oWurzel = (IZeile)cHelp.toArray()[0];
        return oWurzel;
    }

    public Collection<Collection<IZeile>> getZweigeOhneWurzel() {
        Vector<Collection<IZeile>> cZweigeNeu = new Vector<Collection<IZeile>>();
        boolean bNurAktuelleZweige = this.mnAnzeige == 1;
        List<List<IZeile>> cZweige = this.mcZweige;
        if (bNurAktuelleZweige) {
            cZweige = this.getAktuelleZweige();
        }
        Iterator<List<IZeile>> iter = cZweige.iterator();
        while (iter.hasNext()) {
            Vector<IZeile> cKnotenProZweigNeu = new Vector<IZeile>();
            cZweigeNeu.add(cKnotenProZweigNeu);
            Collection cKnotenProZweig = iter.next();
            for (IZeile oZeile : cKnotenProZweig) {
                if (oZeile.getStrukturnummer() <= 0) continue;
                cKnotenProZweigNeu.add(oZeile);
            }
        }
        return cZweigeNeu;
    }

    public IZeilen getZeilenFuerTabelleHTML() {
        if (this.isEmpty()) {
            return new IZeilen(new Vector<IZeile>());
        }
        Collection<IZeile> cZeilen = this.getZeilenFuerTabelle();
        this.mIZeilen = new IZeilen(cZeilen);
        return this.mIZeilen;
    }

    public boolean isEmpty() {
        if (this.mcZweige == null) {
            return true;
        }
        return this.mcZweige.size() == 0;
    }

    private List<List<IZeile>> getAktuelleZweige() {
        if (this.mcZweigeMitSachnummer.size() != 0) {
            return this.mcZweigeMitSachnummer;
        }
        ArrayList<List<IZeile>> aResult = new ArrayList<List<IZeile>>();
        block0: for (List<IZeile> cZweig : this.mcZweige) {
            for (IZeile oZeile : cZweig) {
                if (!oZeile.getSachnummer(false).equals(this.getSachnummerGesucht())) continue;
                aResult.add(cZweig);
                continue block0;
            }
        }
        return aResult;
    }

    private boolean findeZeileInArrayList(ArrayList<IZeile> aDaten, IZeile oZeile) {
        for (int i = 0; i < aDaten.size(); ++i) {
            IZeile oZeileComp = aDaten.get(i);
            if (oZeileComp.getStrukturnummer() != oZeile.getStrukturnummer() || !oZeileComp.getTeilenummer().equals(oZeile.getTeilenummer())) continue;
            return true;
        }
        return false;
    }

    private int getInsertIndex(ArrayList<IZeile> aDaten, int nStrukturnummer) {
        for (int i = 0; i < aDaten.size(); ++i) {
            IZeile oZeileComp = aDaten.get(i);
            if (oZeileComp.getStrukturnummer() != nStrukturnummer) continue;
            return i;
        }
        return -1;
    }

    public void adjustBlattFlag() {
        if (this.mcZweige == null) {
            return;
        }
        for (Collection collection : this.mcZweige) {
            IZeile oLast = (IZeile)collection.toArray()[collection.size() - 1];
            oLast.istBlatt(true);
        }
    }

    public void setExpandFlag(String sSachnummer, boolean bExpand) {
        if (this.mcZweige == null) {
            return;
        }
        for (Collection collection : this.mcZweige) {
            for (IZeile iZeile : collection) {
                if (!iZeile.getSachnummer(false).equals(sSachnummer)) continue;
                iZeile.istExpandiert(bExpand);
            }
        }
        this.adjustVisibleFlag();
    }

    public void adjustVisibleFlag() {
        if (this.mcZweige == null) {
            return;
        }
        Iterator<List<IZeile>> iter = this.mcZweige.iterator();
        while (iter.hasNext()) {
            boolean bFoundCollabiert = false;
            Collection cKnoten = iter.next();
            for (IZeile oZeile : cKnoten) {
                oZeile.istVisible(true);
                if (bFoundCollabiert) {
                    oZeile.istVisible(false);
                    continue;
                }
                if (oZeile.istExpandiert()) continue;
                bFoundCollabiert = true;
            }
        }
    }

    public boolean hasScrollTargetTabelle() {
        IZeile oZeile;
        String sSachnummerGesucht = this.getSachnummerGesucht();
        if (sSachnummerGesucht == null || sSachnummerGesucht.equals("")) {
            return false;
        }
        Collection<IZeile> cZeilen = this.getZeilenFuerTabelle();
        Object[] cZeilenArray = cZeilen.toArray();
        int i = -1;
        for (i = 0; i < cZeilenArray.length && !(oZeile = (IZeile)cZeilenArray[i]).getSachnummer(false).equals(sSachnummerGesucht); ++i) {
        }
        return i != -1 && i > 7;
    }

    public Collection<IZeile> getAlleZeilen(Collection<String> cTeilenummernUnformatiert, Collection<String> cMarke) throws InvalidInitializationException {
        if (cTeilenummernUnformatiert == null || cMarke == null) {
            throw new InvalidInitializationException("Collection f\u00fcr Teilenummern oder Marke is null ");
        }
        int nAnzeige = this.getAnzeige();
        this.setAnzeige(0);
        Collection<IZeile> cAlleZeilen = this.getZeilenFuerTabelle();
        for (IZeile iZeile : cAlleZeilen) {
            cTeilenummernUnformatiert.add(iZeile.getTeilenummerUnformatiert());
            Collection<String> cHelp = iZeile.getMarken();
            String sMarke = "";
            if (cHelp.size() >= 1) {
                sMarke = (String)cHelp.toArray()[0];
            }
            cMarke.add(sMarke);
        }
        this.setAnzeige(nAnzeige);
        return cAlleZeilen;
    }
}

